/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.controller;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISwitchTenantService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/groupingmodel/tenant/switch"})
public class SwitchTenantController {
    @Resource
    private ISwitchTenantService switchTenantService;
    @Lazy
    @Resource
    private ISysTenantService sysTenantService;

    @GetMapping(value={"getDefaultTenant"})
    public ApiResponse<SysTenant> getDefaultTenant(@RequestParam(value="username") String username) {
        return ApiResponse.success((Object)this.switchTenantService.getDefaultTenant(username));
    }

    @GetMapping(value={"getSwitchTenant"})
    public ApiResponse<List<SysTenant>> switchTenantList() {
        SecurityUser user = BaseSecurityUtil.getUser();
        return ApiResponse.success((Object)this.switchTenantService.switchTenantList(user.getUserId()));
    }

    @GetMapping
    public ApiResponse<Boolean> switchTenant(@RequestParam(value="tenantCode") String tenantCode) {
        HussarTenantDefinition tenantInfo = this.sysTenantService.getTenantByTenantCode(tenantCode);
        if (null == tenantInfo) {
            throw new BaseException("\u8be5\u79df\u6237\u4e0d\u5b58\u5728,\u5207\u6362\u5931\u8d25!");
        }
        return ApiResponse.success((Object)this.switchTenantService.switchTenant(tenantInfo.getConnName(), tenantInfo));
    }
}

