/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.dto.SysBaseConfigDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.SysTenantMultUser;
import com.jxdinfo.hussar.tenant.common.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.common.model.SysTenantStruCancel;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUser;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUserStru;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantMultUserService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantStruCancelService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantStruService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUserService;
import com.jxdinfo.hussar.tenant.common.service.TenantOrganizationUserService;
import com.jxdinfo.hussar.tenant.common.util.TenantAuthorizationUtils;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.groupingmodel.dto.TenantTernaryAccountDto;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SolitaryGroupingModelTenant;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantUserStruService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.TenantGroupingModelService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TenantGroupingModelServiceImpl
implements TenantGroupingModelService {
    private final Logger logger = LoggerFactory.getLogger(TenantGroupingModelServiceImpl.class);
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private TenantOrganizationUserService tenantOrganizationUserService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysOfficeService sysOfficeService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantMultUserService tenantMultUserService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantStruService sysTenantStruService;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    private ISysOrganTypeService sysOrganTypeService;
    @Resource
    private ISysStruRuleService sysStruRuleService;
    @Resource
    private ISysTenantUserService sysTenantUserService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantStruCancelService sysTenantStruCancelService;
    @Resource
    private ISysTenantUserStruService sysTenantUserStruService;

    @HussarTransactional
    public void initTenantThreeAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        SysBaseConfigDto defaultSecret;
        ArrayList<SysUsers> sysUsersList = new ArrayList<SysUsers>();
        ArrayList<SysStaff> sysStaffList = new ArrayList<SysStaff>();
        ArrayList<SysUserRole> sysUserRoleList = new ArrayList<SysUserRole>();
        ArrayList<SysTenantMultUser> tenantMultUsers = new ArrayList<SysTenantMultUser>();
        int initSeq = 1;
        int initUserType = 0;
        String securitySecrecy = solitaryGroupingModelTenant.getSecuritySecrecy().getUserAccount();
        String securityAudit = solitaryGroupingModelTenant.getSecurityAudit().getUserAccount();
        String systemManage = solitaryGroupingModelTenant.getSystemManage().getUserAccount();
        HashSet<String> userAccounts = new HashSet<String>();
        userAccounts.add(securitySecrecy);
        userAccounts.add(securityAudit);
        userAccounts.add(systemManage);
        if (userAccounts.size() != 3 || this.usersService.count((Wrapper)new LambdaQueryWrapper().in(SysUsers::getUserAccount, userAccounts)) > 0L) {
            throw new BaseException("\u79df\u6237\u521b\u5efa\u5931\u8d25\uff0c\u4e09\u5458\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        LinkedHashMap<Long, TenantTernaryAccountDto> roleAccountMap = new LinkedHashMap<Long, TenantTernaryAccountDto>();
        roleAccountMap.put(1450785935166925011L, solitaryGroupingModelTenant.getSecuritySecrecy());
        roleAccountMap.put(1450781935868925962L, solitaryGroupingModelTenant.getSecurityAudit());
        roleAccountMap.put(1450715195867925063L, solitaryGroupingModelTenant.getSystemManage());
        String password = "123456";
        SysBaseConfigDto createUserConfig = this.baseConfigService.getSysBaseConfigDto("create_user_use_default_pass");
        if (HussarUtils.isNotEmpty((Object)createUserConfig) && "0".equals(createUserConfig.getConfigValue()) && HussarUtils.isNotEmpty((Object)(defaultSecret = this.baseConfigService.getSysBaseConfigDto("default_password")))) {
            password = defaultSecret.getConfigValue();
        }
        for (Map.Entry ternaryAccountDto : roleAccountMap.entrySet()) {
            int staffSeq = initSeq;
            List staffs = this.sysStaffService.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysStaff::getStaffOrder}).orderByDesc(SysStaff::getStaffOrder));
            if (HussarUtils.isNotEmpty((Object)staffs)) {
                staffSeq = ((SysStaff)staffs.get(0)).getStaffOrder() + initSeq;
            }
            int usersSeq = initSeq;
            List sysUserSeq = this.usersService.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysUsers::getUserOrder}).orderByDesc(SysUsers::getUserOrder));
            if (HussarUtils.isNotEmpty((Object)sysUserSeq)) {
                usersSeq = ((SysUsers)sysUserSeq.get(0)).getUserOrder() + initSeq;
            }
            ++initSeq;
            SysStaff sysStaff = new SysStaff();
            long staffId = IdWorker.getId((Object)sysStaff);
            sysStaff.setId(Long.valueOf(staffId));
            sysStaff.setName(((TenantTernaryAccountDto)ternaryAccountDto.getValue()).getStaffName());
            sysStaff.setStaffOrder(Integer.valueOf(staffSeq));
            sysStaff.setStaffCode(String.valueOf(staffId));
            sysStaffList.add(sysStaff);
            SysUsers sysUsers = new SysUsers();
            long usersId = IdWorker.getId((Object)sysUsers);
            sysUsers.setId(Long.valueOf(usersId));
            sysUsers.setEmployeeId(Long.valueOf(staffId));
            sysUsers.setUserName(((TenantTernaryAccountDto)ternaryAccountDto.getValue()).getStaffName());
            sysUsers.setUserAccount(((TenantTernaryAccountDto)ternaryAccountDto.getValue()).getUserAccount());
            TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
            sysUsers.setPassword(TenantUtil.getEncodeSecure((String)password));
            sysUsers.setUserOrder(Integer.valueOf(usersSeq));
            sysUsersList.add(sysUsers);
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(Long.valueOf(usersId));
            sysUserRole.setGrantedRole((Long)ternaryAccountDto.getKey());
            sysUserRole.setAdminOption("1");
            sysUserRoleList.add(sysUserRole);
            SysTenantMultUser sysTenantMultUser = new SysTenantMultUser();
            sysTenantMultUser.setTenantId(solitaryGroupingModelTenant.getTenantId());
            sysTenantMultUser.setUserId(Long.valueOf(usersId));
            sysTenantMultUser.setUserType(String.valueOf(initUserType++));
            tenantMultUsers.add(sysTenantMultUser);
        }
        this.usersService.saveBatch(sysUsersList);
        this.sysStaffService.saveBatch(sysStaffList);
        this.tenantMultUserService.saveBatch(tenantMultUsers);
        this.tenantOrganizationUserService.initTernaryUserInfo(connName, sysStaffList, sysUsersList, sysUserRoleList);
    }

    @HussarTransactional
    public void updateTenantTernaryAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        Map<String, Long> tenantMultUserMap = this.tenantMultUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantMultUser::getTenantId, (Object)solitaryGroupingModelTenant.getTenantId())).stream().collect(Collectors.toMap(SysTenantMultUser::getUserType, SysTenantMultUser::getUserId));
        if (HussarUtils.isEmpty(tenantMultUserMap)) {
            this.initTenantThreeAdmin(connName, solitaryGroupingModelTenant);
            return;
        }
        ArrayList<SysStaff> sysStaffList = new ArrayList<SysStaff>();
        ArrayList<SysUsers> sysUsersList = new ArrayList<SysUsers>();
        ArrayList<SysStaff> copiedSysStaffList = new ArrayList<SysStaff>();
        ArrayList<SysUsers> copiedSysUsersList = new ArrayList<SysUsers>();
        for (Map.Entry<String, Long> tenantMultUser : tenantMultUserMap.entrySet()) {
            SysStaff sysStaff;
            Long usersId = null;
            String name = "";
            if ("0".equals(tenantMultUser.getKey())) {
                usersId = tenantMultUserMap.get("0");
                name = solitaryGroupingModelTenant.getSecuritySecrecy().getStaffName();
            } else if ("1".equals(tenantMultUser.getKey())) {
                usersId = tenantMultUserMap.get("1");
                name = solitaryGroupingModelTenant.getSecurityAudit().getStaffName();
            } else if ("2".equals(tenantMultUser.getKey())) {
                usersId = tenantMultUserMap.get("2");
                name = solitaryGroupingModelTenant.getSystemManage().getStaffName();
            }
            if (HussarUtils.isEmpty((Object)usersId)) {
                throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u7684\u7528\u6237");
            }
            SysUsers sysUsers = this.usersService.getById(usersId);
            if (HussarUtils.isNotEmpty((Object)sysUsers)) {
                sysUsers.setUserName(name);
                sysUsersList.add(sysUsers);
                SysUsers sysUsersCopy = new SysUsers();
                HussarUtils.copy((Object)sysUsers, (Object)sysUsersCopy);
                copiedSysUsersList.add(sysUsersCopy);
            }
            if (!HussarUtils.isNotEmpty((Object)(sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)sysUsers.getEmployeeId())))) continue;
            sysStaff.setName(name);
            sysStaffList.add(sysStaff);
            SysStaff sysStaffCopy = new SysStaff();
            HussarUtils.copy((Object)sysStaff, (Object)sysStaffCopy);
            copiedSysStaffList.add(sysStaffCopy);
        }
        this.sysStaffService.saveOrUpdateBatch(sysStaffList);
        this.usersService.saveOrUpdateBatch(sysUsersList);
        this.tenantOrganizationUserService.updateTernaryUserInfo(connName, copiedSysStaffList, copiedSysUsersList);
    }

    public void initTenantStruAndUsers(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        Long tenantId = solitaryGroupingModelTenant.getTenantId();
        this.sysTenantStruService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)tenantId));
        this.sysTenantStruCancelService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantStruCancel::getTenantId, (Object)tenantId));
        this.tenantOrganizationUserService.removeSyncTenantStruAndUsersWithOrgRule(connName);
        List struIdList = solitaryGroupingModelTenant.getStruIdList();
        List cancelStruIdList = solitaryGroupingModelTenant.getCancelStruIdList();
        String struIdListString = "";
        if (HussarUtils.isNotEmpty((Object)struIdList)) {
            struIdListString = struIdList.stream().map(Object::toString).collect(Collectors.joining(","));
        }
        this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff1a\u83b7\u53d6\u524d\u7aef\u52fe\u9009\u7684\u540c\u6b65\u7ec4\u7ec7ID\uff1a{}", (Object)struIdListString);
        if (HussarUtils.isNotEmpty((Object)struIdList)) {
            ArrayList<SysTenantStru> sysTenantStrus = new ArrayList<SysTenantStru>();
            for (Long struId : struIdList) {
                SysTenantStru sysTenantStru = new SysTenantStru();
                sysTenantStru.setStruId(struId);
                sysTenantStru.setTenantId(tenantId);
                sysTenantStrus.add(sysTenantStru);
            }
            List list = this.sysStruService.list();
            HashSet<Long> struIdChild = TenantAuthorizationUtils.getStruChild((List)list, (List)struIdList);
            List<SysStru> sysStruList = this.sysStruService.listByIds((Collection)struIdChild);
            if (HussarUtils.isNotEmpty((Object)cancelStruIdList)) {
                ArrayList<SysTenantStruCancel> sysTenantStruCancelList = new ArrayList<SysTenantStruCancel>();
                for (int k = 0; k < cancelStruIdList.size(); ++k) {
                    Long cancelStruId = (Long)cancelStruIdList.get(k);
                    SysTenantStruCancel sysTenantStruCancel = new SysTenantStruCancel();
                    sysTenantStruCancel.setStruId(cancelStruId);
                    sysTenantStruCancel.setTenantId(tenantId);
                    sysTenantStruCancelList.add(sysTenantStruCancel);
                }
                this.sysTenantStruCancelService.saveBatch(sysTenantStruCancelList);
                Set cancelStruChildId = TenantAuthorizationUtils.getStruChild((List)list, (List)cancelStruIdList);
                if (HussarUtils.isNotEmpty((Object)cancelStruChildId)) {
                    cancelStruChildId.removeAll(struIdList);
                    ArrayList<SysStru> sysStrusRes = new ArrayList<SysStru>();
                    HashSet<Long> struIdChildRes = new HashSet<Long>();
                    for (int i = 0; i < sysStruList.size(); ++i) {
                        SysStru sysStru = (SysStru)sysStruList.get(i);
                        if (cancelStruChildId.contains(sysStru.getId())) continue;
                        sysStrusRes.add(sysStru);
                    }
                    for (Long id : struIdChild) {
                        if (cancelStruChildId.contains(id)) continue;
                        struIdChildRes.add(id);
                    }
                    if (HussarUtils.isNotEmpty(sysStrusRes)) {
                        sysStruList = sysStrusRes;
                    }
                    if (HussarUtils.isNotEmpty(struIdChildRes)) {
                        struIdChild = struIdChildRes;
                    }
                }
            }
            int sysStruListSize = 0;
            if (HussarUtils.isNotEmpty((Object)sysStruList)) {
                sysStruListSize = sysStruList.size();
            }
            this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff0c\u5b50\u7ec4\u7ec7\u4e2a\u6570\uff1a{}", (Object)sysStruListSize);
            TenantAuthorizationUtils.noParentSetParent((List)sysStruList, (Long)11L);
            List organId = sysStruList.stream().map(SysStru::getOrganId).collect(Collectors.toList());
            List<SysOrgan> sysOrgans = this.sysOrganService.listByIds(organId);
            int sysOrgansSize = 0;
            if (HussarUtils.isNotEmpty((Object)sysOrgans)) {
                sysOrgansSize = sysOrgans.size();
            }
            this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff0c\u540c\u6b65SYS_ORGAN\u4e2a\u6570\uff1a{}", (Object)sysOrgansSize);
            List<SysOffice> sysOffices = this.sysOfficeService.list((Wrapper)new LambdaQueryWrapper().in(SysOffice::getStruId, (Collection)struIdChild));
            int sysOfficesSize = 0;
            if (HussarUtils.isNotEmpty((Object)sysOffices)) {
                sysOfficesSize = sysOffices.size();
            }
            this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff0c\u540c\u6b65SYS_OFFICE\u4e2a\u6570\uff1a{}", (Object)sysOfficesSize);
            List sysOrganTypes = new ArrayList();
            List organTypeQuery = this.sysOrganTypeService.list();
            if (HussarUtils.isNotEmpty((Object)organTypeQuery)) {
                sysOrganTypes = organTypeQuery;
            }
            this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff0c\u540c\u6b65SYS_ORGAN_TYPE\u4e2a\u6570\uff1a{}", (Object)sysOrganTypes.size());
            List sysStruRules = new ArrayList();
            List struRuleQuery = this.sysStruRuleService.list();
            if (HussarUtils.isNotEmpty((Object)struRuleQuery)) {
                sysStruRules = struRuleQuery;
            }
            this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff0c\u540c\u6b65SYS_STRU_RULE\u4e2a\u6570\uff1a{}", (Object)sysStruRules.size());
            List<SysStruUser> sysStruUserList = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdChild));
            int sysStruUserListSize = 0;
            if (HussarUtils.isNotEmpty((Object)sysStruUserList)) {
                sysStruUserListSize = sysStruUserList.size();
            }
            this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff0c\u540c\u6b65SYS_STRU_USER\u4e2a\u6570\uff1a{}", (Object)sysStruUserListSize);
            Set<Long> userIds = null;
            List<SysUsers> sysUsers = null;
            List<SysStaff> sysStaffs = null;
            List<SysStruStaff> sysStruStaffList = null;
            if (HussarUtils.isNotEmpty((Object)sysStruUserList)) {
                userIds = sysStruUserList.stream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                sysUsers = this.usersService.listByIds(userIds);
                List sysStaffIds = sysUsers.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                sysStaffs = this.sysStaffService.listByIds(sysStaffIds);
                sysStruStaffList = this.sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, sysStaffIds));
            }
            int sysUsersSize = 0;
            if (HussarUtils.isNotEmpty(sysUsers)) {
                sysUsersSize = sysUsers.size();
            }
            this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff0c\u540c\u6b65SYS_USERS\u4e2a\u6570\uff1a{}", (Object)sysUsersSize);
            int sysStaffsSize = 0;
            if (HussarUtils.isNotEmpty(sysStaffs)) {
                sysStaffsSize = sysStaffs.size();
            }
            this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff0c\u540c\u6b65SYS_STAFF\u4e2a\u6570\uff1a{}", (Object)sysStaffsSize);
            int sysStruStaffListSize = 0;
            if (HussarUtils.isNotEmpty(sysStruStaffList)) {
                sysStruStaffListSize = sysStruStaffList.size();
            }
            this.logger.info("TenantGroupingModelServiceImpl.initTenantStruAndUsers()\u65b9\u6cd5\uff0c\u540c\u6b65SYS_STRU_STAFF\u4e2a\u6570\uff1a{}", (Object)sysStruStaffListSize);
            this.sysTenantStruService.saveBatch(sysTenantStrus);
            this.handleSpecialUser(solitaryGroupingModelTenant, sysStruList, sysOrgans, sysOffices, sysStruUserList, userIds, sysUsers, sysStaffs, sysStruStaffList);
            sysStruList = this.distinctById(sysStruList, SysStru::getId);
            sysOrgans = this.distinctById(sysOrgans, SysOrgan::getId);
            sysOffices = this.distinctById(sysOffices, SysOffice::getId);
            sysStruUserList = this.distinctById(sysStruUserList, SysStruUser::getId);
            sysUsers = this.distinctById(sysUsers, SysUsers::getId);
            sysStaffs = this.distinctById(sysStaffs, SysStaff::getId);
            sysStruStaffList = this.distinctById(sysStruStaffList, SysStruStaff::getId);
            this.tenantOrganizationUserService.syncTenantStruAndUsers(connName, sysStruList, sysOrgans, sysOffices, sysStruUserList, userIds, sysUsers, sysStaffs, sysStruStaffList, sysOrganTypes, sysStruRules);
        }
    }

    private void handleSpecialUser(SolitaryGroupingModelTenant solitaryGroupingModelTenant, List<SysStru> sysStruList, List<SysOrgan> sysOrgans, List<SysOffice> sysOffices, List<SysStruUser> sysStruUserList, Set<Long> userIds, List<SysUsers> sysUsers, List<SysStaff> sysStaffs, List<SysStruStaff> sysStruStaffList) {
        List userIdList = solitaryGroupingModelTenant.getUserIdList();
        List userStruIdList = solitaryGroupingModelTenant.getUserStruIdList();
        Long tenantId = solitaryGroupingModelTenant.getTenantId();
        this.sysTenantUserService.remove((Wrapper)Wrappers.lambdaQuery().eq(SysTenantUser::getTenantId, (Object)tenantId));
        this.sysTenantUserStruService.remove((Wrapper)Wrappers.lambdaQuery().eq(SysTenantUserStru::getTenantId, (Object)tenantId));
        if (HussarUtils.isEmpty((Object)userIdList) || HussarUtils.isEmpty((Object)userStruIdList)) {
            return;
        }
        ArrayList tenantUserList = Lists.newArrayList();
        for (Long userId : userIdList) {
            SysTenantUser sysTenantUser = new SysTenantUser();
            sysTenantUser.setUserId(userId);
            sysTenantUser.setTenantId(tenantId);
            tenantUserList.add(sysTenantUser);
        }
        this.sysTenantUserService.saveBatch((Collection)tenantUserList);
        List sysStrus = this.sysStruService.listByIds((Collection)userStruIdList);
        sysStruList.addAll(sysStrus);
        ArrayList sysTenantUserStruLis = Lists.newArrayList();
        if (HussarUtils.isNotEmpty((Object)userStruIdList)) {
            for (int i = 0; i < userStruIdList.size(); ++i) {
                SysTenantUserStru sysTenantUserStru = new SysTenantUserStru();
                sysTenantUserStru.setStruId((Long)userStruIdList.get(i));
                sysTenantUserStru.setTenantId(tenantId);
                sysTenantUserStruLis.add(sysTenantUserStru);
            }
            this.sysTenantUserStruService.saveBatch((Collection)sysTenantUserStruLis);
        }
        TenantAuthorizationUtils.noParentSetParent(sysStruList, (Long)11L);
        List organId = sysStrus.stream().map(SysStru::getOrganId).collect(Collectors.toList());
        List organList = this.sysOrganService.listByIds(organId);
        sysOrgans.addAll(organList);
        List officeList = this.sysOfficeService.list((Wrapper)new LambdaQueryWrapper().in(SysOffice::getStruId, (Collection)userStruIdList));
        sysOffices.addAll(officeList);
        List sysStruUsers = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, (Collection)userIdList));
        sysStruUserList.addAll(sysStruUsers);
        userIds.addAll(userIdList);
        List usersList = this.usersService.listByIds((Collection)userIdList);
        sysUsers.addAll(usersList);
        List sysStaffIds = usersList.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
        List staffList = this.sysStaffService.listByIds(sysStaffIds);
        sysStaffs.addAll(staffList);
        List sysStruStaffs = this.sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, sysStaffIds));
        sysStruStaffList.addAll(sysStruStaffs);
    }

    private <T, R> List<T> distinctById(List<T> list, Function<T, R> keyExtractor) {
        if (HussarUtils.isEmpty(list)) {
            return list;
        }
        return list.stream().collect(Collectors.collectingAndThen(Collectors.toMap(keyExtractor, item -> item, (oldValue, newValue) -> oldValue, LinkedHashMap::new), map -> new ArrayList(map.values())));
    }
}

