/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.ISysTenantDatasourceGroup;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDatasourceGroupService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantStruService;
import com.jxdinfo.hussar.tenant.common.service.impl.AbstractHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.groupingmodel.dao.SysTenantGroupingModelMapper;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SolitaryGroupingModelTenant;
import com.jxdinfo.hussar.tenant.groupingmodel.service.TenantGroupingModelService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.groupingmodel.service.impl.hussarBaseSolitaryGroupingModelTenantServiceImpl")
public class HussarBaseSolitaryGroupingModelTenantServiceImpl
extends AbstractHussarBaseTenantService<SolitaryGroupingModelTenant> {
    @Lazy
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantGroupingModelMapper sysTenantGroupingModelMapper;
    @Autowired
    private ISysTenantDatasourceGroupService sysTenantDatasourceService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantStruService sysTenantStruService;
    @Autowired
    private ISysTenantRecordService tenantRecordService;
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private TenantGroupingModelService tenantGroupingModelService;
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysBaseConfigService baseConfigService;

    public Page<SolitaryGroupingModelTenant> searchTenant(QueryTenantDto queryTenantDto) {
        Page page = new Page(queryTenantDto.getCurrent(), queryTenantDto.getSize());
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("tenantCode", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantCode()));
        queryOrgParams.put("tenantName", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantName()));
        queryOrgParams.put("tenantStatus", queryTenantDto.getTenantStatus());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SolitaryGroupingModelTenant> solitaryGroupingModelTenants = this.sysTenantGroupingModelMapper.searchSolitaryGroupingModelTenant(page, queryOrgParams);
        page.setRecords(solitaryGroupingModelTenants);
        return page;
    }

    public SolitaryGroupingModelTenant findTenantById(Long tenantId) {
        HussarTenantDefinition tenantByTenantId = this.getTenantByTenantId(tenantId);
        return (SolitaryGroupingModelTenant)TenantUtil.convert((HussarTenantDefinition)tenantByTenantId, SolitaryGroupingModelTenant.class);
    }

    public void initTenantAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setUserName(solitaryGroupingModelTenant.getLinkman());
        sysUsers.setMobile(solitaryGroupingModelTenant.getContactNumber());
        String userAccount = solitaryGroupingModelTenant.getUserAccount();
        if (this.usersService.count((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userAccount)) > 0L) {
            throw new BaseException("\u7528\u6237\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        sysUsers.setUserAccount(userAccount);
        TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
        String encodeSecure = TenantUtil.getEncodeSecure((String)solitaryGroupingModelTenant.getSecure());
        sysUsers.setPassword(encodeSecure);
        Integer userOrder = this.usersService.getUserMaxOrder();
        userOrder = HussarUtils.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        sysUsers.setUserOrder(userOrder);
        this.usersService.save((Object)sysUsers);
        this.usersService.save(connName, (Object)sysUsers);
        solitaryGroupingModelTenant.setTenantAdminId(sysUsers.getId());
    }

    public void afterAddTenant(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        String connName = solitaryGroupingModelTenant.getConnName();
        this.baseConfigService.update(connName, null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysBaseConfig::getConfigKey, (Object)"allow_change_pwd")).set(SysBaseConfig::getConfigValue, (Object)"1"));
        HussarCacheUtil.evictKeysLike((String)"base_config", (String)"allow_change_pwd");
    }

    public void initTenantThreeAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        this.tenantGroupingModelService.initTenantThreeAdmin(connName, solitaryGroupingModelTenant);
    }

    public void updateTenantTernaryAdmin(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        this.tenantGroupingModelService.updateTenantTernaryAdmin(connName, solitaryGroupingModelTenant);
    }

    public void saveTenant(SolitaryGroupingModelTenant solitaryTenant) {
        SysTenant tenant = TenantUtil.convert2SysTenant((HussarTenantDefinition)solitaryTenant);
        this.sysTenantService.saveOrUpdate((Object)tenant);
    }

    public boolean isUpdateTenantStru(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        List sysTenantStrus = this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)solitaryGroupingModelTenant.getTenantId()));
        List struIdListNew = solitaryGroupingModelTenant.getStruIdList();
        if (HussarUtils.isEmpty((Object)sysTenantStrus) && HussarUtils.isNotEmpty((Object)struIdListNew)) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)struIdListNew)) {
            List struIds = sysTenantStrus.stream().map(SysTenantStru::getStruId).collect(Collectors.toList());
            return struIds.size() != struIdListNew.size() || !new HashSet(struIdListNew).containsAll(struIds);
        }
        return false;
    }

    public boolean isUpdateTenantSource(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        boolean microService = EnvironmentUtil.isMicroService();
        Long tenantId = solitaryGroupingModelTenant.getTenantId();
        if (!microService) {
            ISysTenantDatasourceGroup sysTenantDatasources = (ISysTenantDatasourceGroup)this.sysTenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ISysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(ISysTenantDatasourceGroup::getServiceName));
            if (HussarUtils.isNotEmpty((Object)sysTenantDatasources)) {
                Long datasourceIdNew;
                Long dbIdOld = sysTenantDatasources.getDbId();
                return !HussarUtils.equals((Object)dbIdOld, (Object)(datasourceIdNew = solitaryGroupingModelTenant.getDatasourceId()));
            }
        } else {
            List storagePropertiesListNew = solitaryGroupingModelTenant.getStoragePropertiesList();
            int newDatasourceCount = storagePropertiesListNew.size();
            SysTenantRecord sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantId, (Object)tenantId));
            HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)JSON.parseObject((String)sysTenantRecord.getTenantParams(), HussarTenantDefinition.class);
            List storagePropertiesListOld = hussarTenantDefinition.getStoragePropertiesList();
            int oldDatasourceCount = storagePropertiesListOld.size();
            for (Map storagePropertiesNewMap : storagePropertiesListNew) {
                String serviceName = storagePropertiesNewMap.get("serviceName").toString();
                if (newDatasourceCount != oldDatasourceCount) {
                    return true;
                }
                Map storagePropertiesOldMap = storagePropertiesListOld.stream().filter(item -> item.get("serviceName").toString().equals(serviceName)).findFirst().orElse(null);
                if (storagePropertiesOldMap == null) {
                    return true;
                }
                if (HussarUtils.equals(storagePropertiesOldMap.get("jdbcUrl"), storagePropertiesNewMap.get("jdbcUrl")) && HussarUtils.equals(storagePropertiesOldMap.get("remark"), storagePropertiesNewMap.get("remark"))) continue;
                return true;
            }
        }
        return false;
    }

    public void initTenantStruAndUsers(String connName, SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        this.tenantGroupingModelService.initTenantStruAndUsers(connName, solitaryGroupingModelTenant);
    }

    public void initTenantDataSource(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        Long tenantId = solitaryGroupingModelTenant.getTenantId();
        this.removeTenantDatasource(tenantId);
        boolean microService = EnvironmentUtil.isMicroService();
        if (microService) {
            String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
            List storagePropertiesList = solitaryGroupingModelTenant.getStoragePropertiesList();
            boolean flag = false;
            for (Map storageProperties : storagePropertiesList) {
                if (!currentServiceName.equals(storageProperties.get("serviceName").toString())) continue;
                Long dbId = ((SysDataSource)this.datasourceService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getConnName, (Object)solitaryGroupingModelTenant.getConnName()))).getId();
                ISysTenantDatasourceGroup sysTenantDatasource = new ISysTenantDatasourceGroup();
                sysTenantDatasource.setTenantId(tenantId);
                sysTenantDatasource.setDbId(dbId);
                sysTenantDatasource.setServiceName(currentServiceName);
                this.sysTenantDatasourceService.save((Object)sysTenantDatasource);
                flag = true;
            }
            if (!flag) {
                throw new BaseException("\u672a\u627e\u5230\u9ed8\u8ba4\u670d\u52a1\u540d\u5bf9\u5e94\u7684serviceName");
            }
        } else {
            ISysTenantDatasourceGroup sysTenantDatasource = new ISysTenantDatasourceGroup();
            sysTenantDatasource.setTenantId(tenantId);
            sysTenantDatasource.setDbId(solitaryGroupingModelTenant.getDatasourceId());
            sysTenantDatasource.setServiceName(null);
            this.sysTenantDatasourceService.save((Object)sysTenantDatasource);
        }
    }

    public boolean isCreateDbFail(SolitaryGroupingModelTenant solitaryGroupingModelTenant) {
        return StepConstants.CREATE_DB == solitaryGroupingModelTenant.getStepNo();
    }

    public void removeTenantDatasource(Long tenantId) {
        this.sysTenantDatasourceService.remove((Wrapper)new LambdaQueryWrapper().eq(ISysTenantDatasourceGroup::getTenantId, (Object)tenantId));
    }
}

