/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.ISysTenantDatasourceGroup;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantMultUser;
import com.jxdinfo.hussar.tenant.common.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.common.model.SysTenantStruCancel;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUser;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUserStru;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDatasourceGroupService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantMultUserService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantStruCancelService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantStruService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUserService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SolitaryGroupingModelTenant;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantUserStruService;
import com.jxdinfo.hussar.tenant.groupingmodel.vo.SolitaryGroupingModelTenantVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"solitary\u79df\u6237"})
@RestController(value="com.jxdinfo.hussar.tenant.groupingmodel.controller.hussarBaseSolitaryGroupingModelTenantController")
@RequestMapping(value={"/hussarBase/tenant"})
public class HussarBaseSolitaryGroupingModelTenantController {
    @Autowired
    private IHussarBaseTenantService<SolitaryGroupingModelTenant> hussarBaseTenantService;
    @Autowired
    private ISysTenantDatasourceGroupService sysTenantDatasourceService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantStruService sysTenantStruService;
    @Autowired
    private DatasourceService datasourceService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Lazy
    @Autowired(required=false)
    private ISysTenantMultUserService tenantMultUserService;
    @Autowired
    private ISysUsersService usersService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Resource
    private ISysTenantUserService sysTenantUserService;
    @Resource
    private ISysTenantRecordService sysTenantRecordService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantStruCancelService sysTenantStruCancelService;
    @Resource
    private ISysTenantUserStruService sysTenantUserStruService;

    @PostMapping(value={"/addTenant"})
    @ApiOperation(value="\u65b0\u589e\u79df\u6237", notes="\u65b0\u589e\u79df\u6237")
    @CheckPermission(value={"hussarBase:tenant:addTenant"})
    public ApiResponse<String> addSolitaryTenant(@ApiParam(value="Tenant\u5b9e\u4f53") @RequestBody SolitaryGroupingModelTenant solitaryTenant) {
        return this.hussarBaseTenantService.addTenant((Object)solitaryTenant);
    }

    @PostMapping(value={"/editTenant"})
    @ApiOperation(value="\u4fee\u6539\u79df\u6237", notes="\u4fee\u6539\u79df\u6237")
    @CheckPermission(value={"hussarBase:tenant:editTenant"})
    public ApiResponse<String> editSolitaryTenant(@ApiParam(value="solitaryTenant\u5b9e\u4f53") @RequestBody SolitaryGroupingModelTenant solitaryTenant) {
        this.hussarBaseTenantService.editTenant((Object)solitaryTenant);
        return ApiResponse.success((String)"\u79df\u6237\u4fee\u6539\u6210\u529f\uff01");
    }

    @PostMapping(value={"/deleteTenant"})
    @ApiOperation(value="\u5220\u9664\u79df\u6237", notes="\u5220\u9664\u79df\u6237")
    @CheckPermission(value={"hussarBase:tenant:deleteTenant"})
    public ApiResponse<String> deleteSolitaryTenant(@ApiParam(value="\u79df\u6237id") @RequestBody Long tenantId) {
        this.hussarBaseTenantService.deleteTenant(tenantId);
        return ApiResponse.success((String)"\u79df\u6237\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/searchTenant"})
    @ApiOperation(value="\u67e5\u8be2\u79df\u6237\u5217\u8868", notes="\u67e5\u8be2\u79df\u6237\u5217\u8868")
    public ApiResponse<Page<SolitaryGroupingModelTenant>> searchSolitaryTenant(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") QueryTenantDto queryTenantDto) {
        return ApiResponse.success((Object)this.hussarBaseTenantService.searchTenant(queryTenantDto));
    }

    @GetMapping(value={"/viewTenant"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u79df\u6237\u4fe1\u606f", notes="\u6839\u636eid\u67e5\u8be2\u79df\u6237\u4fe1\u606f")
    public ApiResponse<SolitaryGroupingModelTenantVo> viewTenant(@ApiParam(value="\u79df\u6237id") @RequestParam Long tenantId) {
        List sysTenantUserStruList;
        Object organNameAndId;
        List userIds;
        List struCanelIds;
        List struIds;
        ISysTenantDatasourceGroup sysTenantDatasource;
        boolean microService;
        HussarTenantDefinition definition = this.hussarBaseTenantService.getTenantByTenantId(tenantId);
        List storagePropertiesList = definition.getStoragePropertiesList();
        if (HussarUtils.isNotEmpty((Object)storagePropertiesList)) {
            for (Map temp : storagePropertiesList) {
                Map map;
                String suffix = "single";
                microService = EnvironmentUtil.isMicroService();
                if (microService) {
                    suffix = (String)temp.get("serviceName");
                }
                if (HussarUtils.isEmpty((Object)(map = TenantCacheUtil.loadDatasourceFromCache((String)definition.getTenantCode(), (String)suffix)))) continue;
                temp.putAll(map);
            }
            definition.setStoragePropertiesList(storagePropertiesList);
        }
        SolitaryGroupingModelTenantVo convert = (SolitaryGroupingModelTenantVo)TenantUtil.convert((HussarTenantDefinition)definition, SolitaryGroupingModelTenantVo.class);
        long count = this.sysTenantLogService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)definition.getTenantCode())).eq(SysTenantLog::getExecStatus, (Object)0)).eq(SysTenantLog::getStepNo, (Object)StepConstants.CREATE_DB));
        if (count > 0L) {
            convert.setStepNo(StepConstants.CREATE_DB);
        }
        if (!(microService = EnvironmentUtil.isMicroService()) && null != (sysTenantDatasource = (ISysTenantDatasourceGroup)this.sysTenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ISysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(ISysTenantDatasourceGroup::getServiceName)))) {
            Long dbId = sysTenantDatasource.getDbId();
            String dbName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getDbName();
            HashMap<Long, String> datasourceInfo = new HashMap<Long, String>();
            datasourceInfo.put(dbId, dbName);
            convert.setDatasourceInfo(datasourceInfo);
        }
        if (HussarUtils.isNotEmpty(struIds = this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)tenantId)).stream().map(SysTenantStru::getStruId).collect(Collectors.toList()))) {
            List organNameAndIds = this.sysStruMapper.getOrganNameAndId(struIds);
            convert.setStruInfo(organNameAndIds);
        }
        if (HussarUtils.isNotEmpty(struCanelIds = this.sysTenantStruCancelService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantStruCancel::getTenantId, (Object)tenantId)).stream().map(SysTenantStruCancel::getStruId).collect(Collectors.toList()))) {
            List organNameAndIdsCencel = this.sysStruMapper.getOrganNameAndId(struCanelIds);
            convert.setStruInfoCancel(organNameAndIdsCencel);
        }
        if (HussarUtils.isNotEmpty(userIds = this.sysTenantUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantUser::getTenantId, (Object)tenantId)).stream().map(SysTenantUser::getUserId).collect(Collectors.toList()))) {
            List userVoList = this.sysUsersMapper.getUserAndStruIdByIds(userIds);
            convert.setUserInfo(userVoList);
            List userStruIds = userVoList.stream().map(UserVo::getStruId).collect(Collectors.toList());
            organNameAndId = this.sysStruMapper.getOrganNameAndId(userStruIds);
            convert.setUserStruInfo((List)organNameAndId);
        }
        if (HussarUtils.isNotEmpty((Object)(sysTenantUserStruList = this.sysTenantUserStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantUserStru::getTenantId, (Object)tenantId))))) {
            List struIdList = sysTenantUserStruList.stream().map(SysTenantUserStru::getStruId).collect(Collectors.toList());
            organNameAndId = this.sysStruMapper.getOrganNameAndId(struIdList);
            List list = convert.getUserStruInfo();
            if (HussarUtils.isEmpty((Object)list)) {
                convert.setUserStruInfo((List)organNameAndId);
            } else {
                List organVoIds = list.stream().map(OrganVo::getId).collect(Collectors.toList());
                for (int i = 0; i < organNameAndId.size(); ++i) {
                    OrganVo organVo = (OrganVo)organNameAndId.get(i);
                    if (organVoIds.contains(organVo.getId())) continue;
                    list.add(organVo);
                }
                convert.setUserStruInfo(list);
            }
        }
        Map<String, Long> tenantMultUserMap = this.tenantMultUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantMultUser::getTenantId, (Object)tenantId)).stream().collect(Collectors.toMap(SysTenantMultUser::getUserType, SysTenantMultUser::getUserId));
        for (Map.Entry entry : tenantMultUserMap.entrySet()) {
            SysUsers sysUsers;
            if ("0".equals(entry.getKey())) {
                sysUsers = this.usersService.getById(tenantMultUserMap.get("0"));
                convert.setSecuritySecrecyName(sysUsers.getUserName());
                convert.setSecuritySecrecyAccount(sysUsers.getUserAccount());
                continue;
            }
            if ("1".equals(entry.getKey())) {
                sysUsers = this.usersService.getById(tenantMultUserMap.get("1"));
                convert.setSecurityAuditName(sysUsers.getUserName());
                convert.setSecurityAuditAccount(sysUsers.getUserAccount());
                continue;
            }
            if (!"2".equals(entry.getKey())) continue;
            sysUsers = this.usersService.getById(tenantMultUserMap.get("2"));
            convert.setSystemManageName(sysUsers.getUserName());
            convert.setSystemManageAccount(sysUsers.getUserAccount());
        }
        Long tenantAdminId = convert.getTenantAdminId();
        SysUsers sysUsers = this.usersService.getById(tenantAdminId);
        if (HussarUtils.isNotEmpty((Object)sysUsers)) {
            convert.setLinkman(sysUsers.getUserName());
            convert.setUserAccount(sysUsers.getUserAccount());
            convert.setContactNumber(sysUsers.getMobile());
        }
        return ApiResponse.success((Object)convert);
    }
}

