/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.feign.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@DependsOn(value={"springContextHolder"})
@Service(value="com.jxdinfo.hussar.tenant.groupingmodel.service.feign.impl.remoteGroupingModelTenantTypeParseServiceImpl")
public class RemoteGroupingModelTenantTypeParseServiceImpl
implements IHussarTenantCommonService {
    @Lazy
    @Autowired(required=false)
    private ISysTenantService tenantService;

    public HussarTenantDefinition parse() {
        String tenantCode = TenantCommonUtil.getTenantCodeByUrl();
        if (HussarUtils.isNotBlank((CharSequence)tenantCode)) {
            return this.search(tenantCode);
        }
        return new DefaultTenant();
    }

    public HussarTenantDefinition search(String tenantCode) {
        HussarTenantDefinition tenantByTenantCode = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
        if (HussarUtils.isEmpty((Object)tenantByTenantCode)) {
            if (tenantCode.equalsIgnoreCase("0")) {
                DefaultTenant defaultTenant = new DefaultTenant();
                defaultTenant.setTenantName("\u5e73\u53f0\u7ea7");
                return defaultTenant;
            }
            tenantByTenantCode = this.tenantService.getTenantByTenantCode(tenantCode);
        }
        return tenantByTenantCode;
    }
}

