/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeMetaInfo;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeMetaTotal;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeMetaInfoService;
import com.jxdinfo.hussar.tenant.common.service.IUpgradeJsonLoadService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.common.service.impl.SysTenantUpgradeMetaInfoServiceImpl")
public class SysTenantUpgradeMetaInfoServiceImpl
implements ISysTenantUpgradeMetaInfoService {
    private Map<String, UpgradeMetaTotal> upgradeMetaInfoMap = new LinkedHashMap<String, UpgradeMetaTotal>();
    private Map<String, Integer> versionOrderMap = new LinkedHashMap<String, Integer>();
    @Autowired
    private IUpgradeJsonLoadService upgradeJsonLoadService;

    public void init() {
        this.upgradeJsonLoadService.loadUpgradeJson();
        this.upgradeMetaInfoMap = this.upgradeJsonLoadService.getMetaTotalInfoMap();
        this.versionOrderMap = this.upgradeJsonLoadService.getVersionOrderMap();
    }

    public Map<String, UpgradeMetaTotal> getUpgradeMetaInfoMap() {
        return this.upgradeMetaInfoMap;
    }

    public List<UpgradeMetaInfo> getVersionMetaNoContainFrom(String fromVersion, String toVersion) {
        if (HussarUtils.isEmpty(this.upgradeMetaInfoMap)) {
            return new ArrayList<UpgradeMetaInfo>();
        }
        Integer start = this.versionOrderMap.get(fromVersion);
        Integer end = this.versionOrderMap.get(toVersion);
        Collection<UpgradeMetaTotal> values = this.upgradeMetaInfoMap.values();
        ArrayList<UpgradeMetaInfo> result = new ArrayList<UpgradeMetaInfo>();
        for (UpgradeMetaTotal ut : values) {
            List upgradeAllSteps = ut.getUpgradeAllSteps();
            if (HussarUtils.isEmpty((Object)upgradeAllSteps)) continue;
            for (UpgradeMetaInfo um : upgradeAllSteps) {
                um.setDirName(ut.getDirName());
                Integer order = um.getOrder();
                if (order <= start || order > end) continue;
                result.add(um);
            }
        }
        return result;
    }

    public List<UpgradeMetaInfo> getVersionMeta(String fromVersion, String toVersion) {
        Collection<UpgradeMetaTotal> values = this.upgradeMetaInfoMap.values();
        ArrayList<UpgradeMetaInfo> result = new ArrayList<UpgradeMetaInfo>();
        for (UpgradeMetaTotal ut : values) {
            List upgradeAllSteps = ut.getUpgradeAllSteps();
            if (HussarUtils.isEmpty((Object)upgradeAllSteps)) continue;
            for (UpgradeMetaInfo um : upgradeAllSteps) {
                String version = um.getVersion();
                if (version.compareTo(fromVersion) < 0 || version.compareTo(toVersion) > 0) continue;
                result.add(um);
            }
        }
        return result;
    }

    public List<UpgradeMetaInfo> getUpgradeMetaInfoByVersion(String version) {
        if (HussarUtils.isEmpty(this.upgradeMetaInfoMap)) {
            return null;
        }
        ArrayList<UpgradeMetaInfo> result = new ArrayList<UpgradeMetaInfo>();
        this.upgradeMetaInfoMap.forEach((k, v) -> {
            List upgradeAllSteps = v.getUpgradeAllSteps();
            if (HussarUtils.isNotEmpty((Object)upgradeAllSteps)) {
                for (UpgradeMetaInfo um : upgradeAllSteps) {
                    if (!um.getVersion().equalsIgnoreCase(version)) continue;
                    result.add(um);
                }
            }
        });
        return result;
    }
}

