/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.tenant.common.dto.SysTenantUpgradeCountDto;
import com.jxdinfo.hussar.tenant.common.dto.SysTenantUpgradeRecordDto;
import com.jxdinfo.hussar.tenant.common.dto.TenantVersionDto;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeMetaInfo;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeStep;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgradeRecord;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantExecuteStepListService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeMetaInfoService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.service.IUpgradeProcedureService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUpgradeScriptUtils;
import com.jxdinfo.hussar.tenant.common.util.TenantUpgradeUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;

@Service(value="com.jxdinfo.hussar.tenant.common.service.impl.sysTenantExecuteStepListServiceImpl")
public class SysTenantExecuteStepListServiceImpl
implements ISysTenantExecuteStepListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysTenantExecuteStepListServiceImpl.class);
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Autowired
    private IUpgradeProcedureService upgradeProcedureService;
    @Autowired
    private ISysTenantUpgradeMetaInfoService sysTenantUpgradeMetaInfoService;
    @Autowired
    private ISysTenantUpgradeService sysTenantUpgradeService;
    @Autowired
    private ISysTenantUpgradeRecordService sysTenantUpgradeRecordService;
    @Autowired
    private ISysTenantService sysTenantService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch(List<SysTenantUpgrade> tenantUpgradeList) {
        this.sysTenantUpgradeMetaInfoService.init();
        Map upgradeMetaTotalMap = this.sysTenantUpgradeMetaInfoService.getUpgradeMetaInfoMap();
        LinkedMultiValueMap multiValueLevelMap = new LinkedMultiValueMap();
        ConcurrentHashMap<Long, String> result = new ConcurrentHashMap<Long, String>();
        for (SysTenantUpgrade sysTenantUpgrade : tenantUpgradeList) {
            multiValueLevelMap.add((Object)sysTenantUpgrade.getConnName(), (Object)sysTenantUpgrade);
            sysTenantUpgrade.setUpdateStatus("1");
        }
        LinkedHashMap programMap = new LinkedHashMap();
        if (HussarUtils.isEmpty((Object)upgradeMetaTotalMap)) {
            return;
        }
        upgradeMetaTotalMap.forEach((k, v) -> {
            List upgradeAllSteps = v.getUpgradeAllSteps();
            for (UpgradeMetaInfo item : upgradeAllSteps) {
                List upgradeSteps = item.getUpgradeSteps();
                ArrayList<UpgradeStep> temp = new ArrayList<UpgradeStep>();
                for (UpgradeStep us : upgradeSteps) {
                    if (!us.getType().equalsIgnoreCase("procedure")) continue;
                    temp.add(us);
                }
                programMap.put(item.getVersion(), temp);
            }
        });
        Set connSet = multiValueLevelMap.keySet();
        String serviceName = EnvironmentUtil.getServiceName();
        for (String connName : connSet) {
            ItemDataSource itemDataSource = this.dynamicDatasourceService.getDatasourceByPoolName(connName);
            String jdbcUrl = itemDataSource.getUrl();
            String dbMode = itemDataSource.getDbMode();
            DbType dbType_ = itemDataSource.getDbType();
            List execList = multiValueLevelMap.get((Object)connName);
            String toVersion = ((SysTenantUpgrade)execList.get(execList.size() - 1)).getCurrentVersion();
            Long tenantId = ((SysTenantUpgrade)execList.get(0)).getTenantId();
            HussarTenantDefinition tenantByTenantId = this.sysTenantService.getTenantByTenantId(tenantId);
            if (DbType.KINGBASE_ES.equals((Object)dbType_) && StringUtils.isBlank((CharSequence)dbMode)) {
                List storagePropertiesList = tenantByTenantId.getStoragePropertiesList();
                for (Map storageProperties : storagePropertiesList) {
                    String driverClass = (String)storageProperties.get("driverClass");
                    String serviceName_ = (String)storageProperties.get("serviceName");
                    if (!driverClass.contains("kingbase") || !serviceName_.equals(serviceName)) continue;
                    dbMode = (String)storageProperties.get("dbMode");
                    break;
                }
            }
            if (StringUtils.isBlank((CharSequence)dbMode)) {
                dbMode = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.datasource.dynamic.datasource.master.db-mode");
            }
            String upgradeSqlDirName = TenantUpgradeUtil.getUpgradeSqlDirName((String)jdbcUrl, (String)dbMode);
            String dbType = TenantUpgradeUtil.getDbType((String)jdbcUrl, (String)dbMode);
            String fromVersion = tenantByTenantId.getTenantVersion();
            SysTenantUpgradeRecordDto sysTenantUpgradeRecordDto = new SysTenantUpgradeRecordDto();
            sysTenantUpgradeRecordDto.setTenantId(tenantId);
            sysTenantUpgradeRecordDto.setFromVersion(fromVersion);
            sysTenantUpgradeRecordDto.setToVersion(toVersion);
            SysTenantUpgradeCountDto sysTenantUpgradeCountDto = new SysTenantUpgradeCountDto();
            sysTenantUpgradeCountDto.setTenantId(tenantId);
            sysTenantUpgradeCountDto.setFromVersion(fromVersion);
            Integer start = this.sysTenantUpgradeService.getUpgradeStep(sysTenantUpgradeCountDto);
            sysTenantUpgradeCountDto.setStart(start);
            boolean flag = true;
            SysTenantUpgradeRecord sysTenantUpgradeRecord = this.sysTenantUpgradeRecordService.getSysTenantUpgradeRecord(sysTenantUpgradeRecordDto);
            for (SysTenantUpgrade stu : execList) {
                Connection connection = null;
                String upgradeType = stu.getUpgradeType();
                String version = stu.getCurrentVersion();
                String upgradeDescription = stu.getUpgradeDescription();
                String realdesc = upgradeDescription.substring(upgradeDescription.lastIndexOf(":") + 1);
                String sqlPath = stu.getSqlPath();
                String dirName = stu.getDirName();
                List upgradeSteps = (List)programMap.get(version);
                Optional<UpgradeStep> first = upgradeSteps.stream().filter(i -> realdesc.equals(i.getDescription())).findFirst();
                if ("procedure".equalsIgnoreCase(upgradeType)) {
                    if (!flag) continue;
                    try {
                        connection = itemDataSource.getConnection();
                        connection.setAutoCommit(false);
                        this.upgradeProcedureService.invoke(first.get().getUpgradeProcedures());
                        result.put(stu.getId(), "1");
                        stu.setUpdateStatus("1");
                        connection.commit();
                        continue;
                    }
                    catch (Exception e) {
                        result.put(stu.getId(), "0");
                        stu.setUpdateStatus("0");
                        stu.setUpdateError("\u6267\u884c\u7a0b\u5e8f\u5931\u8d25\uff1a" + ExceptionUtil.getExceptionAllinformation((Throwable)e));
                        try {
                            connection.rollback();
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                        flag = false;
                        continue;
                    }
                    finally {
                        try {
                            connection.setAutoCommit(true);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        this.sysTenantUpgradeService.updateTenantUpgrade(stu);
                        LOGGER.info("\u66f4\u65b0\u6b65\u9aa4{}\u72b6\u6001\u4e3a{}", (Object)stu.getId(), (Object)stu.getUpdateStatus());
                        continue;
                    }
                }
                if (!flag) continue;
                try {
                    connection = itemDataSource.getConnection();
                    connection.setAutoCommit(false);
                    String classpathSql = null;
                    classpathSql = sqlPath.startsWith("/tenantsql/upgrade/") ? sqlPath : "/tenantsql/upgrade/" + dirName + "/" + upgradeType + "/" + upgradeSqlDirName + "/" + sqlPath;
                    ClassPathResource classPathResource = new ClassPathResource(classpathSql);
                    TenantUpgradeScriptUtils.executeSqlScript((Connection)connection, (String)dbType, (Resource)classPathResource);
                    stu.setSqlPath(classpathSql);
                    result.put(stu.getId(), "1");
                    stu.setUpdateStatus("1");
                    connection.commit();
                }
                catch (Exception e) {
                    result.put(stu.getId(), "0");
                    stu.setUpdateStatus("0");
                    stu.setUpdateError("\u6267\u884cSQL\u5931\u8d25\uff1a" + ExceptionUtil.getExceptionAllinformation((Throwable)e));
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    flag = false;
                }
                finally {
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    this.sysTenantUpgradeService.updateTenantUpgrade(stu);
                    LOGGER.info("\u66f4\u65b0\u6b65\u9aa4{}\u72b6\u6001\u4e3a{}", (Object)stu.getId(), (Object)stu.getUpdateStatus());
                }
            }
            long count = this.sysTenantUpgradeService.countNeSuccess(sysTenantUpgradeCountDto);
            if (count == 0L) {
                sysTenantUpgradeRecord.setUpdateStatus("1");
                TenantVersionDto tenantVersionDto = new TenantVersionDto();
                tenantVersionDto.setTenantId(tenantId);
                tenantVersionDto.setVersion(sysTenantUpgradeRecord.getToVersion());
                this.sysTenantService.updateTenantVersion(tenantVersionDto);
            } else {
                long count2 = this.sysTenantUpgradeService.countFail(sysTenantUpgradeCountDto);
                if (count2 > 0L) {
                    sysTenantUpgradeRecord.setUpdateStatus("0");
                }
            }
            this.sysTenantUpgradeRecordService.updateTenantUpgradeRecord(sysTenantUpgradeRecord);
        }
    }
}

