/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.support;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeMetaInfo;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeMetaTotal;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeStep;
import com.jxdinfo.hussar.tenant.common.service.IUpgradeJsonLoadService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.common.support.UpgradeJsonLoadServiceImpl")
public class UpgradeJsonLoadServiceImpl
implements IUpgradeJsonLoadService {
    public static final String UPGRADE_JSON_RESOURCE_LOCATION = "tenantsql/upgrade/upgrade.json";
    private static final Logger logger = LoggerFactory.getLogger(UpgradeJsonLoadServiceImpl.class);
    static final Map<String, UpgradeMetaTotal> cache = new LinkedHashMap<String, UpgradeMetaTotal>();
    static final Set<String> versionSet = new LinkedHashSet<String>();
    static final Map<String, Integer> versionOrderMap = new LinkedHashMap<String, Integer>();
    private static final String DEFAULT_VERSION = "9.3.0";
    private final ConfigurableApplicationContext applicationContext;

    public UpgradeJsonLoadServiceImpl(ConfigurableApplicationContext context) {
        this.applicationContext = context;
    }

    public void loadUpgradeJson() {
        versionSet.add(DEFAULT_VERSION);
        versionOrderMap.put(DEFAULT_VERSION, 1);
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        if (null == classLoader) {
            throw new BaseException("classLoader\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Enumeration<URL> urls = null;
        try {
            urls = classLoader.getResources(UPGRADE_JSON_RESOURCE_LOCATION);
        }
        catch (IOException e) {
            logger.info("\u672a\u8bfb\u53d6\u5230{}", (Object)UPGRADE_JSON_RESOURCE_LOCATION);
        }
        if (null != urls) {
            ArrayList<UpgradeMetaTotal> list = new ArrayList<UpgradeMetaTotal>();
            try {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    this.addMetaList(list, url);
                }
                if (HussarUtils.isEmpty(list)) {
                    return;
                }
                this.sortAndInit(list);
            }
            catch (IOException ex) {
                logger.error("Unable to load upgrade.json from location [{}]", (Object)UPGRADE_JSON_RESOURCE_LOCATION);
                throw new BaseException("Unable to load upgrade.json from location [tenantsql/upgrade/upgrade.json]", (Throwable)ex);
            }
        }
    }

    private void sortAndInit(List<UpgradeMetaTotal> list) {
        Collections.sort(list, Comparator.comparingInt(UpgradeMetaTotal::getGlobalOrder));
        for (UpgradeMetaTotal t : list) {
            List upgradeAllSteps = t.getUpgradeAllSteps();
            if (HussarUtils.isEmpty((Object)upgradeAllSteps)) continue;
            Collections.sort(upgradeAllSteps, Comparator.comparingInt(UpgradeMetaInfo::getOrder));
            for (UpgradeMetaInfo upgradeMetaInfo : upgradeAllSteps) {
                List upgradeSteps = upgradeMetaInfo.getUpgradeSteps();
                if (upgradeMetaInfo.getOrder() == 1 && !upgradeMetaInfo.getVersion().equals(DEFAULT_VERSION)) {
                    versionSet.remove(DEFAULT_VERSION);
                    versionOrderMap.remove(DEFAULT_VERSION);
                    versionSet.add(upgradeMetaInfo.getVersion());
                    versionOrderMap.put(upgradeMetaInfo.getVersion(), upgradeMetaInfo.getOrder());
                }
                if (HussarUtils.isEmpty((Object)upgradeSteps)) continue;
                Collections.sort(upgradeSteps, Comparator.comparingInt(UpgradeStep::getStep));
                versionSet.add(upgradeMetaInfo.getVersion());
                versionOrderMap.put(upgradeMetaInfo.getVersion(), upgradeMetaInfo.getOrder());
            }
            cache.put(t.getDirName(), t);
        }
    }

    private void addMetaList(List<UpgradeMetaTotal> list, URL url) throws IOException {
        boolean add;
        UrlResource resource = new UrlResource(url);
        String content = IOUtils.toString((InputStream)resource.getInputStream(), (String)"UTF-8");
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        UpgradeMetaTotal upgradeMetaTotal = (UpgradeMetaTotal)JSON.parseObject((String)content, UpgradeMetaTotal.class);
        boolean bl = add = null != upgradeMetaTotal && StringUtils.isNotBlank((CharSequence)upgradeMetaTotal.getDirName()) && null == cache.get(upgradeMetaTotal.getDirName());
        if (add) {
            list.add(upgradeMetaTotal);
        }
    }

    public Map<String, UpgradeMetaTotal> getMetaTotalInfoMap() {
        if (HussarUtils.isEmpty(cache)) {
            this.loadUpgradeJson();
        }
        return cache;
    }

    public Set<String> getAllVersion() {
        if (HussarUtils.isEmpty(versionSet)) {
            this.loadUpgradeJson();
        }
        return versionSet;
    }

    public String getNextVersion(String version) {
        if (HussarUtils.isEmpty(versionSet)) {
            this.loadUpgradeJson();
        }
        LinkedHashSet linkedHashSet = (LinkedHashSet)versionSet;
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            String e = (String)iterator.next();
            if (!e.equalsIgnoreCase(version)) continue;
            return (String)iterator.next();
        }
        return "unknow";
    }

    public Map<String, Integer> getVersionOrderMap() {
        if (HussarUtils.isEmpty(versionOrderMap)) {
            this.loadUpgradeJson();
        }
        return versionOrderMap;
    }

    public List<String> getSelectVersionList(String maxVersion) {
        ArrayList<String> result = new ArrayList<String>();
        LinkedHashSet linkedHashSet = (LinkedHashSet)versionSet;
        Iterator iterator = linkedHashSet.iterator();
        boolean add = false;
        while (iterator.hasNext()) {
            String e = (String)iterator.next();
            if (add) {
                result.add(e);
            }
            if (!e.equalsIgnoreCase(maxVersion)) continue;
            add = true;
        }
        return result;
    }
}

