/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.manager.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarTenantExtendProperties;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseDatabaseOperateService;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.tenant.common.manager.ISchemaManager;
import java.io.IOException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.init.UncategorizedScriptException;

public class DefaultSchemaManagerImpl
implements ISchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSchemaManagerImpl.class);
    @Autowired
    private SysDataSourceService sysDataSourceService;
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSQLExecutor;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Autowired
    private HussarTenantExtendProperties hussarTenantExtendProperties;
    @Value(value="${spring.datasource.dynamic.datasource.master.db-mode:kingbase_oracle}")
    private String KingBaseMode;

    public SysDataSourceDto createSchemaAndInitData(SysDataSourceDto sysDataSourceDto) throws BaseException, IOException, SQLException, InterruptedException, UncategorizedScriptException {
        String dbType = DbUtil.getDbType((String)sysDataSourceDto.getJdbcUrl());
        IHussarBaseDatabaseOperateService hussarBaseDatabaseOperateService = DatabaseFactory.get((String)dbType);
        String connName = sysDataSourceDto.getConnName();
        LOGGER.info("\u521b\u5efa\u6570\u636e\u6e90{}\uff0c\u5e76\u6267\u884c\u811a\u672c\u3002\u3002\u3002", (Object)connName);
        Boolean isConnect = hussarBaseDatabaseOperateService.tryConnection(sysDataSourceDto);
        if (!isConnect.booleanValue()) {
            hussarBaseDatabaseOperateService.createSchema(sysDataSourceDto);
        }
        if (this.hussarTenantExtendProperties.isAutoCreateDb()) {
            this.sysDataSourceService.saveDataSourceWithCheck(sysDataSourceDto, false);
        }
        if (this.hussarTenantExtendProperties.isAutoExecuteSql()) {
            this.hussarBaseSQLExecutor.execTenantSqlFile(connName, dbType, hussarBaseDatabaseOperateService.getInitExecuteSQLScripts());
        }
        if (this.hussarTenantExtendProperties.isAutoCreateDb()) {
            sysDataSourceDto.setStatus("1");
            sysDataSourceDto.setInstantName(connName);
            this.sysDataSourceService.updateById((Object)sysDataSourceDto);
        }
        return sysDataSourceDto;
    }

    public boolean tryConnection(SysDataSourceDto sysDataSourceDto) {
        String dbType = DbUtil.getDbType((String)sysDataSourceDto.getJdbcUrl());
        if ("kingbasees".equals(dbType) && "kingbase_pg".equals(this.KingBaseMode)) {
            dbType = "postgresql";
        }
        IHussarBaseDatabaseOperateService hussarBaseDatabaseOperateService = DatabaseFactory.get((String)dbType);
        return hussarBaseDatabaseOperateService.tryConnection(sysDataSourceDto);
    }
}

