/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.config;

import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.jxdinfo.hussar.platform.core.support.service.CacheCreatorService;
import com.jxdinfo.hussar.support.datasource.config.DynamicDatasourceConfig;
import com.jxdinfo.hussar.support.datasource.support.HeaderDatasourceKey;
import com.jxdinfo.hussar.tenant.common.cache.DynamicCachePrefixServiceImpl;
import com.jxdinfo.hussar.tenant.common.interceptor.HussarTenantInterceptor;
import com.jxdinfo.hussar.tenant.common.processer.TenantDatasourceKeyProcesser;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnProperty(prefix="hussar.core.tenant", name={"enabled"}, havingValue="true", matchIfMissing=false)
@Configuration
@AutoConfigureBefore(value={DynamicDatasourceConfig.class})
public class HussarTenantCommonAutoConfig
implements WebMvcConfigurer {
    @Bean(value={"com.jxdinfo.hussar.tenant.common.interceptor.hussarTenantInterceptor"})
    public HussarTenantInterceptor hussarTenantInterceptor() {
        return new HussarTenantInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.hussarTenantInterceptor()).addPathPatterns(new String[]{"/**"});
        super.addInterceptors(registry);
    }

    @Bean
    public HeaderDatasourceKey headerDatasourceKey() {
        return new TenantDatasourceKeyProcesser();
    }

    @Bean(value={"com.jxdinfo.hussar.tenant.cache.dynamicCachePrefixServiceImpl"})
    public CacheCreatorService tenantCacheCreatorService() {
        return new DynamicCachePrefixServiceImpl();
    }

    @Bean(value={"com.jxdinfo.hussar.tenant.tenantIdWorker"})
    public DefaultIdentifierGenerator tenantIdWorker() {
        return new DefaultIdentifierGenerator(8L, 8L);
    }
}

