/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.domain.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.domain.model.SolitarydomainTenant;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"solitary\u79df\u6237"})
@RestController(value="com.jxdinfo.hussar.tenant.domain.controller.hussarBaseSolitarydomainTenantController")
@RequestMapping(value={"/hussarBase/tenant"})
public class HussarBaseSolitarydomainTenantController {
    @Autowired
    private IHussarBaseTenantService<SolitarydomainTenant> hussarBaseTenantService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysUsersService sysUsersService;

    @PostMapping(value={"/addTenant"})
    @ApiOperation(value="\u65b0\u589e\u79df\u6237", notes="\u65b0\u589e\u79df\u6237")
    @CheckPermission(value={"hussarBase:tenant:addTenant"})
    public ApiResponse<String> addSolitaryTenant(@ApiParam(value="Tenant\u5b9e\u4f53") @RequestBody SolitarydomainTenant solitaryTenant) {
        return this.hussarBaseTenantService.addTenant((Object)solitaryTenant);
    }

    @PostMapping(value={"/editTenant"})
    @ApiOperation(value="\u4fee\u6539\u79df\u6237", notes="\u4fee\u6539\u79df\u6237")
    @CheckPermission(value={"hussarBase:tenant:editTenant"})
    public ApiResponse<String> editSolitaryTenant(@ApiParam(value="solitaryTenant\u5b9e\u4f53") @RequestBody SolitarydomainTenant solitaryTenant) {
        String domain = solitaryTenant.getTenantDomain();
        AssertUtil.isNotEmpty((String)domain, (String)"\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        boolean duplicate = this.sysTenantService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantDomain, (Object)domain)).ne(SysTenant::getId, (Object)solitaryTenant.getTenantId())) > 0L;
        AssertUtil.isFalse((boolean)duplicate, (String)"\u57df\u540d\u91cd\u590d\uff01");
        this.hussarBaseTenantService.editTenant((Object)solitaryTenant);
        return ApiResponse.success((String)"\u79df\u6237\u4fee\u6539\u6210\u529f\uff01");
    }

    @PostMapping(value={"/deleteTenant"})
    @ApiOperation(value="\u5220\u9664\u79df\u6237", notes="\u5220\u9664\u79df\u6237")
    @CheckPermission(value={"hussarBase:tenant:deleteTenant"})
    public ApiResponse<String> deleteSolitaryTenant(@ApiParam(value="\u79df\u6237id") @RequestBody Long tenantId) {
        this.hussarBaseTenantService.deleteTenant(tenantId);
        return ApiResponse.success((String)"\u79df\u6237\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/searchTenant"})
    @ApiOperation(value="\u67e5\u8be2\u79df\u6237\u5217\u8868", notes="\u67e5\u8be2\u79df\u6237\u5217\u8868")
    public ApiResponse<Page<SolitarydomainTenant>> searchSolitaryTenant(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") QueryTenantDto queryTenantDto) {
        return ApiResponse.success((Object)this.hussarBaseTenantService.searchTenant(queryTenantDto));
    }

    @GetMapping(value={"/viewTenant"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u79df\u6237\u4fe1\u606f", notes="\u6839\u636eid\u67e5\u8be2\u79df\u6237\u4fe1\u606f")
    public ApiResponse<SolitarydomainTenant> viewTenant(@ApiParam(value="\u79df\u6237id") @RequestParam Long tenantId) {
        HussarTenantDefinition definition = this.hussarBaseTenantService.getTenantByTenantId(tenantId);
        List storagePropertiesList = definition.getStoragePropertiesList();
        for (Map temp : storagePropertiesList) {
            String suffix = "single";
            boolean microService = EnvironmentUtil.isMicroService();
            if (microService) {
                suffix = (String)temp.get("serviceName");
            }
            temp.put("password", "");
            Map map = TenantCacheUtil.loadDatasourceFromCache((String)definition.getTenantCode(), (String)suffix);
            if (HussarUtils.isEmpty((Object)map)) continue;
            map.put("password", "");
            temp.putAll(map);
        }
        definition.setStoragePropertiesList(storagePropertiesList);
        SolitarydomainTenant convert = (SolitarydomainTenant)TenantUtil.convert((HussarTenantDefinition)definition, SolitarydomainTenant.class);
        Long tenantAdminId = convert.getTenantAdminId();
        if ("4".equals(definition.getTenantStatus())) {
            return ApiResponse.success((Object)convert);
        }
        SysUsers user = (SysUsers)this.sysUsersService.getById(convert.getConnName(), (Serializable)tenantAdminId);
        if (HussarUtils.isNotEmpty((Object)user)) {
            convert.setLinkman(user.getUserName());
            convert.setUserAccount(user.getUserAccount());
            convert.setContactNumber(user.getMobile());
        }
        return ApiResponse.success((Object)convert);
    }
}

