/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.domain.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import com.jxdinfo.hussar.tenant.domain.model.SolitarydomainTenant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"springContextHolder"})
@Service(value="com.jxdinfo.hussar.tenant.domain.service.impl.domainTenantTypeParseServiceImpl")
public class DomainTenantTypeParseServiceImpl
implements IHussarTenantCommonService {
    @Autowired
    private IHussarBaseTenantService<SolitarydomainTenant> hussarBaseTenantService;

    public HussarTenantDefinition parse() {
        String domain = TenantCommonUtil.getTenantCodeByDomain();
        if (!TenantCommonUtil.isLocal((String)domain)) {
            return this.search(domain);
        }
        return new DefaultTenant();
    }

    public HussarTenantDefinition search(String domain) {
        HussarTenantDefinition tenantByDomain = TenantCacheUtil.loadFromCacheByDomain((String)domain);
        if (HussarUtils.isEmpty((Object)tenantByDomain) && HussarUtils.isEmpty((Object)(tenantByDomain = this.hussarBaseTenantService.getTenantByDomain(domain)))) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u57df\u540d\u4e3a" + domain + "\u7684\u79df\u6237\u4fe1\u606f");
        }
        return tenantByDomain;
    }
}

