/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import org.apache.commons.lang3.StringUtils;

public class TenantUpgradeUtil {
    private TenantUpgradeUtil() {
    }

    public static String getUpgradeSqlDirName(String jdbcUrl, String dbMode) {
        DbType dbType = JdbcUtils.getDbType((String)jdbcUrl);
        String result = "";
        result = StringUtils.isNotBlank((CharSequence)dbMode) && dbType.equals((Object)DbType.KINGBASE_ES) ? TenantUpgradeUtil.getUpgradeSqlDirNameKingBase(dbMode) : (dbType.equals((Object)DbType.SQL_SERVER) || dbType.equals((Object)DbType.SQL_SERVER2005) ? "sqlserver" : (dbType.equals((Object)DbType.POSTGRE_SQL) ? "postgre" : (dbType.equals((Object)DbType.GAUSS) || dbType.equals((Object)DbType.OPENGAUSS) ? "gauss" : (dbType.equals((Object)DbType.ORACLE) || dbType.equals((Object)DbType.ORACLE_12C) ? "oracle" : dbType.getDb()))));
        return result;
    }

    private static String getUpgradeSqlDirNameKingBase(String dbMode) {
        if ("kingbase_oracle".equalsIgnoreCase(dbMode)) {
            return "kingbase";
        }
        if ("kingbase_mysql".equalsIgnoreCase(dbMode)) {
            return "kingbase_mysql";
        }
        if ("kingbase_pg".equalsIgnoreCase(dbMode)) {
            return "postgre";
        }
        return dbMode;
    }

    private static String getDbTypeKingBase(String dbMode) {
        if ("kingbase_oracle".equalsIgnoreCase(dbMode)) {
            return "kingbase";
        }
        if ("kingbase_mysql".equalsIgnoreCase(dbMode)) {
            return "kingbase_mysql";
        }
        if ("kingbase_pg".equalsIgnoreCase(dbMode)) {
            return "postgresql";
        }
        return dbMode;
    }

    public static String getDbType(String jdbcUrl, String dbMode) {
        DbType dbType = JdbcUtils.getDbType((String)jdbcUrl);
        String result = "";
        result = StringUtils.isNotBlank((CharSequence)dbMode) && dbType.equals((Object)DbType.KINGBASE_ES) ? TenantUpgradeUtil.getDbTypeKingBase(dbMode) : (dbType.equals((Object)DbType.SQL_SERVER) || dbType.equals((Object)DbType.SQL_SERVER2005) ? "sqlserver" : (dbType.equals((Object)DbType.POSTGRE_SQL) ? "postgresql" : (dbType.equals((Object)DbType.GAUSS) || dbType.equals((Object)DbType.OPENGAUSS) ? "gauss" : (dbType.equals((Object)DbType.ORACLE) || dbType.equals((Object)DbType.ORACLE_12C) ? "oracle" : dbType.getDb()))));
        return result;
    }
}

