/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HussarContextHolder {
    public static final void setTenant(HussarTenantDefinition tenantEntity) {
        HussarTenantContextHolder.setTenantDetails((TenantDetails)tenantEntity);
    }

    public static final HussarTenantDefinition getHussarTenant() {
        TenantDetails tenantEntity = HussarTenantContextHolder.getTenant();
        if (!(tenantEntity instanceof HussarTenantDefinition)) {
            tenantEntity = new DefaultTenant();
        }
        return (HussarTenantDefinition)tenantEntity;
    }

    public static final String getConnName() {
        return HussarTenantContextHolder.getConnName();
    }

    public static final void remove() {
        HussarTenantContextHolder.remove();
    }

    public static final void setTenant(String connName, String tenantCode) {
        if (HussarUtils.isNotBlank((CharSequence)connName) && HussarUtils.isNotBlank((CharSequence)tenantCode) && !connName.equals("master")) {
            HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantCode(tenantCode);
            if (HussarUtils.isNotEmpty((Object)((Object)definition))) {
                HussarContextHolder.setTenant(definition);
            } else {
                HussarContextHolder.setTenant(new DefaultTenant());
            }
        } else {
            HussarContextHolder.setTenant(new DefaultTenant());
        }
    }

    public static ServletRequestAttributes getNewServletRequestAttributes(String tcode) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes != null) {
            return new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(servletRequestAttributes.getRequest()));
        }
        HussarHttpServletRequest hussarHttpServletRequest = new HussarHttpServletRequest();
        if (HussarUtils.isNotBlank((CharSequence)tcode)) {
            hussarHttpServletRequest.addHeader("tcode", tcode);
        }
        return new ServletRequestAttributes((HttpServletRequest)hussarHttpServletRequest);
    }
}

