/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.template.print.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.util.OssCascadeUtils;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.template.print.dao.SysTemplatePrintInfoMapper;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import com.jxdinfo.hussar.template.print.enums.TemplateEnum;
import com.jxdinfo.hussar.template.print.handler.ExcelHandler;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintInfo;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import com.jxdinfo.hussar.template.print.utils.CheckHookUtil;
import com.jxdinfo.hussar.template.print.utils.FieldControl;
import com.jxdinfo.hussar.template.print.utils.MergeCellDetector;
import com.jxdinfo.hussar.template.print.utils.VerifyExcelUtil;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.template.print.service.impl.SysTemplatePrintInfoServiceImpl")
public class SysTemplatePrintInfoServiceImpl
extends HussarServiceImpl<SysTemplatePrintInfoMapper, SysTemplatePrintInfo>
implements ISysTemplatePrintInfoService {
    private static final String PROCESS_KEY = "processKey";
    private static final String PROCESS_NODE_ID = "processNodeId";
    private static final String TEMPLATE_ID = "templateId";
    private static final String TEMPLATE_FILE_NAME = "templateFileName";
    private static final String TEMPLATE_TYPE = "templateType";
    private static final String TEMPLATE_NAME = "templateName";
    private static final String FILE_ID = "fileId";
    private static final String QRCODE = "qrcode";
    private static final String BARCODE = "barcode";
    private static final String IMAGE = "image";
    private static final String FIXED = "fixed";
    @Resource
    private OssService ossService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ExcelHandler excelHandler;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ISysExcelTaskService sysExcelTaskService;
    private static final Logger logger = LoggerFactory.getLogger(SysTemplatePrintInfoServiceImpl.class);
    private static final Map<Class<?>, Field[]> FIELD_CACHE = new ConcurrentHashMap();

    public void processTemplates(PublishTemplateDto dto) {
        List delTemplateIds = (List)dto.getParams().get("removed");
        List addTemplateInfo = (List)dto.getParams().get("added");
        Map templateDatas = dto.getTemplateDatas();
        this.deleteTemplates(delTemplateIds);
        this.addTemplates(addTemplateInfo, templateDatas);
    }

    public ApiResponse<List<Map<String, String>>> getTemplateInfoList(Map<String, String> params) {
        List tempList;
        ArrayList list = new ArrayList();
        String pageId = params.get("pageId");
        String scenceId = params.get("scenceId");
        if (HussarUtils.isNotEmpty((Object)pageId) && HussarUtils.isNotEmpty((Object)scenceId) && HussarUtils.isNotEmpty((Object)(tempList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTemplatePrintInfo::getPageId, (Object)pageId)).eq(SysTemplatePrintInfo::getScenceId, (Object)scenceId)).eq(SysTemplatePrintInfo::getTemplateSource, (Object)"0"))))) {
            SecurityUser currentUser = BaseSecurityUtil.getUser();
            if (currentUser == null) {
                logger.error("\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
                return ApiResponse.fail((String)"\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
            }
            String deptId = String.valueOf(currentUser.getDeptId());
            List roleList = currentUser.getRolesList().stream().map(String::valueOf).collect(Collectors.toList());
            String userId = currentUser.getId().toString();
            String postId = HussarUtils.isEmpty((Object)currentUser.getExtendUserMap("postId")) ? "" : currentUser.getExtendUserMap("postId").toString();
            Iterator iterator = tempList.iterator();
            String processKey = params.get(PROCESS_KEY);
            String processNode = params.get("processNode");
            while (iterator.hasNext()) {
                boolean isVisible = false;
                SysTemplatePrintInfo info = (SysTemplatePrintInfo)iterator.next();
                JSONObject content = JSON.parseObject((String)info.getContent());
                String visibleScope = info.getVisibleScope();
                if (HussarUtils.isNotEmpty((Object)visibleScope)) {
                    JSONObject json = JSON.parseObject((String)visibleScope);
                    String user = (String)json.get((Object)"user");
                    String role = (String)json.get((Object)"role");
                    String organ = (String)json.get((Object)"organ");
                    String post = (String)json.get((Object)"post");
                    if (HussarUtils.isNotEmpty((Object)user) && user.contains(userId)) {
                        isVisible = true;
                    }
                    if (!isVisible && HussarUtils.isNotEmpty((Object)organ) && HussarUtils.isNotEmpty((Object)deptId) && organ.contains(deptId)) {
                        isVisible = true;
                    }
                    if (!isVisible && HussarUtils.isNotEmpty((Object)post) && HussarUtils.isNotEmpty((Object)postId) && organ.contains(postId)) {
                        isVisible = true;
                    }
                    if (!isVisible && HussarUtils.isNotEmpty((Object)role)) {
                        if (!(roleList = roleList.stream().filter(role::contains).collect(Collectors.toList())).isEmpty()) {
                            isVisible = true;
                        }
                    }
                } else {
                    isVisible = true;
                }
                if (isVisible) {
                    String infoProcessKey = (String)content.get((Object)PROCESS_KEY);
                    String infoProcessNodeId = (String)content.get((Object)PROCESS_NODE_ID);
                    if (HussarUtils.isNotEmpty((Object)infoProcessKey)) {
                        if (!infoProcessKey.equals(processKey)) {
                            isVisible = false;
                        } else if (infoProcessNodeId != null && (infoProcessNodeId.isEmpty() || HussarUtils.isEmpty((Object)processNode) || !infoProcessNodeId.contains(processNode))) {
                            isVisible = false;
                        }
                    }
                }
                if (!isVisible) {
                    iterator.remove();
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(TEMPLATE_ID, info.getTemplateId().toString());
                map.put(TEMPLATE_FILE_NAME, (String)content.get((Object)TEMPLATE_FILE_NAME));
                map.put(TEMPLATE_TYPE, (String)content.get((Object)TEMPLATE_TYPE));
                map.put(TEMPLATE_NAME, (String)content.get((Object)TEMPLATE_NAME));
                list.add(map);
            }
        }
        return ApiResponse.success(list);
    }

    public ApiResponse<String> getFileId(Map<String, Object> params) {
        byte[] bytes1;
        Long templateId = Long.valueOf(params.get(TEMPLATE_ID).toString());
        if (HussarUtils.isEmpty((Object)templateId)) {
            logger.error("\u672a\u4f20\u9012\u6a21\u677f\u4fe1\u606f\uff01");
            return ApiResponse.fail((String)"\u672a\u4f20\u9012\u6a21\u677f\u4fe1\u606f\uff01");
        }
        Object formData = params.get("formData");
        if (HussarUtils.isEmpty((Object)formData)) {
            logger.error("\u672a\u4f20\u9012\u8868\u5355\u6570\u636e\uff01");
            return ApiResponse.fail((String)"\u672a\u4f20\u9012\u8868\u5355\u6570\u636e\uff01");
        }
        JSONObject dataMap = (JSONObject)JSON.toJSON((Object)formData);
        this.deal(dataMap);
        HashMap<String, Integer> widgetLevel = new HashMap<String, Integer>();
        HashMap<String, String> granMap = new HashMap<String, String>();
        HashMap<String, String> widgets = new HashMap<String, String>();
        for (String key : dataMap.keySet()) {
            Object value = dataMap.get((Object)key);
            widgets.put(key, "JXDNInput");
            if (value == null) {
                dataMap.put(key, (Object)"");
                continue;
            }
            if (!(value instanceof List)) continue;
            widgets.put(key, "JXDNChildrenTable");
            ArrayList<JSONObject> newChildList = new ArrayList<JSONObject>();
            List childList = (List)value;
            for (Object childData : childList) {
                JSONObject childDataMap = (JSONObject)JSON.toJSON(childData);
                this.deal(childDataMap);
                for (String childKey : childDataMap.keySet()) {
                    Object childValue = childDataMap.get((Object)childKey);
                    granMap.put(childKey, key);
                    widgets.put(childKey, "JXDNInput");
                    if (childValue != null) continue;
                    childDataMap.put(childKey, (Object)"");
                }
                newChildList.add(childDataMap);
            }
            dataMap.put(key, newChildList);
            widgetLevel.put(key, 1);
        }
        String widgetLevelStr = JSON.toJSONString(widgetLevel);
        String granMapStr = JSON.toJSONString(granMap);
        SysTemplatePrintInfo template = (SysTemplatePrintInfo)this.getById(templateId);
        if (HussarUtils.isEmpty((Object)template)) {
            logger.error("\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606f\uff01");
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606f\uff01");
        }
        JSONObject content = JSON.parseObject((String)template.getContent());
        Long fileId = content.getLong(FILE_ID);
        byte[] bytes = (byte[])this.ossService.backgroundDownload(fileId).getData();
        File file = null;
        try {
            file = File.createTempFile("template", "." + template.getTemplateSource());
            FileOutputStream fos = new FileOutputStream(file);
            Object object = null;
            try {
                fos.write(bytes);
            }
            catch (Throwable childKey) {
                object = childKey;
                throw childKey;
            }
            finally {
                if (fos != null) {
                    if (object != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable childKey) {
                            ((Throwable)object).addSuppressed(childKey);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new BaseException((Throwable)e);
        }
        if (!file.exists()) {
            logger.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return ApiResponse.fail((String)"\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        String fileName = (String)content.get((Object)TEMPLATE_FILE_NAME);
        if (fileName.endsWith(".docx")) {
            bytes1 = this.replaceWordContent(file, (Map<String, Object>)dataMap);
        } else if (fileName.endsWith(".xlsx")) {
            Map<String, String> map = this.dealMap(widgetLevelStr, granMapStr, widgets);
            bytes1 = this.replaceExcelContent(file, dataMap, map);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u683c\u5f0f");
        }
        try {
            String fileType = Files.probeContentType(file.toPath());
            ApiResponse result = this.ossService.backgroundUpload((MultipartFile)new HussarBaseMultipartFile(fileName, fileName, fileType, bytes1));
            ApiResponse apiResponse = ApiResponse.success((Object)((Long)result.getData()).toString(), (String)"");
            return apiResponse;
        }
        catch (IOException e) {
            logger.error("\u9884\u89c8\u6587\u4ef6\u5b58\u50a8\u5931\u8d25\uff01", (Throwable)e);
            throw new HussarException("\u9884\u89c8\u6587\u4ef6\u5b58\u50a8\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            file.delete();
        }
    }

    private Map<String, String> dealMap(String widgetLevelStr, String granMapStr, Map<String, String> widgets) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty(widgets)) {
            map.putAll(widgets);
        }
        map.put("granMap", granMapStr);
        map.put("widgetLevel", widgetLevelStr);
        return map;
    }

    public void deleteTemplates(Map<String, Object> params) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Object pageIds = params.get("pageIds");
        Object appIds = params.get("appIds");
        Object scenceIds = params.get("scenceIds");
        if (HussarUtils.isNotEmpty((Object)pageIds)) {
            ((LambdaQueryWrapper)queryWrapper.or()).in(SysTemplatePrintInfo::getPageId, Arrays.asList(pageIds.toString().split(",")));
        }
        if (HussarUtils.isNotEmpty((Object)appIds)) {
            ((LambdaQueryWrapper)queryWrapper.or()).in(SysTemplatePrintInfo::getAppId, (Collection)Arrays.stream(appIds.toString().split(",")).map(Long::valueOf).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty((Object)scenceIds)) {
            ((LambdaQueryWrapper)queryWrapper.or()).in(SysTemplatePrintInfo::getScenceId, Arrays.asList(scenceIds.toString().split(",")));
        }
        List<Long> templateIds = this.list((Wrapper)queryWrapper).stream().map(SysTemplatePrintInfo::getTemplateId).collect(Collectors.toList());
        this.deleteTemplates(templateIds);
    }

    public List<SysTemplatePrintInfo> getTemplateListByPageId(String pageId) {
        return this.list((Wrapper)new LambdaQueryWrapper().eq(SysTemplatePrintInfo::getPageId, (Object)pageId));
    }

    public ApiResponse<String> saveOrUpdateTemplateInfo(SysTemplatePrintInfo templatePrintInfo) {
        try {
            return ApiResponse.success((String)String.valueOf(this.saveOrUpdate((BaseEntity)templatePrintInfo)));
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25", (Throwable)e);
        }
    }

    public ApiResponse<String> delTemplateById(Long templateId) {
        try {
            return ApiResponse.success((String)String.valueOf(this.removeById(templateId)));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    public SysTemplatePrintInfo getByIdContainsProcessName(Long templateId) {
        BpmResponseResult bpmResponseResult;
        SysTemplatePrintInfo sysTemplatePrintInfo = (SysTemplatePrintInfo)this.getById(templateId);
        JSONObject jsonObjectContend = JSONObject.parseObject((String)sysTemplatePrintInfo.getContent());
        if (HussarUtils.isNotEmpty((Object)jsonObjectContend) && jsonObjectContend.containsKey((Object)PROCESS_KEY) && HussarUtils.isNotEmpty((Object)jsonObjectContend.get((Object)PROCESS_KEY)) && (bpmResponseResult = DefinitionEngineService.queryNodeInfoByProcessKeyAndVersion((String)jsonObjectContend.getString(PROCESS_KEY), null)).isSuccess()) {
            JSONArray jsonArray = bpmResponseResult.getResult();
            if (HussarUtils.isNotEmpty((Object)jsonArray)) {
                JSONObject jsonObjectResult = jsonArray.getJSONObject(0);
                String processName = jsonObjectResult.getString("processDefinitionName");
                jsonObjectContend.put("processDefinitionName", (Object)processName);
            }
            sysTemplatePrintInfo.setContent(JSONObject.toJSONString((Object)jsonObjectContend));
        }
        return sysTemplatePrintInfo;
    }

    public ApiResponse<List<SysTemplatePrintInfo>> getTemplateListByBusinessId(String businessId) {
        return ApiResponse.success((Object)this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTemplatePrintInfo::getPageId, (Object)businessId)).eq(SysTemplatePrintInfo::getEnabled, (Object)true)));
    }

    public ApiResponse<String> generateTemplate(SysTemplatePrintInfo templatePrintInfo) {
        try {
            String content = templatePrintInfo.getContent();
            JSONObject object = JSON.parseObject((String)content);
            Object fieldControl = object.get((Object)"fieldControl");
            String custom = object.getString("custom");
            if (ToolUtil.isNotEmpty((Object)fieldControl) && "1".equals(custom)) {
                Map<String, Object> fileMap = this.generateTemplate(fieldControl.toString(), templatePrintInfo.getName());
                object.put(FILE_ID, (Object)String.valueOf(fileMap.get(FILE_ID)));
                object.put(TEMPLATE_FILE_NAME, fileMap.get("fileName"));
                templatePrintInfo.setContent(object.toJSONString());
            }
            this.saveOrUpdate((BaseEntity)templatePrintInfo);
            return ApiResponse.success((String)String.valueOf(templatePrintInfo.getTemplateId()));
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.TEMPLATE_GENERATION_FAILED.getMessage()), (Throwable)e);
        }
    }

    public ApiResponse<String> updateFieldControl(String fileId, String fieldControl) {
        try {
            File file;
            Workbook workbook;
            AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)((Object)fileId));
            if (HussarUtils.isEmpty((Object)attachmentModel)) {
                throw new IllegalArgumentException(TranslateUtil.getTranslateName((String)TemplateEnum.THE_FILE_DOES_NOT_EXIST.getMessage()));
            }
            String oldFileName = attachmentModel.getAttachmentName();
            String suffix = VerifyExcelUtil.getSuffix((String)oldFileName);
            String path = attachmentModel.getAttachmentDir() + fileId + suffix;
            String encryptKey = attachmentModel.getEncrypt();
            if (HussarUtils.isNotEmpty((Object)encryptKey)) {
                OssCascadeUtils.decrypt((String)path, (String)encryptKey);
            }
            if ((workbook = VerifyExcelUtil.getWorkbookFile(null, (File)(file = new File(path)))) == null) {
                throw new IllegalArgumentException(TranslateUtil.getTranslateName((String)TemplateEnum.THE_WORKBOOK_CANNOT_BE_CREATED.getMessage()));
            }
            Sheet sheet = workbook.getSheetAt(0);
            Row hideRow = sheet.getRow(0);
            List fieldControlList = JSON.parseArray((String)fieldControl, FieldControl.class);
            HashMap hidePropMap = new HashMap();
            hideRow.forEach(cell -> hidePropMap.put(cell.getStringCellValue(), cell.getColumnIndex()));
            for (FieldControl control : fieldControlList) {
                if (hidePropMap.containsKey(control.getProp())) {
                    control.setImportField("true");
                    continue;
                }
                List children = control.getChildren();
                if (HussarUtils.isNotEmpty((Object)children)) {
                    boolean flag;
                    if ("association".equals(control.getPropType())) {
                        flag = false;
                        for (FieldControl child : children) {
                            if (hidePropMap.containsKey(child.getProp())) {
                                flag = true;
                                child.setImportField("true");
                                continue;
                            }
                            child.setImportField("false");
                        }
                        if (flag) {
                            control.setImportField("true");
                            continue;
                        }
                        control.setImportField("false");
                        continue;
                    }
                    flag = false;
                    for (FieldControl child : children) {
                        String propName = String.format("%s%s%s", control.getProp(), ".", child.getProp());
                        if (hidePropMap.containsKey(propName)) {
                            flag = true;
                            child.setImportField("true");
                            continue;
                        }
                        child.setImportField("false");
                    }
                    if (flag) {
                        control.setImportField("true");
                        continue;
                    }
                    control.setImportField("false");
                    continue;
                }
                control.setImportField("false");
            }
            return ApiResponse.success((Object)JSON.toJSONString((Object)fieldControlList), (String)TranslateUtil.getTranslateName((String)TemplateEnum.THE_FIELD_CONTROL_INFORMATION_HAS_BEEN_UPDATED_SUCCESSFULLY.getMessage()));
        }
        catch (IOException e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.FILE_READING_FAILED.getMessage()), (Throwable)e);
        }
    }

    public Map<String, Object> generateTemplate(String fieldControlArray, String templateName) {
        Object associateTable2;
        Object dictType;
        Object headerRowCell;
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(templateName);
        Row hideRow = sheet.createRow(0);
        hideRow.setZeroHeight(true);
        Row headerRow = sheet.createRow(1);
        List fieldControls = JSON.parseArray((String)fieldControlArray, FieldControl.class);
        List fieldControlList = fieldControls.stream().filter(fieldControl -> "true".equals(fieldControl.getImportField())).collect(Collectors.toList());
        XSSFCellStyle headerStyle = SysTemplatePrintInfoServiceImpl.createHeaderStyle((Workbook)workbook);
        ArrayList<FieldControl> fieldControlArrayList = new ArrayList<FieldControl>();
        HashMap<String, Integer> headerMap = new HashMap<String, Integer>();
        for (FieldControl fieldControl2 : fieldControlList) {
            if (!fieldControl2.getChildren().isEmpty()) {
                List subFieldControls = fieldControl2.getChildren();
                String propType = fieldControl2.getPropType();
                int num = 0;
                for (FieldControl subFieldControl : subFieldControls) {
                    StringBuilder subProp = new StringBuilder();
                    if ("collection".equals(propType)) {
                        subProp.append(fieldControl2.getProp());
                        subProp.append(".");
                    }
                    subProp.append(subFieldControl.getProp());
                    StringBuilder subPropName = new StringBuilder();
                    if ("collection".equals(propType)) {
                        subPropName.append(fieldControl2.getPropName());
                        subPropName.append(".");
                    }
                    subPropName.append(subFieldControl.getPropName());
                    if (!"true".equals(subFieldControl.getImportField())) continue;
                    subFieldControl.setProp(subProp.toString());
                    subFieldControl.setPropName(subPropName.toString());
                    fieldControlArrayList.add(subFieldControl);
                    ++num;
                }
                if (!"collection".equals(propType)) continue;
                headerMap.put(fieldControl2.getProp(), num);
                continue;
            }
            fieldControlArrayList.add(fieldControl2);
        }
        MergeCellDetector mergeDetector = new MergeCellDetector();
        mergeDetector.init(sheet);
        Row headerSecondRow = sheet.createRow(2);
        for (int i = 0; i < fieldControlArrayList.size(); ++i) {
            List associateTableList;
            List dicSingles;
            Cell hideRowCell = hideRow.createCell(i);
            FieldControl fieldControl3 = (FieldControl)fieldControlArrayList.get(i);
            hideRowCell.setCellStyle((CellStyle)headerStyle);
            hideRowCell.setCellValue(fieldControl3.getProp());
            headerRowCell = headerRow.createCell(i);
            headerRowCell.setCellStyle((CellStyle)headerStyle);
            int firstRow = 2;
            if (ToolUtil.isNotEmpty(headerMap)) {
                firstRow = 3;
                Cell headerRowCell2 = headerSecondRow.createCell(i);
                headerRowCell2.setCellStyle((CellStyle)headerStyle);
                if (fieldControl3.getProp().contains(".")) {
                    String[] propNameArray = fieldControl3.getPropName().split("\\.");
                    String[] propArray = fieldControl3.getProp().split("\\.");
                    if (!mergeDetector.isMergedCell(headerRowCell.getRowIndex(), headerRowCell.getColumnIndex())) {
                        headerRowCell.setCellValue(propNameArray[0]);
                        headerRowCell2.setCellValue(propNameArray[1]);
                        if ((Integer)headerMap.get(propArray[0]) > 1) {
                            sheet.addMergedRegion(new CellRangeAddress(1, 1, i, i + (Integer)headerMap.get(propArray[0]) - 1));
                            mergeDetector.init(sheet);
                        }
                    } else {
                        headerRowCell2.setCellValue(propNameArray[1]);
                    }
                } else {
                    headerRowCell.setCellValue(fieldControl3.getPropName());
                    sheet.addMergedRegion(new CellRangeAddress(1, 2, i, i));
                    mergeDetector.init(sheet);
                }
            } else {
                headerRowCell.setCellValue(fieldControl3.getPropName());
            }
            dictType = fieldControl3.getDictType();
            if (ToolUtil.isNotEmpty((Object)dictType) && !(dicSingles = this.sysDicRefService.getDictByType((String)dictType)).isEmpty()) {
                String[] items = (String[])dicSingles.stream().map(DicSingle::getLabel).toArray(String[]::new);
                VerifyExcelUtil.addListDataValidation((Sheet)sheet, (int)i, (int)i, (int)firstRow, (int)50000, (String[])items);
            }
            if (!ToolUtil.isNotEmpty((Object)(associateTable2 = fieldControl3.getAssociateTable()))) continue;
            String associateService = fieldControl3.getAssociateService();
            IService service = null;
            try {
                service = VerifyExcelUtil.getServiceByModel((String)associateService);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            if (service == null || (associateTableList = service.list()).isEmpty()) continue;
            String[] items = (String[])associateTableList.stream().map(item -> HussarUtils.getProperty((Object)item, (String)fieldControl3.getAssociateTableProp()) == null ? "" : HussarUtils.getProperty((Object)item, (String)fieldControl3.getAssociateTableProp()).toString()).toArray(String[]::new);
            VerifyExcelUtil.addListDataValidation((Sheet)sheet, (int)i, (int)i, (int)firstRow, (int)50000, (String[])items);
        }
        VerifyExcelUtil.autoAdjustAllColumnWidth((Sheet)sheet);
        sheet.setColumnWidth(fieldControlArrayList.size(), 2304);
        Long id = EngineUtil.getId();
        File tempFile = null;
        try {
            byte[] fileContent;
            Object workbookReference2;
            tempFile = File.createTempFile(id.toString(), ".xlsx");
            FileOutputStream fos = new FileOutputStream(tempFile);
            headerRowCell = null;
            try {
                workbookReference2 = workbook;
                dictType = null;
                try {
                    workbookReference2.write((OutputStream)fos);
                }
                catch (Throwable associateTable2) {
                    dictType = associateTable2;
                    throw associateTable2;
                }
                finally {
                    if (workbookReference2 != null) {
                        if (dictType != null) {
                            try {
                                workbookReference2.close();
                            }
                            catch (Throwable associateTable2) {
                                ((Throwable)dictType).addSuppressed(associateTable2);
                            }
                        } else {
                            workbookReference2.close();
                        }
                    }
                }
            }
            catch (Throwable workbookReference2) {
                headerRowCell = workbookReference2;
                throw workbookReference2;
            }
            finally {
                if (fos != null) {
                    if (headerRowCell != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable workbookReference2) {
                            ((Throwable)headerRowCell).addSuppressed(workbookReference2);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
            FileInputStream inputStream = new FileInputStream(tempFile);
            workbookReference2 = null;
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                associateTable2 = null;
                try {
                    int nRead;
                    byte[] data = new byte[8192];
                    while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                        buffer.write(data, 0, nRead);
                    }
                    fileContent = buffer.toByteArray();
                }
                catch (Throwable data) {
                    associateTable2 = data;
                    throw data;
                }
                finally {
                    if (buffer != null) {
                        if (associateTable2 != null) {
                            try {
                                buffer.close();
                            }
                            catch (Throwable data) {
                                ((Throwable)associateTable2).addSuppressed(data);
                            }
                        } else {
                            buffer.close();
                        }
                    }
                }
            }
            catch (Throwable buffer) {
                workbookReference2 = buffer;
                throw buffer;
            }
            finally {
                if (inputStream != null) {
                    if (workbookReference2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable buffer) {
                            ((Throwable)workbookReference2).addSuppressed(buffer);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            String fileName = templateName + ".xlsx";
            String contentType = Files.probeContentType(tempFile.toPath());
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(fileName, fileName, contentType, fileContent);
            ApiResponse fileId = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("fileName", fileName);
            result.put(FILE_ID, fileId.getData());
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            throw new HussarException("\u6587\u4ef6\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (HussarUtils.isNotEmpty(tempFile) && tempFile.exists()) {
                try {
                    FileUtils.forceDelete((File)tempFile);
                }
                catch (IOException e) {
                    throw new HussarException("\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public <T> List<T> readInputStreamCheckExcel(MultipartFile file, String templateId, Long taskId) {
        String fileName;
        InputStream input;
        SecurityUser user = BaseSecurityUtil.getUser();
        try {
            input = file.getInputStream();
            fileName = file.getOriginalFilename();
        }
        catch (IOException e) {
            throw new com.jxdinfo.hussar.support.exception.HussarException((Throwable)e);
        }
        List result = new ArrayList();
        try (InputStream inputStream = input;){
            byte[] fileBytes = VerifyExcelUtil.readStreamFully((InputStream)inputStream);
            SysTemplatePrintInfo sysPrintTemplate = (SysTemplatePrintInfo)this.getById((Serializable)((Object)templateId));
            if (ToolUtil.isEmpty((Object)sysPrintTemplate)) {
                throw new com.jxdinfo.hussar.support.exception.HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.THE_TEMPLATE_DOES_NOT_EXIST.getMessage()));
            }
            JSONObject contentObject = JSONObject.parseObject((String)sysPrintTemplate.getContent());
            ObjectMapper mapper = new ObjectMapper();
            List fieldControlList = (List)mapper.readValue(contentObject.getString("fieldControl"), (TypeReference)new TypeReference<List<FieldControl>>(){});
            fieldControlList = fieldControlList.stream().filter(fieldControl -> "true".equals(fieldControl.getImportField())).collect(Collectors.toList());
            List importList = new ArrayList();
            String entityClassPath = contentObject.getString("entityClassPath");
            Class<?> tClass = Class.forName(entityClassPath);
            FIELD_CACHE.put(tClass, tClass.getDeclaredFields());
            FIELD_CACHE.put(FieldControl.class, FieldControl.class.getDeclaredFields());
            String[] entityClassPaths = entityClassPath.split("\\.");
            CheckHookUtil.readExcel((String)entityClassPaths[entityClassPaths.length - 1], importList, (InputStream)new ByteArrayInputStream(fileBytes));
            if (ToolUtil.isEmpty(importList)) {
                importList = VerifyExcelUtil.readInputStream((String)fileName, (InputStream)new ByteArrayInputStream(fileBytes), tClass, fieldControlList);
            }
            if (ToolUtil.isNotEmpty(importList)) {
                result = VerifyExcelUtil.checkExcel((SecurityUser)user, importList, fieldControlList, (String)fileName, (InputStream)new ByteArrayInputStream(fileBytes), (Long)taskId, (String)entityClassPaths[entityClassPaths.length - 1]);
                CheckHookUtil.check((String)entityClassPaths[entityClassPaths.length - 1], importList, (String)fileName);
                CheckHookUtil.importData((String)entityClassPaths[entityClassPaths.length - 1], importList, (String)fileName);
                List userResult = CheckHookUtil.userImportData((String)entityClassPaths[entityClassPaths.length - 1], importList, (String)fileName, result);
                if (userResult != null) {
                    result = userResult;
                }
            }
        }
        catch (Exception e) {
            SysExcelTask excelTask = this.sysExcelTaskService.getById(taskId);
            excelTask.setTaskStatus(Integer.valueOf(6));
            excelTask.setErrorMsg(e.getMessage());
            excelTask.setDataSuccess(Integer.valueOf(0));
            excelTask.setLastTime(LocalDateTime.now());
            excelTask.setLastEditor(user.getId());
            this.sysExcelTaskService.updateById(excelTask);
            throw new com.jxdinfo.hussar.support.exception.HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.VERIFICATION_FAILED.getMessage()), (Throwable)e);
        }
        return result;
    }

    private void deleteTemplates(List<Long> delTemplateIds) {
        if (HussarUtils.isEmpty(delTemplateIds)) {
            return;
        }
        List list = this.listByIds(delTemplateIds);
        List fileIds = list.stream().map(info -> JSON.parseObject((String)info.getContent()).getLong(FILE_ID) == null ? 0L : JSON.parseObject((String)info.getContent()).getLong(FILE_ID)).collect(Collectors.toList());
        List fileList = this.attachmentManagerService.listByIds(fileIds);
        fileList.forEach(fileInfo -> {
            String filePath = fileInfo.getAttachmentDir() + fileInfo.getId() + "." + fileInfo.getAttachmentType();
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        });
        this.attachmentManagerService.removeByIds(fileIds);
        this.removeByIds(delTemplateIds);
    }

    private void addTemplates(List<Map<String, Object>> addTemplates, Map<String, byte[]> templateDatas) {
        if (HussarUtils.isEmpty(addTemplates)) {
            return;
        }
        ArrayList<SysTemplatePrintInfo> list = new ArrayList<SysTemplatePrintInfo>();
        for (Map<String, Object> template : addTemplates) {
            byte[] bytes;
            Long id = Long.parseLong(template.get(TEMPLATE_ID).toString());
            String absolute = (String)template.get("absolute");
            String fileName = (String)template.get("fileName");
            Long fileId = null;
            if (HussarUtils.isNotEmpty((Object)absolute) && HussarUtils.isNotEmpty((Object)(bytes = templateDatas.get(absolute)))) {
                ApiResponse result = this.ossService.backgroundUpload((MultipartFile)new HussarBaseMultipartFile(fileName, fileName, ".docx", bytes));
                fileId = (Long)result.getData();
            }
            SysTemplatePrintInfo entity = new SysTemplatePrintInfo();
            String groupId = (String)template.get("groupId");
            SysTemplatePrintInfo oldEntity = (SysTemplatePrintInfo)this.getById(id);
            if (HussarUtils.isNotEmpty((Object)oldEntity)) {
                String oldGroupId = oldEntity.getGroupId();
                groupId = !oldGroupId.contains(groupId) ? oldGroupId + "," + groupId : oldGroupId;
            }
            entity.setTemplateId(id);
            if (template.get("visibleScope") == null) {
                entity.setVisibleScope("");
            } else {
                entity.setVisibleScope((String)template.get("visibleScope"));
            }
            entity.setPageId((String)template.get("pageId"));
            entity.setScenceId((String)template.get("scenceId"));
            entity.setGroupId((String)template.get("groupId"));
            entity.setName((String)template.get(TEMPLATE_NAME));
            entity.setAppId(template.get("appId") == null ? null : Long.valueOf(Long.parseLong(template.get("appId").toString())));
            entity.setTemplateSource("0");
            JSONObject content = new JSONObject();
            content.put(FILE_ID, (Object)fileId);
            if ("excel-import".equals(template.get("type"))) {
                content.put(FILE_ID, template.get(FILE_ID));
            }
            content.put(TEMPLATE_NAME, template.get(TEMPLATE_NAME));
            content.put(TEMPLATE_FILE_NAME, (Object)fileName);
            content.put(TEMPLATE_TYPE, template.get(TEMPLATE_TYPE));
            content.put("templateScence", template.get("templateScence"));
            content.put("templateStatus", template.get("templateStatus"));
            content.put("businessId", template.get("businessId"));
            content.put(PROCESS_KEY, template.get(PROCESS_KEY));
            content.put(PROCESS_NODE_ID, template.get(PROCESS_NODE_ID));
            content.put("description", template.get("description"));
            if (ToolUtil.isNotEmpty((Object)template.get("entityClassPath"))) {
                content.put("entityClassPath", template.get("entityClassPath"));
            }
            if (ToolUtil.isNotEmpty((Object)template.get("default"))) {
                content.put("default", template.get("default"));
            }
            if (ToolUtil.isNotEmpty((Object)template.get("fieldControl"))) {
                content.put("fieldControl", template.get("fieldControl"));
            }
            if (ToolUtil.isNotEmpty((Object)template.get("custom"))) {
                content.put("custom", template.get("custom"));
            }
            entity.setContent(content.toJSONString());
            if (HussarUtils.isNotEmpty((Object)template.get("type"))) {
                entity.setType(template.get("type").toString());
            }
            if (HussarUtils.isNotEmpty((Object)template.get("templateStatus"))) {
                entity.setEnabled(Boolean.valueOf(String.valueOf(template.get("templateStatus"))));
            }
            list.add(entity);
        }
        this.saveOrUpdateBatch(list);
    }

    private void getResourcePath(String prefixPath) {
        try {
            boolean flag;
            File dir = new File(prefixPath);
            if (!dir.exists() && !(flag = dir.mkdirs())) {
                throw new IOException("\u521b\u5efa\u6253\u5370\u6a21\u677f\u6587\u4ef6\u5939\u5931\u8d25\uff01");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] replaceExcelContent(File file, JSONObject dataMap, Map<String, String> map) {
        Long fileId = this.excelHandler.executeExcelGeneration(file, dataMap, map);
        return (byte[])this.ossService.backgroundDownload(fileId).getData();
    }

    private byte[] replaceWordContent(File file, Map<String, Object> dataMap) {
        try {
            FileInputStream fis = new FileInputStream(file);
            XWPFDocument doc = new XWPFDocument((InputStream)fis);
            HashMap<String, Object> replaceMap = new HashMap<String, Object>();
            this.getReplacerMap(doc, replaceMap, dataMap);
            for (XWPFParagraph paragraph : doc.getParagraphs()) {
                this.replaceTemplate(paragraph, replaceMap, doc);
            }
            for (XWPFTable table : doc.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            this.replaceTemplate(paragraph, replaceMap, doc);
                        }
                    }
                }
            }
            replaceMap.keySet().removeIf(key -> !key.contains(".") || !key.contains("#" + replaceMap.get(key).toString()));
            this.replaceChildValueInTable(doc, replaceMap, dataMap);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            doc.write((OutputStream)out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void getReplacerMap(XWPFDocument doc, Map<String, Object> replaceMap, Map<String, Object> dataMap) {
        String httpArea = "\\$\\{(.*http.*).*?\\}";
        for (String key : dataMap.keySet()) {
            String dataArea = "\\$\\{[^{}]*" + Pattern.quote("#" + key) + "(?![^{}]http)[^{}]*\\}";
            for (XWPFParagraph paragraph : doc.getParagraphs()) {
                this.addReplaceMap(replaceMap, paragraph, dataArea);
                this.addReplaceMap(replaceMap, paragraph, httpArea);
            }
            for (XWPFTable table : doc.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            this.addReplaceMap(replaceMap, paragraph, dataArea);
                            this.addReplaceMap(replaceMap, paragraph, httpArea);
                        }
                    }
                }
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        String area = "<(.*?)#(.*?)>";
        for (String placeholder : replaceMap.keySet()) {
            Object address = "";
            String[] other = null;
            if (placeholder.contains("http")) {
                int index = placeholder.indexOf("http");
                address = placeholder.substring(index, placeholder.indexOf(")|", index));
                other = placeholder.split((String)address);
                Matcher matcher = Pattern.compile(area).matcher(placeholder);
                while (matcher.find()) {
                    String filed = matcher.group();
                    if (list.contains(filed)) continue;
                    list.add(filed);
                }
            }
            if (list.isEmpty()) continue;
            block10: for (String string : list) {
                if (string.contains("#") && string.indexOf(".", string.indexOf("#")) != -1) {
                    address = ((String)address).replaceAll(string, "");
                    replaceMap.put(placeholder, other[0] + (String)address + other[1]);
                    continue;
                }
                for (String s : dataMap.keySet()) {
                    if (!string.contains(s)) continue;
                    address = ((String)address).replaceAll(string, HussarUtils.isEmpty((Object)dataMap.get(s)) ? "" : dataMap.get(s).toString());
                    replaceMap.put(placeholder, other[0] + (String)address + other[1]);
                    continue block10;
                }
            }
            list.clear();
        }
        block12: for (String placeholder : replaceMap.keySet()) {
            for (String key : dataMap.keySet()) {
                if (!placeholder.contains("#" + key)) continue;
                Object data = dataMap.get(key);
                if (placeholder.contains(".") && "ms".equals(replaceMap.get(placeholder))) {
                    int n = placeholder.indexOf("#") + 1;
                    String tableName = placeholder.substring(n, placeholder.indexOf(".", n));
                    replaceMap.put(placeholder, tableName);
                    continue block12;
                }
                if (placeholder.contains("http")) continue;
                if (data instanceof LinkedHashMap) {
                    data = this.formatDate((LinkedHashMap)data, placeholder);
                }
                replaceMap.put(placeholder, data);
                continue block12;
            }
        }
        for (String placeholder : replaceMap.keySet()) {
            try {
                ByteArrayOutputStream byteArrayOutputStream;
                HashMap<EncodeHintType, Object> hints;
                String data = replaceMap.get(placeholder) + "";
                if (placeholder.contains(QRCODE) && !placeholder.contains("#" + data)) {
                    QRCodeWriter qrCodeWriter = new QRCodeWriter();
                    hints = new HashMap<EncodeHintType, Object>();
                    hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                    hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                    BitMatrix bitMatrix = qrCodeWriter.encode(data, BarcodeFormat.QR_CODE, 300, 300, hints);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayOutputStream);
                    replaceMap.put(placeholder, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    continue;
                }
                if (placeholder.contains(BARCODE) && !placeholder.contains("#" + data)) {
                    if (data.matches(".*[\\u4e00-\\u9fa5].*")) {
                        data = "error!";
                    }
                    Code128Writer barcodeWriter = new Code128Writer();
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 1);
                    BitMatrix bitMatrix = barcodeWriter.encode(data, BarcodeFormat.CODE_128, 300, 120, hints);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayOutputStream);
                    replaceMap.put(placeholder, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    continue;
                }
                Object objData = replaceMap.get(placeholder);
                if (objData instanceof LinkedHashMap) {
                    data = this.formatDate((LinkedHashMap)objData, placeholder);
                }
                replaceMap.put(placeholder, data);
            }
            catch (WriterException | IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String formatDate(LinkedHashMap<String, Object> date, String placeholder) {
        if (!date.containsKey("year")) {
            return "";
        }
        String str = "|format(";
        Integer month = (int)((Integer)date.get("monthValue"));
        Integer day = (int)((Integer)date.get("dayOfMonth"));
        Integer year = (int)((Integer)date.get("year"));
        Integer hour = (int)((Integer)date.get("hour"));
        Integer minute = (int)((Integer)date.get("minute"));
        Integer second = (int)((Integer)date.get("second"));
        if (placeholder.contains(str)) {
            int index = placeholder.indexOf(str);
            String format = placeholder.substring(index + 1, placeholder.indexOf(")", index)).trim();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            return LocalDateTime.of((int)year, month, (int)day, (int)hour, (int)minute, (int)second).format(formatter);
        }
        return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
    }

    private void addReplaceMap(Map<String, Object> replaceMap, XWPFParagraph paragraph, String area) {
        boolean flag = false;
        Matcher matcher = Pattern.compile(area).matcher(paragraph.getText());
        while (matcher.find()) {
            String placeholder = matcher.group();
            if (HussarUtils.isNotEmpty(replaceMap)) {
                for (String replaceKey : replaceMap.keySet()) {
                    if (!replaceKey.equals(placeholder)) continue;
                    flag = true;
                    break;
                }
            }
            if (flag) {
                flag = false;
                continue;
            }
            if (!placeholder.contains(".") || placeholder.contains("<") && placeholder.contains(">")) {
                replaceMap.put(placeholder, null);
                continue;
            }
            replaceMap.put(placeholder, "ms");
        }
    }

    private void replaceTemplate(XWPFParagraph paragraph, Map<String, Object> replaceMap, XWPFDocument doc) {
        if (HussarUtils.isNotEmpty(replaceMap)) {
            Iterator iterator = paragraph.getRuns().iterator();
            XWPFRun tempRun = null;
            String placeholder = null;
            int type = 0;
            while (iterator.hasNext()) {
                XWPFRun run = (XWPFRun)iterator.next();
                String text = run.getText(0);
                if (HussarUtils.isNotEmpty((Object)text) && text.contains("$")) {
                    tempRun = null;
                    placeholder = null;
                    type = 1;
                    int start = text.indexOf("$");
                    if (start != text.length() - 1 && text.charAt(start + 1) == '{') {
                        type = 2;
                        if (text.substring(start).contains("}")) {
                            type = 0;
                            placeholder = text.substring(start, text.indexOf("}", start) + 1);
                            if (placeholder.contains(".")) continue;
                            this.replacePlaceholder(replaceMap, placeholder, paragraph, run, doc);
                            continue;
                        }
                        tempRun = run;
                        continue;
                    }
                    if (start != text.length() - 1) continue;
                    tempRun = run;
                    continue;
                }
                if (!HussarUtils.isNotEmpty(tempRun)) continue;
                if (type == 1 && text.charAt(0) != '{') {
                    type = 0;
                    tempRun = null;
                    placeholder = null;
                    continue;
                }
                if (type == 1 && text.charAt(0) == '{') {
                    type = 2;
                    if (text.contains("}")) {
                        String str = tempRun.getText(0);
                        tempRun.setText(str.substring(0, str.length() - 1), 0);
                        placeholder = text.substring(0, text.indexOf("}") + 1);
                        run.setText("$" + text, 0);
                        if (placeholder.contains(".")) continue;
                        this.replacePlaceholder(replaceMap, placeholder, paragraph, run, doc);
                        continue;
                    }
                    String str = tempRun.getText(0);
                    tempRun.setText(str.substring(0, str.length() - 1), 0);
                    run.setText("$" + text, 0);
                    tempRun = run;
                    continue;
                }
                if (type != 2) continue;
                if (text.contains("}")) {
                    int index = text.indexOf("}");
                    if (text.contains("$") || text.contains("{")) {
                        int index2;
                        int index1 = text.indexOf("$");
                        if (index1 * (index2 = text.indexOf("{")) >= 0) {
                            if (index1 + 1 == index2 && index2 < index) {
                                placeholder = text.substring(index1, index + 1);
                                if (placeholder.contains(".")) continue;
                                this.replacePlaceholder(replaceMap, placeholder, paragraph, run, doc);
                                continue;
                            }
                            if (index1 + 1 == index2 && index1 > index) {
                                tempRun.setText(tempRun.getText(0) + text.substring(0, index1 + 1), 0);
                                run.setText(text.substring(index1 + 1), 0);
                                placeholder = text.substring(0, index + 1);
                                if (!placeholder.contains(".")) {
                                    this.replacePlaceholder(replaceMap, placeholder, paragraph, tempRun, doc);
                                }
                                tempRun = run;
                                continue;
                            }
                            type = 0;
                            tempRun = null;
                            placeholder = null;
                            continue;
                        }
                        if (index1 == text.length() - 1) {
                            String str = tempRun.getText(0) + text.substring(0, index1);
                            tempRun.setText(str, 0);
                            placeholder = tempRun.getText(0).substring(0, str.indexOf("}"));
                            if (!placeholder.contains(".")) {
                                this.replacePlaceholder(replaceMap, placeholder, paragraph, tempRun, doc);
                            }
                            run.setText("$", 0);
                            type = 1;
                            tempRun = run;
                            continue;
                        }
                        type = 0;
                        tempRun = null;
                        placeholder = null;
                        continue;
                    }
                    String str = tempRun.getText(0) + text;
                    tempRun.setText("", 0);
                    run.setText(str, 0);
                    placeholder = str.substring(0, str.indexOf("}") + 1);
                    if (!placeholder.contains(".") || placeholder.contains("<") && placeholder.contains(">")) {
                        this.replacePlaceholder(replaceMap, placeholder, paragraph, run, doc);
                    }
                    type = 0;
                    tempRun = null;
                    placeholder = null;
                    continue;
                }
                String str = tempRun.getText(0);
                tempRun.setText("", 0);
                run.setText(str + text, 0);
                tempRun = run;
            }
        }
    }

    private void replacePlaceholder(Map<String, Object> replaceMap, String placeholder, XWPFParagraph paragraph, XWPFRun run, XWPFDocument doc) {
        String text = run.getText(0);
        for (String key : replaceMap.keySet()) {
            if (!placeholder.equals(key)) continue;
            if (replaceMap.get(key) instanceof InputStream) {
                try {
                    Double[] size;
                    if (text.equals(placeholder)) {
                        Double[] size2;
                        run.setText("", 0);
                        if (key.contains(QRCODE)) {
                            size2 = this.getImgSize(placeholder, 1.0);
                            run.addPicture((InputStream)replaceMap.get(key), 6, IMAGE, (int)(size2[0] * 36000.0), (int)(size2[1] * 36000.0));
                        }
                        if (key.contains(BARCODE)) {
                            size2 = this.getImgSize(placeholder, 1.5);
                            run.addPicture((InputStream)replaceMap.get(key), 6, IMAGE, (int)(size2[0] * 36000.0), (int)(size2[1] * 36000.0));
                        }
                        if (!key.contains("radio")) break;
                        break;
                    }
                    String[] splitText = text.split(Pattern.quote(placeholder));
                    run.setText(splitText[0], 0);
                    XWPFRun newRun = paragraph.insertNewRun(paragraph.getRuns().indexOf(run));
                    if (key.contains(QRCODE)) {
                        size = this.getImgSize(placeholder, 1.0);
                        newRun.addPicture((InputStream)replaceMap.get(key), 6, IMAGE, (int)(size[0] * 36000.0), (int)(size[1] * 36000.0));
                    }
                    if (key.contains(BARCODE)) {
                        size = this.getImgSize(placeholder, 1.5);
                        newRun.addPicture((InputStream)replaceMap.get(key), 6, IMAGE, (int)(size[0] * 36000.0), (int)(size[1] * 36000.0));
                    }
                    if (splitText.length <= 1 || splitText[1].isEmpty()) break;
                    XWPFRun newTextRun = paragraph.insertNewRun(paragraph.getRuns().indexOf(run) + 1);
                    newTextRun.setText(splitText[1], 0);
                    newTextRun.setBold(run.isBold());
                    newTextRun.setItalic(run.isItalic());
                    newTextRun.setFontFamily(run.getFontFamily());
                    newTextRun.setFontSize(run.getFontSize());
                    newTextRun.setUnderline(run.getUnderline());
                    newTextRun.setColor(run.getColor());
                    newTextRun.setStrikeThrough(run.isStrikeThrough());
                    newTextRun.setDoubleStrikethrough(run.isDoubleStrikeThrough());
                    newTextRun.setSmallCaps(run.isSmallCaps());
                    newTextRun.setCharacterSpacing(run.getCharacterSpacing());
                    newTextRun.setKerning(run.getKerning());
                    break;
                }
                catch (IOException | InvalidFormatException e) {
                    throw new RuntimeException(e);
                }
            }
            if (key.contains("sign")) {
                run.setText(text.replaceAll(Pattern.quote(placeholder), ""), 0);
                this.handleSignature(placeholder, replaceMap.get(placeholder).toString(), run, 0);
                break;
            }
            if (key.contains("picture")) {
                run.setText(text.replaceAll(Pattern.quote(placeholder), ""), 0);
                this.handleImg(doc, paragraph, placeholder, replaceMap.get(placeholder).toString(), run, 0, false);
                break;
            }
            run.setText(text.replaceAll(Pattern.quote(placeholder), replaceMap.get(placeholder).toString()), 0);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSignature(String tempString, String replaceText, XWPFRun aRun, int position) {
        if (tempString.contains("|") && tempString.contains("size") && HussarUtils.isNotEmpty((Object)replaceText)) {
            String[] split = tempString.split("\\|");
            if (split.length > 1) {
                String size = split[1];
                int mode = 0;
                String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                String[] split1 = imageconfig.split("\\*");
                String width = split1[0];
                String height = split1[1];
                if (!width.contains("auto")) {
                    String[] split2;
                    if (height.contains(FIXED)) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 1;
                    } else if (height.contains("_")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 2;
                    } else {
                        height = "auto";
                        mode = 3;
                    }
                }
                double widthToHeight = 0.0;
                if (split1.length == 2) {
                    int index = replaceText.indexOf(",");
                    replaceText = replaceText.substring(index + 1);
                    ByteArrayInputStream inputStream = null;
                    try {
                        Base64.Decoder decoder = Base64.getDecoder();
                        byte[] b = decoder.decode(replaceText);
                        inputStream = new ByteArrayInputStream(b);
                    }
                    catch (Exception e) {
                        logger.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25", (Object)tempString);
                        logger.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    if (HussarUtils.isNotEmpty((Object)inputStream)) {
                        try {
                            List<Double> wh = this.getImageWidthAndHeight(width, height, mode, widthToHeight);
                            if (HussarUtils.isEmpty(wh)) {
                                logger.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef", (Object)tempString);
                            }
                            aRun.addPicture((InputStream)inputStream, this.judgeImgType("PNG"), "\u624b\u5199\u7b7e\u540d", wh.get(0).intValue() * 36000, wh.get(1).intValue() * 36000);
                        }
                        catch (Exception e) {
                            logger.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
                            logger.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)inputStream);
                        }
                    }
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    public List<Double> getImageWidthAndHeight(String width, String height, int mode, double widthToHeight) {
        if (widthToHeight == 0.0) {
            widthToHeight = 1.5;
        }
        ArrayList<Double> list = new ArrayList<Double>();
        if (mode == 0) {
            list.add(Double.parseDouble(height) * widthToHeight);
            list.add(Double.valueOf(height));
            return list;
        }
        if (mode == 1) {
            list.add(Double.valueOf(width));
            list.add(Double.valueOf(height));
            return list;
        }
        if (mode == 3 || mode == 2) {
            list.add(Double.parseDouble(width));
            list.add(Double.parseDouble(width) / widthToHeight);
            return list;
        }
        list.add(Double.parseDouble(width));
        list.add(Double.parseDouble(height));
        return list;
    }

    public int judgeImgType(String type) {
        if ("EMF".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("WMF".equalsIgnoreCase(type)) {
            return 3;
        }
        if ("PICT".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("JPEG".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("PNG".equalsIgnoreCase(type)) {
            return 6;
        }
        if ("DIB".equalsIgnoreCase(type)) {
            return 7;
        }
        if ("GIF".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("TIFF".equalsIgnoreCase(type)) {
            return 9;
        }
        if ("EPS".equalsIgnoreCase(type)) {
            return 10;
        }
        if ("BMP".equalsIgnoreCase(type)) {
            return 11;
        }
        if ("WPG".equalsIgnoreCase(type)) {
            return 12;
        }
        logger.error("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u7c7b\u578b\uff1a{},\u5df2\u81ea\u52a8\u8f6c\u4e3aPNG\u683c\u5f0f", (Object)type);
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleImg(XWPFDocument doc, XWPFParagraph para, String tempString, String replaceText, XWPFRun aRun, int position, boolean exactFlag) {
        List<Object> wh = new ArrayList();
        int mode = 0;
        String imageconfig = tempString.substring(tempString.indexOf("=") + 1, tempString.indexOf("}"));
        String[] split = imageconfig.split("\\*");
        String width = split[0];
        String height = split[1];
        if (!width.contains("auto")) {
            if (height.contains(FIXED)) {
                String[] split1 = height.split("_");
                height = split1[0];
                mode = 1;
            } else if (height.contains("_")) {
                String[] split2 = height.split("_");
                height = split2[0];
                mode = 2;
            } else {
                height = "auto";
                mode = 3;
            }
        }
        AttachmentManagerModelVo attachmentManagerModel = this.ossService.getByFileId(Long.valueOf(replaceText));
        InputStream inputStream = null;
        ByteArrayInputStream stream = null;
        ByteArrayInputStream stream2 = null;
        if (HussarUtils.isNotEmpty((Object)attachmentManagerModel)) {
            block44: {
                String id = String.valueOf(attachmentManagerModel.getId());
                String type = String.valueOf(attachmentManagerModel.getAttachmentType());
                String name = String.valueOf(attachmentManagerModel.getAttachmentName());
                byte[] bytes = this.showImageByte(Long.valueOf(id));
                double widthToHeight = 0.0;
                byte[] bs = new byte[]{};
                try {
                    inputStream = new ByteArrayInputStream(bytes);
                    stream = new ByteArrayInputStream(bytes);
                    stream2 = new ByteArrayInputStream(bytes);
                    bs = IOUtils.toByteArray((InputStream)stream);
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(bs));
                    widthToHeight = (double)image.getWidth() / (double)image.getHeight();
                    inputStream = this.handleWebp(inputStream, stream2, System.getProperty("user.dir") + File.separator, image);
                    File filePath = new File(System.getProperty("user.dir") + File.separator);
                    if (filePath.exists()) {
                        filePath.delete();
                    }
                    if (HussarUtils.isNotEmpty((Object)inputStream)) {
                        wh = this.getImageWidthAndHeight(width, height, mode, widthToHeight);
                        if (HussarUtils.isEmpty(wh)) {
                            logger.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)attachmentManagerModel);
                        }
                        aRun.addPicture(inputStream, this.judgeImgType(type), name, ((Double)wh.get(0)).intValue() * 36000, ((Double)wh.get(1)).intValue() * 36000);
                    }
                }
                catch (Exception e) {
                    logger.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)attachmentManagerModel);
                    logger.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (stream2 != null) {
                            ((InputStream)stream2).close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    XmlCursor xmlCursor;
                    XWPFParagraph paragraph;
                    CTPPr pPr;
                    int posOfParagraph;
                    XWPFParagraph next;
                    CTDrawing drawing;
                    if (!exactFlag || !HussarUtils.isNotEmpty((Object)aRun.getEmbeddedPictures()) || !HussarUtils.isNotEmpty((Object)aRun.getCTR()) || !HussarUtils.isNotEmpty((Object)aRun.getCTR().getDrawingList()) || !HussarUtils.isNotEmpty((Object)(drawing = aRun.getCTR().getDrawingArray(0)).getInlineList())) break block44;
                    CTGraphicalObject graphic = drawing.getInlineArray(0).getGraphic();
                    String anchorXML = "<wp:anchor  xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" simplePos=\"0\" relativeHeight=\"0\" behindDoc=\"0\" locked=\"0\" layoutInCell=\"1\" allowOverlap=\"1\"><wp:simplePos x=\"0\" y=\"0\"/><wp:positionH relativeFrom=\"column\"><wp:posOffset>635</wp:posOffset></wp:positionH><wp:positionV relativeFrom=\"paragraph\"><wp:posOffset>" + -(589280 * ((Double)wh.get(1)).intValue() / 20) + "</wp:posOffset></wp:positionV><wp:extent cx=\"" + ((Double)wh.get(0)).intValue() * 36000 + "\" cy=\"" + ((Double)wh.get(1)).intValue() * 36000 + "\"/><wp:effectExtent l=\"0\" t=\"0\" r=\"0\" b=\"0\"/><wp:wrapNone/><wp:docPr id=\"1\" name=\"Drawing 0\" descr=\"11\"/><wp:cNvGraphicFramePr/></wp:anchor>";
                    CTDrawing drawing1 = null;
                    try {
                        drawing1 = CTDrawing.Factory.parse((String)anchorXML);
                    }
                    catch (XmlException e) {
                        e.printStackTrace();
                    }
                    CTAnchor anchor = drawing1.getAnchorArray(0);
                    anchor.setGraphic(graphic);
                    drawing.setAnchorArray(new CTAnchor[]{anchor});
                    drawing.removeInline(0);
                    XmlObject copyPPr = null;
                    if (HussarUtils.isNotEmpty((Object)para.getCTP()) && HussarUtils.isNotEmpty((Object)para.getCTP().getPPr())) {
                        CTPPr pPr2 = para.getCTP().getPPr();
                        copyPPr = pPr2.copy();
                    }
                    if (HussarUtils.isEmpty((Object)(next = doc.getParagraphArray((posOfParagraph = doc.getPosOfParagraph(para)) + 1)))) {
                        next = doc.createParagraph();
                    }
                    if (HussarUtils.isEmpty((Object)(pPr = (paragraph = doc.insertNewParagraph(xmlCursor = next.getCTP().newCursor())).getCTP().getPPr()))) {
                        pPr = paragraph.getCTP().addNewPPr();
                    }
                    pPr.set(copyPPr);
                    if (HussarUtils.isNotEmpty((Object)para.getCTP()) && HussarUtils.isNotEmpty((Object)para.getCTP().getPPr()) && HussarUtils.isNotEmpty((Object)para.getCTP().getPPr().getSectPr())) {
                        CTPPr oriPPr = para.getCTP().getPPr();
                        oriPPr.unsetSectPr();
                    }
                }
                catch (Exception e) {
                    logger.error("\u56fe\u7247\u6d6e\u4e8e\u6587\u5b57\u4e0a\u65b9\u5931\u8d25", (Throwable)e);
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    public byte[] showImageByte(Long id) {
        return (byte[])this.ossService.backgroundDownload(id).getData();
    }

    public InputStream handleWebp(InputStream inputStream, InputStream stream, String outputPath, BufferedImage image) throws IOException {
        boolean isWebp = this.imgType(stream);
        if (isWebp) {
            String path = outputPath + "wordTemplate" + File.separator + "webp" + File.separator;
            File filePath = new File(outputPath + "wordTemplate" + File.separator + "webp" + File.separator);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            String newPath = path + System.currentTimeMillis() + ".png";
            ImageIO.write((RenderedImage)image, "png", new File(newPath));
            return Files.newInputStream(Paths.get(newPath, new String[0]), new OpenOption[0]);
        }
        return inputStream;
    }

    public boolean imgType(InputStream inputStream) throws IOException {
        byte[] fileHeader = new byte[4];
        inputStream.read(fileHeader, 0, fileHeader.length);
        inputStream.close();
        String header = this.bytes2Hex(fileHeader);
        return header.contains("52494646");
    }

    public String bytes2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(b & 0xFF);
            sb.append(hex.length() == 2 ? hex : "0" + hex);
        }
        return sb.toString();
    }

    private Double[] getImgSize(String placeholder, double ratio) {
        Double[] size = new Double[2];
        int delimiter1 = placeholder.indexOf("size=");
        int delimiter2 = placeholder.indexOf("*", delimiter1);
        int delimiter3 = placeholder.indexOf("}", delimiter2);
        String widthStr = placeholder.substring(delimiter1 + 5, delimiter2);
        String heightStr = placeholder.substring(delimiter2 + 1, delimiter3);
        double weight = Double.parseDouble(widthStr.split("_")[0]);
        double height = Double.parseDouble(heightStr.split("_")[0]);
        if (!widthStr.contains(FIXED)) {
            size[1] = height;
            size[0] = heightStr.contains(FIXED) ? Double.valueOf(height * ratio) : Double.valueOf(weight);
        } else {
            size[0] = weight;
            size[1] = heightStr.contains(FIXED) ? Double.valueOf(height) : Double.valueOf(weight / ratio);
        }
        return size;
    }

    private void replaceChildValueInTable(XWPFDocument doc, Map<String, Object> replaceMap, Map<String, Object> dataMap) {
        if (HussarUtils.isEmpty(replaceMap)) {
            return;
        }
        HashMap<String, List> childValues = new HashMap<String, List>();
        HashMap<String, Integer> valueCountMap = new HashMap<String, Integer>();
        block4: for (String placeholder : replaceMap.keySet()) {
            String tableName = replaceMap.get(placeholder).toString();
            for (String key : dataMap.keySet()) {
                if (!key.equals(tableName)) continue;
                childValues.put(tableName, (List)dataMap.get(key));
                valueCountMap.put(tableName, ((List)childValues.get(tableName)).size());
                continue block4;
            }
        }
        List tables = doc.getTables();
        HashMap replaceRows = new HashMap();
        for (XWPFTable table : tables) {
            List tableRows = table.getRows();
            if (tableRows.isEmpty()) continue;
            LinkedList templateRowInfo = new LinkedList();
            for (XWPFTableRow xWPFTableRow : tableRows) {
                int maxRowCount = 0;
                block8: for (XWPFTableCell tableRowCell : xWPFTableRow.getTableCells()) {
                    String content = tableRowCell.getText();
                    for (String key : childValues.keySet()) {
                        if (!content.contains(key)) continue;
                        maxRowCount = Math.max(maxRowCount, (Integer)valueCountMap.get(key));
                        continue block8;
                    }
                }
                if (maxRowCount == 0) continue;
                int index = tableRows.indexOf(xWPFTableRow);
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("index", index);
                map.put("maxRowCount", maxRowCount);
                templateRowInfo.add(0, map);
            }
            for (Map map : templateRowInfo) {
                int index = (Integer)map.get("index");
                int maxRowCount = (Integer)map.get("maxRowCount");
                XWPFTableRow templateRow = (XWPFTableRow)tableRows.get(index);
                List tableCells = templateRow.getTableCells();
                for (int i = 1; i <= maxRowCount; ++i) {
                    XWPFTableRow newRow = table.insertNewTableRow(index + i);
                    for (XWPFTableCell tableCell : tableCells) {
                        CTVMerge vMerge;
                        XWPFTableCell newCell = newRow.createCell();
                        newCell.removeParagraph(0);
                        for (XWPFParagraph tableCellParagraph : tableCell.getParagraphs()) {
                            CTPPr pPr;
                            XWPFParagraph newParagraph = newCell.addParagraph();
                            for (XWPFRun tableCellParagraphRun : tableCellParagraph.getRuns()) {
                                XWPFRun newRun = newParagraph.createRun();
                                String content = tableCellParagraphRun.getText(0);
                                block15: for (String key : childValues.keySet()) {
                                    Matcher matcher;
                                    if (content.isEmpty() || !(matcher = Pattern.compile("\\$\\{.*" + key + ".*\\}").matcher(content)).find()) continue;
                                    try {
                                        String placeholder = matcher.group();
                                        Object formData = ((List)childValues.get(key)).get(i - 1);
                                        Map childFormData = (Map)new ObjectMapper().convertValue(formData, Map.class);
                                        if (childFormData != null) {
                                            for (String childKey : childFormData.keySet()) {
                                                if (!placeholder.contains(key + "." + childKey)) continue;
                                                String data = "";
                                                Object pending = childFormData.get(childKey);
                                                data = pending instanceof LinkedHashMap ? this.formatDate((LinkedHashMap)pending, placeholder) : content.replaceAll(Pattern.quote(placeholder), pending + "");
                                                String[] other = content.split(Pattern.quote(placeholder));
                                                try {
                                                    Double[] size;
                                                    ByteArrayOutputStream byteArrayOutputStream;
                                                    BitMatrix bitMatrix;
                                                    HashMap<EncodeHintType, Object> hints;
                                                    if (placeholder.contains(QRCODE)) {
                                                        QRCodeWriter qrCodeWriter = new QRCodeWriter();
                                                        hints = new HashMap<EncodeHintType, Object>();
                                                        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                                                        bitMatrix = qrCodeWriter.encode(data, BarcodeFormat.QR_CODE, 300, 300, hints);
                                                        byteArrayOutputStream = new ByteArrayOutputStream();
                                                        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayOutputStream);
                                                        newRun.setText("", 0);
                                                        size = this.getImgSize(placeholder, 1.0);
                                                        newRun.addPicture((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), 6, IMAGE, (int)(size[0] * 36000.0), (int)(size[1] * 36000.0));
                                                        continue block15;
                                                    }
                                                    if (placeholder.contains(BARCODE)) {
                                                        if (placeholder.matches(".*[\\u4e00-\\u9fa5].*")) {
                                                            data = "The barcode does not support Chinese characters!";
                                                        }
                                                        Code128Writer barcodeWriter = new Code128Writer();
                                                        hints = new HashMap();
                                                        hints.put(EncodeHintType.MARGIN, 1);
                                                        bitMatrix = barcodeWriter.encode(data, BarcodeFormat.CODE_128, 300, 120, hints);
                                                        byteArrayOutputStream = new ByteArrayOutputStream();
                                                        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayOutputStream);
                                                        newRun.setText("", 0);
                                                        size = this.getImgSize(placeholder, 1.5);
                                                        newRun.addPicture((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), 6, IMAGE, (int)(size[0] * 36000.0), (int)(size[1] * 36000.0));
                                                        continue block15;
                                                    }
                                                    if (placeholder.contains("sign")) {
                                                        newRun.setText("", 0);
                                                        this.handleSignature(placeholder, data, newRun, 0);
                                                        continue block15;
                                                    }
                                                    if (placeholder.contains("picture")) {
                                                        newRun.setText("", 0);
                                                        this.handleImg(doc, newParagraph, placeholder, data, newRun, 0, false);
                                                        continue block15;
                                                    }
                                                    newRun.setText(data, 0);
                                                    continue block15;
                                                }
                                                catch (WriterException | IOException | InvalidFormatException e) {
                                                    throw new RuntimeException(e);
                                                }
                                            }
                                            continue;
                                        }
                                        newRun.setText(content.replaceAll(placeholder, ""));
                                    }
                                    catch (IndexOutOfBoundsException placeholder) {}
                                }
                                newRun.setFontFamily(tableCellParagraphRun.getFontFamily());
                                int fontSize = tableCellParagraphRun.getFontSize();
                                if (fontSize != -1) {
                                    newRun.setFontSize(tableCellParagraphRun.getFontSize());
                                }
                                newRun.setBold(tableCellParagraphRun.isBold());
                                newRun.setItalic(tableCellParagraphRun.isItalic());
                                newRun.setUnderline(tableCellParagraphRun.getUnderline());
                                newRun.setColor(tableCellParagraphRun.getColor());
                            }
                            newParagraph.setAlignment(tableCellParagraph.getAlignment());
                            newParagraph.setBorderBottom(tableCellParagraph.getBorderBottom());
                            newParagraph.setBorderLeft(tableCellParagraph.getBorderLeft());
                            newParagraph.setBorderRight(tableCellParagraph.getBorderRight());
                            newParagraph.setBorderTop(tableCellParagraph.getBorderTop());
                            int firstLine = tableCellParagraph.getIndentationFirstLine();
                            int hanging = tableCellParagraph.getIndentationHanging();
                            int left = tableCellParagraph.getIndentationLeft();
                            int right = tableCellParagraph.getIndentationRight();
                            int after = tableCellParagraph.getSpacingAfter();
                            int before = tableCellParagraph.getSpacingBefore();
                            if (firstLine != -1) {
                                newParagraph.setIndentationFirstLine(firstLine);
                            }
                            if (hanging != -1) {
                                newParagraph.setIndentationHanging(hanging);
                            }
                            if (left != -1) {
                                newParagraph.setIndentationLeft(left);
                            }
                            if (right != -1) {
                                newParagraph.setIndentationRight(right);
                            }
                            if (after != -1) {
                                newParagraph.setSpacingAfter(after);
                            }
                            if (before != -1) {
                                newParagraph.setSpacingBefore(before);
                            }
                            CTPPr cTPPr = pPr = tableCellParagraph.getCTP().isSetPPr() ? tableCellParagraph.getCTP().getPPr() : tableCellParagraph.getCTP().addNewPPr();
                            if (pPr.isSetSpacing()) {
                                CTSpacing spacing = pPr.getSpacing();
                                spacing.setLineRule(STLineSpacingRule.AUTO);
                            }
                            newParagraph.setSpacingBetween(tableCellParagraph.getSpacingBetween());
                        }
                        CTTcPr sourceTcPr = tableCell.getCTTc().getTcPr();
                        if (sourceTcPr != null) {
                            newCell.getCTTc().setTcPr(sourceTcPr);
                        }
                        if ((vMerge = tableCell.getCTTc().getTcPr().getVMerge()) == null || vMerge.getVal() != STMerge.CONTINUE) continue;
                        newCell.getCTTc().getTcPr().setVMerge(tableCell.getCTTc().getTcPr().getVMerge());
                    }
                }
                table.removeRow(index);
            }
        }
    }

    private void deal(JSONObject dataMap) {
        String localDateTimeRegex = "^\\d{4}-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(0[0-9]|1[0-9]|2[0-3]):([0-5][0-9])(:[0-5][0-9])?$";
        Pattern localDateTimePattern = Pattern.compile(localDateTimeRegex);
        for (String key : dataMap.keySet()) {
            String value = String.valueOf(dataMap.get((Object)key));
            if (!SysTemplatePrintInfoServiceImpl.isValidLocalDateTime(localDateTimePattern, value)) continue;
            String processedValueStr = value.replace("T", " ");
            dataMap.put(key, (Object)processedValueStr);
        }
    }

    private static boolean isValidLocalDateTime(Pattern localDateTimePattern, String dateTimeStr) {
        Matcher matcher = localDateTimePattern.matcher(dateTimeStr);
        return matcher.matches();
    }

    private static XSSFCellStyle createHeaderStyle(Workbook workbook) {
        XSSFCellStyle style = (XSSFCellStyle)workbook.createCellStyle();
        byte[] blackRGB = new byte[]{0, 0, 0};
        XSSFColor blackColor = new XSSFColor(blackRGB, null);
        Font font = workbook.createFont();
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        font.setColor(blackColor.getIndex());
        style.setFont(font);
        byte[] rgb = new byte[]{-39, -39, -39};
        XSSFColor color = new XSSFColor(rgb, null);
        style.setFillForegroundColor(color);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setTopBorderColor(blackColor.getIndex());
        style.setBottomBorderColor(blackColor.getIndex());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }
}

