/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.template.print.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.PermissionEnum;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.HussarTreePermission;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.template.print.dao.SysTemplatePrintGroupInfoMapper;
import com.jxdinfo.hussar.template.print.dao.SysTemplatePrintInfoMapper;
import com.jxdinfo.hussar.template.print.dto.PageTemplateDTO;
import com.jxdinfo.hussar.template.print.enums.TemplateEnum;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintGroupInfo;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintInfo;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintGroupInfoService;
import com.jxdinfo.hussar.template.print.vo.GroupTreeVO;
import com.jxdinfo.hussar.template.print.vo.SearchGroupVO;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.template.print.service.impl.SysTemplatePrintGroupInfoServiceImpl")
public class SysTemplatePrintGroupInfoServiceImpl
extends HussarServiceImpl<SysTemplatePrintGroupInfoMapper, SysTemplatePrintGroupInfo>
implements ISysTemplatePrintGroupInfoService {
    @Resource
    SysTemplatePrintGroupInfoMapper groupInfoMapper;
    @Resource
    SysTemplatePrintInfoMapper templateMapper;
    public static final String ICON = "module";
    public static final String PRINT_TYPE = "print";

    public ApiResponse<String> deleteGroupAndChild(Long groupId) {
        ArrayList<Long> idList = new ArrayList<Long>();
        this.getAllSubGroupIds(groupId, idList);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        for (String id : idList.stream().map(Object::toString).collect(Collectors.toList())) {
            queryWrapper.or(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.apply("FIND_IN_SET({0}, GROUP_ID) > 0", new Object[]{id});
            });
        }
        Long count = this.templateMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0L) {
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff0c\u5b58\u5728\u5173\u8054\u7684\u6253\u5370\u6a21\u677f");
        }
        try {
            return ApiResponse.success((Object)String.valueOf(this.groupInfoMapper.deleteBatchIds(idList)), (String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    public ApiResponse<String> saveOrUpdateGroupInfo(SysTemplatePrintGroupInfo groupInfo) {
        try {
            return ApiResponse.success((Object)String.valueOf(this.saveOrUpdate((BaseEntity)groupInfo)), (String)"");
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25", (Throwable)e);
        }
    }

    public void processGroups(List<SysTemplatePrintGroupInfo> groupInfoList) {
        this.addGroups(groupInfoList);
    }

    public ApiResponse<List<GroupTreeVO>> getGroupTree(Long parentId) {
        List<GroupTreeVO> groupTree;
        if (HussarUtils.isEmpty((Object)parentId)) {
            parentId = 0L;
        }
        if (HussarUtils.isNotEmpty(groupTree = this.groupInfoMapper.searchGroupTree(parentId))) {
            this.setGroupTree(groupTree);
        }
        return ApiResponse.success((Object)HussarTreeParser.getTreeList(groupTree));
    }

    public ApiResponse<IPage<SearchGroupVO>> getGroupNodeByPage(PageInfo pageInfo, String name) {
        try {
            Page page = HussarPageUtils.convert((PageInfo)pageInfo);
            page.setRecords(this.groupInfoMapper.selectGroupNodeByPage(page, name));
            return ApiResponse.success((Object)page);
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    public ApiResponse<List<GroupTreeVO>> echoGroupTreeById(Long id) {
        SysTemplatePrintGroupInfo groupInfo = (SysTemplatePrintGroupInfo)this.getById(id);
        ArrayList<Long> idList = new ArrayList<Long>();
        this.getIdsToRoot(groupInfo.getParentId(), idList);
        List<GroupTreeVO> result = this.groupInfoMapper.backGroupTree(idList);
        this.setGroupTree(result);
        return ApiResponse.success((Object)HussarTreeParser.getTreeList(result));
    }

    public ApiResponse<IPage<SysTemplatePrintInfo>> getTemplateByPage(PageTemplateDTO pageTemplateDTO) {
        try {
            Page page = new Page((long)pageTemplateDTO.getPage().intValue(), (long)pageTemplateDTO.getSize().intValue());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (StringUtil.isNotBlank((CharSequence)pageTemplateDTO.getName())) {
                queryWrapper.like(SysTemplatePrintInfo::getName, (Object)pageTemplateDTO.getName());
            }
            if (StringUtil.isNotBlank((CharSequence)pageTemplateDTO.getTemplateId())) {
                queryWrapper.eq(SysTemplatePrintInfo::getTemplateId, (Object)pageTemplateDTO.getTemplateId());
            }
            if (StringUtil.isNotBlank((CharSequence)pageTemplateDTO.getType())) {
                if (PRINT_TYPE.equals(pageTemplateDTO.getType())) {
                    queryWrapper.isNull(SysTemplatePrintInfo::getType);
                } else {
                    queryWrapper.eq(SysTemplatePrintInfo::getType, (Object)pageTemplateDTO.getType());
                }
            }
            if (HussarUtils.isNotEmpty((Object)pageTemplateDTO.getGroupId()) && pageTemplateDTO.getGroupId() > 0L) {
                ArrayList<Long> idList = new ArrayList<Long>();
                this.getAllSubGroupIds(pageTemplateDTO.getGroupId(), idList);
                if (HussarUtils.isNotEmpty(idList)) {
                    queryWrapper.in(SysTemplatePrintInfo::getGroupId, (Collection)idList.stream().map(Object::toString).collect(Collectors.toList()));
                }
            }
            queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
            IPage templateList = this.templateMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            return ApiResponse.success((Object)templateList);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.QUERY_FAILED.getMessage()), (Throwable)e);
        }
    }

    public ApiResponse<SysTemplatePrintGroupInfo> getGroupByResourceId(String resourceId) {
        return ApiResponse.success((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTemplatePrintGroupInfo::getResourceId, (Object)resourceId)));
    }

    public void addGroups(List<SysTemplatePrintGroupInfo> addGroupInfos) {
        if (HussarUtils.isEmpty(addGroupInfos)) {
            return;
        }
        for (SysTemplatePrintGroupInfo groupInfo : addGroupInfos) {
            groupInfo.setParentId(Long.valueOf(groupInfo.getParentId() == null ? 0L : groupInfo.getParentId()));
        }
        this.saveOrUpdateBatch(addGroupInfos);
    }

    private void getAllSubGroupIds(Long groupId, List<Long> idList) {
        List groupInfoList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysTemplatePrintGroupInfo::getParentId, (Object)groupId));
        if (HussarUtils.isNotEmpty((Object)groupInfoList)) {
            for (SysTemplatePrintGroupInfo groupInfo : groupInfoList) {
                this.getAllSubGroupIds(groupInfo.getGroupId(), idList);
            }
        }
        idList.add(groupId);
    }

    private void getIdsToRoot(Long parentId, List<Long> idList) {
        List groupInfoList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysTemplatePrintGroupInfo::getParentId, (Object)parentId));
        if (HussarUtils.isNotEmpty((Object)groupInfoList)) {
            for (SysTemplatePrintGroupInfo groupInfo : groupInfoList) {
                idList.add(groupInfo.getGroupId());
            }
            if (parentId != 0L) {
                SysTemplatePrintGroupInfo parentGroup = (SysTemplatePrintGroupInfo)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTemplatePrintGroupInfo::getGroupId, (Object)parentId));
                this.getIdsToRoot(parentGroup.getParentId(), idList);
            }
        }
    }

    private void setGroupTree(List<GroupTreeVO> groupTreeVos) {
        for (GroupTreeVO groupTreeVo : groupTreeVos) {
            groupTreeVo.setDisabled(Boolean.valueOf(false));
            groupTreeVo.setIcon(ICON);
            List permissions = groupTreeVo.getPermissions();
            permissions.add(new HussarTreePermission(PermissionEnum.DELETE.getId(), PermissionEnum.DELETE.getName(), Boolean.valueOf(true)));
            groupTreeVo.setPermissions(permissions);
        }
    }
}

