/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.template.print.utils;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCodeFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoCodeFileUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractFileFromZip(byte[] zipData, String targetFileName) {
        ByteArrayInputStream bais = new ByteArrayInputStream(zipData);
        try (ZipInputStream zis = new ZipInputStream(bais);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().equals(targetFileName)) {
                    StringBuilder content = new StringBuilder();
                    byte[] buffer = new byte[1024];
                    while (true) {
                        int len;
                        if ((len = zis.read(buffer)) <= 0) {
                            zis.closeEntry();
                            String string = content.toString();
                            return string;
                        }
                        content.append(new String(buffer, 0, len));
                    }
                }
                zis.closeEntry();
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.error("\u6587\u4ef6 " + targetFileName + " \u672a\u5728 zip \u6587\u4ef6\u4e2d\u627e\u5230\u3002");
        }
        return null;
    }

    public static void extractZipToDirectory(byte[] zipData, String targetDirectory) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(zipData);
        try (ZipInputStream zis = new ZipInputStream(bais);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName = entry.getName();
                File entryFile = new File(targetDirectory, entryName);
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                } else {
                    File parentDir = entryFile.getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    NoCodeFileUtil.writeToFile(zis, entryFile);
                }
                zis.closeEntry();
            }
        }
    }

    private static void writeToFile(ZipInputStream zis, File file) throws IOException {
        try (OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = zis.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
        }
    }

    public static void returnByteArray(byte[] data, String fileName, HttpServletResponse response) throws IOException {
        String encoding = NoCodeFileUtil.detectEncoding(data);
        if (HussarUtils.isEmpty((Object)encoding)) {
            encoding = Charset.defaultCharset().name();
        }
        response.setHeader("Content-Disposition", "attachment;filename=\"" + new String(fileName.getBytes(StandardCharsets.UTF_8), "ISO8859-1") + "\"");
        response.setContentType("application/octet-stream;charset=" + encoding);
        response.setContentLengthLong((long)data.length);
        ServletOutputStream os = response.getOutputStream();
        os.write(data);
        os.flush();
        os.close();
    }

    public static String verifyName(String name) {
        if (HussarUtils.isNotEmpty((Object)name)) {
            name = name.replace("\\", "");
            name = name.replace("/", "");
            name = name.replace(":", "");
            name = name.replace("*", "");
            name = name.replace("?", "");
            name = name.replace("\"", "");
            name = name.replace(">", "");
            name = name.replace("<", "");
            name = name.replace("|", "");
            name = name.replace("$", "");
            name = name.replace("#", "");
            name = name.replace("&", "");
            name = name.replace("%", "");
            name = name.replace("~", "");
            name = name.replace("{", "");
            name = name.replace("}", "");
            name = name.replace("[", "");
            name = name.replace("]", "");
        }
        return name;
    }

    public static void showPicture(byte[] data, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        response.setContentType("image/jpeg");
        ServletOutputStream os = response.getOutputStream();
        os.write(data);
        os.flush();
        os.close();
    }

    public static String detectEncoding(byte[] bytes) {
        String encodingFromBOM = NoCodeFileUtil.detectEncodingFromBOM(bytes);
        if (encodingFromBOM != null) {
            return encodingFromBOM;
        }
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(bytes, 0, bytes.length);
        detector.dataEnd();
        String detectedEncoding = detector.getDetectedCharset();
        detector.reset();
        return detectedEncoding != null ? detectedEncoding : "UTF-8";
    }

    private static String detectEncodingFromBOM(byte[] bytes) {
        if (bytes.length >= 3 && (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191) {
            return "UTF-8";
        }
        if (bytes.length >= 2 && (bytes[0] & 0xFF) == 254 && (bytes[1] & 0xFF) == 255) {
            return "UTF-16BE";
        }
        if (bytes.length >= 2 && (bytes[0] & 0xFF) == 255 && (bytes[1] & 0xFF) == 254) {
            if (bytes.length >= 4 && bytes[2] == 0 && bytes[3] == 0) {
                return "UTF-32LE";
            }
            return "UTF-16LE";
        }
        return null;
    }
}

