/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.template.print.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class MergeCellDetector {
    private List<CellRangeAddress> mergeRegions;

    public void init(Sheet sheet) {
        this.mergeRegions = new ArrayList<CellRangeAddress>(sheet.getMergedRegions());
    }

    public boolean isColumnMerged(int rowIndex, int columnIndex) {
        CellRangeAddress region = this.getMergedRegion(rowIndex, columnIndex);
        return region != null && region.getFirstColumn() != region.getLastColumn();
    }

    public boolean isMergedCell(int rowIndex, int columnIndex) {
        for (CellRangeAddress region : this.mergeRegions) {
            if (!region.isInRange(rowIndex, columnIndex)) continue;
            return true;
        }
        return false;
    }

    public CellRangeAddress getMergedRegion(int rowIndex, int columnIndex) {
        for (CellRangeAddress region : this.mergeRegions) {
            if (!region.isInRange(rowIndex, columnIndex)) continue;
            return region;
        }
        return null;
    }

    public List<CellRangeAddress> getMergeRegions() {
        return this.mergeRegions;
    }
}

