/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.template.print.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.IService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DictVo;
import com.jxdinfo.hussar.mail.core.util.StrUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.plugin.file.properties.OssFileProperties;
import com.jxdinfo.hussar.support.transdict.core.anno.Trans;
import com.jxdinfo.hussar.template.print.enums.TemplateEnum;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintInfo;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import com.jxdinfo.hussar.template.print.utils.CheckHookUtil;
import com.jxdinfo.hussar.template.print.utils.FieldControl;
import com.jxdinfo.hussar.template.print.utils.HeaderParser;
import com.jxdinfo.hussar.template.print.utils.MergeCellDetector;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class VerifyExcelUtil {
    private static final Logger logger = LoggerFactory.getLogger(VerifyExcelUtil.class);
    private static final Map<Class<?>, Field[]> FIELD_CACHE = new ConcurrentHashMap();
    private static final Map<String, MethodHandle> METHOD_CACHE = new ConcurrentHashMap<String, MethodHandle>();
    private static final ISysDicRefService dicRefService = (ISysDicRefService)SpringContextHolder.getBean(ISysDicRefService.class);
    private static final ISysTemplatePrintInfoService templatePrintInfoService = (ISysTemplatePrintInfoService)SpringContextHolder.getBean(ISysTemplatePrintInfoService.class);
    private static final OssFileProperties ossFileProperties = (OssFileProperties)SpringContextHolder.getBean(OssFileProperties.class);
    private static final AttachmentManagerService attachmentManagerService = (AttachmentManagerService)SpringContextHolder.getBean(AttachmentManagerService.class);
    private static final ISysUsersService sysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
    private static final ISysOrganService sysOrganService = (ISysOrganService)SpringContextHolder.getBean(ISysOrganService.class);
    private static final ISysExcelTaskService sysExcelTaskService = (ISysExcelTaskService)SpringContextHolder.getBean(ISysExcelTaskService.class);
    private static final List<String> validUserPropNames = new ArrayList<String>();
    private static final List<String> validOrganPropNames = new ArrayList<String>();

    public static <T> List<T> readInputStreamCheckExcel(SecurityUser user, String fileName, InputStream input, String templateId, Long taskId) {
        List result = new ArrayList();
        try (InputStream inputStream = input;){
            byte[] fileBytes = VerifyExcelUtil.readStreamFully(inputStream);
            SysTemplatePrintInfo sysPrintTemplate = (SysTemplatePrintInfo)templatePrintInfoService.getById((Serializable)((Object)templateId));
            if (ToolUtil.isEmpty((Object)sysPrintTemplate)) {
                throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.THE_TEMPLATE_DOES_NOT_EXIST.getMessage()));
            }
            JSONObject contentObject = JSONObject.parseObject((String)sysPrintTemplate.getContent());
            ObjectMapper mapper = new ObjectMapper();
            List<FieldControl> fieldControlList = (List<FieldControl>)mapper.readValue(contentObject.getString("fieldControl"), (TypeReference)new TypeReference<List<FieldControl>>(){});
            fieldControlList = fieldControlList.stream().filter(fieldControl -> "true".equals(fieldControl.getImportField())).collect(Collectors.toList());
            List<Object> importList = new ArrayList();
            String entityClassPath = contentObject.getString("entityClassPath");
            Class<?> tClass = Class.forName(entityClassPath);
            FIELD_CACHE.put(tClass, tClass.getDeclaredFields());
            FIELD_CACHE.put(FieldControl.class, FieldControl.class.getDeclaredFields());
            String[] entityClassPaths = entityClassPath.split("\\.");
            CheckHookUtil.readExcel(entityClassPaths[entityClassPaths.length - 1], importList, new ByteArrayInputStream(fileBytes));
            if (ToolUtil.isEmpty(importList)) {
                importList = VerifyExcelUtil.readInputStream(fileName, new ByteArrayInputStream(fileBytes), tClass, fieldControlList);
            }
            if (ToolUtil.isNotEmpty(importList)) {
                result = VerifyExcelUtil.checkExcel(user, importList, fieldControlList, fileName, new ByteArrayInputStream(fileBytes), taskId);
                CheckHookUtil.check(entityClassPaths[entityClassPaths.length - 1], importList, fileName);
                CheckHookUtil.importData(entityClassPaths[entityClassPaths.length - 1], importList, fileName);
            }
        }
        catch (Exception e) {
            SysExcelTask excelTask = (SysExcelTask)sysExcelTaskService.getById((Serializable)taskId);
            excelTask.setTaskStatus(Integer.valueOf(6));
            excelTask.setErrorMsg(e.getMessage());
            excelTask.setDataSuccess(Integer.valueOf(0));
            excelTask.setLastTime(LocalDateTime.now());
            excelTask.setLastEditor(user.getId());
            sysExcelTaskService.updateById((Object)excelTask);
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.VERIFICATION_FAILED.getMessage()), (Throwable)e);
        }
        return result;
    }

    public static <T> List<T> readInputStream(String fileName, InputStream input, Class<T> aClass, List<FieldControl> fieldControlList) {
        List<T> list;
        Workbook book = VerifyExcelUtil.getWorkbookInputStream(input, fileName);
        if (book == null) {
            return new ArrayList();
        }
        try (Workbook workbook = book;){
            Sheet sheet = workbook.getSheetAt(0);
            list = VerifyExcelUtil.readSheet(sheet, aClass, fieldControlList);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.FILE_READING_FAILED.getMessage()), (Throwable)e);
        }
        return list;
    }

    private static <T, S> List<T> readSheet(Sheet sheet, Class<T> aClass, List<FieldControl> fieldControlList) throws Exception {
        MergeCellDetector mergeDetector = new MergeCellDetector();
        mergeDetector.init(sheet);
        int rowStart = sheet.getFirstRowNum();
        int rowEnd = sheet.getLastRowNum();
        Row headRow = sheet.getRow(rowStart);
        if (headRow == null) {
            return new ArrayList();
        }
        int cellStart = headRow.getFirstCellNum();
        short cellEnd = headRow.getLastCellNum();
        ArrayList<T> list = new ArrayList<T>();
        if (rowStart == rowEnd) {
            return list;
        }
        Field[] fields = VerifyExcelUtil.getCachedFields(aClass);
        Map<String, Integer> headerMap = HeaderParser.parseHeader(sheet);
        List<FieldControl> fieldControlArrayList = VerifyExcelUtil.flattenFieldControls(fieldControlList);
        List typeNames = fieldControlArrayList.stream().map(FieldControl::getDictType).filter(dictType -> !dictType.isEmpty()).collect(Collectors.toList());
        List dictVos = dicRefService.getDictVosByTypeNames(typeNames);
        HashMap userTranslateMap = new HashMap();
        HashMap organTranslateMap = new HashMap();
        HashMap modelTranslateMap = new HashMap();
        int tableStartRow = 3;
        if (aClass.isAnnotationPresent(TableName.class) || sheet.getMergedRegions().isEmpty()) {
            tableStartRow = 2;
        }
        for (FieldControl fieldControl : fieldControlArrayList) {
            Cell cell;
            Row row;
            int i;
            if (!headerMap.containsKey(fieldControl.getProp())) continue;
            if (ToolUtil.isNotEmpty((Object)fieldControl.getUserTranslate())) {
                ArrayList<String> userTranslate = new ArrayList<String>();
                for (i = tableStartRow; i <= rowEnd; ++i) {
                    row = sheet.getRow(i);
                    cell = row.getCell(headerMap.get(fieldControl.getProp()).intValue());
                    if (!ToolUtil.isNotEmpty((Object)VerifyExcelUtil.getCellValue(cell)) || userTranslate.contains(VerifyExcelUtil.getCellValue(cell))) continue;
                    userTranslate.add(VerifyExcelUtil.getCellValue(cell));
                }
                if (userTranslateMap.containsKey(fieldControl.getUserTranslate())) {
                    ((List)userTranslateMap.get(fieldControl.getUserTranslate())).addAll(userTranslate);
                } else {
                    userTranslateMap.put(fieldControl.getUserTranslate(), userTranslate);
                }
            }
            if (ToolUtil.isNotEmpty((Object)fieldControl.getOrganTranslate())) {
                ArrayList<String> organTranslate = new ArrayList<String>();
                for (i = tableStartRow; i <= rowEnd; ++i) {
                    row = sheet.getRow(i);
                    cell = row.getCell(headerMap.get(fieldControl.getProp()).intValue());
                    if (!ToolUtil.isNotEmpty((Object)VerifyExcelUtil.getCellValue(cell)) || organTranslate.contains(VerifyExcelUtil.getCellValue(cell))) continue;
                    organTranslate.add(VerifyExcelUtil.getCellValue(cell));
                }
                if (organTranslateMap.containsKey(fieldControl.getOrganTranslate())) {
                    ((List)organTranslateMap.get(fieldControl.getOrganTranslate())).addAll(organTranslate);
                } else {
                    organTranslateMap.put(fieldControl.getOrganTranslate(), organTranslate);
                }
            }
            if (!ToolUtil.isNotEmpty((Object)fieldControl.getAssociateTable())) continue;
            ArrayList<String> modelTranslate = new ArrayList<String>();
            for (i = tableStartRow; i <= rowEnd; ++i) {
                row = sheet.getRow(i);
                cell = row.getCell(headerMap.get(fieldControl.getProp()).intValue());
                if (!ToolUtil.isNotEmpty((Object)VerifyExcelUtil.getCellValue(cell)) || modelTranslate.contains(VerifyExcelUtil.getCellValue(cell))) continue;
                modelTranslate.add(VerifyExcelUtil.getCellValue(cell));
            }
            HashMap<String, ArrayList<String>> modelMap = new HashMap<String, ArrayList<String>>();
            if (modelTranslateMap.containsKey(fieldControl.getAssociateService())) {
                if (((Map)modelTranslateMap.get(fieldControl.getAssociateService())).containsKey(fieldControl.getAssociateTableProp())) {
                    List oldModelTranslate = (List)((Map)modelTranslateMap.get(fieldControl.getAssociateService())).get(fieldControl.getAssociateTableProp());
                    modelTranslate.addAll(oldModelTranslate);
                }
                Map oldModelMap = (Map)modelTranslateMap.get(fieldControl.getAssociateService());
                modelMap.putAll(oldModelMap);
            }
            modelMap.put(fieldControl.getAssociateTableProp(), modelTranslate);
            modelTranslateMap.put(fieldControl.getAssociateService(), modelMap);
        }
        ArrayList<UserStaffVo> userStaffVos = new ArrayList<UserStaffVo>();
        for (Object key : userTranslateMap.keySet()) {
            List userTranslate = (List)userTranslateMap.get(key);
            if (userTranslate.size() > 1000) {
                for (int i = 0; i < userTranslate.size(); i += 1000) {
                    userStaffVos.addAll(VerifyExcelUtil.getUsersAndStaffInfo((String)key, userTranslate.subList(i, Math.min(i + 1000, userTranslate.size()))));
                }
                continue;
            }
            if (!ToolUtil.isNotEmpty((Object)userTranslate)) continue;
            userStaffVos.addAll(VerifyExcelUtil.getUsersAndStaffInfo((String)key, userTranslate));
        }
        ArrayList<OrganizationBo> arrayList = new ArrayList<OrganizationBo>();
        for (String key : organTranslateMap.keySet()) {
            List organTranslate = (List)organTranslateMap.get(key);
            if (organTranslate.size() > 1000) {
                for (int i = 0; i < organTranslate.size(); i += 1000) {
                    arrayList.addAll(VerifyExcelUtil.selectOrganizationBos(key, organTranslate.subList(i, Math.min(i + 1000, organTranslate.size()))));
                }
                continue;
            }
            if (!ToolUtil.isNotEmpty((Object)organTranslate)) continue;
            arrayList.addAll(VerifyExcelUtil.selectOrganizationBos(key, organTranslate));
        }
        HashMap<String, List<S>> classListHashMap = new HashMap<String, List<S>>();
        for (String serviceName : modelTranslateMap.keySet()) {
            Map modelTranslate = (Map)modelTranslateMap.get(serviceName);
            ArrayList modelTranslateList = new ArrayList();
            for (String associationProp : modelTranslate.keySet()) {
                IService service = (IService)SpringContextHolder.getBean((String)serviceName);
                Class<?> subClass = VerifyExcelUtil.getEntityClass(service.getClass());
                List modelTransList = (List)modelTranslate.get(associationProp);
                if (modelTranslate.size() > 1000) {
                    for (int i = 0; i < modelTransList.size(); i += 1000) {
                        SFunction<?, S> function = VerifyExcelUtil.convertToSFunction(subClass, associationProp);
                        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                        wrapper.in(function, modelTransList.subList(i, Math.min(i + 1000, modelTransList.size())));
                        modelTranslateList.addAll(service.list((Wrapper)wrapper));
                    }
                    continue;
                }
                if (!ToolUtil.isNotEmpty((Object)modelTransList)) continue;
                SFunction<?, S> function = VerifyExcelUtil.convertToSFunction(subClass, associationProp);
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(function, (Collection)modelTransList);
                modelTranslateList.addAll(service.list((Wrapper)wrapper));
            }
            classListHashMap.put(serviceName, modelTranslateList);
        }
        if (mergeDetector.getMergeRegions().isEmpty()) {
            for (int i = rowStart + 2; i <= rowEnd; ++i) {
                T importData = aClass.newInstance();
                for (int j = cellStart; j < cellEnd; ++j) {
                    VerifyExcelUtil.mapCellToField(fields, sheet, i, j, arrayList, userStaffVos, importData, fieldControlArrayList, dictVos, classListHashMap);
                }
                list.add(importData);
            }
            return list;
        }
        for (int i = rowStart + 3; i <= rowEnd; ++i) {
            int maxSubLength = VerifyExcelUtil.mapSubTableData(fields, sheet, i, headerMap, arrayList, userStaffVos, aClass, list, fieldControlArrayList, dictVos, classListHashMap);
            i = i + maxSubLength - 1;
        }
        return list;
    }

    public static <S, T> List<S> readSubTable(Sheet sheet, Class<S> clazz, int startRowIndex, Map<String, Integer> headerMap, List<OrganizationBo> organizationBos, List<UserStaffVo> userStaffVos, List<FieldControl> fieldControlArrayList, List<DictVo> dictVos, Map<String, List<T>> modelDataMap) throws Exception {
        Row row;
        HashMap<String, Integer> subMap = new HashMap<String, Integer>();
        for (String key : headerMap.keySet()) {
            if (!key.contains(".") || !clazz.getName().contains(StrUtil.upperFirst((CharSequence)key.split("\\.")[0]))) continue;
            subMap.put(key.split("\\.")[1], headerMap.get(key));
        }
        ArrayList<S> subResult = new ArrayList<S>();
        List mergedRegions = sheet.getMergedRegions();
        Row startRow = sheet.getRow(startRowIndex);
        int lastCellNum = startRow.getLastCellNum();
        boolean found = false;
        block1: for (CellRangeAddress region : mergedRegions) {
            if (found) break;
            for (int i = 0; i < lastCellNum; ++i) {
                int colIndex;
                int rowIndex;
                Cell startRowCell = startRow.getCell(i);
                if (startRowCell == null || !region.isInRange(rowIndex = startRowCell.getRowIndex(), colIndex = startRowCell.getColumnIndex())) continue;
                int lastRowOfMerge = region.getLastRow();
                headerMap.put("lastRow", lastRowOfMerge);
                found = true;
                continue block1;
            }
        }
        if (!found) {
            headerMap.put("lastRow", startRowIndex);
        }
        for (int i = startRowIndex; i < headerMap.get("lastRow") + 1 && !VerifyExcelUtil.isEmptyRow(row = sheet.getRow(i)); ++i) {
            S subObj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            boolean flag = false;
            for (Field field : clazz.getDeclaredFields()) {
                if (!subMap.containsKey(field.getName())) continue;
                Cell cell = row.getCell(((Integer)subMap.get(field.getName())).intValue());
                if (ToolUtil.isNotEmpty((Object)VerifyExcelUtil.getCellValue(cell))) {
                    flag = true;
                }
                if (field.isAnnotationPresent(Trans.class)) {
                    VerifyExcelUtil.processTransAnnotation(cell, field, subObj, organizationBos, userStaffVos, fieldControlArrayList, dictVos, modelDataMap);
                    continue;
                }
                if (!VerifyExcelUtil.isCellTypeMatch(cell, field.getType())) continue;
                HussarUtils.setProperty(subObj, (String)field.getName(), (Object)VerifyExcelUtil.getCellValue(cell, field.getType()));
            }
            if (!flag) continue;
            subResult.add(subObj);
        }
        return subResult;
    }

    public static <T, S> List<T> checkExcel(SecurityUser user, List<T> importList, List<FieldControl> fieldControlList, String fileName, InputStream input, Long taskId) throws Exception {
        HashMap<String, FieldControl> fieldControlMap = new HashMap<String, FieldControl>();
        for (FieldControl fieldControl : fieldControlList) {
            if (!fieldControl.getChildren().isEmpty()) {
                List<FieldControl> subFieldControls = fieldControl.getChildren();
                fieldControlMap.put(fieldControl.getProp(), fieldControl);
                for (FieldControl subFieldControl : subFieldControls) {
                    if (!"true".equals(subFieldControl.getImportField())) continue;
                    subFieldControl.setProp(subFieldControl.getProp());
                    subFieldControl.setPropName(subFieldControl.getPropName());
                    fieldControlMap.put(subFieldControl.getProp(), subFieldControl);
                }
                continue;
            }
            fieldControlMap.put(fieldControl.getProp(), fieldControl);
        }
        Class<?> tClass = importList.get(0).getClass();
        Field[] fields = VerifyExcelUtil.getCachedFields(tClass);
        List<T> copy = VerifyExcelUtil.deepCopy(importList);
        ArrayList<Object> newList = new ArrayList<Object>();
        for (int j = 0; j < importList.size(); ++j) {
            if (!ToolUtil.isNotEmpty((Object)HussarCacheUtil.get((String)"subLength", importList.get(j)))) continue;
            int num = (Integer)HussarCacheUtil.get((String)"subLength", importList.get(j));
            for (int k = 0; k < num; ++k) {
                Object t = tClass.newInstance();
                for (Field field : fields) {
                    if (ToolUtil.isNotEmpty(VerifyExcelUtil.getGenericType(field))) {
                        List childList = (List)HussarUtils.getProperty(copy.get(j), (String)field.getName());
                        if (k >= childList.size()) continue;
                        ArrayList objects = new ArrayList();
                        objects.add(childList.get(k));
                        HussarUtils.setProperty(t, (String)field.getName(), (Object)objects);
                        continue;
                    }
                    if ("serialVersionUID".equals(field.getName())) continue;
                    HussarUtils.setProperty(t, (String)field.getName(), (Object)HussarUtils.getProperty(importList.get(j), (String)field.getName()));
                }
                newList.add(t);
            }
        }
        int errorNum = 0;
        Workbook workbook = VerifyExcelUtil.getWorkbookInputStream(input, fileName);
        if (ToolUtil.isNotEmpty((Object)workbook)) {
            try (Workbook book = workbook;){
                Sheet sheet = book.getSheetAt(0);
                int tableStartRow = 3;
                if (tClass.isAnnotationPresent(TableName.class) || sheet.getMergedRegions().isEmpty()) {
                    newList.addAll(copy);
                    tableStartRow = 2;
                }
                int rootNum = newList.size();
                Row firstRow = sheet.getRow(0);
                int lastColumnIndex = firstRow.getLastCellNum() - 1;
                for (Row row : sheet) {
                    boolean flag = false;
                    if (row.getRowNum() < tableStartRow) continue;
                    Object importClass = newList.get(row.getRowNum() - tableStartRow);
                    for (int j = 0; j <= lastColumnIndex; ++j) {
                        Cell cell = row.getCell(j);
                        if (ToolUtil.isEmpty((Object)cell)) {
                            cell = row.createCell(j);
                        }
                        for (Field field : fields) {
                            Object fieldValue;
                            String excelProp = VerifyExcelUtil.getCellValue(sheet.getRow(0).getCell(j));
                            String excelPropName = VerifyExcelUtil.getCellValue(sheet.getRow(1).getCell(j));
                            if (!fieldControlMap.containsKey(field.getName()) || !fieldControlMap.containsKey(excelProp)) continue;
                            FieldControl fieldControl = (FieldControl)fieldControlMap.get(field.getName());
                            if (field.getName().equals(excelProp)) {
                                fieldValue = HussarUtils.getProperty(importClass, (String)excelProp);
                                flag = VerifyExcelUtil.verify(fieldControl, cell, excelPropName, fieldValue, tableStartRow, flag);
                                continue;
                            }
                            if (!excelProp.split("\\.")[0].equals(field.getName())) continue;
                            fieldValue = HussarUtils.getProperty(importClass, (String)field.getName());
                            String subExcelPropName = VerifyExcelUtil.getCellValue(sheet.getRow(2).getCell(j));
                            Class<?> sClass = VerifyExcelUtil.getGenericType(field);
                            Field[] subFields = VerifyExcelUtil.getCachedFields(sClass);
                            FieldControl subFieldControl = (FieldControl)fieldControlMap.get(excelProp);
                            for (Field subField : subFields) {
                                List subData;
                                if (!excelProp.split("\\.")[1].equals(subField.getName()) || !ToolUtil.isNotEmpty((Object)(subData = (List)fieldValue))) continue;
                                Object subFieldValue = HussarUtils.getProperty(subData.get(0), (String)subField.getName());
                                flag = VerifyExcelUtil.verify(subFieldControl, cell, subExcelPropName, subFieldValue, tableStartRow, flag);
                            }
                        }
                    }
                    if (!flag) continue;
                    ++errorNum;
                }
                Long fileId = VerifyExcelUtil.upload(book);
                SysExcelTask excelTask = (SysExcelTask)sysExcelTaskService.getById((Serializable)taskId);
                if (errorNum > 0) {
                    int successNum = rootNum - errorNum;
                    excelTask.setTaskStatus(Integer.valueOf(3));
                    excelTask.setDataSuccess(Integer.valueOf(successNum));
                    excelTask.setDataError(Integer.valueOf(errorNum));
                } else {
                    excelTask.setTaskStatus(Integer.valueOf(2));
                    excelTask.setDataSuccess(Integer.valueOf(rootNum));
                    excelTask.setDataError(Integer.valueOf(0));
                }
                excelTask.setTaskFile(fileId);
                excelTask.setFileName(fileName);
                excelTask.setLastTime(LocalDateTime.now());
                if (ToolUtil.isNotEmpty((Object)user)) {
                    excelTask.setLastEditor(user.getId());
                }
                sysExcelTaskService.updateById((Object)excelTask);
            }
            catch (Exception e) {
                throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.VERIFICATION_FAILED.getMessage()), (Throwable)e);
            }
        }
        if (errorNum > 0) {
            return new ArrayList();
        }
        return importList;
    }

    private static Class<?> getGenericType(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            return (Class)type.getActualTypeArguments()[0];
        }
        return null;
    }

    public static Field[] getCachedFields(Class<?> clazz) {
        return FIELD_CACHE.computeIfAbsent(clazz, Class::getDeclaredFields);
    }

    public static <T> IService<T> getServiceByModel(String serviceName) {
        return (IService)SpringContextHolder.getBean((String)serviceName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Workbook getWorkbookFile(MultipartFile mFile, File file) throws IOException {
        String fileName;
        InputStream in;
        boolean fileNotExist;
        boolean bl = fileNotExist = file == null || !file.exists();
        if (mFile == null && fileNotExist) {
            return null;
        }
        if (mFile != null) {
            in = mFile.getInputStream();
            fileName = mFile.getOriginalFilename();
        } else {
            in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            fileName = file.getName().toLowerCase();
        }
        if (fileName == null) {
            return null;
        }
        try (InputStream inputStream = in;){
            XSSFWorkbook book;
            if (fileName.endsWith(".xlsx")) {
                book = new XSSFWorkbook(inputStream);
                return book;
            }
            if (fileName.endsWith(".xls")) {
                POIFSFileSystem poifsFileSystem = new POIFSFileSystem(inputStream);
                book = new HSSFWorkbook(poifsFileSystem);
                return book;
            }
            Workbook workbook = null;
            return workbook;
        }
        catch (IOException e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.FILE_READING_FAILED.getMessage()), (Throwable)e);
        }
    }

    public static Workbook getWorkbookInputStream(InputStream input, String fileName) {
        XSSFWorkbook book = null;
        if (input == null) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.THE_INPUT_STREAM_CANNOT_BE_EMPTY.getMessage()));
        }
        try (InputStream inputStream = input;){
            if (fileName.endsWith(".xlsx")) {
                book = new XSSFWorkbook(inputStream);
            } else if (fileName.endsWith(".xls")) {
                POIFSFileSystem poifsFileSystem = new POIFSFileSystem(inputStream);
                book = new HSSFWorkbook(poifsFileSystem);
            }
        }
        catch (IOException e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.FILE_READING_FAILED.getMessage()), (Throwable)e);
        }
        return book;
    }

    public static String getCellValue(Cell cell) {
        if (cell == null || cell.getCellType() == CellType.BLANK) {
            return "";
        }
        if (cell.getCellType() == CellType.STRING) {
            String val = cell.getStringCellValue();
            if (val == null || val.trim().isEmpty()) {
                return "";
            }
            return val.trim();
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            String s = cell.getNumericCellValue() + "";
            if (Pattern.matches(".*\\.0*", s)) {
                return s.split("\\.")[0];
            }
            return s;
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return cell.getBooleanCellValue() + "";
        }
        return cell.getCellFormula();
    }

    public static boolean isEmptyRow(Row row) {
        if (row == null) {
            return true;
        }
        for (Cell cell : row) {
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    public static Object getCellValue(Cell cell, Class<?> type) {
        if (cell == null) {
            return null;
        }
        if (type == String.class) {
            return cell.getStringCellValue();
        }
        if (type == Integer.class) {
            return (int)cell.getNumericCellValue();
        }
        if (type == Long.class) {
            return (long)cell.getNumericCellValue();
        }
        if (type == Double.class) {
            return cell.getNumericCellValue();
        }
        if (type == Boolean.class) {
            return cell.getBooleanCellValue();
        }
        if (type == LocalDateTime.class) {
            return cell.getLocalDateTimeCellValue();
        }
        return null;
    }

    public static <T> List<T> deepCopy(List<T> list) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(list);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            return (List)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(TranslateUtil.getTranslateName((String)TemplateEnum.DEEP_COPY_FAILED.getMessage()), e);
        }
    }

    public static void drawingPatriarch(Workbook workbook, Sheet sheet, Cell cell, String error) {
        CreationHelper factory = workbook.getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        int charCount = error.length();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setRow1(cell.getRowIndex());
        anchor.setCol2(cell.getColumnIndex() + Math.max(1, charCount / 10));
        anchor.setRow2(cell.getRowIndex() + 3);
        if (cell.getCellComment() != null) {
            cell.removeCellComment();
        }
        Comment comment = drawing.createCellComment(anchor);
        RichTextString str = factory.createRichTextString(error);
        comment.setString(str);
        comment.setAuthor("Hussar");
        comment.setVisible(false);
        cell.setCellComment(comment);
        short dataFormat = cell.getCellStyle().getDataFormat();
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.cloneStyleFrom(cell.getCellStyle());
        cellStyle.setDataFormat(dataFormat);
        XSSFColor redColor = new XSSFColor(new byte[]{-1, 0, 0}, null);
        ((XSSFCellStyle)cellStyle).setBottomBorderColor(redColor);
        ((XSSFCellStyle)cellStyle).setTopBorderColor(redColor);
        ((XSSFCellStyle)cellStyle).setLeftBorderColor(redColor);
        ((XSSFCellStyle)cellStyle).setRightBorderColor(redColor);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
        cell.setCellStyle(cellStyle);
    }

    private static CellType conversionType(FieldControl fieldControl) {
        switch (fieldControl.getDataType()) {
            case "String": {
                return CellType.STRING;
            }
            case "Boolean": {
                return CellType.BOOLEAN;
            }
            case "Integer": 
            case "Double": 
            case "Long": 
            case "Numeric": 
            case "LocalDateTime": {
                return CellType.NUMERIC;
            }
        }
        return null;
    }

    public static <T, S> SFunction<T, S> convertToSFunction(Class<T> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            String getterPrefix = field.getType() == Boolean.TYPE ? "is" : "get";
            String getterName = getterPrefix + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            Method method = clazz.getMethod(getterName, new Class[0]);
            String cacheKey = clazz.getName() + "#" + fieldName;
            MethodHandle methodHandle = METHOD_CACHE.computeIfAbsent(cacheKey, k -> {
                try {
                    return MethodHandles.lookup().unreflect(method);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
            MethodType samType = MethodType.methodType(method.getReturnType(), clazz);
            CallSite callSite = LambdaMetafactory.altMetafactory(MethodHandles.lookup(), "apply", MethodType.methodType(SFunction.class), samType, methodHandle, samType, 1);
            return callSite.getTarget().invokeExact();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(TranslateUtil.getTranslateName((String)TemplateEnum.THE_FIELD_DOES_NOT_EXIST.getMessage()));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(TranslateUtil.getTranslateName((String)TemplateEnum.MISSING_GETTER_METHOD.getMessage()) + e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Long upload(Workbook workbook) throws Exception {
        Long id = EngineUtil.getId();
        String outputFilePath = ossFileProperties.getFileUploadPath() + id + ".xlsx";
        try (FileOutputStream fileOut = new FileOutputStream(outputFilePath);){
            workbook.write((OutputStream)fileOut);
        }
        File file1 = new File(outputFilePath);
        String fileName = file1.getName();
        String suffix = VerifyExcelUtil.getSuffix(fileName);
        String fileSavePath = ossFileProperties.getFileUploadPath();
        AttachmentManagerModel attachment = new AttachmentManagerModel();
        attachment.setId(id);
        attachment.setAttachmentName(fileName);
        attachment.setAttachmentType(suffix.replace(".", ""));
        attachment.setAttachmentSize(Long.valueOf(file1.length()));
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            attachment.setUploadPer(user.getUserId());
        }
        attachment.setAttachmentDir(fileSavePath);
        attachment.setUploadDate(LocalDateTime.now());
        attachmentManagerService.save((Object)attachment);
        return attachment.getId();
    }

    public static String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    public static void addListDataValidation(Sheet sheet, int firstCol, int lastCol, int firstRow, int lastRow, String[] items) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList region = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = helper.createExplicitListConstraint(items);
        DataValidation validation = helper.createValidation(constraint, region);
        validation.setSuppressDropDownArrow(true);
        validation.setShowErrorBox(true);
        sheet.addValidationData(validation);
    }

    private static <T, S> boolean verify(FieldControl fieldControl, Cell cell, String excelPropName, Object fieldValue, int startRow, boolean flag) {
        String organTranslate;
        String userTranslate;
        StringBuilder errorMsg = new StringBuilder();
        Sheet sheet = cell.getSheet();
        Workbook workbook = sheet.getWorkbook();
        if (ToolUtil.isNotEmpty((Object)VerifyExcelUtil.conversionType(fieldControl)) && cell.getCellType() != CellType.BLANK && cell.getCellType() != VerifyExcelUtil.conversionType(fieldControl)) {
            flag = true;
            VerifyExcelUtil.drawingPatriarch(workbook, sheet, cell, errorMsg.append("\u5f53\u524d\u5355\u5143\u683c\u683c\u5f0f\u4e0d\u6b63\u786e").toString());
        }
        if ("true".equals(fieldControl.getRequired()) && ToolUtil.isEmpty((Object)VerifyExcelUtil.getCellValue(cell)) && ToolUtil.isEmpty((Object)fieldValue)) {
            if (ToolUtil.isNotEmpty((Object)errorMsg.toString())) {
                errorMsg.append(System.lineSeparator());
            }
            flag = true;
            VerifyExcelUtil.drawingPatriarch(workbook, sheet, cell, errorMsg.append(String.format("[%s]\u4e0d\u80fd\u4e3a\u7a7a", excelPropName)).toString());
        }
        if (ToolUtil.isNotEmpty((Object)(userTranslate = fieldControl.getUserTranslate())) && ToolUtil.isEmpty((Object)fieldValue) && ToolUtil.isNotEmpty((Object)VerifyExcelUtil.getCellValue(cell))) {
            if (ToolUtil.isNotEmpty((Object)errorMsg.toString())) {
                errorMsg.append(System.lineSeparator());
            }
            flag = true;
            VerifyExcelUtil.drawingPatriarch(workbook, sheet, cell, errorMsg.append(String.format("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728(\u5f53\u524d\u503c\u4e3a[%s])", VerifyExcelUtil.getCellValue(cell))).toString());
        }
        if (ToolUtil.isNotEmpty((Object)(organTranslate = fieldControl.getOrganTranslate())) && ToolUtil.isEmpty((Object)fieldValue) && ToolUtil.isNotEmpty((Object)VerifyExcelUtil.getCellValue(cell))) {
            if (ToolUtil.isNotEmpty((Object)errorMsg.toString())) {
                errorMsg.append(System.lineSeparator());
            }
            flag = true;
            VerifyExcelUtil.drawingPatriarch(workbook, sheet, cell, errorMsg.append(String.format("\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u4e0d\u5b58\u5728(\u5f53\u524d\u503c\u4e3a[%s])", VerifyExcelUtil.getCellValue(cell))).toString());
        }
        if (ToolUtil.isNotEmpty((Object)fieldControl.getDictType()) && ToolUtil.isNotEmpty((Object)VerifyExcelUtil.getCellValue(cell)) && ToolUtil.isEmpty((Object)fieldValue)) {
            if (ToolUtil.isNotEmpty((Object)errorMsg.toString())) {
                errorMsg.append(System.lineSeparator());
            }
            flag = true;
            VerifyExcelUtil.drawingPatriarch(workbook, sheet, cell, errorMsg.append(String.format("[%s]\u7684\u503c\u4e0d\u5b58\u5728\u5bf9\u5e94\u5b57\u5178\u503c(\u5f53\u524d\u503c\u4e3a[%s])", excelPropName, VerifyExcelUtil.getCellValue(cell))).toString());
        }
        if (ToolUtil.isNotEmpty((Object)fieldControl.getAssociateTable()) && ToolUtil.isEmpty((Object)fieldValue) && ToolUtil.isNotEmpty((Object)VerifyExcelUtil.getCellValue(cell))) {
            if (ToolUtil.isNotEmpty((Object)errorMsg.toString())) {
                errorMsg.append(System.lineSeparator());
            }
            flag = true;
            VerifyExcelUtil.drawingPatriarch(workbook, sheet, cell, errorMsg.append(String.format("[%s]\u7684\u503c\u4e0d\u5b58\u5728\u5bf9\u5e94\u5173\u8054\u8868\u503c(\u5f53\u524d\u503c\u4e3a[%s])", excelPropName, VerifyExcelUtil.getCellValue(cell))).toString());
        }
        if (HussarUtils.equals((Object)fieldControl.getUnique(), (Object)"true") && VerifyExcelUtil.validateColumnUnique(cell, startRow, errorMsg, excelPropName)) {
            flag = true;
        }
        return flag;
    }

    public static boolean validateColumnUnique(Cell cell, int startRow, StringBuilder errorMsg, String excelPropName) {
        HashMap<String, Integer> uniqueValues = new HashMap<String, Integer>();
        boolean hasDuplicates = false;
        Sheet sheet = cell.getSheet();
        Workbook workbook = sheet.getWorkbook();
        int columnIdx = cell.getColumnIndex();
        String uniqueValue = "";
        for (int i = startRow; i <= cell.getRowIndex(); ++i) {
            Cell rowCell;
            String cellValue;
            Row row = sheet.getRow(i);
            if (row == null || (cellValue = VerifyExcelUtil.getCellValue(rowCell = row.getCell(columnIdx))).isEmpty()) continue;
            if (!uniqueValues.containsKey(cellValue)) {
                uniqueValues.put(cellValue, i + 1);
                continue;
            }
            if (!uniqueValues.containsKey(VerifyExcelUtil.getCellValue(cell))) continue;
            hasDuplicates = true;
            uniqueValue = cellValue;
            break;
        }
        if (hasDuplicates) {
            if (ToolUtil.isNotEmpty((Object)errorMsg.toString())) {
                errorMsg.append(System.lineSeparator());
            }
            VerifyExcelUtil.drawingPatriarch(workbook, sheet, cell, errorMsg.append(String.format("[%s]\u7684\u503c\u4e0d\u80fd\u91cd\u590d(\u5f53\u524d\u503c\u4e3a[%s]\u4e0e\u7b2c[%s]\u884c\u91cd\u590d)", excelPropName, VerifyExcelUtil.getCellValue(cell), uniqueValues.get(uniqueValue))).toString());
        }
        return hasDuplicates;
    }

    public static Class<?> getEntityClass(Class<?> serviceClass) {
        Type genericSuperclass = serviceClass.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length >= 2) {
                return (Class)actualTypeArguments[1];
            }
        } else {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            Type extendsType = ((Class)genericSuperclass).getGenericSuperclass();
            if (extendsType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)extendsType).getActualTypeArguments()).length >= 2) {
                return (Class)actualTypeArguments[1];
            }
        }
        throw new IllegalArgumentException(TranslateUtil.getTranslateName((String)TemplateEnum.THE_ENTITY_CLASS_OF_THE_SERVICE_CANNOT_BE_PARSED.getMessage()));
    }

    public static void autoAdjustAllColumnWidth(Sheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        for (int col = 0; col <= sheet.getRow(0).getLastCellNum(); ++col) {
            int maxLength = 0;
            for (int row = 0; row <= lastRowNum; ++row) {
                int length;
                Cell cell;
                Row currentRow = sheet.getRow(row);
                if (currentRow == null || (cell = currentRow.getCell(col)) == null) continue;
                String cellValue = VerifyExcelUtil.getCellValue(cell);
                int n = length = cellValue == null ? 0 : cellValue.getBytes().length;
                if (length <= maxLength) continue;
                maxLength = length;
            }
            int width = maxLength * 256 + 512;
            sheet.setColumnWidth(col, Math.min(width, 14080));
        }
    }

    public static boolean isCellTypeMatch(Cell cell, Class<?> targetType) {
        if (cell == null) {
            return false;
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case STRING: {
                return targetType == String.class;
            }
            case NUMERIC: {
                return targetType == Integer.class || targetType == Long.class || targetType == Double.class || targetType == LocalDateTime.class;
            }
            case BOOLEAN: {
                return targetType == Boolean.class;
            }
        }
        return false;
    }

    public static List<FieldControl> flattenFieldControls(List<FieldControl> fieldControlList) {
        ArrayList<FieldControl> fieldControlArrayList = new ArrayList<FieldControl>();
        for (FieldControl fieldControl : fieldControlList) {
            if (!fieldControl.getChildren().isEmpty()) {
                List<FieldControl> subFieldControls = fieldControl.getChildren();
                String propType = fieldControl.getPropType();
                for (FieldControl subFieldControl : subFieldControls) {
                    StringBuilder subProp = new StringBuilder();
                    if ("collection".equals(propType)) {
                        subProp.append(fieldControl.getProp());
                        subProp.append(".");
                    }
                    subProp.append(subFieldControl.getProp());
                    StringBuilder subPropName = new StringBuilder();
                    if ("collection".equals(propType)) {
                        subPropName.append(fieldControl.getPropName());
                        subPropName.append(".");
                    }
                    subPropName.append(subFieldControl.getPropName());
                    if (!"true".equals(subFieldControl.getImportField())) continue;
                    subFieldControl.setProp(subProp.toString());
                    subFieldControl.setPropName(subPropName.toString());
                    fieldControlArrayList.add(subFieldControl);
                }
                continue;
            }
            fieldControlArrayList.add(fieldControl);
        }
        return fieldControlArrayList;
    }

    private static <T, S> void processTransAnnotation(Cell cell, Field field, T importData, List<OrganizationBo> organizationBos, List<UserStaffVo> userStaffVos, List<FieldControl> fieldControlArrayList, List<DictVo> dictVos, Map<String, List<S>> modelDataMap) {
        String prop = VerifyExcelUtil.getCellValue(cell);
        Trans trans = field.getAnnotation(Trans.class);
        String[] refs = trans.refs();
        String ref = trans.ref();
        String namespace = trans.namespace();
        String key = trans.key();
        String[] queryFields = trans.queryFields();
        if ("TranslateDict".equals(namespace) && ToolUtil.isNotEmpty((Object)key)) {
            HussarUtils.setProperty(importData, (String)ref.split("#")[0], (Object)prop);
            ArrayList singleList = new ArrayList();
            dictVos.stream().filter(dicVo -> key.equals(dicVo.getTypeName())).forEach(dicVo -> singleList.addAll(dicVo.getSingleList()));
            Optional<DicSingle> value = singleList.stream().filter(dicSingle -> dicSingle.getLabel().equals(prop)).findFirst();
            value.ifPresent(dicSingle -> HussarUtils.setProperty((Object)importData, (String)field.getName(), (Object)dicSingle.getValue()));
        }
        for (String refStr : refs) {
            for (FieldControl fieldControl : fieldControlArrayList) {
                if (!fieldControl.getProp().equals(field.getName()) && (!fieldControl.getProp().contains(".") || !field.getName().equals(fieldControl.getProp().split("\\.")[1]))) continue;
                String finalTransProp = refStr.split("#")[1];
                if ("TranslateOrganization".equals(namespace)) {
                    if (!HussarUtils.equals((Object)finalTransProp, (Object)fieldControl.getOrganTranslate())) continue;
                    HussarUtils.setProperty(importData, (String)refStr.split("#")[0], (Object)VerifyExcelUtil.getCellValue(cell));
                    Optional<Long> organId = organizationBos.stream().filter(item -> VerifyExcelUtil.getCellValue(cell).equals(HussarUtils.getProperty((Object)item, (String)finalTransProp))).map(OrganizationBo::getId).findFirst();
                    organId.ifPresent(aLong -> HussarUtils.setProperty((Object)importData, (String)field.getName(), (Object)aLong));
                    continue;
                }
                if ("TranslateUser".equals(namespace)) {
                    if (!HussarUtils.equals((Object)finalTransProp, (Object)fieldControl.getUserTranslate())) continue;
                    HussarUtils.setProperty(importData, (String)refStr.split("#")[0], (Object)VerifyExcelUtil.getCellValue(cell));
                    Optional<Long> userId = userStaffVos.stream().filter(item -> VerifyExcelUtil.getCellValue(cell).equals(HussarUtils.getProperty((Object)item, (String)finalTransProp))).map(UserStaffVo::getUserId).findFirst();
                    userId.ifPresent(aLong -> HussarUtils.setProperty((Object)importData, (String)field.getName(), (Object)aLong));
                    continue;
                }
                if (!HussarUtils.equals((Object)finalTransProp, (Object)fieldControl.getAssociateTableProp())) continue;
                HussarUtils.setProperty(importData, (String)refStr.split("#")[0], (Object)VerifyExcelUtil.getCellValue(cell));
                List<S> transData = modelDataMap.get(namespace);
                if (!ToolUtil.isNotEmpty(transData)) continue;
                for (S s : transData) {
                    if (!VerifyExcelUtil.getCellValue(cell).equals(HussarUtils.getProperty(s, (String)finalTransProp))) continue;
                    HussarUtils.setProperty(importData, (String)field.getName(), (Object)HussarUtils.getProperty(s, (String)queryFields[0]));
                }
            }
        }
    }

    public static <T, S> void mapCellToField(Field[] fields, Sheet sheet, int rowIndex, int columnIndex, List<OrganizationBo> organizationBos, List<UserStaffVo> userStaffVos, T importData, List<FieldControl> fieldControlArrayList, List<DictVo> dictVos, Map<String, List<S>> modelDataMap) {
        Row headRow = sheet.getRow(sheet.getFirstRowNum());
        Row eachRow = sheet.getRow(rowIndex);
        for (Field field : fields) {
            Cell cell = eachRow.getCell(columnIndex);
            Cell headCell = headRow.getCell(columnIndex);
            if (!VerifyExcelUtil.getCellValue(headCell).equals(field.getName()) || "serialVersionUID".equals(field.getName())) continue;
            if (field.isAnnotationPresent(Trans.class)) {
                VerifyExcelUtil.processTransAnnotation(cell, field, importData, organizationBos, userStaffVos, fieldControlArrayList, dictVos, modelDataMap);
                continue;
            }
            if (!VerifyExcelUtil.isCellTypeMatch(cell, field.getType())) continue;
            HussarUtils.setProperty(importData, (String)field.getName(), (Object)VerifyExcelUtil.getCellValue(cell, field.getType()));
        }
    }

    private static <T, S> int mapSubTableData(Field[] fields, Sheet sheet, int rowIndex, Map<String, Integer> headerMap, List<OrganizationBo> organizationBos, List<UserStaffVo> userStaffVos, Class<T> aClass, List<T> importDataList, List<FieldControl> fieldControlArrayList, List<DictVo> dictVos, Map<String, List<S>> modelDataMap) throws Exception {
        T importData = aClass.newInstance();
        boolean isDataRow = false;
        int maxSubLength = 1;
        Row headRow = sheet.getRow(sheet.getFirstRowNum());
        Row eachRow = sheet.getRow(rowIndex);
        for (Field field : fields) {
            Integer colIndex = headerMap.get(field.getName());
            if (colIndex != null && eachRow.getCell(colIndex.intValue()) != null) {
                VerifyExcelUtil.mapCellToSubField(field, eachRow, headRow, colIndex, importData, organizationBos, userStaffVos, fieldControlArrayList, dictVos, modelDataMap);
                isDataRow = true;
            }
            HashMap<String, Integer> subMap = new HashMap<String, Integer>();
            for (String key : headerMap.keySet()) {
                if (!key.contains(".")) continue;
                subMap.put(key.split("\\.")[0], headerMap.get(key));
            }
            Integer subIndex = (Integer)subMap.get(field.getName());
            if (!isDataRow || !ToolUtil.isNotEmpty((Object)subIndex) || !VerifyExcelUtil.getCellValue(headRow.getCell(subIndex.intValue())).contains(field.getName())) continue;
            List<?> subData = VerifyExcelUtil.readSubTable(sheet, VerifyExcelUtil.getGenericType(field), rowIndex, headerMap, organizationBos, userStaffVos, fieldControlArrayList, dictVos, modelDataMap);
            HussarUtils.setProperty(importData, (String)field.getName(), subData);
            if (subData.size() <= maxSubLength) continue;
            maxSubLength = subData.size();
        }
        if (isDataRow) {
            importDataList.add(importData);
        }
        HussarCacheUtil.put((String)"subLength", importData, (Object)maxSubLength);
        return maxSubLength;
    }

    private static <T, S> void mapCellToSubField(Field field, Row eachRow, Row headRow, int colIndex, T importData, List<OrganizationBo> organizationBos, List<UserStaffVo> userStaffVos, List<FieldControl> fieldControlArrayList, List<DictVo> dictVos, Map<String, List<S>> modelDataMap) {
        Cell cell = eachRow.getCell(colIndex);
        Cell headCell = headRow.getCell(colIndex);
        if (cell == null) {
            return;
        }
        if (VerifyExcelUtil.getCellValue(headCell).equals(field.getName()) && !"serialVersionUID".equals(field.getName())) {
            if (field.isAnnotationPresent(Trans.class)) {
                VerifyExcelUtil.processTransAnnotation(cell, field, importData, organizationBos, userStaffVos, fieldControlArrayList, dictVos, modelDataMap);
            } else if (VerifyExcelUtil.isCellTypeMatch(cell, field.getType())) {
                HussarUtils.setProperty(importData, (String)field.getName(), (Object)VerifyExcelUtil.getCellValue(cell, field.getType()));
            }
        }
    }

    private static byte[] readStreamFully(InputStream is) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try (InputStream inputStream = is;){
            int nRead;
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
        }
        catch (IOException e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.FAILED_STREAM_READING.getMessage()), (Throwable)e);
        }
        return buffer.toByteArray();
    }

    public static List<OrganizationBo> selectOrganizationBos(String propName, List<String> params) {
        if (!validOrganPropNames.contains(propName)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.INVALID_PROP_NAME.getMessage()));
        }
        return sysOrganService.selectOrganizationBos(params, propName);
    }

    public static List<UserStaffVo> getUsersAndStaffInfo(String propName, List<String> params) {
        if (!validUserPropNames.contains(propName)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.INVALID_PROP_NAME.getMessage()));
        }
        return sysUsersService.getUsersAndStaffInfo(params, propName);
    }

    static {
        validOrganPropNames.add("parentId");
        validOrganPropNames.add("organCode");
        validOrganPropNames.add("organName");
        validOrganPropNames.add("organType");
        validOrganPropNames.add("organTypeName");
        validOrganPropNames.add("parentOrganCode");
        validOrganPropNames.add("parentOrganName");
        validOrganPropNames.add("parentOrganType");
        validOrganPropNames.add("parentOrganTypeName");
        validOrganPropNames.add("organFname");
        validUserPropNames.add("userName");
        validUserPropNames.add("userAccount");
        validUserPropNames.add("sex");
        validUserPropNames.add("birthday");
        validUserPropNames.add("idcard");
        validUserPropNames.add("address");
        validUserPropNames.add("workId");
        validUserPropNames.add("workDate");
        validUserPropNames.add("graduateSchool");
        validUserPropNames.add("graduateDate");
    }
}

