/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.template.print.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.template.print.dao.mapping.SysTemplatePrintInfoMapper;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintInfo;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.template.print.service.impl.SysTemplatePrintInfoServiceImpl")
public class SysTemplatePrintInfoServiceImpl
extends HussarServiceImpl<SysTemplatePrintInfoMapper, SysTemplatePrintInfo>
implements ISysTemplatePrintInfoService {
    @Resource
    private SysTemplatePrintInfoMapper mapper;
    @Resource
    private OssService ossService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    private static final Logger logger = LoggerFactory.getLogger(SysTemplatePrintInfoServiceImpl.class);

    public void processTemplates(PublishTemplateDto dto) {
        List delTemplateIds = (List)dto.getParams().get("removed");
        List addTemplateInfo = (List)dto.getParams().get("added");
        Map templateDatas = dto.getTemplateDatas();
        this.deleteTemplates(delTemplateIds);
        this.addTemplates(addTemplateInfo, templateDatas);
    }

    public ApiResponse<List<Map<String, String>>> getTemplateInfoList(Map<String, String> params) {
        List tempList;
        ArrayList list = new ArrayList();
        String pageId = params.get("pageId");
        String scenceId = params.get("scenceId");
        if (HussarUtils.isNotEmpty((Object)pageId) && HussarUtils.isNotEmpty((Object)scenceId) && HussarUtils.isNotEmpty((Object)(tempList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTemplatePrintInfo::getPageId, (Object)pageId)).eq(SysTemplatePrintInfo::getScenceId, (Object)scenceId)).eq(SysTemplatePrintInfo::getTemplateSource, (Object)"0"))))) {
            SecurityUser currentUser = BaseSecurityUtil.getUser();
            if (currentUser == null) {
                logger.error("\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
                return ApiResponse.fail((String)"\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
            }
            String deptId = String.valueOf(currentUser.getDeptId());
            List roleList = currentUser.getRolesList().stream().map(String::valueOf).collect(Collectors.toList());
            String userId = currentUser.getId().toString();
            String postId = HussarUtils.isEmpty((Object)currentUser.getExtendUserMap("postId")) ? "" : currentUser.getExtendUserMap("postId").toString();
            Iterator iterator = tempList.iterator();
            String processKey = params.get("processKey");
            String processNode = params.get("processNode");
            while (iterator.hasNext()) {
                boolean isVisible = false;
                SysTemplatePrintInfo info = (SysTemplatePrintInfo)iterator.next();
                JSONObject content = JSONObject.parseObject((String)info.getContent());
                String visibleScope = info.getVisibleScope();
                if (HussarUtils.isNotEmpty((Object)visibleScope)) {
                    JSONObject json = JSONObject.parseObject((String)visibleScope);
                    String user = (String)json.get((Object)"user");
                    String role = (String)json.get((Object)"role");
                    String organ = (String)json.get((Object)"organ");
                    String post = (String)json.get((Object)"post");
                    if (HussarUtils.isNotEmpty((Object)user) && user.contains(userId)) {
                        isVisible = true;
                    }
                    if (!isVisible && HussarUtils.isNotEmpty((Object)organ) && HussarUtils.isNotEmpty((Object)deptId) && organ.contains(deptId)) {
                        isVisible = true;
                    }
                    if (!isVisible && HussarUtils.isNotEmpty((Object)post) && HussarUtils.isNotEmpty((Object)postId) && organ.contains(postId)) {
                        isVisible = true;
                    }
                    if (!isVisible && HussarUtils.isNotEmpty((Object)role)) {
                        if (!(roleList = roleList.stream().filter(role::contains).collect(Collectors.toList())).isEmpty()) {
                            isVisible = true;
                        }
                    }
                } else {
                    isVisible = true;
                }
                if (isVisible) {
                    String infoProcessKey = (String)content.get((Object)"processKey");
                    String infoProcessNodeId = (String)content.get((Object)"processNodeId");
                    if (HussarUtils.isNotEmpty((Object)infoProcessKey)) {
                        if (!infoProcessKey.equals(processKey)) {
                            isVisible = false;
                        } else if (infoProcessNodeId != null && (infoProcessNodeId.isEmpty() || HussarUtils.isEmpty((Object)processNode) || !infoProcessNodeId.contains(processNode))) {
                            isVisible = false;
                        }
                    }
                }
                if (!isVisible) {
                    iterator.remove();
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("templateId", info.getTemplateId().toString());
                map.put("templateFileName", (String)content.get((Object)"templateFileName"));
                map.put("templateType", (String)content.get((Object)"templateType"));
                list.add(map);
            }
        }
        return ApiResponse.success(list);
    }

    public ApiResponse<String> getFileId(Map<String, Object> params) {
        Long templateId = Long.valueOf(params.get("templateId").toString());
        if (HussarUtils.isEmpty((Object)templateId)) {
            logger.error("\u672a\u4f20\u9012\u6a21\u677f\u4fe1\u606f\uff01");
            return ApiResponse.fail((String)"\u672a\u4f20\u9012\u6a21\u677f\u4fe1\u606f\uff01");
        }
        Object formData = params.get("formData");
        if (HussarUtils.isEmpty((Object)formData)) {
            logger.error("\u672a\u4f20\u9012\u8868\u5355\u6570\u636e\uff01");
            return ApiResponse.fail((String)"\u672a\u4f20\u9012\u8868\u5355\u6570\u636e\uff01");
        }
        JSONObject dataMap = (JSONObject)JSONObject.toJSON((Object)formData);
        this.deal(dataMap);
        for (String key : dataMap.keySet()) {
            Object value = dataMap.get((Object)key);
            if (value == null) {
                dataMap.put(key, (Object)"");
                continue;
            }
            if (!(value instanceof List)) continue;
            ArrayList<JSONObject> newChildList = new ArrayList<JSONObject>();
            List childList = (List)value;
            for (Object childData : childList) {
                JSONObject childDataMap = (JSONObject)JSONObject.toJSON(childData);
                for (String childKey : childDataMap.keySet()) {
                    Object childValue = childDataMap.get((Object)childKey);
                    if (childValue != null) continue;
                    childDataMap.put(childKey, (Object)"");
                }
                newChildList.add(childDataMap);
            }
            dataMap.put(key, newChildList);
        }
        SysTemplatePrintInfo template = (SysTemplatePrintInfo)this.getById(templateId);
        if (HussarUtils.isEmpty((Object)template)) {
            logger.error("\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606f\uff01");
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606f\uff01");
        }
        JSONObject content = JSONObject.parseObject((String)template.getContent());
        Long fileId = content.getLong("fileId");
        byte[] bytes = (byte[])this.ossService.backgroundDownload(fileId).getData();
        File file = null;
        try {
            file = File.createTempFile("template", "." + template.getTemplateSource());
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!file.exists()) {
            logger.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return ApiResponse.fail((String)"\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        byte[] bytes1 = this.replaceFileContent(file, (Map<String, Object>)dataMap);
        String fileName = (String)content.get((Object)"templateFileName");
        try {
            String fileType = Files.probeContentType(file.toPath());
            ApiResponse result = this.ossService.backgroundUpload((MultipartFile)new HussarBaseMultipartFile(fileName, fileName, fileType, bytes1));
            ApiResponse apiResponse = ApiResponse.success((Object)((Long)result.getData()).toString(), (String)"");
            return apiResponse;
        }
        catch (IOException e) {
            logger.error("\u9884\u89c8\u6587\u4ef6\u5b58\u50a8\u5931\u8d25\uff01", (Throwable)e);
            throw new HussarException("\u9884\u89c8\u6587\u4ef6\u5b58\u50a8\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            file.delete();
        }
    }

    public void deleteTemplates(Map<String, Object> params) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Object pageIds = params.get("pageIds");
        Object appIds = params.get("appIds");
        Object scenceIds = params.get("scenceIds");
        if (HussarUtils.isNotEmpty((Object)pageIds)) {
            ((LambdaQueryWrapper)queryWrapper.or()).in(SysTemplatePrintInfo::getPageId, Arrays.asList(pageIds.toString().split(",")));
        }
        if (HussarUtils.isNotEmpty((Object)appIds)) {
            ((LambdaQueryWrapper)queryWrapper.or()).in(SysTemplatePrintInfo::getAppId, (Collection)Arrays.stream(appIds.toString().split(",")).map(Long::valueOf).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty((Object)scenceIds)) {
            ((LambdaQueryWrapper)queryWrapper.or()).in(SysTemplatePrintInfo::getScenceId, Arrays.asList(scenceIds.toString().split(",")));
        }
        List<Long> templateIds = this.list((Wrapper)queryWrapper).stream().map(SysTemplatePrintInfo::getTemplateId).collect(Collectors.toList());
        this.deleteTemplates(templateIds);
    }

    public List<SysTemplatePrintInfo> getTemplateListByPageId(String pageId) {
        return this.list((Wrapper)new LambdaQueryWrapper().eq(SysTemplatePrintInfo::getPageId, (Object)pageId));
    }

    private void deleteTemplates(List<Long> delTemplateIds) {
        if (HussarUtils.isEmpty(delTemplateIds)) {
            return;
        }
        List list = this.listByIds(delTemplateIds);
        List fileIds = list.stream().map(info -> JSONObject.parseObject((String)info.getContent()).getLong("fileId")).collect(Collectors.toList());
        List fileList = this.attachmentManagerService.listByIds(fileIds);
        fileList.forEach(fileInfo -> {
            String filePath = fileInfo.getAttachmentDir() + fileInfo.getId() + "." + fileInfo.getAttachmentType();
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        });
        this.attachmentManagerService.removeByIds(fileIds);
        this.removeByIds(delTemplateIds);
    }

    private void addTemplates(List<Map<String, Object>> addTemplates, Map<String, byte[]> templateDatas) {
        if (HussarUtils.isEmpty(addTemplates)) {
            return;
        }
        ArrayList<SysTemplatePrintInfo> list = new ArrayList<SysTemplatePrintInfo>();
        for (Map<String, Object> template : addTemplates) {
            Long id = Long.parseLong(template.get("templateId").toString());
            String absolute = (String)template.get("absolute");
            String fileName = (String)template.get("fileName");
            byte[] bytes = templateDatas.get(absolute);
            if (!HussarUtils.isNotEmpty((Object)bytes)) continue;
            ApiResponse result = this.ossService.backgroundUpload((MultipartFile)new HussarBaseMultipartFile(fileName, fileName, ".docx", bytes));
            Long fileId = (Long)result.getData();
            SysTemplatePrintInfo entity = new SysTemplatePrintInfo();
            entity.setTemplateId(id);
            entity.setVisibleScope((String)template.get("visibleScope"));
            entity.setPageId((String)template.get("pageId"));
            entity.setScenceId((String)template.get("scenceId"));
            entity.setAppId(template.get("appId") == null ? null : Long.valueOf(Long.parseLong(template.get("appId").toString())));
            entity.setTemplateSource("0");
            JSONObject content = new JSONObject();
            content.put("fileId", (Object)fileId);
            content.put("templateName", template.get("templateName"));
            content.put("templateFileName", (Object)fileName);
            content.put("templateType", template.get("templateType"));
            content.put("templateScence", template.get("templateScence"));
            content.put("templateStatus", template.get("templateStatus"));
            content.put("modelId", template.get("modelId"));
            content.put("processKey", template.get("processKey"));
            content.put("processNodeId", template.get("processNodeId"));
            entity.setContent(content.toJSONString());
            list.add(entity);
        }
        this.saveOrUpdateBatch(list);
    }

    private void getResourcePath(String prefixPath) {
        try {
            boolean flag;
            File dir = new File(prefixPath);
            if (!dir.exists() && !(flag = dir.mkdirs())) {
                throw new IOException("\u521b\u5efa\u6253\u5370\u6a21\u677f\u6587\u4ef6\u5939\u5931\u8d25\uff01");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] replaceFileContent(File file, Map<String, Object> dataMap) {
        try {
            FileInputStream fis = new FileInputStream(file);
            XWPFDocument doc = new XWPFDocument((InputStream)fis);
            HashMap<String, Object> replaceMap = new HashMap<String, Object>();
            this.getReplacerMap(doc, replaceMap, dataMap);
            for (XWPFParagraph paragraph : doc.getParagraphs()) {
                this.replaceTemplate(paragraph, replaceMap);
            }
            for (XWPFTable table : doc.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            this.replaceTemplate(paragraph, replaceMap);
                        }
                    }
                }
            }
            replaceMap.keySet().removeIf(key -> !key.contains(".") || !key.contains("#" + replaceMap.get(key).toString()));
            this.replaceChildValueInTable(doc, replaceMap, dataMap);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            doc.write((OutputStream)out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void getReplacerMap(XWPFDocument doc, Map<String, Object> replaceMap, Map<String, Object> dataMap) {
        String httpArea = "\\$\\{(.*http.*).*?\\}";
        for (String key : dataMap.keySet()) {
            String dataArea = "\\$\\{[^{}]*" + Pattern.quote("#" + key) + "(?![^{}]http)[^{}]*\\}";
            for (XWPFParagraph paragraph : doc.getParagraphs()) {
                this.addReplaceMap(replaceMap, paragraph, dataArea);
                this.addReplaceMap(replaceMap, paragraph, httpArea);
            }
            for (XWPFTable table : doc.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            this.addReplaceMap(replaceMap, paragraph, dataArea);
                            this.addReplaceMap(replaceMap, paragraph, httpArea);
                        }
                    }
                }
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        String area = "<(.*?)#(.*?)>";
        for (String placeholder : replaceMap.keySet()) {
            Object address = "";
            String[] other = null;
            if (placeholder.contains("http")) {
                int index = placeholder.indexOf("http");
                address = placeholder.substring(index, placeholder.indexOf(")|", index));
                other = placeholder.split((String)address);
                Matcher matcher = Pattern.compile(area).matcher(placeholder);
                while (matcher.find()) {
                    String filed = matcher.group();
                    if (list.contains(filed)) continue;
                    list.add(filed);
                }
            }
            if (list.isEmpty()) continue;
            block10: for (String string : list) {
                if (string.contains("#") && string.indexOf(".", string.indexOf("#")) != -1) {
                    address = ((String)address).replaceAll(string, "");
                    replaceMap.put(placeholder, other[0] + (String)address + other[1]);
                    continue;
                }
                for (String s : dataMap.keySet()) {
                    if (!string.contains(s)) continue;
                    address = ((String)address).replaceAll(string, HussarUtils.isEmpty((Object)dataMap.get(s)) ? "" : dataMap.get(s).toString());
                    replaceMap.put(placeholder, other[0] + (String)address + other[1]);
                    continue block10;
                }
            }
            list.clear();
        }
        block12: for (String placeholder : replaceMap.keySet()) {
            for (String key : dataMap.keySet()) {
                if (!placeholder.contains("#" + key)) continue;
                Object data = dataMap.get(key);
                if (placeholder.contains(".") && "ms".equals(replaceMap.get(placeholder))) {
                    int n = placeholder.indexOf("#") + 1;
                    String tableName = placeholder.substring(n, placeholder.indexOf(".", n));
                    replaceMap.put(placeholder, tableName);
                    continue block12;
                }
                if (placeholder.contains("http")) continue;
                if (data instanceof LinkedHashMap) {
                    data = this.formatDate((LinkedHashMap)data, placeholder);
                }
                replaceMap.put(placeholder, data);
                continue block12;
            }
        }
        for (String placeholder : replaceMap.keySet()) {
            try {
                ByteArrayOutputStream byteArrayOutputStream;
                HashMap<EncodeHintType, Object> hints;
                String data = replaceMap.get(placeholder) + "";
                if (placeholder.contains("qrcode") && !placeholder.contains("#" + data)) {
                    QRCodeWriter qrCodeWriter = new QRCodeWriter();
                    hints = new HashMap<EncodeHintType, Object>();
                    hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                    hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                    BitMatrix bitMatrix = qrCodeWriter.encode(data, BarcodeFormat.QR_CODE, 300, 300, hints);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayOutputStream);
                    replaceMap.put(placeholder, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    continue;
                }
                if (placeholder.contains("barcode") && !placeholder.contains("#" + data)) {
                    if (data.matches(".*[\\u4e00-\\u9fa5].*")) {
                        data = "error!";
                    }
                    Code128Writer barcodeWriter = new Code128Writer();
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 1);
                    BitMatrix bitMatrix = barcodeWriter.encode(data, BarcodeFormat.CODE_128, 300, 120, hints);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayOutputStream);
                    replaceMap.put(placeholder, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    continue;
                }
                Object objData = replaceMap.get(placeholder);
                if (objData instanceof LinkedHashMap) {
                    data = this.formatDate((LinkedHashMap)objData, placeholder);
                }
                replaceMap.put(placeholder, data);
            }
            catch (WriterException | IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String formatDate(LinkedHashMap<String, Object> date, String placeholder) {
        if (!date.containsKey("year")) {
            return "";
        }
        String str = "|format(";
        Integer month = (int)((Integer)date.get("monthValue"));
        Integer day = (int)((Integer)date.get("dayOfMonth"));
        Integer year = (int)((Integer)date.get("year"));
        Integer hour = (int)((Integer)date.get("hour"));
        Integer minute = (int)((Integer)date.get("minute"));
        Integer second = (int)((Integer)date.get("second"));
        if (placeholder.contains(str)) {
            int index = placeholder.indexOf(str);
            String format = placeholder.substring(index + 1, placeholder.indexOf(")", index)).trim();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            return LocalDateTime.of((int)year, month, (int)day, (int)hour, (int)minute, (int)second).format(formatter);
        }
        return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
    }

    private void addReplaceMap(Map<String, Object> replaceMap, XWPFParagraph paragraph, String area) {
        boolean flag = false;
        Matcher matcher = Pattern.compile(area).matcher(paragraph.getText());
        while (matcher.find()) {
            String placeholder = matcher.group();
            if (HussarUtils.isNotEmpty(replaceMap)) {
                for (String replaceKey : replaceMap.keySet()) {
                    if (!replaceKey.equals(placeholder)) continue;
                    flag = true;
                    break;
                }
            }
            if (flag) {
                flag = false;
                continue;
            }
            if (!placeholder.contains(".") || placeholder.contains("<") && placeholder.contains(">")) {
                replaceMap.put(placeholder, null);
                continue;
            }
            replaceMap.put(placeholder, "ms");
        }
    }

    private void replaceTemplate(XWPFParagraph paragraph, Map<String, Object> replaceMap) {
        if (HussarUtils.isNotEmpty(replaceMap)) {
            Iterator iterator = paragraph.getRuns().iterator();
            XWPFRun tempRun = null;
            String placeholder = null;
            int type = 0;
            while (iterator.hasNext()) {
                XWPFRun run = (XWPFRun)iterator.next();
                String text = run.getText(0);
                if (HussarUtils.isNotEmpty((Object)text) && text.contains("$")) {
                    tempRun = null;
                    placeholder = null;
                    type = 1;
                    int start = text.indexOf("$");
                    if (start != text.length() - 1 && text.charAt(start + 1) == '{') {
                        type = 2;
                        if (text.substring(start).contains("}")) {
                            type = 0;
                            placeholder = text.substring(start, text.indexOf("}", start) + 1);
                            if (placeholder.contains(".")) continue;
                            this.replacePlaceholder(replaceMap, placeholder, paragraph, run);
                            continue;
                        }
                        tempRun = run;
                        continue;
                    }
                    if (start != text.length() - 1) continue;
                    tempRun = run;
                    continue;
                }
                if (!HussarUtils.isNotEmpty(tempRun)) continue;
                if (type == 1 && text.charAt(0) != '{') {
                    type = 0;
                    tempRun = null;
                    placeholder = null;
                    continue;
                }
                if (type == 1 && text.charAt(0) == '{') {
                    type = 2;
                    if (text.contains("}")) {
                        String str = tempRun.getText(0);
                        tempRun.setText(str.substring(0, str.length() - 1), 0);
                        placeholder = text.substring(0, text.indexOf("}") + 1);
                        run.setText("$" + text, 0);
                        if (placeholder.contains(".")) continue;
                        this.replacePlaceholder(replaceMap, placeholder, paragraph, run);
                        continue;
                    }
                    String str = tempRun.getText(0);
                    tempRun.setText(str.substring(0, str.length() - 1), 0);
                    run.setText("$" + text, 0);
                    tempRun = run;
                    continue;
                }
                if (type != 2) continue;
                if (text.contains("}")) {
                    int index = text.indexOf("}");
                    if (text.contains("$") || text.contains("{")) {
                        int index2;
                        int index1 = text.indexOf("$");
                        if (index1 * (index2 = text.indexOf("{")) >= 0) {
                            if (index1 + 1 == index2 && index2 < index) {
                                placeholder = text.substring(index1, index + 1);
                                if (placeholder.contains(".")) continue;
                                this.replacePlaceholder(replaceMap, placeholder, paragraph, run);
                                continue;
                            }
                            if (index1 + 1 == index2 && index1 > index) {
                                tempRun.setText(tempRun.getText(0) + text.substring(0, index1 + 1), 0);
                                run.setText(text.substring(index1 + 1), 0);
                                placeholder = text.substring(0, index + 1);
                                if (!placeholder.contains(".")) {
                                    this.replacePlaceholder(replaceMap, placeholder, paragraph, tempRun);
                                }
                                tempRun = run;
                                continue;
                            }
                            type = 0;
                            tempRun = null;
                            placeholder = null;
                            continue;
                        }
                        if (index1 == text.length() - 1) {
                            String str = tempRun.getText(0) + text.substring(0, index1);
                            tempRun.setText(str, 0);
                            placeholder = tempRun.getText(0).substring(0, str.indexOf("}"));
                            if (!placeholder.contains(".")) {
                                this.replacePlaceholder(replaceMap, placeholder, paragraph, tempRun);
                            }
                            run.setText("$", 0);
                            type = 1;
                            tempRun = run;
                            continue;
                        }
                        type = 0;
                        tempRun = null;
                        placeholder = null;
                        continue;
                    }
                    String str = tempRun.getText(0) + text;
                    tempRun.setText("", 0);
                    run.setText(str, 0);
                    placeholder = str.substring(0, str.indexOf("}") + 1);
                    if (!placeholder.contains(".") || placeholder.contains("<") && placeholder.contains(">")) {
                        this.replacePlaceholder(replaceMap, placeholder, paragraph, run);
                    }
                    type = 0;
                    tempRun = null;
                    placeholder = null;
                    continue;
                }
                String str = tempRun.getText(0);
                tempRun.setText("", 0);
                run.setText(str + text, 0);
                tempRun = run;
            }
        }
    }

    private void replacePlaceholder(Map<String, Object> replaceMap, String placeholder, XWPFParagraph paragraph, XWPFRun run) {
        String text = run.getText(0);
        for (String key : replaceMap.keySet()) {
            if (!placeholder.equals(key)) continue;
            if (replaceMap.get(key) instanceof InputStream) {
                try {
                    Double[] size;
                    if (text.equals(placeholder)) {
                        Double[] size2;
                        run.setText("", 0);
                        if (key.contains("qrcode")) {
                            size2 = this.getImgSize(placeholder, 1.0);
                            run.addPicture((InputStream)replaceMap.get(key), 6, "image", (int)(size2[0] * 36000.0), (int)(size2[1] * 36000.0));
                        }
                        if (!key.contains("barcode")) break;
                        size2 = this.getImgSize(placeholder, 1.5);
                        run.addPicture((InputStream)replaceMap.get(key), 6, "image", (int)(size2[0] * 36000.0), (int)(size2[1] * 36000.0));
                        break;
                    }
                    String[] splitText = text.split(Pattern.quote(placeholder));
                    run.setText(splitText[0], 0);
                    XWPFRun newRun = paragraph.insertNewRun(paragraph.getRuns().indexOf(run));
                    if (key.contains("qrcode")) {
                        size = this.getImgSize(placeholder, 1.0);
                        newRun.addPicture((InputStream)replaceMap.get(key), 6, "image", (int)(size[0] * 36000.0), (int)(size[1] * 36000.0));
                    }
                    if (key.contains("barcode")) {
                        size = this.getImgSize(placeholder, 1.5);
                        newRun.addPicture((InputStream)replaceMap.get(key), 6, "image", (int)(size[0] * 36000.0), (int)(size[1] * 36000.0));
                    }
                    if (splitText.length <= 1 || splitText[1].isEmpty()) break;
                    XWPFRun newTextRun = paragraph.insertNewRun(paragraph.getRuns().indexOf(run) + 1);
                    newTextRun.setText(splitText[1], 0);
                    newTextRun.setBold(run.isBold());
                    newTextRun.setItalic(run.isItalic());
                    newTextRun.setFontFamily(run.getFontFamily());
                    newTextRun.setFontSize(run.getFontSize());
                    newTextRun.setUnderline(run.getUnderline());
                    newTextRun.setColor(run.getColor());
                    newTextRun.setStrikeThrough(run.isStrikeThrough());
                    newTextRun.setDoubleStrikethrough(run.isDoubleStrikeThrough());
                    newTextRun.setSmallCaps(run.isSmallCaps());
                    newTextRun.setCharacterSpacing(run.getCharacterSpacing());
                    newTextRun.setKerning(run.getKerning());
                    break;
                }
                catch (IOException | InvalidFormatException e) {
                    throw new RuntimeException(e);
                }
            }
            run.setText(text.replaceAll(Pattern.quote(placeholder), replaceMap.get(placeholder).toString()), 0);
            break;
        }
    }

    private Double[] getImgSize(String placeholder, double ratio) {
        Double[] size = new Double[2];
        int delimiter1 = placeholder.indexOf("size=");
        int delimiter2 = placeholder.indexOf("*", delimiter1);
        int delimiter3 = placeholder.indexOf("}", delimiter2);
        String widthStr = placeholder.substring(delimiter1 + 5, delimiter2);
        String heightStr = placeholder.substring(delimiter2 + 1, delimiter3);
        double weight = Double.parseDouble(widthStr.split("_")[0]);
        double height = Double.parseDouble(heightStr.split("_")[0]);
        if (!widthStr.contains("fixed")) {
            size[1] = height;
            size[0] = heightStr.contains("fixed") ? Double.valueOf(height * ratio) : Double.valueOf(weight);
        } else {
            size[0] = weight;
            size[1] = heightStr.contains("fixed") ? Double.valueOf(height) : Double.valueOf(weight / ratio);
        }
        return size;
    }

    private void replaceChildValueInTable(XWPFDocument doc, Map<String, Object> replaceMap, Map<String, Object> dataMap) {
        if (HussarUtils.isEmpty(replaceMap)) {
            return;
        }
        HashMap<String, List> childValues = new HashMap<String, List>();
        HashMap<String, Integer> valueCountMap = new HashMap<String, Integer>();
        block2: for (String placeholder : replaceMap.keySet()) {
            String tableName = replaceMap.get(placeholder).toString();
            for (String key : dataMap.keySet()) {
                if (!key.equals(tableName)) continue;
                childValues.put(tableName, (List)dataMap.get(key));
                valueCountMap.put(tableName, ((List)childValues.get(tableName)).size());
                continue block2;
            }
        }
        List tables = doc.getTables();
        HashMap replaceRows = new HashMap();
        for (XWPFTable table : tables) {
            List tableRows = table.getRows();
            if (tableRows.isEmpty()) continue;
            LinkedList templateRowInfo = new LinkedList();
            for (XWPFTableRow xWPFTableRow : tableRows) {
                int maxRowCount = 0;
                block6: for (XWPFTableCell tableRowCell : xWPFTableRow.getTableCells()) {
                    String content = tableRowCell.getText();
                    for (String key : childValues.keySet()) {
                        if (!content.contains(key)) continue;
                        maxRowCount = Math.max(maxRowCount, (Integer)valueCountMap.get(key));
                        continue block6;
                    }
                }
                if (maxRowCount == 0) continue;
                int index = tableRows.indexOf(xWPFTableRow);
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("index", index);
                map.put("maxRowCount", maxRowCount);
                templateRowInfo.add(0, map);
            }
            for (Map map : templateRowInfo) {
                int index = (Integer)map.get("index");
                int maxRowCount = (Integer)map.get("maxRowCount");
                XWPFTableRow templateRow = (XWPFTableRow)tableRows.get(index);
                List tableCells = templateRow.getTableCells();
                for (int i = 1; i <= maxRowCount; ++i) {
                    XWPFTableRow newRow = table.insertNewTableRow(index + i);
                    for (XWPFTableCell tableCell : tableCells) {
                        CTVMerge vMerge;
                        XWPFTableCell newCell = newRow.createCell();
                        newCell.removeParagraph(0);
                        for (XWPFParagraph tableCellParagraph : tableCell.getParagraphs()) {
                            XWPFParagraph newParagraph = newCell.addParagraph();
                            for (XWPFRun tableCellParagraphRun : tableCellParagraph.getRuns()) {
                                XWPFRun newRun = newParagraph.createRun();
                                String content = tableCellParagraphRun.getText(0);
                                block13: for (String key : childValues.keySet()) {
                                    Matcher matcher;
                                    if (content.isEmpty() || !(matcher = Pattern.compile("\\$\\{.*" + key + ".*\\}").matcher(content)).find()) continue;
                                    String placeholder = matcher.group();
                                    Object formData = ((List)childValues.get(key)).get(i - 1);
                                    Map childFormData = (Map)new ObjectMapper().convertValue(formData, Map.class);
                                    if (childFormData != null) {
                                        for (String childKey : childFormData.keySet()) {
                                            if (!placeholder.contains(key + "." + childKey)) continue;
                                            String data = "";
                                            Object pending = childFormData.get(childKey);
                                            data = pending instanceof LinkedHashMap ? this.formatDate((LinkedHashMap)pending, placeholder) : content.replaceAll(Pattern.quote(placeholder), pending + "");
                                            String[] other = content.split(Pattern.quote(placeholder));
                                            try {
                                                Double[] size;
                                                ByteArrayOutputStream byteArrayOutputStream;
                                                BitMatrix bitMatrix;
                                                HashMap<EncodeHintType, Object> hints;
                                                if (placeholder.contains("qrcode")) {
                                                    QRCodeWriter qrCodeWriter = new QRCodeWriter();
                                                    hints = new HashMap<EncodeHintType, Object>();
                                                    hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                                                    bitMatrix = qrCodeWriter.encode(data, BarcodeFormat.QR_CODE, 300, 300, hints);
                                                    byteArrayOutputStream = new ByteArrayOutputStream();
                                                    MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayOutputStream);
                                                    newRun.setText("", 0);
                                                    size = this.getImgSize(placeholder, 1.0);
                                                    newRun.addPicture((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), 6, "image", (int)(size[0] * 36000.0), (int)(size[1] * 36000.0));
                                                    continue block13;
                                                }
                                                if (placeholder.contains("barcode")) {
                                                    if (placeholder.matches(".*[\\u4e00-\\u9fa5].*")) {
                                                        data = "The barcode does not support Chinese characters!";
                                                    }
                                                    Code128Writer barcodeWriter = new Code128Writer();
                                                    hints = new HashMap();
                                                    hints.put(EncodeHintType.MARGIN, 1);
                                                    bitMatrix = barcodeWriter.encode(data, BarcodeFormat.CODE_128, 300, 120, hints);
                                                    byteArrayOutputStream = new ByteArrayOutputStream();
                                                    MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayOutputStream);
                                                    newRun.setText("", 0);
                                                    size = this.getImgSize(placeholder, 1.5);
                                                    newRun.addPicture((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), 6, "image", (int)(size[0] * 36000.0), (int)(size[1] * 36000.0));
                                                    continue block13;
                                                }
                                                newRun.setText(data, 0);
                                                continue block13;
                                            }
                                            catch (WriterException | IOException | InvalidFormatException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                        continue;
                                    }
                                    newRun.setText(content.replaceAll(placeholder, ""));
                                }
                                newRun.setFontFamily(tableCellParagraphRun.getFontFamily());
                                int fontSize = tableCellParagraphRun.getFontSize();
                                if (fontSize != -1) {
                                    newRun.setFontSize(tableCellParagraphRun.getFontSize());
                                }
                                newRun.setBold(tableCellParagraphRun.isBold());
                                newRun.setItalic(tableCellParagraphRun.isItalic());
                                newRun.setUnderline(tableCellParagraphRun.getUnderline());
                                newRun.setColor(tableCellParagraphRun.getColor());
                            }
                            newParagraph.setAlignment(tableCellParagraph.getAlignment());
                            newParagraph.setBorderBottom(tableCellParagraph.getBorderBottom());
                            newParagraph.setBorderLeft(tableCellParagraph.getBorderLeft());
                            newParagraph.setBorderRight(tableCellParagraph.getBorderRight());
                            newParagraph.setBorderTop(tableCellParagraph.getBorderTop());
                            int firstLine = tableCellParagraph.getIndentationFirstLine();
                            int hanging = tableCellParagraph.getIndentationHanging();
                            int left = tableCellParagraph.getIndentationLeft();
                            int right = tableCellParagraph.getIndentationRight();
                            int after = tableCellParagraph.getSpacingAfter();
                            int before = tableCellParagraph.getSpacingBefore();
                            if (firstLine != -1) {
                                newParagraph.setIndentationFirstLine(firstLine);
                            }
                            if (hanging != -1) {
                                newParagraph.setIndentationHanging(hanging);
                            }
                            if (left != -1) {
                                newParagraph.setIndentationLeft(left);
                            }
                            if (right != -1) {
                                newParagraph.setIndentationRight(right);
                            }
                            if (after != -1) {
                                newParagraph.setSpacingAfter(after);
                            }
                            if (before != -1) {
                                newParagraph.setSpacingBefore(before);
                            }
                            newParagraph.setSpacingBetween(tableCellParagraph.getSpacingBetween());
                        }
                        CTTcPr sourceTcPr = tableCell.getCTTc().getTcPr();
                        if (sourceTcPr != null) {
                            newCell.getCTTc().setTcPr(sourceTcPr);
                        }
                        if ((vMerge = tableCell.getCTTc().getTcPr().getVMerge()) == null || vMerge.getVal() != STMerge.CONTINUE) continue;
                        newCell.getCTTc().getTcPr().setVMerge(tableCell.getCTTc().getTcPr().getVMerge());
                    }
                }
                table.removeRow(index);
            }
        }
    }

    private void deal(JSONObject dataMap) {
        String LOCAL_DATE_TIME_REGEX = "^\\d{4}-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(0[0-9]|1[0-9]|2[0-3]):([0-5][0-9])(:[0-5][0-9])?$";
        Pattern LOCAL_DATE_TIME_PATTERN = Pattern.compile(LOCAL_DATE_TIME_REGEX);
        for (String key : dataMap.keySet()) {
            String value = String.valueOf(dataMap.get((Object)key));
            if (!SysTemplatePrintInfoServiceImpl.isValidLocalDateTime(LOCAL_DATE_TIME_PATTERN, value)) continue;
            String processedValueStr = value.replace("T", " ");
            dataMap.put(key, (Object)processedValueStr);
        }
    }

    private static boolean isValidLocalDateTime(Pattern LOCAL_DATE_TIME_PATTERN, String dateTimeStr) {
        Matcher matcher = LOCAL_DATE_TIME_PATTERN.matcher(dateTimeStr);
        return matcher.matches();
    }
}

