/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.syncdata.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleSyncMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersSyncMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.syncdata.constants.SyncConstants;
import com.jxdinfo.hussar.syncdata.dao.SyncUserMapper;
import com.jxdinfo.hussar.syncdata.model.SyncUser;
import com.jxdinfo.hussar.syncdata.model.SyncUserRole;
import com.jxdinfo.hussar.syncdata.service.ISyncUserService;
import com.jxdinfo.hussar.syncdata.util.Md5Util;
import com.jxdinfo.hussar.syncdata.util.SyncUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncUserServiceImpl
extends ServiceImpl<SyncUserMapper, SyncUser>
implements ISyncUserService {
    @Resource
    private SyncUserMapper syncUserMapper;
    @Resource
    private SysUsersSyncMapper sysUsersSyncMapper;
    @Resource
    private SysUserRoleSyncMapper sysUserRoleSyncMapper;
    @Resource
    private HussarProperties hussarProperties;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;

    @Override
    @Transactional
    public Boolean syncUserData(List<SyncUser> syncUserList) {
        Object userId;
        boolean flag = true;
        ArrayList<SyncUser> userInsertList = new ArrayList<SyncUser>();
        ArrayList<SyncUser> userUpdateList = new ArrayList<SyncUser>();
        ArrayList<String> userDelList = new ArrayList<String>();
        List<SyncUser> localUserList = this.syncUserMapper.selectLocalList(SyncConstants.SYSTEM_DEFAULT_USER_IDS);
        HashMap<String, String> compareSyncMap = new HashMap<String, String>();
        HashMap<String, String> compareLocalMap = new HashMap<String, String>();
        Date date = new Date();
        for (SyncUser syncUser : syncUserList) {
            String compareHash = Md5Util.md5Hash(JSON.toJSONString((Object)((Object)syncUser)));
            compareSyncMap.put(syncUser.getUserId(), compareHash);
        }
        for (SyncUser syncUser : localUserList) {
            userId = syncUser.getUserId();
            if (compareSyncMap.get(userId) == null) {
                userDelList.add((String)userId);
            }
            compareLocalMap.put((String)userId, syncUser.getCompareHash());
        }
        for (SyncUser syncUser : syncUserList) {
            userId = syncUser.getUserId();
            String compareSyncHash = (String)compareSyncMap.get(userId);
            String compareLocalHash = (String)compareLocalMap.get(userId);
            if (compareLocalHash == null) {
                syncUser.setCompareHash(compareSyncHash);
                syncUser.setCreateTime(date);
                userInsertList.add(syncUser);
                continue;
            }
            if (compareSyncHash.equals(compareLocalHash)) continue;
            syncUser.setCompareHash(compareSyncHash);
            syncUser.setLastTime(date);
            userUpdateList.add(syncUser);
        }
        try {
            if (userInsertList.size() > 0) {
                List<String> repetitiveAccounts = this.sysUsersSyncMapper.selectRepetitiveAccount(userInsertList);
                if (repetitiveAccounts.size() > 0) {
                    if (repetitiveAccounts.size() < 100) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (String userAccount : repetitiveAccounts) {
                            stringBuilder.append(userAccount);
                            stringBuilder.append("\u3001");
                        }
                        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                        flag = false;
                        throw new RuntimeException(stringBuilder.toString() + "\u662f\u5df2\u5b58\u5728\u7684\u8d26\u53f7\uff01");
                    }
                    flag = false;
                    throw new RuntimeException("\u65b0\u589e\u6570\u636e\u5b58\u5728\u5df2\u6709\u7684\u8d26\u53f7\uff01");
                }
                int maxLimit = 10000;
                if (userInsertList.size() > maxLimit) {
                    for (int i = 0; i <= (userInsertList.size() - 1) / maxLimit; ++i) {
                        List<SyncUser> insertList = SyncUtil.getPartOfList(i, maxLimit, userInsertList);
                        this.syncUserMapper.insertSyncUserByList(insertList);
                        this.insertUser(insertList);
                    }
                } else {
                    this.syncUserMapper.insertSyncUserByList(userInsertList);
                    this.insertUser(userInsertList);
                }
            }
            if (userUpdateList.size() > 0) {
                int maxLimit = 10000;
                if (userUpdateList.size() > maxLimit) {
                    for (int i = 0; i <= (userUpdateList.size() - 1) / maxLimit; ++i) {
                        List<SyncUser> updateList = SyncUtil.getPartOfList(i, maxLimit, userUpdateList);
                        this.syncUserMapper.updateSyncUserByList(updateList);
                        this.updateUser(updateList);
                    }
                } else {
                    this.syncUserMapper.updateSyncUserByList(userUpdateList);
                    this.updateUser(userUpdateList);
                }
            }
            if (userDelList.size() > 0) {
                int maxLimit = 30000;
                if (userDelList.size() > maxLimit) {
                    for (int i = 0; i <= (userDelList.size() - 1) / maxLimit; ++i) {
                        List<String> deleteList = SyncUtil.getPartOfList(i, maxLimit, userDelList);
                        this.syncUserMapper.deleteSyncUserByList(deleteList);
                        this.deleteUser(deleteList);
                    }
                } else {
                    this.syncUserMapper.deleteSyncUserByList(userDelList);
                    this.deleteUser(userDelList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
            throw new RuntimeException("\u7528\u6237\u540c\u6b65\u5f02\u5e38\uff01");
        }
        return flag;
    }

    private void insertUser(List<SyncUser> syncUserList) throws Exception {
        ArrayList<SysUsers> usersList = new ArrayList<SysUsers>();
        ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
        for (SyncUser syncUser : syncUserList) {
            SysUsers sysUsers = this.fillUserInfo(syncUser, true);
            SysUserRole userRole = this.fillUserRoleInfo(syncUser);
            usersList.add(sysUsers);
            userRoleList.add(userRole);
        }
        this.sysUsersSyncMapper.insertUserByList(usersList);
        this.sysUserRoleSyncMapper.insertUserRoleByList(userRoleList);
    }

    private void updateUser(List<SyncUser> syncUserList) throws Exception {
        ArrayList<SysUsers> usersList = new ArrayList<SysUsers>();
        for (SyncUser syncUser : syncUserList) {
            SysUsers sysUsers = this.fillUserInfo(syncUser, false);
            usersList.add(sysUsers);
        }
        this.sysUsersSyncMapper.updateUserByList(usersList);
    }

    private void deleteUser(List<String> userIdList) throws Exception {
        this.sysUsersSyncMapper.deleteUserByList(userIdList);
        this.sysUserRoleSyncMapper.deleteUserPublicRole(userIdList, "public_role");
    }

    private SysUsers fillUserInfo(SyncUser syncUser, boolean isInsert) {
        SysUsers sysUsers = new SysUsers();
        Date date = new Date();
        sysUsers.setUserId(syncUser.getUserId());
        sysUsers.setUserName(ToolUtil.isEmpty((Object)syncUser.getUserName()) ? null : syncUser.getUserName());
        sysUsers.setIsCpublic(syncUser.getIsCpublic());
        sysUsers.setLockTime(ToolUtil.isEmpty((Object)syncUser.getLockTime()) ? null : Date.from(LocalDateTime.parse(syncUser.getLockTime(), this.dateTimeFormatter).atZone(ZoneId.systemDefault()).toInstant()));
        sysUsers.setStartTime(syncUser.getStartTime());
        sysUsers.setExpiredTime(syncUser.getExpiredTime());
        sysUsers.setPswdUptTime(ToolUtil.isEmpty((Object)syncUser.getPswdUptTime()) ? null : Date.from(LocalDateTime.parse(syncUser.getPswdUptTime(), this.dateTimeFormatter).atZone(ZoneId.systemDefault()).toInstant()));
        sysUsers.setPswdTime(ToolUtil.isEmpty((Object)syncUser.getPswdTime()) ? null : Date.from(LocalDateTime.parse(syncUser.getPswdTime(), this.dateTimeFormatter).atZone(ZoneId.systemDefault()).toInstant()));
        sysUsers.setCorporationId(syncUser.getCorporationId());
        sysUsers.setEmployeeId(syncUser.getEmployeeId());
        sysUsers.setEMail(syncUser.geteMail());
        sysUsers.setMobile(syncUser.getMobile());
        sysUsers.setWeChat(syncUser.getWechat());
        sysUsers.setTelephone(syncUser.getTelephone());
        sysUsers.setProvinceCode(syncUser.getProvinceCode());
        sysUsers.setPermissionStruId("");
        sysUsers.setAccessLoginStartTime(ToolUtil.isEmpty((Object)syncUser.getAccessLoginStartTime()) ? null : syncUser.getAccessLoginStartTime());
        sysUsers.setAccessLoginEndTime(ToolUtil.isEmpty((Object)syncUser.getAccessLoginEndTime()) ? null : syncUser.getAccessLoginEndTime());
        sysUsers.setDepartmentId(sysUsers.getCorporationId());
        sysUsers.setSecurityLevel(ToolUtil.isEmpty((Object)syncUser.getSecurityLevel()) ? SyncConstants.DEFAULT_SECURITY_LEVEL : syncUser.getSecurityLevel());
        sysUsers.setUserOrder(ToolUtil.isEmpty((Object)syncUser.getUserOrder()) ? SyncConstants.DEFAULT_ORDER : syncUser.getUserOrder());
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        if (isInsert) {
            sysUsers.setUserAccount(syncUser.getUserAccount());
            if (!this.hussarProperties.getLoginUpperOpen().booleanValue()) {
                sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
            }
            sysUsers.setPassword(this.credentialsMatcher.passwordEncode(syncUser.getPassword().getBytes()));
            sysUsers.setAccountStatus(ToolUtil.isEmpty((Object)syncUser.getAccountStatus()) ? "1" : syncUser.getAccountStatus());
            sysUsers.setTypeProperty(ToolUtil.isEmpty((Object)syncUser.getTypeProperty()) ? "1" : syncUser.getTypeProperty());
            sysUsers.setMaxSessions(ToolUtil.isEmpty((Object)syncUser.getMaxSessions()) ? SyncConstants.DEFAULT_MAX_SESSIONS : syncUser.getMaxSessions());
            sysUsers.setIsSys(ToolUtil.isEmpty((Object)syncUser.getIsSys()) ? "0" : syncUser.getIsSys());
            sysUsers.setLoginTimeLimit(ToolUtil.isEmpty((Object)syncUser.getLoginTimeLimit()) ? "0" : syncUser.getLoginTimeLimit());
            sysUsers.setLoginIpLimit(ToolUtil.isEmpty((Object)syncUser.getLoginIpLimit()) ? "0" : syncUser.getLoginIpLimit());
            sysUsers.setCreateTime(date);
        } else {
            sysUsers.setAccountStatus(syncUser.getAccountStatus());
            sysUsers.setTypeProperty(syncUser.getTypeProperty());
            sysUsers.setMaxSessions(syncUser.getMaxSessions());
            sysUsers.setIsSys(syncUser.getIsSys());
            sysUsers.setLoginTimeLimit(syncUser.getLoginTimeLimit());
            sysUsers.setLoginIpLimit(syncUser.getLoginIpLimit());
        }
        return sysUsers;
    }

    private SysUserRole fillUserRoleInfo(SyncUser syncUser) {
        SysUserRole sysUserRole = new SysUserRole();
        Date date = new Date();
        sysUserRole.setUserId(syncUser.getUserId());
        sysUserRole.setGrantedRole("public_role");
        sysUserRole.setAdminOption("1");
        sysUserRole.setCreateTime(date);
        sysUserRole.setLastTime(date);
        return sysUserRole;
    }

    @Override
    @Transactional
    public Boolean syncUserRoleData(List<SyncUserRole> syncUserRoleList) {
        boolean flag = true;
        ArrayList<SysUserRole> userRoleInsertList = new ArrayList<SysUserRole>();
        for (SyncUserRole syncUserRole : syncUserRoleList) {
            SysUserRole userRole = new SysUserRole();
            Date date = new Date();
            userRole.setUserId(syncUserRole.getUserId());
            userRole.setGrantedRole(syncUserRole.getRoleId());
            userRole.setAdminOption("1");
            userRole.setCreateTime(date);
            userRole.setLastTime(date);
            userRoleInsertList.add(userRole);
        }
        try {
            this.sysUserRoleSyncMapper.deleteLastUserRole("public_role", SyncConstants.SYSTEM_DEFAULT_USER_ROLE);
            if (userRoleInsertList.size() > 0) {
                int maxLimit = 30000;
                if (userRoleInsertList.size() > maxLimit) {
                    for (int i = 0; i <= (userRoleInsertList.size() - 1) / maxLimit; ++i) {
                        List<SysUserRole> insertList = SyncUtil.getPartOfList(i, maxLimit, userRoleInsertList);
                        this.sysUserRoleSyncMapper.insertUserRoleByList(insertList);
                    }
                } else {
                    this.sysUserRoleSyncMapper.insertUserRoleByList(userRoleInsertList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
            throw new RuntimeException("\u7528\u6237\u89d2\u8272\u5173\u8054\u540c\u6b65\u5f02\u5e38\uff01");
        }
        return flag;
    }
}

