/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.syncdata.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganSyncMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStaffSyncMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruSyncMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOrganSync;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruAssistOrganSyncMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.syncdata.constants.SyncConstants;
import com.jxdinfo.hussar.syncdata.dao.SyncStaffMapper;
import com.jxdinfo.hussar.syncdata.model.SyncStaff;
import com.jxdinfo.hussar.syncdata.model.SyncStaffOrgan;
import com.jxdinfo.hussar.syncdata.service.ISyncStaffService;
import com.jxdinfo.hussar.syncdata.util.Md5Util;
import com.jxdinfo.hussar.syncdata.util.SyncUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncStaffServiceImpl
extends ServiceImpl<SyncStaffMapper, SyncStaff>
implements ISyncStaffService {
    @Resource
    private SyncStaffMapper syncStaffMapper;
    @Resource
    private SysStruSyncMapper sysStruSyncMapper;
    @Resource
    private SysOrganSyncMapper sysOrganSyncMapper;
    @Resource
    private SysStaffSyncMapper sysStaffSyncMapper;
    @Resource
    private SysStruAssistOrganSyncMapper sysStruAssistOrganSyncMapper;

    @Override
    @Transactional
    public Boolean syncStaffData(List<SyncStaff> syncStaffList) {
        String employeeId;
        boolean flag = true;
        ArrayList<SyncStaff> staffInsertList = new ArrayList<SyncStaff>();
        ArrayList<SyncStaff> staffUpdateList = new ArrayList<SyncStaff>();
        ArrayList<String> staffDelList = new ArrayList<String>();
        List<SyncStaff> localOrganList = this.syncStaffMapper.selectLocalList("9");
        HashMap<String, String> compareSyncMap = new HashMap<String, String>();
        HashMap<String, String> compareLocalMap = new HashMap<String, String>();
        Date date = new Date();
        for (SyncStaff syncStaff : syncStaffList) {
            String compareHash = Md5Util.md5Hash(JSON.toJSONString((Object)syncStaff));
            compareSyncMap.put(syncStaff.getEmployeeId(), compareHash);
        }
        for (SyncStaff syncStaff : localOrganList) {
            employeeId = syncStaff.getEmployeeId();
            if (compareSyncMap.get(employeeId) == null) {
                staffDelList.add(employeeId);
            }
            compareLocalMap.put(employeeId, syncStaff.getCompareHash());
        }
        for (SyncStaff syncStaff : syncStaffList) {
            employeeId = syncStaff.getEmployeeId();
            String compareSyncHash = (String)compareSyncMap.get(employeeId);
            String compareLocalHash = (String)compareLocalMap.get(employeeId);
            if (compareLocalHash == null) {
                syncStaff.setCompareHash(compareSyncHash);
                syncStaff.setCreateTime(date);
                staffInsertList.add(syncStaff);
                continue;
            }
            if (compareSyncHash.equals(compareLocalHash)) continue;
            syncStaff.setCompareHash(compareSyncHash);
            syncStaff.setLastTime(date);
            staffUpdateList.add(syncStaff);
        }
        try {
            if (staffInsertList.size() > 0) {
                int maxLimit = 10000;
                if (staffInsertList.size() > maxLimit) {
                    for (int i = 0; i <= (staffInsertList.size() - 1) / maxLimit; ++i) {
                        List<SyncStaff> insertList = SyncUtil.getPartOfList(i, maxLimit, staffInsertList);
                        this.syncStaffMapper.insertSyncStaffByList(insertList);
                        this.insertStaff(insertList);
                    }
                } else {
                    this.syncStaffMapper.insertSyncStaffByList(staffInsertList);
                    this.insertStaff(staffInsertList);
                }
            }
            if (staffUpdateList.size() > 0) {
                int maxLimit = 10000;
                if (staffUpdateList.size() > maxLimit) {
                    for (int i = 0; i <= (staffUpdateList.size() - 1) / maxLimit; ++i) {
                        List<SyncStaff> updateList = SyncUtil.getPartOfList(i, maxLimit, staffUpdateList);
                        this.syncStaffMapper.updateSyncStaffByList(updateList);
                        this.updateStaff(updateList);
                    }
                } else {
                    this.syncStaffMapper.updateSyncStaffByList(staffUpdateList);
                    this.updateStaff(staffUpdateList);
                }
            }
            if (staffDelList.size() > 0) {
                int maxLimit = 30000;
                if (staffDelList.size() > maxLimit) {
                    for (int i = 0; i <= (staffDelList.size() - 1) / maxLimit; ++i) {
                        List<String> deleteList = SyncUtil.getPartOfList(i, maxLimit, staffDelList);
                        this.syncStaffMapper.deleteSyncStaffByList(deleteList);
                        this.deleteStaff(deleteList);
                    }
                } else {
                    this.syncStaffMapper.deleteSyncStaffByList(staffDelList);
                    this.deleteStaff(staffDelList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
            throw new RuntimeException("\u4eba\u5458\u540c\u6b65\u5f02\u5e38\uff01");
        }
        return flag;
    }

    private void insertStaff(List<SyncStaff> syncStaffList) throws Exception {
        ArrayList<SysOrganSync> organList = new ArrayList<SysOrganSync>();
        ArrayList<SysStru> struList = new ArrayList<SysStru>();
        ArrayList<SysStaff> staffList = new ArrayList<SysStaff>();
        for (SyncStaff syncStaff : syncStaffList) {
            SysOrganSync sysOrganSync = this.fillOrganInfo(syncStaff, true);
            SysStru sysStru = this.fillStruInfo(syncStaff, true);
            SysStaff sysStaff = this.fillStaffInfo(syncStaff);
            String organId = this.getUUID();
            sysOrganSync.setOrganId(organId);
            sysStru.setOrganId(organId);
            sysStaff.setStaffId(this.getUUID());
            if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
                sysStru.setOrganAlias(sysOrganSync.getOrganName());
            }
            organList.add(sysOrganSync);
            struList.add(sysStru);
            staffList.add(sysStaff);
        }
        this.sysStruSyncMapper.insertStruByList(struList);
        this.sysOrganSyncMapper.insertOrganByList(organList);
        this.sysStaffSyncMapper.insertStaffByList(staffList);
    }

    private void updateStaff(List<SyncStaff> syncStaffList) throws Exception {
        ArrayList<SysOrganSync> organList = new ArrayList<SysOrganSync>();
        ArrayList<SysStru> struList = new ArrayList<SysStru>();
        ArrayList<SysStaff> staffList = new ArrayList<SysStaff>();
        for (SyncStaff syncStaff : syncStaffList) {
            SysOrganSync sysOrganSync = this.fillOrganInfo(syncStaff, false);
            SysStru sysStru = this.fillStruInfo(syncStaff, false);
            SysStaff sysStaff = this.fillStaffInfo(syncStaff);
            if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
                sysStru.setOrganAlias(sysOrganSync.getOrganName());
            }
            sysOrganSync.setStruId(syncStaff.getEmployeeId());
            organList.add(sysOrganSync);
            struList.add(sysStru);
            staffList.add(sysStaff);
        }
        this.sysStruSyncMapper.updateStruByList(struList);
        this.sysOrganSyncMapper.updateOrganByList(organList);
        this.sysStaffSyncMapper.updateStaffByList(staffList);
    }

    private void deleteStaff(List<String> struIdList) throws Exception {
        List<String> organIdList = this.sysOrganSyncMapper.selectOrganIdsByStruIds(struIdList);
        List<String> staffIdList = this.sysStaffSyncMapper.selectStaffIdsByStruIds(struIdList);
        this.sysStruSyncMapper.deleteStruByList(struIdList);
        if (organIdList.size() > 0) {
            this.sysOrganSyncMapper.deleteOrganByList(organIdList);
        }
        if (staffIdList.size() > 0) {
            this.sysStaffSyncMapper.deleteStaffByList(staffIdList);
        }
    }

    private SysStru fillStruInfo(SyncStaff syncStaff, boolean isInsert) {
        SysStru sysStru = new SysStru();
        Date date = new Date();
        sysStru.setStruId(syncStaff.getEmployeeId());
        sysStru.setStruType("9");
        sysStru.setOrganAlias(syncStaff.getEmployeeName());
        sysStru.setParentId(syncStaff.getParentId());
        sysStru.setStruLevel(syncStaff.getStruLevel());
        sysStru.setStruPath(syncStaff.getStruPath());
        sysStru.setProvinceCode(syncStaff.getProvinceCode());
        sysStru.setIsEmployee("1");
        if (isInsert) {
            sysStru.setIsLeaf(ToolUtil.isEmpty((Object)syncStaff.getIsLeaf()) ? "0" : syncStaff.getIsLeaf());
            sysStru.setInUse(ToolUtil.isEmpty((Object)syncStaff.getInUse()) ? "1" : syncStaff.getInUse());
            sysStru.setStruOrder(ToolUtil.isEmpty((Object)syncStaff.getStruOrder()) ? SyncConstants.DEFAULT_ORDER : syncStaff.getStruOrder());
            sysStru.setGlobalOrder(ToolUtil.isEmpty((Object)syncStaff.getGlobalOrder()) ? SyncConstants.DEFAULT_ORDER : syncStaff.getGlobalOrder());
            sysStru.setCreateTime(date);
        } else {
            sysStru.setIsLeaf(syncStaff.getIsLeaf());
            sysStru.setInUse(syncStaff.getInUse());
            sysStru.setStruOrder(syncStaff.getStruOrder());
            sysStru.setGlobalOrder(syncStaff.getGlobalOrder());
            sysStru.setLastTime(date);
        }
        return sysStru;
    }

    private SysOrganSync fillOrganInfo(SyncStaff syncStaff, boolean isInsert) {
        SysOrganSync sysOrganSync = new SysOrganSync();
        Date date = new Date();
        sysOrganSync.setOrganName(syncStaff.getEmployeeName());
        sysOrganSync.setOrganType("9");
        if (isInsert) {
            sysOrganSync.setOrganCode(syncStaff.getEmployeeCode());
            sysOrganSync.setInUse(ToolUtil.isEmpty((Object)syncStaff.getInUse()) ? "1" : syncStaff.getInUse());
            sysOrganSync.setCreateTime(date);
        } else {
            sysOrganSync.setInUse(syncStaff.getInUse());
            sysOrganSync.setLastTime(date);
        }
        return sysOrganSync;
    }

    private SysStaff fillStaffInfo(SyncStaff syncStaff) {
        SysStaff sysStaff = new SysStaff();
        sysStaff.setStruId(syncStaff.getEmployeeId());
        sysStaff.setName(syncStaff.getEmployeeName());
        sysStaff.setSex(syncStaff.getSex());
        sysStaff.setBirthday(syncStaff.getBirthday());
        sysStaff.setIdcard(syncStaff.getIdcard());
        sysStaff.setAddress(syncStaff.getAddress());
        sysStaff.setWorkId(syncStaff.getWorkId());
        sysStaff.setWorkDate(syncStaff.getWorkDate());
        sysStaff.setGraduateDate(syncStaff.getGraduateDate());
        sysStaff.setGraduateSchool(syncStaff.getGraduateSchool());
        return sysStaff;
    }

    private String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    @Transactional
    public Boolean syncStaffOrganData(List<SyncStaffOrgan> syncStaffOrganList) {
        boolean flag = true;
        ArrayList<SysStruAssistOrgan> staffOrganInsertList = new ArrayList<SysStruAssistOrgan>();
        for (SyncStaffOrgan syncStaffOrgan : syncStaffOrganList) {
            SysStruAssistOrgan staffOrgan = new SysStruAssistOrgan();
            Date date = new Date();
            staffOrgan.setId(this.getUUID());
            staffOrgan.setStruId(syncStaffOrgan.getEmployeeId());
            staffOrgan.setAssistParentId(syncStaffOrgan.getOrganId());
            staffOrgan.setCreateTime(date);
            staffOrgan.setLastTime(date);
            staffOrganInsertList.add(staffOrgan);
        }
        try {
            this.sysStruAssistOrganSyncMapper.deleteStaffOrganByList();
            if (staffOrganInsertList.size() > 0) {
                int maxLimit = 30000;
                if (staffOrganInsertList.size() > maxLimit) {
                    for (int i = 0; i <= (staffOrganInsertList.size() - 1) / maxLimit; ++i) {
                        List<SysStruAssistOrgan> insertList = SyncUtil.getPartOfList(i, maxLimit, staffOrganInsertList);
                        this.sysStruAssistOrganSyncMapper.insertStaffOrganByList(insertList);
                    }
                } else {
                    this.sysStruAssistOrganSyncMapper.insertStaffOrganByList(staffOrganInsertList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
            throw new RuntimeException("\u4eba\u5458\u7ec4\u7ec7\u5173\u8054\u540c\u6b65\u5f02\u5e38\uff01");
        }
        return flag;
    }
}

