/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.syncdata.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.permit.dao.SysRolesSyncMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.syncdata.constants.SyncConstants;
import com.jxdinfo.hussar.syncdata.dao.SyncRoleMapper;
import com.jxdinfo.hussar.syncdata.model.SyncRole;
import com.jxdinfo.hussar.syncdata.service.ISyncRoleService;
import com.jxdinfo.hussar.syncdata.util.Md5Util;
import com.jxdinfo.hussar.syncdata.util.SyncUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncRoleServiceImpl
extends ServiceImpl<SyncRoleMapper, SyncRole>
implements ISyncRoleService {
    @Resource
    private SyncRoleMapper syncRoleMapper;
    @Resource
    private SysRolesSyncMapper sysRolesSyncMapper;

    @Override
    @Transactional
    public Boolean syncRoleData(List<SyncRole> syncRoleList) {
        String roleId;
        boolean flag = true;
        ArrayList<SyncRole> roleInsertList = new ArrayList<SyncRole>();
        ArrayList<SyncRole> roleUpdateList = new ArrayList<SyncRole>();
        ArrayList<String> roleDelList = new ArrayList<String>();
        List<SyncRole> localRoleList = this.syncRoleMapper.selectLocalList(SyncConstants.SYSTEM_DEFAULT_ROLE_IDS);
        HashMap<String, String> compareSyncMap = new HashMap<String, String>();
        HashMap<String, String> compareLocalMap = new HashMap<String, String>();
        Date date = new Date();
        for (SyncRole syncRole : syncRoleList) {
            String compareHash = Md5Util.md5Hash(JSON.toJSONString((Object)((Object)syncRole)));
            compareSyncMap.put(syncRole.getRoleId(), compareHash);
        }
        for (SyncRole syncRole : localRoleList) {
            roleId = syncRole.getRoleId();
            if (compareSyncMap.get(roleId) == null) {
                roleDelList.add(roleId);
            }
            compareLocalMap.put(roleId, syncRole.getCompareHash());
        }
        for (SyncRole syncRole : syncRoleList) {
            roleId = syncRole.getRoleId();
            String compareSyncHash = (String)compareSyncMap.get(roleId);
            String compareLocalHash = (String)compareLocalMap.get(roleId);
            if (compareLocalHash == null) {
                syncRole.setCompareHash(compareSyncHash);
                syncRole.setCreateTime(date);
                roleInsertList.add(syncRole);
                continue;
            }
            if (compareSyncHash.equals(compareLocalHash)) continue;
            syncRole.setCompareHash(compareSyncHash);
            syncRole.setLastTime(date);
            roleUpdateList.add(syncRole);
        }
        try {
            if (roleInsertList.size() > 0) {
                int maxLimit = 10000;
                if (roleInsertList.size() > maxLimit) {
                    for (int i = 0; i <= (roleInsertList.size() - 1) / maxLimit; ++i) {
                        List<SyncRole> insertList = SyncUtil.getPartOfList(i, maxLimit, roleInsertList);
                        this.syncRoleMapper.insertSyncRoleByList(insertList);
                        this.insertRole(insertList);
                    }
                } else {
                    this.syncRoleMapper.insertSyncRoleByList(roleInsertList);
                    this.insertRole(roleInsertList);
                }
            }
            if (roleUpdateList.size() > 0) {
                int maxLimit = 10000;
                if (roleUpdateList.size() > maxLimit) {
                    for (int i = 0; i <= (roleUpdateList.size() - 1) / maxLimit; ++i) {
                        List<SyncRole> updateList = SyncUtil.getPartOfList(i, maxLimit, roleUpdateList);
                        this.syncRoleMapper.updateSyncRoleByList(updateList);
                        this.updateRole(updateList);
                    }
                } else {
                    this.syncRoleMapper.updateSyncRoleByList(roleUpdateList);
                    this.updateRole(roleUpdateList);
                }
            }
            if (roleDelList.size() > 0) {
                int maxLimit = 30000;
                if (roleDelList.size() > maxLimit) {
                    for (int i = 0; i <= (roleDelList.size() - 1) / maxLimit; ++i) {
                        List<String> deleteList = SyncUtil.getPartOfList(i, maxLimit, roleDelList);
                        this.syncRoleMapper.deleteSyncRoleByList(deleteList);
                        this.deleteRole(deleteList);
                    }
                } else {
                    this.syncRoleMapper.deleteSyncRoleByList(roleDelList);
                    this.deleteRole(roleDelList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
            throw new RuntimeException("\u89d2\u8272\u540c\u6b65\u5f02\u5e38\uff01");
        }
        return flag;
    }

    private void insertRole(List<SyncRole> syncRoleList) throws Exception {
        ArrayList<SysRoles> rolesList = new ArrayList<SysRoles>();
        for (SyncRole syncRole : syncRoleList) {
            SysRoles sysRoles = this.fillRoleInfo(syncRole, true);
            rolesList.add(sysRoles);
        }
        this.sysRolesSyncMapper.insertRoleByList(rolesList);
    }

    private void updateRole(List<SyncRole> syncRoleList) throws Exception {
        ArrayList<SysRoles> rolesList = new ArrayList<SysRoles>();
        for (SyncRole syncRole : syncRoleList) {
            SysRoles sysRoles = this.fillRoleInfo(syncRole, false);
            rolesList.add(sysRoles);
        }
        this.sysRolesSyncMapper.updateRoleByList(rolesList);
    }

    private void deleteRole(List<String> roleIdList) throws Exception {
        this.sysRolesSyncMapper.deleteRoleByList(roleIdList);
    }

    private SysRoles fillRoleInfo(SyncRole syncRole, boolean isInsert) {
        SysRoles sysRoles = new SysRoles();
        Date date = new Date();
        sysRoles.setRoleId(syncRole.getRoleId());
        sysRoles.setRoleName(syncRole.getRoleName());
        sysRoles.setRoleAlias(syncRole.getRoleAlias());
        sysRoles.setIsSys("0");
        sysRoles.setCorporationId("2");
        sysRoles.setGroupId("2");
        if (isInsert) {
            sysRoles.setRoleOrder(ToolUtil.isEmpty((Object)syncRole.getRoleOrder()) ? SyncConstants.DEFAULT_ORDER : syncRole.getRoleOrder());
            sysRoles.setCreateTime(date);
            sysRoles.setLastTime(date);
        } else {
            sysRoles.setRoleOrder(syncRole.getRoleOrder());
            sysRoles.setLastTime(date);
        }
        return sysRoles;
    }
}

