/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.syncdata.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.organ.dao.SysOfficeSyncMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganSyncMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruSyncMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOffice;
import com.jxdinfo.hussar.bsp.organ.model.SysOrganSync;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruRoleSyncMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysStruRole;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.syncdata.constants.SyncConstants;
import com.jxdinfo.hussar.syncdata.dao.SyncOrganMapper;
import com.jxdinfo.hussar.syncdata.model.SyncOrgan;
import com.jxdinfo.hussar.syncdata.model.SyncOrganRole;
import com.jxdinfo.hussar.syncdata.service.ISyncOrganService;
import com.jxdinfo.hussar.syncdata.util.Md5Util;
import com.jxdinfo.hussar.syncdata.util.SyncUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncOrganServiceImpl
extends ServiceImpl<SyncOrganMapper, SyncOrgan>
implements ISyncOrganService {
    @Resource
    private SyncOrganMapper syncOrganMapper;
    @Resource
    private SysStruSyncMapper sysStruSyncMapper;
    @Resource
    private SysOrganSyncMapper sysOrganSyncMapper;
    @Resource
    private SysOfficeSyncMapper sysOfficeSyncMapper;
    @Resource
    private SysStruRoleSyncMapper sysStruRoleSyncMapper;

    @Override
    @Transactional
    public Boolean syncOrgData(List<SyncOrgan> syncOrganList) {
        String organId;
        boolean flag = true;
        ArrayList<SyncOrgan> organInsertList = new ArrayList<SyncOrgan>();
        ArrayList<SyncOrgan> organUpdateList = new ArrayList<SyncOrgan>();
        ArrayList<String> organDelList = new ArrayList<String>();
        List<SyncOrgan> localOrganList = this.syncOrganMapper.selectLocalList(SyncConstants.SYSTEM_DEFAULT_ORGAN_IDS, "9");
        HashMap<String, String> compareSyncMap = new HashMap<String, String>();
        HashMap<String, String> compareLocalMap = new HashMap<String, String>();
        Date date = new Date();
        for (SyncOrgan syncOrgan : syncOrganList) {
            String compareHash = Md5Util.md5Hash(JSON.toJSONString((Object)((Object)syncOrgan)));
            compareSyncMap.put(syncOrgan.getOrganId(), compareHash);
        }
        for (SyncOrgan syncOrgan : localOrganList) {
            organId = syncOrgan.getOrganId();
            if (compareSyncMap.get(organId) == null) {
                organDelList.add(organId);
            }
            compareLocalMap.put(organId, syncOrgan.getCompareHash());
        }
        for (SyncOrgan syncOrgan : syncOrganList) {
            organId = syncOrgan.getOrganId();
            String compareSyncHash = (String)compareSyncMap.get(organId);
            String compareLocalHash = (String)compareLocalMap.get(organId);
            if (compareLocalHash == null) {
                syncOrgan.setCompareHash(compareSyncHash);
                syncOrgan.setCreateTime(date);
                organInsertList.add(syncOrgan);
                continue;
            }
            if (compareSyncHash.equals(compareLocalHash)) continue;
            syncOrgan.setCompareHash(compareSyncHash);
            syncOrgan.setLastTime(date);
            organUpdateList.add(syncOrgan);
        }
        try {
            if (organInsertList.size() > 0) {
                int maxLimit = 10000;
                if (organInsertList.size() > maxLimit) {
                    for (int i = 0; i <= (organInsertList.size() - 1) / maxLimit; ++i) {
                        List<SyncOrgan> insertList = SyncUtil.getPartOfList(i, maxLimit, organInsertList);
                        this.syncOrganMapper.insertSyncOrganByList(insertList);
                        this.insertOrgan(insertList);
                    }
                } else {
                    this.syncOrganMapper.insertSyncOrganByList(organInsertList);
                    this.insertOrgan(organInsertList);
                }
            }
            if (organUpdateList.size() > 0) {
                int maxLimit = 10000;
                if (organUpdateList.size() > maxLimit) {
                    for (int i = 0; i <= (organUpdateList.size() - 1) / maxLimit; ++i) {
                        List<SyncOrgan> updateList = SyncUtil.getPartOfList(i, maxLimit, organUpdateList);
                        this.syncOrganMapper.updateSyncOrganByList(updateList);
                        this.updateOrgan(updateList);
                    }
                } else {
                    this.syncOrganMapper.updateSyncOrganByList(organUpdateList);
                    this.updateOrgan(organUpdateList);
                }
            }
            if (organDelList.size() > 0) {
                int maxLimit = 30000;
                if (organDelList.size() > maxLimit) {
                    for (int i = 0; i <= (organDelList.size() - 1) / maxLimit; ++i) {
                        List<String> deleteList = SyncUtil.getPartOfList(i, maxLimit, organDelList);
                        this.syncOrganMapper.deleteSyncOrganByList(deleteList);
                        this.deleteOrgan(deleteList);
                    }
                } else {
                    this.syncOrganMapper.deleteSyncOrganByList(organDelList);
                    this.deleteOrgan(organDelList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
            throw new RuntimeException("\u7ec4\u7ec7\u540c\u6b65\u5f02\u5e38\uff01");
        }
        return flag;
    }

    private void insertOrgan(List<SyncOrgan> syncOrganList) throws Exception {
        ArrayList<SysOrganSync> organList = new ArrayList<SysOrganSync>();
        ArrayList<SysStru> struList = new ArrayList<SysStru>();
        ArrayList<SysOffice> officeList = new ArrayList<SysOffice>();
        for (SyncOrgan syncOrgan : syncOrganList) {
            SysOrganSync sysOrganSync = this.fillOrganInfo(syncOrgan, true);
            SysStru sysStru = this.fillStruInfo(syncOrgan, true);
            SysOffice sysOffice = this.fillOfficeInfo(syncOrgan);
            String organId = this.getUUID();
            sysOrganSync.setOrganId(organId);
            sysStru.setOrganId(organId);
            sysOffice.setOfficeId(this.getUUID());
            if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
                sysStru.setOrganAlias(sysOrganSync.getOrganName());
            }
            organList.add(sysOrganSync);
            struList.add(sysStru);
            officeList.add(sysOffice);
        }
        this.sysStruSyncMapper.insertStruByList(struList);
        this.sysOrganSyncMapper.insertOrganByList(organList);
        this.sysOfficeSyncMapper.insertOfficeByList(officeList);
    }

    private void updateOrgan(List<SyncOrgan> syncOrganList) throws Exception {
        ArrayList<SysOrganSync> organList = new ArrayList<SysOrganSync>();
        ArrayList<SysStru> struList = new ArrayList<SysStru>();
        ArrayList<SysOffice> officeList = new ArrayList<SysOffice>();
        for (SyncOrgan syncOrgan : syncOrganList) {
            SysOrganSync sysOrganSync = this.fillOrganInfo(syncOrgan, false);
            SysStru sysStru = this.fillStruInfo(syncOrgan, false);
            SysOffice sysOffice = this.fillOfficeInfo(syncOrgan);
            if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
                sysStru.setOrganAlias(sysOrganSync.getOrganName());
            }
            sysOrganSync.setStruId(syncOrgan.getOrganId());
            organList.add(sysOrganSync);
            struList.add(sysStru);
            officeList.add(sysOffice);
        }
        this.sysStruSyncMapper.updateStruByList(struList);
        this.sysOrganSyncMapper.updateOrganByList(organList);
        this.sysOfficeSyncMapper.updateOfficeByList(officeList);
    }

    private void deleteOrgan(List<String> struIdList) throws Exception {
        List<String> organIdList = this.sysOrganSyncMapper.selectOrganIdsByStruIds(struIdList);
        List<String> officeIdList = this.sysOfficeSyncMapper.selectOfficeIdsByStruIds(struIdList);
        this.sysStruSyncMapper.deleteStruByList(struIdList);
        if (organIdList.size() > 0) {
            this.sysOrganSyncMapper.deleteOrganByList(organIdList);
        }
        if (officeIdList.size() > 0) {
            this.sysOfficeSyncMapper.deleteOfficeByList(officeIdList);
        }
    }

    private SysStru fillStruInfo(SyncOrgan syncOrgan, boolean isInsert) {
        SysStru sysStru = new SysStru();
        Date date = new Date();
        sysStru.setStruId(syncOrgan.getOrganId());
        sysStru.setStruType(syncOrgan.getOrganType());
        sysStru.setOrganAlias(syncOrgan.getShortName());
        sysStru.setParentId(syncOrgan.getParentId());
        sysStru.setStruLevel(syncOrgan.getStruLevel());
        sysStru.setStruPath(syncOrgan.getStruPath());
        sysStru.setProvinceCode(syncOrgan.getProvinceCode());
        if (isInsert) {
            sysStru.setIsLeaf(ToolUtil.isEmpty((Object)syncOrgan.getIsLeaf()) ? "0" : syncOrgan.getIsLeaf());
            sysStru.setInUse(ToolUtil.isEmpty((Object)syncOrgan.getInUse()) ? "1" : syncOrgan.getInUse());
            sysStru.setStruOrder(ToolUtil.isEmpty((Object)syncOrgan.getStruOrder()) ? SyncConstants.DEFAULT_ORDER : syncOrgan.getStruOrder());
            sysStru.setGlobalOrder(ToolUtil.isEmpty((Object)syncOrgan.getGlobalOrder()) ? SyncConstants.DEFAULT_ORDER : syncOrgan.getGlobalOrder());
            sysStru.setCreateTime(date);
        } else {
            sysStru.setIsLeaf(syncOrgan.getIsLeaf());
            sysStru.setInUse(syncOrgan.getInUse());
            sysStru.setStruOrder(syncOrgan.getStruOrder());
            sysStru.setGlobalOrder(syncOrgan.getGlobalOrder());
            sysStru.setLastTime(date);
        }
        return sysStru;
    }

    private SysOrganSync fillOrganInfo(SyncOrgan syncOrgan, boolean isInsert) {
        SysOrganSync sysOrganSync = new SysOrganSync();
        Date date = new Date();
        sysOrganSync.setOrganName(syncOrgan.getOrganName());
        sysOrganSync.setShortName(syncOrgan.getShortName());
        sysOrganSync.setOrganType(syncOrgan.getOrganType());
        sysOrganSync.setBeginDate(syncOrgan.getBeginDate());
        sysOrganSync.setEndDate(syncOrgan.getEndDate());
        if (isInsert) {
            sysOrganSync.setOrganCode(syncOrgan.getOrganCode());
            sysOrganSync.setInUse(ToolUtil.isEmpty((Object)syncOrgan.getInUse()) ? "1" : syncOrgan.getInUse());
            sysOrganSync.setCreateTime(date);
        } else {
            sysOrganSync.setInUse(syncOrgan.getInUse());
        }
        sysOrganSync.setLastTime(date);
        return sysOrganSync;
    }

    private SysOffice fillOfficeInfo(SyncOrgan syncOrgan) {
        SysOffice sysOffice = new SysOffice();
        sysOffice.setOfficeAlias(syncOrgan.getOfficeAlias());
        sysOffice.setOfficeAddress(syncOrgan.getOfficeAddress());
        sysOffice.setStruId(syncOrgan.getOrganId());
        return sysOffice;
    }

    private String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    @Transactional
    public Boolean syncOrganRoleData(List<SyncOrganRole> syncOrganRoleList) {
        boolean flag = true;
        ArrayList<SysStruRole> organRoleInsertList = new ArrayList<SysStruRole>();
        for (SyncOrganRole syncOrganRole : syncOrganRoleList) {
            SysStruRole struRole = new SysStruRole();
            Date date = new Date();
            struRole.setStruId(syncOrganRole.getOrganId());
            struRole.setGrantedRole(syncOrganRole.getRoleId());
            struRole.setCreateTime(date);
            struRole.setLastTime(date);
            organRoleInsertList.add(struRole);
        }
        try {
            this.sysStruRoleSyncMapper.deleteOrganRoleByList();
            if (organRoleInsertList.size() > 0) {
                int maxLimit = 30000;
                if (organRoleInsertList.size() > maxLimit) {
                    for (int i = 0; i <= (organRoleInsertList.size() - 1) / maxLimit; ++i) {
                        List<SysStruRole> insertList = SyncUtil.getPartOfList(i, maxLimit, organRoleInsertList);
                        this.sysStruRoleSyncMapper.insertOrganRoleByList(insertList);
                    }
                } else {
                    this.sysStruRoleSyncMapper.insertOrganRoleByList(organRoleInsertList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
            throw new RuntimeException("\u7ec4\u7ec7\u89d2\u8272\u5173\u8054\u540c\u6b65\u5f02\u5e38\uff01");
        }
        return flag;
    }
}

