/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.syncdata.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.syncdata.model.SyncOrgan;
import com.jxdinfo.hussar.syncdata.model.SyncOrganRole;
import com.jxdinfo.hussar.syncdata.model.SyncRole;
import com.jxdinfo.hussar.syncdata.model.SyncStaff;
import com.jxdinfo.hussar.syncdata.model.SyncStaffOrgan;
import com.jxdinfo.hussar.syncdata.model.SyncUser;
import com.jxdinfo.hussar.syncdata.model.SyncUserRole;
import com.jxdinfo.hussar.syncdata.service.ISyncOrganService;
import com.jxdinfo.hussar.syncdata.service.ISyncRoleService;
import com.jxdinfo.hussar.syncdata.service.ISyncStaffService;
import com.jxdinfo.hussar.syncdata.service.ISyncUserService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

@Controller
@RequestMapping(value={"/syncData"})
public class SyncDataController
extends BaseController {
    @Resource
    private ISyncOrganService syncOrganService;
    @Resource
    private ISyncStaffService syncStaffService;
    @Resource
    private ISyncUserService syncUserService;
    @Resource
    private ISyncRoleService syncRoleService;
    @Resource
    private GlobalProperties globalProperties;
    @Autowired
    private RestTemplate restTemplate;
    private String token;

    @RequestMapping(value={"/syncGetToken"})
    @ResponseBody
    public ApiResponse<Map<String, String>> syncGetToken() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "false");
        String syncUrl = this.globalProperties.getSyncUrl();
        JSONObject requestObj = new JSONObject();
        requestObj.put("key", (Object)this.globalProperties.getSyncTokenKey());
        JSONObject jsonObject = (JSONObject)this.restTemplate.postForObject(syncUrl + "/syncData/getToken", (Object)requestObj, JSONObject.class, new Object[0]);
        if (ToolUtil.isNotEmpty((Object)jsonObject)) {
            if ("1".equals(jsonObject.getString("code"))) {
                result.put("message", jsonObject.getString("message"));
            } else if (ToolUtil.isNotEmpty((Object)jsonObject.getString("token"))) {
                this.token = jsonObject.getString("token");
                result.put("success", "true");
                result.put("message", jsonObject.getString("message"));
            } else {
                result.put("message", "\u8fd4\u56detoken\u4e3a\u7a7a");
            }
        } else {
            result.put("message", "\u8bf7\u6c42\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/syncOrgData"})
    @ResponseBody
    public ApiResponse<Map<String, String>> syncOrgData() {
        Map<Object, Object> result = new HashMap<String, String>();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getOrgInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncOrganList = JSON.parseArray((String)map.get("data"), SyncOrgan.class);
                boolean flag = this.syncOrganService.syncOrgData(syncOrganList);
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/syncStaffData"})
    @ResponseBody
    public ApiResponse<Map<String, String>> syncStaffData() {
        Map<Object, Object> result = new HashMap<String, String>();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getEmployeeInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncStaffList = JSON.parseArray((String)map.get("data"), SyncStaff.class);
                boolean flag = this.syncStaffService.syncStaffData(syncStaffList);
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/syncUserData"})
    @ResponseBody
    public ApiResponse<Map<String, String>> syncUserData() {
        Map<Object, Object> result = new HashMap<String, String>();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getUserInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncUserList = JSON.parseArray((String)map.get("data"), SyncUser.class);
                boolean flag = this.syncUserService.syncUserData(syncUserList);
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/syncRoleData"})
    @ResponseBody
    public ApiResponse<Map<String, String>> syncRoleData() {
        Map<Object, Object> result = new HashMap<String, String>();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getRoleInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncRoleList = JSON.parseArray((String)map.get("data"), SyncRole.class);
                boolean flag = this.syncRoleService.syncRoleData(syncRoleList);
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/syncStaffOrganData"})
    @ResponseBody
    public ApiResponse<Map<String, String>> syncStaffOrganData() {
        Map<Object, Object> result = new HashMap<String, String>();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getEmployeeOrgInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncStaffOrganList = JSON.parseArray((String)map.get("data"), SyncStaffOrgan.class);
                boolean flag = this.syncStaffService.syncStaffOrganData(syncStaffOrganList);
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/syncUserRoleData"})
    @ResponseBody
    public ApiResponse<Map<String, String>> syncUserRoleData() {
        Map<Object, Object> result = new HashMap<String, String>();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getUserRoleInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncUserRoleList = JSON.parseArray((String)map.get("data"), SyncUserRole.class);
                boolean flag = this.syncUserService.syncUserRoleData(syncUserRoleList);
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/syncOrganRoleData"})
    @ResponseBody
    public ApiResponse<Map<String, String>> syncOrganRoleData() {
        Map<Object, Object> result = new HashMap<String, String>();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getOrgRoleInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncOrganRoleList = JSON.parseArray((String)map.get("data"), SyncOrganRole.class);
                boolean flag = this.syncOrganService.syncOrganRoleData(syncOrganRoleList);
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return ApiResponse.data(result);
    }

    private Map<String, String> getSyncResult(String url, JSONObject requestObj) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "false");
        result.put("message", "");
        JSONObject jsonObject = (JSONObject)this.restTemplate.postForObject(url, (Object)requestObj, JSONObject.class, new Object[0]);
        if (ToolUtil.isNotEmpty((Object)jsonObject)) {
            if ("2".equals(jsonObject.getString("code"))) {
                result.put("message", "token\u5931\u6548\uff0c\u9700\u91cd\u65b0\u83b7\u53d6");
                return result;
            }
            if ("1".equals(jsonObject.getString("code"))) {
                result.put("message", jsonObject.getString("message"));
                return result;
            }
            if (jsonObject.get((Object)"data") != null) {
                result.put("success", "true");
                result.put("message", jsonObject.getString("message"));
                result.put("data", JSONArray.toJSONString((Object)jsonObject.get((Object)"data")));
            } else {
                result.put("message", "\u8fd4\u56de\u540c\u6b65\u6570\u636e\u4e3a\u7a7a");
            }
        } else {
            result.put("message", "\u8bf7\u6c42\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        return result;
    }
}

