/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.quartz.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.quartz.job.BaseJob;
import com.jxdinfo.hussar.syncdata.model.SyncOrgan;
import com.jxdinfo.hussar.syncdata.model.SyncOrganRole;
import com.jxdinfo.hussar.syncdata.model.SyncRole;
import com.jxdinfo.hussar.syncdata.model.SyncStaff;
import com.jxdinfo.hussar.syncdata.model.SyncStaffOrgan;
import com.jxdinfo.hussar.syncdata.model.SyncUser;
import com.jxdinfo.hussar.syncdata.model.SyncUserRole;
import com.jxdinfo.hussar.syncdata.service.ISyncOrganService;
import com.jxdinfo.hussar.syncdata.service.ISyncRoleService;
import com.jxdinfo.hussar.syncdata.service.ISyncStaffService;
import com.jxdinfo.hussar.syncdata.service.ISyncUserService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

public class SyncDataJob
implements BaseJob {
    private static Logger log = LogManager.getLogger(SyncDataJob.class);
    private static ApplicationContext appCtx = SpringContextHolder.getApplicationContext();
    private ISyncOrganService syncOrganService = (ISyncOrganService)appCtx.getBean(ISyncOrganService.class);
    private ISyncStaffService syncStaffService = (ISyncStaffService)appCtx.getBean(ISyncStaffService.class);
    private ISyncUserService syncUserService = (ISyncUserService)appCtx.getBean(ISyncUserService.class);
    private ISyncRoleService syncRoleService = (ISyncRoleService)appCtx.getBean(ISyncRoleService.class);
    private GlobalProperties globalProperties = (GlobalProperties)appCtx.getBean(GlobalProperties.class);
    private RestTemplate restTemplate = (RestTemplate)appCtx.getBean(RestTemplate.class);
    private String token;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info("\u5f00\u59cb\u6267\u884c\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1: " + new Date());
        Map<String, String> tokenMap = this.getToken();
        if (!"true".equals(tokenMap.get("success"))) {
            log.error("\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a " + tokenMap.get("message"));
            return;
        }
        Map<String, String> organMap = this.syncOrgData();
        if (!"true".equals(organMap.get("success"))) {
            log.error("\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a " + organMap.get("message"));
        } else {
            log.info("\u7ec4\u7ec7\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        }
        Map<String, String> staffMap = this.syncStaffData();
        if (!"true".equals(staffMap.get("success"))) {
            log.error("\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a " + staffMap.get("message"));
        } else {
            log.info("\u4eba\u5458\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        }
        Map<String, String> userMap = this.syncUserData();
        if (!"true".equals(userMap.get("success"))) {
            log.error("\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a " + userMap.get("message"));
        } else {
            log.info("\u7528\u6237\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        }
        Map<String, String> roleMap = this.syncRoleData();
        if (!"true".equals(roleMap.get("success"))) {
            log.error("\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a " + roleMap.get("message"));
        } else {
            log.info("\u89d2\u8272\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        }
        Map<String, String> staffOrganMap = this.syncStaffOrganData();
        if (!"true".equals(staffOrganMap.get("success"))) {
            log.error("\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a " + staffOrganMap.get("message"));
        } else {
            log.info("\u4eba\u5458\u7ec4\u7ec7\u5173\u8054\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        }
        Map<String, String> userRoleMap = this.syncUserRoleData();
        if (!"true".equals(userRoleMap.get("success"))) {
            log.error("\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a " + userRoleMap.get("message"));
        } else {
            log.info("\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        }
        Map<String, String> organRoleMap = this.syncOrganRoleData();
        if (!"true".equals(organRoleMap.get("success"))) {
            log.error("\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a " + organRoleMap.get("message"));
        } else {
            log.info("\u7ec4\u7ec7\u89d2\u8272\u5173\u8054\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        }
        log.info("\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f: " + new Date());
    }

    private Map<String, String> getToken() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "false");
        String syncUrl = this.globalProperties.getSyncUrl();
        JSONObject requestObj = new JSONObject();
        requestObj.put("key", (Object)this.globalProperties.getSyncTokenKey());
        JSONObject jsonObject = (JSONObject)this.restTemplate.postForObject(syncUrl + "/syncData/getToken", (Object)requestObj, JSONObject.class, new Object[0]);
        if (ToolUtil.isNotEmpty((Object)jsonObject)) {
            if ("1".equals(jsonObject.getString("code"))) {
                result.put("message", jsonObject.getString("message"));
            } else if (ToolUtil.isNotEmpty((Object)jsonObject.getString("token"))) {
                this.token = jsonObject.getString("token");
                result.put("success", "true");
                result.put("message", jsonObject.getString("message"));
            } else {
                result.put("message", "\u8fd4\u56detoken\u4e3a\u7a7a");
            }
        } else {
            result.put("message", "\u8bf7\u6c42\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        return result;
    }

    private Map<String, String> syncOrgData() {
        Map<String, String> result = new HashMap<String, String>();
        long startTime = System.currentTimeMillis();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getOrgInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncOrganList = JSON.parseArray((String)map.get("data"), SyncOrgan.class);
                boolean flag = this.syncOrganService.syncOrgData(syncOrganList);
                log.info("\u7ec4\u7ec7\u4fe1\u606f\u540c\u6b65\u7528\u65f6: " + (System.currentTimeMillis() - startTime) + "ms");
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return result;
    }

    private Map<String, String> syncStaffData() {
        Map<String, String> result = new HashMap<String, String>();
        long startTime = System.currentTimeMillis();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getEmployeeInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncStaffList = JSON.parseArray((String)map.get("data"), SyncStaff.class);
                boolean flag = this.syncStaffService.syncStaffData(syncStaffList);
                log.info("\u4eba\u5458\u4fe1\u606f\u540c\u6b65\u7528\u65f6: " + (System.currentTimeMillis() - startTime) + "ms");
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return result;
    }

    private Map<String, String> syncUserData() {
        Map<String, String> result = new HashMap<String, String>();
        long startTime = System.currentTimeMillis();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getUserInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncUserList = JSON.parseArray((String)map.get("data"), SyncUser.class);
                boolean flag = this.syncUserService.syncUserData(syncUserList);
                log.info("\u7528\u6237\u4fe1\u606f\u540c\u6b65\u7528\u65f6: " + (System.currentTimeMillis() - startTime) + "ms");
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return result;
    }

    @RequestMapping(value={"/syncRoleData"})
    @ResponseBody
    public Map<String, String> syncRoleData() {
        Map<String, String> result = new HashMap<String, String>();
        long startTime = System.currentTimeMillis();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getRoleInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncRoleList = JSON.parseArray((String)map.get("data"), SyncRole.class);
                boolean flag = this.syncRoleService.syncRoleData(syncRoleList);
                log.info("\u89d2\u8272\u4fe1\u606f\u540c\u6b65\u7528\u65f6: " + (System.currentTimeMillis() - startTime) + "ms");
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return result;
    }

    @RequestMapping(value={"/syncStaffOrganData"})
    @ResponseBody
    public Map<String, String> syncStaffOrganData() {
        Map<String, String> result = new HashMap<String, String>();
        long startTime = System.currentTimeMillis();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getEmployeeOrgInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncStaffOrganList = JSON.parseArray((String)map.get("data"), SyncStaffOrgan.class);
                boolean flag = this.syncStaffService.syncStaffOrganData(syncStaffOrganList);
                log.info("\u4eba\u5458\u7ec4\u7ec7\u5173\u8054\u4fe1\u606f\u540c\u6b65\u7528\u65f6: " + (System.currentTimeMillis() - startTime) + "ms");
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return result;
    }

    @RequestMapping(value={"/syncUserRoleData"})
    @ResponseBody
    public Map<String, String> syncUserRoleData() {
        Map<String, String> result = new HashMap<String, String>();
        long startTime = System.currentTimeMillis();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getUserRoleInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncUserRoleList = JSON.parseArray((String)map.get("data"), SyncUserRole.class);
                boolean flag = this.syncUserService.syncUserRoleData(syncUserRoleList);
                log.info("\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f\u540c\u6b65\u7528\u65f6: " + (System.currentTimeMillis() - startTime) + "ms");
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return result;
    }

    @RequestMapping(value={"/syncOrganRoleData"})
    @ResponseBody
    public Map<String, String> syncOrganRoleData() {
        Map<String, String> result = new HashMap<String, String>();
        long startTime = System.currentTimeMillis();
        try {
            String syncUrl = this.globalProperties.getSyncUrl();
            JSONObject requestObj = new JSONObject();
            requestObj.put("token", (Object)this.token);
            Map<String, String> map = this.getSyncResult(syncUrl + "/syncData/getOrgRoleInfo", requestObj);
            if ("true".equals(map.get("success"))) {
                List syncOrganRoleList = JSON.parseArray((String)map.get("data"), SyncOrganRole.class);
                boolean flag = this.syncOrganService.syncOrganRoleData(syncOrganRoleList);
                log.info("\u7ec4\u7ec7\u89d2\u8272\u5173\u8054\u4fe1\u606f\u540c\u6b65\u7528\u65f6: " + (System.currentTimeMillis() - startTime) + "ms");
                result.put("success", String.valueOf(flag));
                result.put("message", "");
            } else {
                result = map;
            }
        }
        catch (Exception e) {
            result.put("success", "false");
            result.put("message", e.getCause().toString());
        }
        return result;
    }

    private Map<String, String> getSyncResult(String url, JSONObject requestObj) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "false");
        result.put("message", "");
        JSONObject jsonObject = (JSONObject)this.restTemplate.postForObject(url, (Object)requestObj, JSONObject.class, new Object[0]);
        if (ToolUtil.isNotEmpty((Object)jsonObject)) {
            if ("2".equals(jsonObject.getString("code"))) {
                result.put("message", "token\u5931\u6548\uff0c\u9700\u91cd\u65b0\u83b7\u53d6");
                return result;
            }
            if ("1".equals(jsonObject.getString("code"))) {
                result.put("message", jsonObject.getString("message"));
                return result;
            }
            if (jsonObject.get((Object)"data") != null) {
                result.put("success", "true");
                result.put("message", jsonObject.getString("message"));
                result.put("data", JSONArray.toJSONString((Object)jsonObject.get((Object)"data")));
            } else {
                result.put("message", "\u8fd4\u56de\u540c\u6b65\u6570\u636e\u4e3a\u7a7a");
            }
        } else {
            result.put("message", "\u8bf7\u6c42\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        return result;
    }
}

