/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.Error;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.sync.dto.AddOutsideUserDTO;
import com.jxdinfo.hussar.sync.dto.EditOutsideUserDTO;
import com.jxdinfo.hussar.sync.enums.CheckUserNamePwdResult;
import com.jxdinfo.hussar.sync.enums.IAMDataSyncResponseStatus;
import com.jxdinfo.hussar.sync.enums.SysUserAndRole;
import com.jxdinfo.hussar.sync.manager.AddAccountManager;
import com.jxdinfo.hussar.sync.manager.UpdateAccountManager;
import com.jxdinfo.hussar.sync.properties.IAMDataSyncProperty;
import com.jxdinfo.hussar.sync.service.SchemaAttrService;
import com.jxdinfo.hussar.sync.service.UsersSyncService;
import com.jxdinfo.hussar.sync.service.impl.IAMDataSyncServiceImpl;
import com.jxdinfo.hussar.sync.utils.IAMDataSyncUtil;
import com.jxdinfo.hussar.sync.vo.DataCreateVO;
import com.jxdinfo.hussar.sync.vo.IAMDataSyncResponse;
import com.jxdinfo.hussar.sync.vo.QueryAllUserIdsVO;
import com.jxdinfo.hussar.sync.vo.QueryUserByIdVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsersSyncServiceImpl
extends IAMDataSyncServiceImpl
implements UsersSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersSyncServiceImpl.class);
    private static final List<String> SYSTEM_USER_IDS = Lists.newArrayList((Object[])new Long[]{SysUserAndRole.AUDIT_ADMIN.getValue(), SysUserAndRole.BUSINESS_ADMIN.getValue(), SysUserAndRole.EXAMPLE_USER.getValue(), SysUserAndRole.REVIEW_ADMIN.getValue(), SysUserAndRole.SYSTEM_ADMIN.getValue(), SysUserAndRole.SECURITY_ADMIN.getValue(), SysUserAndRole.DATA_PULL.getValue()}).stream().map(Object::toString).collect(Collectors.toList());
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private SchemaAttrService schemaAttrService;
    @Autowired
    private AddAccountManager addAccountManager;
    @Autowired
    private UpdateAccountManager updateAccountManager;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private IAMDataSyncProperty iamDataSyncProperty;

    public IAMDataSyncResponse UserCreateService(ObjectNode reqBody) {
        Long existedUserId;
        SysStaff syncedSysStaff;
        SysUsers syncedSysUsers;
        AddOutsideUserDTO addOutsideUserDTO;
        LOGGER.error("====================\u7528\u6237\u521b\u5efa\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u7528\u6237\u521b\u5efa\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        try {
            addOutsideUserDTO = (AddOutsideUserDTO)this.objectMapper.treeToValue((TreeNode)reqBody, AddOutsideUserDTO.class);
            syncedSysUsers = (SysUsers)this.objectMapper.treeToValue((TreeNode)reqBody, SysUsers.class);
            syncedSysStaff = (SysStaff)this.objectMapper.treeToValue((TreeNode)reqBody, SysStaff.class);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        R<AddOutsideUserDTO> result = null;
        SysUsers deletedUser = (SysUsers)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)syncedSysUsers.getUserAccount())).eq(SysUsers::getAccountStatus, (Object)"2")).one();
        if (HussarUtils.isEmpty((Object)deletedUser)) {
            result = this.addAccountManager.doAdd(addOutsideUserDTO, false);
            existedUserId = !result.isSuccess() ? null : ((DataMapping)result.getSuccessList().get(0)).getId();
        } else {
            existedUserId = deletedUser.getId();
            Long existedStaffId = deletedUser.getEmployeeId();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysStruUserService.lambdaUpdate().eq(SysStruUser::getUserId, (Object)deletedUser.getId())).set(SysStruUser::getStruId, (Object)syncedSysUsers.getDepartmentId())).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysStruStaffService.lambdaUpdate().eq(SysStruStaff::getId, (Object)existedStaffId)).set(SysStruStaff::getStruId, (Object)syncedSysUsers.getDepartmentId())).update();
        }
        if (HussarUtils.isNotEmpty(result) && !result.isSuccess()) {
            List errorMsgs = ((Error)result.getErrorList().get(0)).getErrMsg().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            String errorMsg = String.join((CharSequence)" & ", errorMsgs);
            LOGGER.error(errorMsg);
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.USER_CREATE_FAILURE.getCode()).message(errorMsg).response();
            LOGGER.info("====================\u7528\u6237\u521b\u5efa\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        assert (existedUserId != null) : "\u672a\u67e5\u8be2\u5230\u5df2\u5b58\u5728\u7684\u7528\u6237";
        if (!reqBody.has("securityLevel") || StringUtil.isBlank((CharSequence)reqBody.get("securityLevel").asText())) {
            syncedSysUsers.setSecurityLevel(this.iamDataSyncProperty.getDefaultSecurityLevel());
        }
        syncedSysUsers.setId(existedUserId);
        syncedSysUsers.setAccountStatus("1");
        this.sysUsersService.updateById((Object)syncedSysUsers);
        Long staffId = this.sysUsersService.getById(existedUserId).getEmployeeId();
        syncedSysStaff.setId(staffId);
        syncedSysStaff.setDelFlag("0");
        UsersSyncServiceImpl.dealWithSyncedSysStaff(syncedSysStaff, (SysStaff)this.sysStaffService.getById((Serializable)staffId));
        this.sysStaffService.updateById((Object)syncedSysStaff);
        DataCreateVO dataCreateVO = new DataCreateVO.DataCreateVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).uid(existedUserId.toString()).response();
        LOGGER.info("====================\u7528\u6237\u521b\u5efa\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)dataCreateVO);
        return dataCreateVO;
    }

    public IAMDataSyncResponse UserUpdateService(ObjectNode reqBody) {
        SysStaff syncedSysStaff;
        SysUsers syncedSysUsers;
        EditOutsideUserDTO editOutsideUserDTO;
        LOGGER.error("====================\u7528\u6237\u4fee\u6539\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u7528\u6237\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        Long syncedUserId = reqBody.get("bimUid").asLong();
        SysUsers existedSysUsers = this.sysUsersService.getById(syncedUserId);
        if (HussarUtils.isEmpty((Object)existedSysUsers)) {
            LOGGER.error(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getMessage());
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getMessage()).response();
            LOGGER.info("====================\u7528\u6237\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        try {
            editOutsideUserDTO = (EditOutsideUserDTO)this.objectMapper.treeToValue((TreeNode)reqBody, EditOutsideUserDTO.class);
            syncedSysUsers = (SysUsers)this.objectMapper.treeToValue((TreeNode)reqBody, SysUsers.class);
            syncedSysStaff = (SysStaff)this.objectMapper.treeToValue((TreeNode)reqBody, SysStaff.class);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        Long existedStaffId = existedSysUsers.getEmployeeId();
        SysStaff existedSysStaff = (SysStaff)this.sysStaffService.getById((Serializable)existedStaffId);
        UsersSyncServiceImpl.dealWithSyncedSysStaff(syncedSysStaff, existedSysStaff);
        if (reqBody.has("__ENABLE__")) {
            String userStatus = reqBody.get("__ENABLE__").asBoolean() ? "1" : "3";
            String staffStatus = reqBody.get("__ENABLE__").asBoolean() ? "0" : "1";
            syncedSysUsers.setAccountStatus(userStatus);
            this.sysUsersService.updateById((Object)syncedSysUsers);
            syncedSysStaff.setDelFlag(staffStatus);
            this.sysStaffService.updateById((Object)syncedSysStaff);
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
            LOGGER.info("====================\u7528\u6237\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        String existedUserAccount = existedSysUsers.getUserAccount();
        if (reqBody.has("departmentId")) {
            Long userDepartmentId = reqBody.get("departmentId").asLong();
            editOutsideUserDTO.setOrganIds((List)Lists.newArrayList((Object[])new Long[]{userDepartmentId}));
        }
        editOutsideUserDTO.setUserAccount(existedUserAccount);
        R<EditOutsideUserDTO> result = this.updateAccountManager.doUpdate(editOutsideUserDTO);
        if (!result.isSuccess()) {
            List errorMsgs = ((Error)result.getErrorList().get(0)).getErrMsg().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            String errorMsg = String.join((CharSequence)" & ", errorMsgs);
            LOGGER.error(errorMsg);
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.USER_UPDATE_FAILURE.getCode()).message(errorMsg).response();
            LOGGER.info("====================\u7528\u6237\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        syncedSysUsers.setId(syncedUserId);
        syncedSysUsers.setLastTime(LocalDateTime.now());
        syncedSysStaff.setId(existedStaffId);
        syncedSysStaff.setLastTime(LocalDateTime.now());
        this.sysUsersService.updateById((Object)syncedSysUsers);
        this.sysStaffService.updateById((Object)syncedSysStaff);
        IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        LOGGER.info("====================\u7528\u6237\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
        return iamDataSyncResponse;
    }

    public IAMDataSyncResponse UserDeleteService(ObjectNode reqBody) {
        LOGGER.error("====================\u7528\u6237\u5220\u9664\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u7528\u6237\u5220\u9664\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        Long deletedUserId = reqBody.get("bimUid").asLong();
        SysUsers deletedSysUsers = this.sysUsersService.getById(deletedUserId);
        if (deletedSysUsers == null) {
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getMessage()).response();
            LOGGER.info("====================\u7528\u6237\u5220\u9664\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysUsersService.lambdaUpdate().eq(SysUsers::getId, (Object)deletedUserId)).set(SysUsers::getAccountStatus, (Object)"2")).update();
        SysStaff deletedSysStaff = (SysStaff)this.sysStaffService.getById((Serializable)deletedSysUsers.getEmployeeId());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysStaffService.lambdaUpdate().eq(SysStaff::getId, (Object)deletedSysStaff.getId())).set(HussarDelflagEntity::getDelFlag, (Object)"1")).update();
        IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        LOGGER.info("====================\u7528\u6237\u5220\u9664\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
        return iamDataSyncResponse;
    }

    public IAMDataSyncResponse QueryAllUserIdsService(ObjectNode reqBody) {
        LOGGER.error("====================\u67e5\u8be2\u5168\u90e8\u7528\u6237id\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u67e5\u8be2\u5168\u90e8\u7528\u6237id\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        List userIds = this.sysUsersService.list().stream().map(SysUsers::getId).map(Object::toString).filter(userId -> !SYSTEM_USER_IDS.contains(userId)).collect(Collectors.toList());
        QueryAllUserIdsVO queryAllUserIdsVO = new QueryAllUserIdsVO.QueryAllUserIdsVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).userIdList(userIds).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        LOGGER.info("====================\u67e5\u8be2\u5168\u90e8\u7528\u6237id\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)queryAllUserIdsVO);
        return queryAllUserIdsVO;
    }

    public IAMDataSyncResponse QueryUserByIdService(ObjectNode reqBody) {
        LOGGER.error("====================\u67e5\u8be2\u7528\u6237\u8be6\u60c5\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u67e5\u8be2\u7528\u6237\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        Long syncedUserId = reqBody.get("bimUid").asLong();
        SysUsers existedSysUsers = this.sysUsersService.getById(syncedUserId);
        if (HussarUtils.isEmpty((Object)existedSysUsers)) {
            LOGGER.error(checkUserNamePwdResult.getMessage());
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getMessage()).response();
            LOGGER.info("====================\u67e5\u8be2\u7528\u6237\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        SysStaff existedSysStaff = (SysStaff)this.sysStaffService.getById((Serializable)Optional.ofNullable(existedSysUsers.getEmployeeId()).orElse(0L));
        List schemaAttrs = this.schemaAttrService.getAttrNameByGroup("account");
        ObjectNode accountInfo = this.objectMapper.createObjectNode();
        ObjectNode dealtUserNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedSysUsers, schemaAttrs);
        ObjectNode dealtStaffNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedSysStaff, schemaAttrs);
        IAMDataSyncUtil.mergeObjectNodes(dealtUserNode, accountInfo);
        IAMDataSyncUtil.mergeObjectNodes(dealtStaffNode, accountInfo);
        QueryUserByIdVO queryUserByIdVO = new QueryUserByIdVO.QueryUserByIdVOBuilder().account(accountInfo).bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        LOGGER.info("====================\u67e5\u8be2\u7528\u6237\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)queryUserByIdVO);
        return queryUserByIdVO;
    }

    private static void dealWithSyncedSysStaff(SysStaff syncedSysStaff, SysStaff savedSysStaff) {
        syncedSysStaff.setName(Optional.ofNullable(syncedSysStaff.getName()).orElse(savedSysStaff.getName()));
        syncedSysStaff.setSex(Optional.ofNullable(syncedSysStaff.getSex()).orElse(savedSysStaff.getSex()));
        syncedSysStaff.setBirthday(Optional.ofNullable(syncedSysStaff.getBirthday()).orElse(savedSysStaff.getBirthday()));
        syncedSysStaff.setIdcard(Optional.ofNullable(syncedSysStaff.getIdcard()).orElse(savedSysStaff.getIdcard()));
        syncedSysStaff.setAddress(Optional.ofNullable(syncedSysStaff.getAddress()).orElse(savedSysStaff.getAddress()));
        syncedSysStaff.setWorkId(Optional.ofNullable(syncedSysStaff.getWorkId()).orElse(savedSysStaff.getWorkId()));
        syncedSysStaff.setWorkDate(Optional.ofNullable(syncedSysStaff.getWorkDate()).orElse(savedSysStaff.getWorkDate()));
        syncedSysStaff.setGraduateDate(Optional.ofNullable(syncedSysStaff.getGraduateDate()).orElse(savedSysStaff.getGraduateDate()));
        syncedSysStaff.setGraduateSchool(Optional.ofNullable(syncedSysStaff.getGraduateSchool()).orElse(savedSysStaff.getGraduateSchool()));
        syncedSysStaff.setStaffCode(Optional.ofNullable(syncedSysStaff.getStaffCode()).orElse(savedSysStaff.getStaffCode()));
        syncedSysStaff.setRemark(Optional.ofNullable(syncedSysStaff.getRemark()).orElse(savedSysStaff.getRemark()));
        syncedSysStaff.setStaffOrder(Optional.ofNullable(syncedSysStaff.getStaffOrder()).orElse(savedSysStaff.getStaffOrder()));
        syncedSysStaff.setStruId(Optional.ofNullable(syncedSysStaff.getStruId()).orElse(savedSysStaff.getStruId()));
    }
}

