/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.ILocalOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.Error;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.sync.enums.CheckUserNamePwdResult;
import com.jxdinfo.hussar.sync.enums.IAMDataSyncResponseStatus;
import com.jxdinfo.hussar.sync.enums.TransferredOrganType;
import com.jxdinfo.hussar.sync.manager.AddOrgManager;
import com.jxdinfo.hussar.sync.manager.UpdateOrgManager;
import com.jxdinfo.hussar.sync.service.OrgansSyncService;
import com.jxdinfo.hussar.sync.service.SchemaAttrService;
import com.jxdinfo.hussar.sync.service.impl.IAMDataSyncServiceImpl;
import com.jxdinfo.hussar.sync.utils.IAMDataSyncUtil;
import com.jxdinfo.hussar.sync.vo.DataCreateVO;
import com.jxdinfo.hussar.sync.vo.IAMDataSyncResponse;
import com.jxdinfo.hussar.sync.vo.QueryAllOrgIdsVO;
import com.jxdinfo.hussar.sync.vo.QueryOrgByIdVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgansSyncServiceImpl
extends IAMDataSyncServiceImpl
implements OrgansSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrgansSyncServiceImpl.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ILocalOrganizationBoService localOrganizationBoService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private SysOrgManageService sysOrgManageService;
    @Autowired
    private SchemaAttrService schemaAttrService;
    @Autowired
    private AddOrgManager addOrgManager;
    @Autowired
    private UpdateOrgManager updateOrgManager;
    @Autowired
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;

    public IAMDataSyncResponse OrgCreateService(ObjectNode reqBody) {
        SysStru existedSysStru;
        SysOrgan syncedSysOrgan;
        SysStru syncedSysStru;
        AddOutsideOrganizationDto addOutsideOrganizationDto;
        LOGGER.error("====================\u7ec4\u7ec7\u673a\u6784\u521b\u5efa\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u7ec4\u7ec7\u65b0\u589e\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        try {
            addOutsideOrganizationDto = (AddOutsideOrganizationDto)this.objectMapper.treeToValue((TreeNode)reqBody, AddOutsideOrganizationDto.class);
            syncedSysStru = (SysStru)this.objectMapper.treeToValue((TreeNode)reqBody, SysStru.class);
            syncedSysOrgan = (SysOrgan)this.objectMapper.treeToValue((TreeNode)reqBody, SysOrgan.class);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        R<AddOutsideOrganizationDto> result = null;
        String organType = this.transferSyncedOrganType(Optional.ofNullable(reqBody.get("organType")).map(JsonNode::asText).orElse("1"));
        SysOrgan deletedOrgan = null;
        String organCode = null;
        if (reqBody.has("organCode")) {
            organCode = reqBody.get("organCode").asText();
        }
        if (HussarUtils.isNotBlank(organCode)) {
            deletedOrgan = (SysOrgan)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysOrganService.lambdaQuery().eq(SysOrgan::getOrganCode, (Object)organCode)).eq(HussarDelflagEntity::getDelFlag, (Object)"1")).one();
        } else {
            organCode = this.generateUniqueRandomOrganCode();
            addOutsideOrganizationDto.setOrganCode(organCode);
            syncedSysOrgan.setOrganCode(organCode);
        }
        if (HussarUtils.isEmpty(deletedOrgan)) {
            String parentOrganCode = this.getParentOrganCode(reqBody.get("parentId"));
            addOutsideOrganizationDto.setParentOrganCode(parentOrganCode);
            addOutsideOrganizationDto.setOrganType(organType);
            result = this.addOrgManager.doCreate(addOutsideOrganizationDto);
            existedSysStru = !result.isSuccess() ? null : (SysStru)((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().eq(SysStru::getId, (Object)((DataMapping)result.getSuccessList().get(0)).getId())).one();
        } else {
            existedSysStru = (SysStru)((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().eq(SysStru::getOrganId, (Object)deletedOrgan.getId())).one();
        }
        if (HussarUtils.isNotEmpty(result) && !result.isSuccess()) {
            List errorMsgs = ((Error)result.getErrorList().get(0)).getErrMsg().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            String errorMsg = String.join((CharSequence)" & ", errorMsgs);
            LOGGER.error(errorMsg);
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.ORG_CREATE_FAILURE.getCode()).message(errorMsg).response();
            LOGGER.info("====================\u7ec4\u7ec7\u65b0\u589e\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        assert (existedSysStru != null) : "\u672a\u67e5\u8be2\u5230\u5df2\u5b58\u5728\u7684\u7ec4\u7ec7";
        Long existedOrganId = existedSysStru.getOrganId();
        syncedSysStru.setId(existedSysStru.getId());
        syncedSysStru.setPrincipalId(Optional.ofNullable(syncedSysStru.getPrincipalId()).orElse(existedSysStru.getPrincipalId()));
        syncedSysStru.setStruType(organType);
        syncedSysStru.setParentId(existedSysStru.getParentId());
        syncedSysStru.setDelFlag("0");
        this.sysStruService.updateById((Object)syncedSysStru);
        syncedSysOrgan.setId(existedOrganId);
        syncedSysOrgan.setOrganType(organType);
        syncedSysOrgan.setDelFlag("0");
        this.sysOrganService.updateById((Object)syncedSysOrgan);
        LOGGER.info("====================\u540c\u6b65\u7ec4\u7ec7\u7c7b\u578b\u4e3a\uff1a{},\u7236\u7ea7\u7ec4\u7ec7id\u4e3a\uff1a{}====================", (Object)organType, (Object)existedSysStru.getParentId());
        DataCreateVO dataCreateVO = new DataCreateVO.DataCreateVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).uid(existedSysStru.getId().toString()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        LOGGER.info("====================\u7ec4\u7ec7\u65b0\u589e\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)dataCreateVO);
        return dataCreateVO;
    }

    public IAMDataSyncResponse OrgUpdateService(ObjectNode reqBody) {
        SysOrgan syncedSysOrgan;
        SysStru syncedSysStru;
        EditOutsideOrganizationDto editOutsideOrganizationDto;
        LOGGER.error("====================\u7ec4\u7ec7\u673a\u6784\u4fee\u6539\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u7ec4\u7ec7\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        Long syncedStruId = reqBody.get("bimOrgId").asLong();
        SysStru existedSysStru = (SysStru)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().eq(SysStru::getId, (Object)syncedStruId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).one();
        if (existedSysStru == null) {
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getMessage()).response();
            LOGGER.info("====================\u7ec4\u7ec7\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        Long existedOrganId = existedSysStru.getOrganId();
        try {
            editOutsideOrganizationDto = (EditOutsideOrganizationDto)this.objectMapper.treeToValue((TreeNode)reqBody, EditOutsideOrganizationDto.class);
            syncedSysStru = (SysStru)this.objectMapper.treeToValue((TreeNode)reqBody, SysStru.class);
            syncedSysOrgan = (SysOrgan)this.objectMapper.treeToValue((TreeNode)reqBody, SysOrgan.class);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        syncedSysStru.setPrincipalId(Optional.ofNullable(syncedSysStru.getPrincipalId()).orElse(existedSysStru.getPrincipalId()));
        if (reqBody.has("__ENABLE__")) {
            String orgStatus = reqBody.get("__ENABLE__").asBoolean() ? "0" : "1";
            syncedSysStru.setId(syncedStruId);
            syncedSysStru.setDelFlag(orgStatus);
            syncedSysStru.setLastTime(LocalDateTime.now());
            this.sysStruService.updateById((Object)syncedSysStru);
            syncedSysOrgan.setId(existedOrganId);
            syncedSysOrgan.setDelFlag(orgStatus);
            syncedSysOrgan.setLastTime(LocalDateTime.now());
            this.sysOrganService.updateById((Object)syncedSysOrgan);
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
            LOGGER.info("====================\u7ec4\u7ec7\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        SysStru syncedParentOrgan = null;
        if (reqBody.has("parentId")) {
            Long parentStruId = reqBody.get("parentId").asLong();
            syncedParentOrgan = (SysStru)this.sysStruService.getById((Serializable)parentStruId);
        }
        String parentOrganCode = null;
        if (HussarUtils.isNotEmpty(syncedParentOrgan)) {
            parentOrganCode = this.localOrganizationBoService.findOrganizationById(syncedParentOrgan.getId()).getOrganCode();
        }
        SysOrgan existedOrgan = Optional.ofNullable(this.sysOrganService.getById((Serializable)existedOrganId)).orElseGet(SysOrgan::new);
        String existedOrganCode = existedOrgan.getOrganCode();
        String newOrganCode = Optional.ofNullable(reqBody.get("organCode")).map(JsonNode::asText).orElse(null);
        editOutsideOrganizationDto.setOrganCode(existedOrganCode);
        editOutsideOrganizationDto.setOrganName(existedOrgan.getOrganName());
        editOutsideOrganizationDto.setOrganAlias(existedSysStru.getOrganAlias());
        editOutsideOrganizationDto.setOrganShortName(existedOrgan.getShortName());
        editOutsideOrganizationDto.setParentOrganCode(parentOrganCode);
        editOutsideOrganizationDto.setNewOrganCode(newOrganCode);
        R<EditOutsideOrganizationDto> result = this.updateOrgManager.doUpdate(editOutsideOrganizationDto);
        if (HussarUtils.isNotEmpty(result) && !result.isSuccess()) {
            List errorMsgs = ((Error)result.getErrorList().get(0)).getErrMsg().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            String errorMsg = String.join((CharSequence)" & ", errorMsgs);
            LOGGER.error(errorMsg);
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.ORG_UPDATE_FAILURE.getCode()).message(errorMsg).response();
            LOGGER.info("====================\u7ec4\u7ec7\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        syncedSysStru.setId(syncedStruId);
        syncedSysStru.setLastTime(LocalDateTime.now());
        syncedSysStru.setOrganAlias(syncedSysOrgan.getOrganName());
        syncedSysStru.setPrincipalId(Optional.ofNullable(syncedSysStru.getPrincipalId()).orElse(existedSysStru.getPrincipalId()));
        this.sysStruService.updateById((Object)syncedSysStru);
        syncedSysOrgan.setId(existedOrganId);
        syncedSysOrgan.setLastTime(LocalDateTime.now());
        this.sysOrganService.updateById((Object)syncedSysOrgan);
        IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        LOGGER.info("====================\u7ec4\u7ec7\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
        return iamDataSyncResponse;
    }

    public IAMDataSyncResponse OrgDeleteService(ObjectNode reqBody) {
        LOGGER.error("====================\u7ec4\u7ec7\u673a\u6784\u5220\u9664\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u7ec4\u7ec7\u5220\u9664\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        SysOrganVo deletedSysOrganVo = this.sysOrgManageService.getOrgInfoById(Long.valueOf(reqBody.get("bimOrgId").asLong()));
        if (deletedSysOrganVo == null) {
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getMessage()).response();
            LOGGER.info("====================\u7ec4\u7ec7\u5220\u9664\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysOrganService.lambdaUpdate().eq(SysOrgan::getId, (Object)deletedSysOrganVo.getOrganId())).set(HussarDelflagEntity::getDelFlag, (Object)"1")).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysStruService.lambdaUpdate().eq(SysStru::getOrganId, (Object)deletedSysOrganVo.getOrganId())).set(HussarDelflagEntity::getDelFlag, (Object)"1")).update();
        IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        LOGGER.info("====================\u7ec4\u7ec7\u5220\u9664\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
        return iamDataSyncResponse;
    }

    public IAMDataSyncResponse QueryAllOrgIdsService(ObjectNode reqBody) {
        LOGGER.error("====================\u67e5\u8be2\u5168\u90e8\u7ec4\u7ec7\u673a\u6784id\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u67e5\u8be2\u5168\u90e8\u7ec4\u7ec7\u673a\u6784id\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        List orgIdList = this.sysStruService.list().stream().map(SysStru::getId).filter(HussarUtils::isNotEmpty).map(String::valueOf).collect(Collectors.toList());
        orgIdList.remove("1");
        QueryAllOrgIdsVO queryAllOrgIdsVO = new QueryAllOrgIdsVO.QueryAllOrgIdsVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).orgIdList(orgIdList).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        LOGGER.info("====================\u67e5\u8be2\u5168\u90e8\u7ec4\u7ec7\u673a\u6784id\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)queryAllOrgIdsVO);
        return queryAllOrgIdsVO;
    }

    public IAMDataSyncResponse QueryOrgByIdService(ObjectNode reqBody) {
        LOGGER.error("====================\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u8be6\u60c5\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
                LOGGER.info("====================\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
                return iamDataSyncResponse;
            }
        }
        Long syncedStruId = reqBody.get("bimOrgId").asLong();
        SysStru existedSysStru = (SysStru)this.sysStruService.getById((Serializable)syncedStruId);
        if (existedSysStru == null) {
            LOGGER.error(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getMessage());
            IAMDataSyncResponse iamDataSyncResponse = new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getMessage()).response();
            LOGGER.info("====================\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)iamDataSyncResponse);
            return iamDataSyncResponse;
        }
        SysOrgan existedSysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)Optional.ofNullable(existedSysStru.getOrganId()).orElse(0L));
        OrganizationBo existedOrganizationBo = this.localOrganizationBoService.findOrganizationById(syncedStruId);
        List schemaAttrs = this.schemaAttrService.getAttrNameByGroup("organization");
        ObjectNode organInfo = this.objectMapper.createObjectNode();
        ObjectNode dealtStruNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedSysStru, schemaAttrs);
        ObjectNode dealtOrganNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedSysOrgan, schemaAttrs);
        ObjectNode dealtOrganizationBoNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedOrganizationBo, schemaAttrs);
        IAMDataSyncUtil.mergeObjectNodes(dealtStruNode, organInfo);
        IAMDataSyncUtil.mergeObjectNodes(dealtOrganNode, organInfo);
        IAMDataSyncUtil.mergeObjectNodes(dealtOrganizationBoNode, organInfo);
        QueryOrgByIdVO queryOrgByIdVO = new QueryOrgByIdVO.QueryOrgByIdVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).organization(organInfo).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        LOGGER.info("====================\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)queryOrgByIdVO);
        return queryOrgByIdVO;
    }

    private String transferSyncedOrganType(String syncedOrganType) {
        switch (syncedOrganType) {
            case "0": {
                return TransferredOrganType.OUT_ORGAN_TYPE_0.get();
            }
            case "2": {
                return TransferredOrganType.OUT_ORGAN_TYPE_2.get();
            }
        }
        return TransferredOrganType.OUT_ORGAN_TYPE_1.get();
    }

    private String getParentOrganCode(JsonNode parentIdNode) {
        if (parentIdNode == null) {
            return "11";
        }
        Long parentId = parentIdNode.asLong();
        OrganizationBo parentOrganBO = this.localOrganizationBoService.findOrganizationById(parentId);
        return parentOrganBO.getOrganCode();
    }

    private String generateUniqueRandomOrganCode() {
        String randomOrganCode = IAMDataSyncUtil.generateRandomOrganCode();
        List existedOrganCodes = this.hussarBaseOrganizationBoService.getAllOrganInfo().stream().map(OrganizationBo::getOrganCode).collect(Collectors.toList());
        while (existedOrganCodes.contains(randomOrganCode)) {
            randomOrganCode = IAMDataSyncUtil.generateRandomOrganCode();
        }
        return randomOrganCode;
    }
}

