/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.service.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.sync.enums.CheckUserNamePwdResult;
import com.jxdinfo.hussar.sync.mapper.SchemaAttrBOStructMapper;
import com.jxdinfo.hussar.sync.model.SchemaAttr;
import com.jxdinfo.hussar.sync.properties.IAMDataSyncProperty;
import com.jxdinfo.hussar.sync.service.IAMDataSyncService;
import com.jxdinfo.hussar.sync.service.SchemaAttrService;
import com.jxdinfo.hussar.sync.utils.IAMDataSyncUtil;
import com.jxdinfo.hussar.sync.vo.SchemaServiceVO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class IAMDataSyncServiceImpl
implements IAMDataSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IAMDataSyncServiceImpl.class);
    @Autowired
    private IAMDataSyncProperty intelligentEnterpriseDataSyncProperty;
    @Autowired
    private SchemaAttrService schemaAttrService;
    @Autowired
    private SchemaAttrBOStructMapper schemaAttrBOStructMapper;

    public SchemaServiceVO SchemaService(ObjectNode reqBody) {
        LOGGER.error("====================\u83b7\u53d6\u5c5e\u6027\u5b57\u6bb5\u53c2\u6570====================\n{}", (Object)reqBody);
        SchemaServiceVO schemaServiceVO = new SchemaServiceVO();
        schemaServiceVO.setBimRequestId(reqBody.get("bimRequestId").asText());
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                LOGGER.info("====================\u83b7\u53d6\u5c5e\u6027\u5b57\u6bb5\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)schemaServiceVO);
                return schemaServiceVO;
            }
        }
        List schemaAttrList = this.schemaAttrService.list();
        Map<String, List<SchemaAttr>> schemaAttrsMap = schemaAttrList.stream().filter(HussarUtils::isNotEmpty).collect(Collectors.groupingBy(SchemaAttr::getAttrGroup));
        schemaServiceVO.setAccount(this.schemaAttrBOStructMapper.toSchemaAttrBOList(schemaAttrsMap.get("account")));
        schemaServiceVO.setOrganization(this.schemaAttrBOStructMapper.toSchemaAttrBOList(schemaAttrsMap.get("organization")));
        LOGGER.info("====================\u83b7\u53d6\u5c5e\u6027\u5b57\u6bb5\u63a5\u53e3\u8fd4\u56de\u503c====================\n{}", (Object)schemaServiceVO);
        return schemaServiceVO;
    }

    public CheckUserNamePwdResult checkUserNamePwd(String bimRemoteUser, String bimRemotePwd) {
        return IAMDataSyncUtil.checkUserNamePwd(bimRemoteUser, bimRemotePwd, this.intelligentEnterpriseDataSyncProperty.getBimRemoteUser(), this.intelligentEnterpriseDataSyncProperty.getBimRemotePwd());
    }
}

