/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.manager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddOrgManager {
    @Autowired
    private ISysOrganService organService;
    @Autowired
    private ISysOrganTypeService organTypeService;
    @Autowired
    private ISysOfficeService sysOfficeService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Autowired
    private ISysStruService struService;
    @Autowired
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Autowired
    private ISysUsersService sysUserService;

    public R<AddOutsideOrganizationDto> doCreate(AddOutsideOrganizationDto addOrganizationDto) {
        Map organTypeMap;
        boolean existCode;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)addOrganizationDto);
        String organCode = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode());
        String organType = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganType());
        String parentOrganCode = StringUtils.trimToEmpty((String)addOrganizationDto.getParentOrganCode());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)organCode);
        boolean bl = existCode = this.organService.count((Wrapper)lambdaQueryWrapper) > 0L;
        if (existCode) {
            OrganUtil.addErrorMsg((List)errors, (Object)addOrganizationDto, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGANIZATION_CODE_DUPLICATION.getMessage())});
        }
        if (!(organTypeMap = this.organTypeService.queryOrganTypeMap()).containsKey(organType)) {
            OrganUtil.addErrorMsg((List)errors, (Object)addOrganizationDto, (String)"organType", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NON_EXIST_ORG_TYPE.getMessage())});
        } else {
            Boolean typeRuleFlag = this.whetherComplianceWithOrganizationRule(parentOrganCode, organType, organTypeMap);
            if (!typeRuleFlag.booleanValue()) {
                OrganUtil.addErrorMsg((List)errors, (Object)addOrganizationDto, (String)"organType", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_COMPLIANT_ORG_TYPE.getMessage())});
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStru sysStru = new SysStru();
            SysOffice sysOffice = new SysOffice();
            SysOrgan sysOrgan = new SysOrgan();
            this.initializationAdd(addOrganizationDto, sysStru, sysOrgan, sysOffice);
            this.wrapAddOrgan(sysStru, sysOrgan);
            this.organService.save((Object)sysOrgan);
            this.sysStruMapper.insert((Object)sysStru);
            this.sysOfficeService.save((Object)sysOffice);
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationAdd(AddOutsideOrganizationDto addOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String parentOrganCode = StringUtils.trimToEmpty((String)addOrganizationDto.getParentOrganCode());
        String organCode = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode());
        String organType = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganType());
        String organName = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)addOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganDescription());
        String organAddress = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAddress());
        Integer struOrder = addOrganizationDto.getStruOrder();
        long sysStruId = HussarUtils.isNotEmpty((Object)addOrganizationDto.getStruId()) ? addOrganizationDto.getStruId() : IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysOfficeId = IdWorker.getId((Object)sysOffice);
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        Long parentId = this.getOrganId(parentOrganCode);
        sysStru.setParentId(parentId);
        Long userId = this.getUserId(userAccount);
        sysStru.setPrincipalId(userId);
        sysStru.setStruType(organType);
        sysStru.setOrganAlias(organAlias);
        SysStru temp = (SysStru)this.sysStruMapper.selectById((Serializable)sysStru.getParentId());
        int level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        if (HussarUtils.isEmpty((Object)struOrder)) {
            struOrder = 1;
            Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
            if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                struOrder = maxOrder + 1;
            }
        }
        sysStru.setStruOrder(struOrder);
        sysOffice.setId(Long.valueOf(sysOfficeId));
        sysOffice.setStruId(Long.valueOf(sysStruId));
        sysOffice.setOfficeAddress(organAddress);
        sysOffice.setOfficeAlias(organDescription);
        if (parentId.equals(Constants.ROOT_NODE_ID)) {
            sysOrgan.setOrganProperty("0");
        } else if (parentId.equals(Constants.OUT_STRU_NODE_ID)) {
            sysOrgan.setOrganProperty("1");
        } else {
            SysOrgan sysOrganTemp = (SysOrgan)((LambdaQueryChainWrapper)this.organService.lambdaQuery().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)parentOrganCode))).one();
            sysOrgan.setOrganProperty(sysOrganTemp.getOrganProperty());
        }
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(organCode);
        sysOrgan.setOrganName(organName);
        sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)organShortName) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)organShortName));
        sysOrgan.setOrganType(organType);
        sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)addOrganizationDto.getOrganAlias()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias()));
        sysOrgan.setOrganCode(organCode);
        sysStru.setIsLeaf("Y");
    }

    public void wrapAddOrgan(SysStru sysStru, SysOrgan sysOrgan) {
        String organFcode = "/" + sysOrgan.getOrganCode();
        String organFname = "/" + sysOrgan.getOrganName();
        long struIdTemp = HussarUtils.isEmpty((Object)sysStru.getId()) ? IdWorker.getId((Object)sysStru) : sysStru.getId();
        String struFid = "/" + struIdTemp;
        String pSeq = "";
        String pFid = "/";
        int level = sysStru.getStruLevel();
        if (level > 1) {
            SysStru pSysStru = (SysStru)this.sysStruMapper.selectById((Serializable)sysStru.getParentId());
            SysOrgan pSysOrgan = (SysOrgan)this.sysOrganMapper.selectById((Serializable)pSysStru.getOrganId());
            pSeq = pSysStru.getStruSeq();
            pFid = pSysStru.getStruFid();
            sysOrgan.setParentTypeCode(pSysOrgan.getOrganType());
            organFcode = pSysOrgan.getOrganFcode() + organFcode;
            struFid = pFid + struFid;
            organFname = pSysOrgan.getOrganFname() + organFname;
            pSysStru.setIsLeaf("N");
            this.sysStruMapper.updateById((Object)pSysStru);
        }
        if (!sysOrgan.getOrganType().equals("9")) {
            sysStru.setStruSeq(this.getStruSeq(pFid, pSeq, level));
        } else {
            sysStru.setStruSeq(pSeq);
        }
        sysOrgan.setOrganFcode(OrganUtil.convert((String)organFcode));
        sysOrgan.setOrganFname(organFname);
        sysStru.setId(Long.valueOf(struIdTemp));
        sysStru.setStruFid(OrganUtil.convert((String)struFid));
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruFid().split("/").length - 1));
    }

    private Boolean whetherComplianceWithOrganizationRule(String parentOrganCode, String organType, Map<String, SysOrganType> organTypeMap) {
        if (HussarUtils.isNotBlank((CharSequence)parentOrganCode) && !parentOrganCode.equals(String.valueOf(Constants.ROOT_NODE_ID)) && !parentOrganCode.equals(String.valueOf(Constants.OUT_STRU_NODE_ID))) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)parentOrganCode);
            SysOrgan parentOrgan = (SysOrgan)this.organService.getOne((Wrapper)lambdaQueryWrapper);
            String parentOrganType = parentOrgan.getOrganType();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStruRule::getSysOrganType, (Object)parentOrganType);
            wrapper.eq(SysStruRule::getOrganType, (Object)organType);
            return this.sysStruRuleMapper.selectCount((Wrapper)wrapper) > 0L;
        }
        String parentType = organTypeMap.get(organType).getParentType();
        return "0".equals(parentType);
    }

    private void refreshStruSeq() {
        List strus = this.sysStruMapper.selectList((Wrapper)null);
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(Constants.ROOT_NODE_ID) || organsEntity.getParentId().equals(Constants.OUT_STRU_NODE_ID)).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq("/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, strus);
            return stru;
        }).collect(Collectors.toList());
        this.struService.updateBatchById((Collection)strus);
    }

    private void setInfo(SysStru root, List<SysStru> strus) {
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq(root.getStruSeq() + "/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, strus);
            return stru;
        }).collect(Collectors.toList());
    }

    private String getStruSeq(String pFid, String pSeq, int level) {
        String maxStruSeq = this.sysStruMapper.getMaxStruSeq(pFid, level);
        return HussarUtils.isBlank((CharSequence)maxStruSeq) ? pSeq + "/0001" : this.getStruSeqByMaxStruSeq(maxStruSeq, pSeq, level);
    }

    private String getStruSeqByMaxStruSeq(String maxStruSeq, String pSeq, int level) {
        String struSeq = "";
        String[] arr = maxStruSeq.split("/");
        if (StringUtils.isNotBlank((CharSequence)pSeq)) {
            int len = arr.length - 1;
            if (len < level) {
                StringBuilder stringBuilder = new StringBuilder(maxStruSeq);
                for (int i = 0; i < level - len; ++i) {
                    stringBuilder.append("/0001");
                }
                struSeq = stringBuilder.toString();
            } else {
                struSeq = maxStruSeq.substring(0, maxStruSeq.lastIndexOf("/")) + "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
            }
        } else {
            struSeq = "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
        }
        return struSeq;
    }

    private Long getOrganId(String organCode) {
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            return Constants.ROOT_NODE_ID;
        }
        if (organCode.equals(String.valueOf(Constants.ROOT_NODE_ID))) {
            return Constants.ROOT_NODE_ID;
        }
        if (organCode.equals(String.valueOf(Constants.OUT_STRU_NODE_ID))) {
            return Constants.OUT_STRU_NODE_ID;
        }
        SysOrgan sysOrganTemp = (SysOrgan)((LambdaQueryChainWrapper)this.organService.lambdaQuery().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)organCode))).one();
        AssertUtil.isNotNull((Object)sysOrganTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PARENT_ORGAN_NOT_FOUND.getMessage()));
        SysStru sysStruTemp = (SysStru)((LambdaQueryChainWrapper)this.struService.lambdaQuery().eq(SysStru::getOrganId, (Object)sysOrganTemp.getId())).one();
        AssertUtil.isNotNull((Object)sysStruTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PARENT_ORGAN_NOT_FOUND.getMessage()));
        return sysStruTemp.getId();
    }

    private Long getUserId(String userAccount) {
        if (HussarUtils.isBlank((CharSequence)userAccount)) {
            return null;
        }
        String userAccountTemp = userAccount;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            userAccountTemp = userAccountTemp.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUserService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)userAccountTemp)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode())).one();
        AssertUtil.isNotNull((Object)sysUsers, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        return sysUsers.getId();
    }
}

