/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.manager;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.sync.dto.AddOutsideUserDTO;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddAccountManager {
    @Autowired
    private IHussarLoginConfigService hussarLoginConfigService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysIdtableService sysIdtableService;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Autowired
    private IHussarPwdConfigService pwdConfigService;
    @Autowired
    private AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Resource
    private SysUsersMapper sysUsersMapper;

    public R<AddOutsideUserDTO> doAdd(AddOutsideUserDTO user, boolean dealWithSelf) {
        List organIds;
        boolean exists;
        boolean convert;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)user);
        String account = StringUtils.trimToEmpty((String)user.getUserAccount());
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        if (exists = this.existUser(account)) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_DUPLICATION.getMessage())});
        }
        Long departmentId = user.getDepartmentId();
        List<Object> list = organIds = HussarUtils.isNotEmpty((Object)user.getOrganIds()) ? user.getOrganIds() : new ArrayList();
        if (HussarUtils.isEmpty((Object)departmentId) && HussarUtils.isEmpty((Object)organIds)) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"departmentId", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EMPTY.getMessage())});
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"organIds", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EMPTY.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)departmentId)) {
            organIds.add(departmentId);
        }
        if (HussarUtils.isNotEmpty((Object)organIds)) {
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            user.setOrganIds(organIds);
            List existStruIds = this.sysStruMapper.selectExistIdByIds(organIds);
            if (existStruIds.size() != organIds.size()) {
                StringBuilder msg = new StringBuilder();
                boolean errorFlag = false;
                for (Long organId : organIds) {
                    if (existStruIds.contains(organId) || organId.equals(departmentId)) continue;
                    msg.append(organId).append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EMPTY.getMessage())).append(";");
                    errorFlag = true;
                }
                if (!existStruIds.contains(departmentId)) {
                    OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"departmentId", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EMPTY.getMessage())});
                }
                if (errorFlag) {
                    OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"organIds", (String[])new String[]{msg.toString()});
                }
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStaff sysStaff = new SysStaff();
            SysUsers sysUsers = new SysUsers();
            ArrayList<SysStruStaff> struStaffList = new ArrayList<SysStruStaff>();
            ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
            user.setUserAccount(account);
            this.initializationAdd(convert, user, struStaffList, struUserList, sysStaff, sysUsers);
            if (dealWithSelf) {
                sysUsers.setPassword(StringUtils.trimToEmpty((String)user.getSecure()));
            }
            this.addStaffUser(struStaffList, struUserList, sysStaff, sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private boolean existUser(String account) {
        Long count = ((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)account)).count();
        return count != null && count > 0L;
    }

    private void initializationAdd(boolean convert, AddOutsideUserDTO userDto, List<SysStruStaff> struStaffList, List<SysStruUser> struUserList, SysStaff sysStaff, SysUsers sysUsers) {
        Integer maxUserOrder;
        Integer maxStaffOrder;
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        long sysUserId = IdWorker.getId((Object)sysUsers);
        List organIds = userDto.getOrganIds();
        String userAccount = StringUtils.trimToEmpty((String)userDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String mail = StringUtils.trimToEmpty((String)userDto.getMail());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        Integer order = userDto.getUserOrder();
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysStaff.setStaffPosition(staffPosition);
        sysStaff.setStaffCode(this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF"));
        int staffOrder = 1;
        staffOrder = HussarUtils.isEmpty((Object)order) ? (HussarUtils.isEmpty((Object)(maxStaffOrder = this.sysStaffMapper.getMaxOrder())) ? staffOrder : maxStaffOrder + 1) : order;
        sysStaff.setStaffOrder(Integer.valueOf(staffOrder));
        sysUsers.setId(Long.valueOf(sysUserId));
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setMaxSessions(Integer.valueOf(-1));
        sysUsers.setUserAccount(convert ? userAccount.toUpperCase() : userAccount);
        sysUsers.setUserName(userName);
        sysUsers.setWeChat(weChat);
        sysUsers.seteMail(mail);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
        sysUsers.setEmployeeId(Long.valueOf(sysStaffId));
        int userOrder = 1;
        userOrder = HussarUtils.isEmpty((Object)order) ? (HussarUtils.isEmpty((Object)(maxUserOrder = this.sysUsersMapper.getUserMaxOrder())) ? userOrder : maxUserOrder + 1) : order;
        sysUsers.setUserOrder(Integer.valueOf(userOrder));
        for (Long organId : organIds) {
            SysStruStaff sysStruStaff = new SysStruStaff();
            SysStruUser sysStruUser = new SysStruUser();
            sysStruStaff.setStruId(organId);
            sysStruStaff.setStaffId(Long.valueOf(sysStaffId));
            struStaffList.add(sysStruStaff);
            sysStruUser.setStruId(organId);
            sysStruUser.setUserId(Long.valueOf(sysUserId));
            struUserList.add(sysStruUser);
        }
    }

    private void addStaffUser(List<SysStruStaff> struStaffList, List<SysStruUser> struUserList, SysStaff sysStaff, SysUsers sysUsers) {
        if (HussarUtils.isNotEmpty(struStaffList)) {
            this.sysStruStaffService.saveBatch(struStaffList);
        }
        if (HussarUtils.isNotEmpty(struUserList)) {
            this.sysStruUserService.saveBatch(struUserList);
        }
        this.sysStaffMapper.insert((Object)sysStaff);
        if (StringUtils.isBlank((CharSequence)sysUsers.getPassword())) {
            String pass = "";
            pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "123456" : this.pwdConfigService.getDefaultPassword();
            String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
            sysUsers.setPassword(pwd);
        }
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setMaxSessions(Integer.valueOf(-1));
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        Long departmentId = struUserList.get(0).getStruId();
        if (HussarUtils.isNotEmpty((Object)departmentId)) {
            sysUsers.setCorporationId(departmentId);
            sysUsers.setDepartmentId(departmentId);
        }
        sysUsers.setEmployeeId(sysStaff.getId());
        sysUsers.setTypeProperty("1");
        this.sysUsersService.save((Object)sysUsers);
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sysUsers.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        this.sysUserRoleMapper.insert((Object)userRole);
    }
}

