/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefreshStruSeqJob
implements BasicProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshStruSeqJob.class);
    @Resource
    private SysStruMapper sysStruMapper;
    @Autowired
    private ISysStruService struService;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        List strus = this.sysStruMapper.selectList((Wrapper)null);
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(Constants.ROOT_NODE_ID) || organsEntity.getParentId().equals(Constants.OUT_STRU_NODE_ID)).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq("/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, strus);
            return stru;
        }).collect(Collectors.toList());
        this.struService.updateBatchById((Collection)strus);
        LOGGER.info("====================\u5b9a\u65f6\u5237\u65b0struOrder\u5230\u6570\u636e\u5e93====================");
        return new ProcessResult(true, "success");
    }

    private void setInfo(SysStru root, List<SysStru> strus) {
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq(root.getStruSeq() + "/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, strus);
            return stru;
        }).collect(Collectors.toList());
    }
}

