/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.service.impl;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.Error;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.sync.enums.CheckUserNamePwdResult;
import com.jxdinfo.hussar.sync.enums.IAMDataSyncResponseStatus;
import com.jxdinfo.hussar.sync.enums.SysUserAndRole;
import com.jxdinfo.hussar.sync.manager.AddAccountManager;
import com.jxdinfo.hussar.sync.manager.DeleteAccountManager;
import com.jxdinfo.hussar.sync.manager.UpdateAccountManager;
import com.jxdinfo.hussar.sync.service.SchemaAttrService;
import com.jxdinfo.hussar.sync.service.UsersSyncService;
import com.jxdinfo.hussar.sync.service.impl.IAMDataSyncServiceImpl;
import com.jxdinfo.hussar.sync.utils.IAMDataSyncUtil;
import com.jxdinfo.hussar.sync.vo.DataCreateVO;
import com.jxdinfo.hussar.sync.vo.IAMDataSyncResponse;
import com.jxdinfo.hussar.sync.vo.QueryAllUserIdsVO;
import com.jxdinfo.hussar.sync.vo.QueryUserByIdVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsersSyncServiceImpl
extends IAMDataSyncServiceImpl
implements UsersSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersSyncServiceImpl.class);
    private static final String SCHEMA_ATTR_ACCOUNT_GROUP = "account";
    private static final String USER_ACTIVATED = "1";
    private static final String USER_DELETED = "2";
    private static final String USER_DEACTIVATED = "3";
    private static final String STAFF_ACTIVATED = "0";
    private static final String STAFF_DEACTIVATED = "1";
    private static final List<String> SYSTEM_USER_IDS = Lists.newArrayList((Object[])new Long[]{SysUserAndRole.AUDIT_ADMIN.getValue(), SysUserAndRole.BUSINESS_ADMIN.getValue(), SysUserAndRole.EXAMPLE_USER.getValue(), SysUserAndRole.REVIEW_ADMIN.getValue(), SysUserAndRole.SYSTEM_ADMIN.getValue(), SysUserAndRole.SECURITY_ADMIN.getValue(), SysUserAndRole.DATA_PULL.getValue()}).stream().map(Object::toString).collect(Collectors.toList());
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private SchemaAttrService schemaAttrService;
    @Autowired
    private AddAccountManager addAccountManager;
    @Autowired
    private UpdateAccountManager updateAccountManager;
    @Autowired
    private DeleteAccountManager deleteAccountManager;
    @Autowired
    private ISysStruService sysStruService;

    public IAMDataSyncResponse UserCreateService(ObjectNode reqBody) {
        SysStaff syncedSysStaff;
        SysUsers syncedSysUsers;
        AddOutsideUserDto addOutsideUserDto;
        LOGGER.info("====================\u7528\u6237\u521b\u5efa\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        try {
            addOutsideUserDto = (AddOutsideUserDto)this.objectMapper.treeToValue((TreeNode)reqBody, AddOutsideUserDto.class);
            syncedSysUsers = (SysUsers)this.objectMapper.treeToValue((TreeNode)reqBody, SysUsers.class);
            syncedSysStaff = (SysStaff)this.objectMapper.treeToValue((TreeNode)reqBody, SysStaff.class);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        Long userDepartmentId = reqBody.get("departmentId").asLong();
        SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)userDepartmentId);
        if (sysStru == null) {
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getMessage()).response();
        }
        addOutsideUserDto.setDepartmentId(userDepartmentId);
        R<AddOutsideUserDto> result = this.addAccountManager.doAdd(addOutsideUserDto, false);
        if (HussarUtils.isNotEmpty((Object)result.getErrorList())) {
            List errorMsgs = ((Error)result.getErrorList().get(0)).getErrMsg().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            String errorMsg = String.join((CharSequence)" & ", errorMsgs);
            LOGGER.error(errorMsg);
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.USER_CREATE_FAILURE.getCode()).message(errorMsg).response();
        }
        Long userId = ((DataMapping)result.getSuccessList().get(0)).getId();
        syncedSysUsers.setId(userId);
        syncedSysUsers.setDepartmentId(userDepartmentId);
        this.sysUsersService.updateById((Object)syncedSysUsers);
        Long staffId = this.sysUsersService.getById(userId).getEmployeeId();
        syncedSysStaff.setId(staffId);
        this.dealWithSyncedSysStaff(syncedSysStaff, (SysStaff)this.sysStaffService.getById((Serializable)staffId));
        this.sysStaffService.updateById((Object)syncedSysStaff);
        return new DataCreateVO.DataCreateVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).uid(userId.toString()).response();
    }

    public IAMDataSyncResponse UserUpdateService(ObjectNode reqBody) {
        SysStaff syncedSysStaff;
        SysUsers syncedSysUsers;
        EditOutsideUserDto editOutsideUserDto;
        LOGGER.info("====================\u7528\u6237\u4fee\u6539\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        try {
            editOutsideUserDto = (EditOutsideUserDto)this.objectMapper.treeToValue((TreeNode)reqBody, EditOutsideUserDto.class);
            syncedSysUsers = (SysUsers)this.objectMapper.treeToValue((TreeNode)reqBody, SysUsers.class);
            syncedSysStaff = (SysStaff)this.objectMapper.treeToValue((TreeNode)reqBody, SysStaff.class);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        Long syncedUserId = reqBody.get("bimUid").asLong();
        String updateUserAccount = Optional.ofNullable(this.sysUsersService.getById(syncedUserId)).map(SysUsers::getUserAccount).orElse("");
        Long userDepartmentId = reqBody.get("departmentId").asLong();
        editOutsideUserDto.setUserAccount(updateUserAccount);
        editOutsideUserDto.setOrganIds((List)Lists.newArrayList((Object[])new Long[]{userDepartmentId}));
        R<EditOutsideUserDto> result = this.updateAccountManager.doUpdate(editOutsideUserDto);
        if (HussarUtils.isNotEmpty((Object)result.getErrorList())) {
            List errorMsgs = ((Error)result.getErrorList().get(0)).getErrMsg().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            String errorMsg = String.join((CharSequence)" & ", errorMsgs);
            LOGGER.error(errorMsg);
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.USER_UPDATE_FAILURE.getCode()).message(errorMsg).response();
        }
        syncedSysUsers.setId(syncedUserId);
        syncedSysUsers.setLastTime(LocalDateTime.now());
        syncedSysUsers.setDepartmentId(userDepartmentId);
        Long existedStaffId = this.sysUsersService.getById(syncedUserId).getEmployeeId();
        syncedSysStaff.setId(existedStaffId);
        syncedSysStaff.setLastTime(LocalDateTime.now());
        SysStaff existedSysStaff = (SysStaff)this.sysStaffService.getById((Serializable)existedStaffId);
        this.dealWithSyncedSysStaff(syncedSysStaff, existedSysStaff);
        if (HussarUtils.isNotEmpty((Object)reqBody.get("__ENABLE__"))) {
            String userStatus = reqBody.get("__ENABLE__").asBoolean() ? "1" : USER_DEACTIVATED;
            String staffStatus = reqBody.get("__ENABLE__").asBoolean() ? STAFF_ACTIVATED : "1";
            syncedSysUsers.setAccountStatus(userStatus);
            this.sysUsersService.updateById((Object)syncedSysUsers);
            syncedSysStaff.setDelFlag(staffStatus);
            this.sysStaffService.updateById((Object)syncedSysStaff);
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        }
        this.sysUsersService.updateById((Object)syncedSysUsers);
        this.sysStaffService.updateById((Object)syncedSysStaff);
        return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
    }

    public IAMDataSyncResponse UserDeleteService(ObjectNode reqBody) {
        LOGGER.info("====================\u7528\u6237\u5220\u9664\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        Long deletedUserId = reqBody.get("bimUid").asLong();
        SysUsers deletedSysUsers = this.sysUsersService.getById(deletedUserId);
        if (deletedSysUsers == null) {
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getMessage()).response();
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysUsersService.lambdaUpdate().eq(SysUsers::getId, (Object)deletedUserId)).set(SysUsers::getAccountStatus, (Object)USER_DELETED)).update();
        SysStaff deletedSysStaff = (SysStaff)this.sysStaffService.getById((Serializable)deletedSysUsers.getEmployeeId());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysStaffService.lambdaUpdate().eq(SysStaff::getId, (Object)deletedSysStaff.getId())).set(HussarDelflagEntity::getDelFlag, (Object)"1")).update();
        return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
    }

    public IAMDataSyncResponse QueryAllUserIdsService(ObjectNode reqBody) {
        LOGGER.info("====================\u67e5\u8be2\u5168\u90e8\u7528\u6237id\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        List userIds = this.sysUsersService.list().stream().map(SysUsers::getId).map(Object::toString).filter(userId -> !SYSTEM_USER_IDS.contains(userId)).collect(Collectors.toList());
        return new QueryAllUserIdsVO.QueryAllUserIdsVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).userIdList(userIds).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
    }

    public IAMDataSyncResponse QueryUserByIdService(ObjectNode reqBody) {
        LOGGER.info("====================\u67e5\u8be2\u7528\u6237\u8be6\u60c5\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        Long syncedUserId = reqBody.get("bimUid").asLong();
        SysUsers existedSysUsers = this.sysUsersService.getById(syncedUserId);
        if (HussarUtils.isEmpty((Object)existedSysUsers)) {
            LOGGER.error(checkUserNamePwdResult.getMessage());
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_USER_ERR.getMessage()).response();
        }
        SysStaff existedSysStaff = (SysStaff)this.sysStaffService.getById((Serializable)Optional.ofNullable(existedSysUsers.getEmployeeId()).orElse(0L));
        List schemaAttrs = this.schemaAttrService.getAttrNameByGroup(SCHEMA_ATTR_ACCOUNT_GROUP);
        ObjectNode accountInfo = this.objectMapper.createObjectNode();
        ObjectNode dealtUserNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedSysUsers, schemaAttrs);
        ObjectNode dealtStaffNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedSysStaff, schemaAttrs);
        IAMDataSyncUtil.mergeObjectNodes(dealtUserNode, accountInfo);
        IAMDataSyncUtil.mergeObjectNodes(dealtStaffNode, accountInfo);
        return new QueryUserByIdVO.QueryUserByIdVOBuilder().account(accountInfo).bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
    }

    private void dealWithSyncedSysStaff(SysStaff syncedSysStaff, SysStaff savedSysStaff) {
        syncedSysStaff.setName(Optional.ofNullable(syncedSysStaff.getName()).orElse(savedSysStaff.getName()));
        syncedSysStaff.setSex(Optional.ofNullable(syncedSysStaff.getSex()).orElse(savedSysStaff.getSex()));
        syncedSysStaff.setBirthday(Optional.ofNullable(syncedSysStaff.getBirthday()).orElse(savedSysStaff.getBirthday()));
        syncedSysStaff.setIdcard(Optional.ofNullable(syncedSysStaff.getIdcard()).orElse(savedSysStaff.getIdcard()));
        syncedSysStaff.setAddress(Optional.ofNullable(syncedSysStaff.getAddress()).orElse(savedSysStaff.getAddress()));
        syncedSysStaff.setWorkId(Optional.ofNullable(syncedSysStaff.getWorkId()).orElse(savedSysStaff.getWorkId()));
        syncedSysStaff.setWorkDate(Optional.ofNullable(syncedSysStaff.getWorkDate()).orElse(savedSysStaff.getWorkDate()));
        syncedSysStaff.setGraduateDate(Optional.ofNullable(syncedSysStaff.getGraduateDate()).orElse(savedSysStaff.getGraduateDate()));
        syncedSysStaff.setGraduateSchool(Optional.ofNullable(syncedSysStaff.getGraduateSchool()).orElse(savedSysStaff.getGraduateSchool()));
        syncedSysStaff.setStaffCode(Optional.ofNullable(syncedSysStaff.getStaffCode()).orElse(savedSysStaff.getStaffCode()));
        syncedSysStaff.setRemark(Optional.ofNullable(syncedSysStaff.getRemark()).orElse(savedSysStaff.getRemark()));
        syncedSysStaff.setStaffOrder(Optional.ofNullable(syncedSysStaff.getStaffOrder()).orElse(savedSysStaff.getStaffOrder()));
        syncedSysStaff.setStruId(Optional.ofNullable(syncedSysStaff.getStruId()).orElse(savedSysStaff.getStruId()));
    }
}

