/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ILocalOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.Error;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.sync.enums.CheckUserNamePwdResult;
import com.jxdinfo.hussar.sync.enums.IAMDataSyncResponseStatus;
import com.jxdinfo.hussar.sync.enums.TransferredOrganType;
import com.jxdinfo.hussar.sync.manager.AddOrgManager;
import com.jxdinfo.hussar.sync.manager.DeleteOrgManager;
import com.jxdinfo.hussar.sync.manager.UpdateOrgManager;
import com.jxdinfo.hussar.sync.service.OrgansSyncService;
import com.jxdinfo.hussar.sync.service.SchemaAttrService;
import com.jxdinfo.hussar.sync.service.impl.IAMDataSyncServiceImpl;
import com.jxdinfo.hussar.sync.utils.IAMDataSyncUtil;
import com.jxdinfo.hussar.sync.vo.DataCreateVO;
import com.jxdinfo.hussar.sync.vo.IAMDataSyncResponse;
import com.jxdinfo.hussar.sync.vo.QueryAllOrgIdsVO;
import com.jxdinfo.hussar.sync.vo.QueryOrgByIdVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgansSyncServiceImpl
extends IAMDataSyncServiceImpl
implements OrgansSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrgansSyncServiceImpl.class);
    private static final String ACTIVATED = "0";
    private static final String DEACTIVATED = "1";
    private static final String SCHEMA_ATTR_ORGANIZATION_GROUP = "organization";
    private static final String ROOT_ORGAN_ID = "1";
    private static final String ROOT_ORGAN_TYPE = "11";
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ILocalOrganizationBoService localOrganizationBoService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private SysOrgManageService sysOrgManageService;
    @Autowired
    private SchemaAttrService schemaAttrService;
    @Autowired
    private AddOrgManager addOrgManager;
    @Autowired
    private UpdateOrgManager updateOrgManager;
    @Autowired
    private DeleteOrgManager deleteOrgManager;

    public IAMDataSyncResponse OrgCreateService(ObjectNode reqBody) {
        SysOrgan syncedSysOrgan;
        SysStru syncedSysStru;
        AddOutsideOrganizationDto addOutsideOrganizationDto;
        LOGGER.info("====================\u7ec4\u7ec7\u673a\u6784\u521b\u5efa\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        try {
            addOutsideOrganizationDto = (AddOutsideOrganizationDto)this.objectMapper.treeToValue((TreeNode)reqBody, AddOutsideOrganizationDto.class);
            syncedSysStru = (SysStru)this.objectMapper.treeToValue((TreeNode)reqBody, SysStru.class);
            syncedSysOrgan = (SysOrgan)this.objectMapper.treeToValue((TreeNode)reqBody, SysOrgan.class);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        SysOrgan sysOrgan = (SysOrgan)((LambdaQueryChainWrapper)this.sysOrganService.lambdaQuery().eq(SysOrgan::getOrganCode, (Object)reqBody.get("organCode").asText())).one();
        if (sysOrgan != null) {
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.REPETITIVE_ORGAN_CODE_ERR.getCode()).message(IAMDataSyncResponseStatus.REPETITIVE_ORGAN_CODE_ERR.getMessage()).response();
        }
        String parentOrganCode = this.getParentOrganCode(reqBody.get("parentId"));
        String organType = this.transferSyncedOrganType(reqBody.get("organType").asText());
        addOutsideOrganizationDto.setParentOrganCode(parentOrganCode);
        addOutsideOrganizationDto.setOrganType(organType);
        R<AddOutsideOrganizationDto> result = this.addOrgManager.doCreate(addOutsideOrganizationDto);
        if (HussarUtils.isNotEmpty((Object)result.getErrorList())) {
            List errorMsgs = ((Error)result.getErrorList().get(0)).getErrMsg().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            String errorMsg = String.join((CharSequence)" & ", errorMsgs);
            LOGGER.error(errorMsg);
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.ORG_CREATE_FAILURE.getCode()).message(errorMsg).response();
        }
        Long existedStruId = ((DataMapping)result.getSuccessList().get(0)).getId();
        SysStru existedSysStru = (SysStru)this.sysStruService.getById((Serializable)existedStruId);
        Long existedOrganId = existedSysStru.getOrganId();
        syncedSysStru.setId(existedStruId);
        syncedSysStru.setPrincipalId(Optional.ofNullable(syncedSysStru.getPrincipalId()).orElse(existedSysStru.getPrincipalId()));
        syncedSysStru.setStruType(organType);
        syncedSysStru.setParentId(existedSysStru.getParentId());
        this.sysStruService.updateById((Object)syncedSysStru);
        syncedSysOrgan.setId(existedOrganId);
        syncedSysOrgan.setOrganType(organType);
        this.sysOrganService.updateById((Object)syncedSysOrgan);
        return new DataCreateVO.DataCreateVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).uid(existedStruId.toString()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
    }

    public IAMDataSyncResponse OrgUpdateService(ObjectNode reqBody) {
        SysOrgan syncedSysOrgan;
        SysStru syncedSysStru;
        EditOutsideOrganizationDto editOutsideOrganizationDto;
        LOGGER.info("====================\u7ec4\u7ec7\u673a\u6784\u4fee\u6539\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        Long syncedStruId = reqBody.get("bimOrgId").asLong();
        SysStru existedSysStru = (SysStru)this.sysStruService.getById((Serializable)syncedStruId);
        if (existedSysStru == null) {
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getMessage()).response();
        }
        SysStru syncedParentOrgan = new SysStru();
        if (reqBody.get("parentId") != null) {
            Long parentStruId = reqBody.get("parentId").asLong();
            syncedParentOrgan = (SysStru)this.sysStruService.getById((Serializable)parentStruId);
        }
        if (syncedParentOrgan == null) {
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.PARENT_ORGAN_NOT_EXIST_ERR.getCode()).message(IAMDataSyncResponseStatus.PARENT_ORGAN_NOT_EXIST_ERR.getMessage()).response();
        }
        Long existedOrganId = existedSysStru.getOrganId();
        try {
            editOutsideOrganizationDto = (EditOutsideOrganizationDto)this.objectMapper.treeToValue((TreeNode)reqBody, EditOutsideOrganizationDto.class);
            syncedSysStru = (SysStru)this.objectMapper.treeToValue((TreeNode)reqBody, SysStru.class);
            syncedSysOrgan = (SysOrgan)this.objectMapper.treeToValue((TreeNode)reqBody, SysOrgan.class);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        if (HussarUtils.isNotEmpty((Object)reqBody.get("__ENABLE__"))) {
            String orgStatus = reqBody.get("__ENABLE__").asBoolean() ? ACTIVATED : "1";
            syncedSysStru.setId(syncedStruId);
            syncedSysStru.setDelFlag(orgStatus);
            syncedSysStru.setPrincipalId(Optional.ofNullable(syncedSysStru.getPrincipalId()).orElse(existedSysStru.getPrincipalId()));
            syncedSysStru.setLastTime(LocalDateTime.now());
            this.sysStruService.updateById((Object)syncedSysStru);
            syncedSysOrgan.setId(existedOrganId);
            syncedSysOrgan.setDelFlag(orgStatus);
            syncedSysOrgan.setLastTime(LocalDateTime.now());
            this.sysOrganService.updateById((Object)syncedSysOrgan);
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
        }
        SysOrgan existedOrgan = Optional.ofNullable(this.sysOrganService.getById((Serializable)existedOrganId)).orElseGet(SysOrgan::new);
        String existedOrganCode = existedOrgan.getOrganCode();
        boolean isDuplicateOrganCode = false;
        if (reqBody.get("organCode") != null) {
            String syncedOrganCode = reqBody.get("organCode").asText();
            boolean bl = isDuplicateOrganCode = reqBody.has("organCode") && !Objects.equals(existedOrganCode, syncedOrganCode) && this.sysOrganService.lambdaQuery().list().stream().anyMatch(organ -> Objects.equals(organ.getOrganCode(), syncedOrganCode));
        }
        if (isDuplicateOrganCode) {
            LOGGER.error(IAMDataSyncResponseStatus.ORGAN_CODE_ALREADY_EXISTS_ERR.getMessage());
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.ORGAN_CODE_ALREADY_EXISTS_ERR.getCode()).message(IAMDataSyncResponseStatus.ORGAN_CODE_ALREADY_EXISTS_ERR.getMessage()).response();
        }
        String parentOrganCode = this.localOrganizationBoService.findOrganizationById(syncedParentOrgan.getOrganId()).getOrganCode();
        editOutsideOrganizationDto.setOrganCode(existedOrganCode);
        editOutsideOrganizationDto.setOrganName(existedOrgan.getOrganName());
        editOutsideOrganizationDto.setOrganAlias(existedSysStru.getOrganAlias());
        editOutsideOrganizationDto.setOrganShortName(existedOrgan.getShortName());
        editOutsideOrganizationDto.setParentOrganCode(parentOrganCode);
        R<EditOutsideOrganizationDto> result = this.updateOrgManager.doUpdate(editOutsideOrganizationDto);
        if (HussarUtils.isNotEmpty((Object)result.getErrorList())) {
            List errorMsgs = ((Error)result.getErrorList().get(0)).getErrMsg().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            String errorMsg = String.join((CharSequence)" & ", errorMsgs);
            LOGGER.error(errorMsg);
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.ORG_UPDATE_FAILURE.getCode()).message(errorMsg).response();
        }
        syncedSysStru.setId(syncedStruId);
        syncedSysStru.setLastTime(LocalDateTime.now());
        syncedSysStru.setOrganAlias(syncedSysOrgan.getOrganName());
        syncedSysStru.setPrincipalId(Optional.ofNullable(syncedSysStru.getPrincipalId()).orElse(existedSysStru.getPrincipalId()));
        this.sysStruService.updateById((Object)syncedSysStru);
        syncedSysOrgan.setId(existedOrganId);
        syncedSysOrgan.setLastTime(LocalDateTime.now());
        this.sysOrganService.updateById((Object)syncedSysOrgan);
        return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
    }

    public IAMDataSyncResponse OrgDeleteService(ObjectNode reqBody) {
        LOGGER.info("====================\u7ec4\u7ec7\u673a\u6784\u5220\u9664\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        SysOrganVo deletedSysOrganVo = this.sysOrgManageService.getOrgInfoById(Long.valueOf(reqBody.get("bimOrgId").asLong()));
        if (deletedSysOrganVo == null) {
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getMessage()).response();
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysOrganService.lambdaUpdate().eq(SysOrgan::getId, (Object)deletedSysOrganVo.getOrganId())).set(HussarDelflagEntity::getDelFlag, (Object)"1")).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysStruService.lambdaUpdate().eq(SysStru::getOrganId, (Object)deletedSysOrganVo.getOrganId())).set(HussarDelflagEntity::getDelFlag, (Object)"1")).update();
        return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
    }

    public IAMDataSyncResponse QueryAllOrgIdsService(ObjectNode reqBody) {
        LOGGER.info("====================\u67e5\u8be2\u5168\u90e8\u7ec4\u7ec7\u673a\u6784id\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        List orgIdList = this.sysStruService.list().stream().map(SysStru::getId).filter(HussarUtils::isNotEmpty).map(String::valueOf).collect(Collectors.toList());
        orgIdList.remove("1");
        return new QueryAllOrgIdsVO.QueryAllOrgIdsVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).orgIdList(orgIdList).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
    }

    public IAMDataSyncResponse QueryOrgByIdService(ObjectNode reqBody) {
        LOGGER.info("====================\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u8be6\u60c5\u53c2\u6570====================\n{}", (Object)reqBody);
        String bimRequestId = reqBody.get("bimRequestId").asText();
        CheckUserNamePwdResult checkUserNamePwdResult = this.checkUserNamePwd(reqBody.get("bimRemoteUser").asText(), reqBody.get("bimRemotePwd").asText());
        switch (checkUserNamePwdResult) {
            case FAILURE: 
            case MISSING_CONFIGURATION: {
                LOGGER.error(checkUserNamePwdResult.getMessage());
                return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getCode()).message(IAMDataSyncResponseStatus.AUTHENTICATION_FAILURE.getMessage() + ":" + checkUserNamePwdResult.getMessage()).response();
            }
        }
        Long syncedStruId = reqBody.get("bimOrgId").asLong();
        SysStru existedSysStru = (SysStru)this.sysStruService.getById((Serializable)syncedStruId);
        if (existedSysStru == null) {
            LOGGER.error(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getMessage());
            return new IAMDataSyncResponse.IAMDataSyncResponseBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getCode()).message(IAMDataSyncResponseStatus.NO_SUCH_ORG_ERR.getMessage()).response();
        }
        SysOrgan existedSysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)Optional.ofNullable(existedSysStru.getOrganId()).orElse(0L));
        OrganizationBo existedOrganizationBo = this.localOrganizationBoService.findOrganizationById(syncedStruId);
        List schemaAttrs = this.schemaAttrService.getAttrNameByGroup(SCHEMA_ATTR_ORGANIZATION_GROUP);
        ObjectNode organInfo = this.objectMapper.createObjectNode();
        ObjectNode dealtStruNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedSysStru, schemaAttrs);
        ObjectNode dealtOrganNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedSysOrgan, schemaAttrs);
        ObjectNode dealtOrganizationBoNode = IAMDataSyncUtil.assembleSchemaAttrInfo(existedOrganizationBo, schemaAttrs);
        IAMDataSyncUtil.mergeObjectNodes(dealtStruNode, organInfo);
        IAMDataSyncUtil.mergeObjectNodes(dealtOrganNode, organInfo);
        IAMDataSyncUtil.mergeObjectNodes(dealtOrganizationBoNode, organInfo);
        return new QueryOrgByIdVO.QueryOrgByIdVOBuilder().bimRequestId(bimRequestId).resultCode(IAMDataSyncResponseStatus.SUCCESS.getCode()).organization(organInfo).message(IAMDataSyncResponseStatus.SUCCESS.getMessage()).response();
    }

    private String transferSyncedOrganType(String syncedOrganType) {
        switch (syncedOrganType) {
            case "0": {
                return TransferredOrganType.OUT_ORGAN_TYPE_0.get();
            }
            case "1": {
                return TransferredOrganType.OUT_ORGAN_TYPE_1.get();
            }
            case "2": {
                return TransferredOrganType.OUT_ORGAN_TYPE_2.get();
            }
        }
        return null;
    }

    private String getParentOrganCode(JsonNode parentIdNode) {
        if (parentIdNode == null) {
            return ROOT_ORGAN_TYPE;
        }
        Long parentId = parentIdNode.asLong();
        OrganizationBo parentOrganBO = this.localOrganizationBoService.findOrganizationById(parentId);
        return parentOrganBO.getOrganCode();
    }
}

