/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.manager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateOrgManager {
    @Autowired
    private ISysOrganService organService;
    @Autowired
    private ISysOfficeService sysOfficeService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Autowired
    private ISysStruService struService;
    @Autowired
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysUsersService sysUsersService;

    public R<EditOutsideOrganizationDto> doUpdate(EditOutsideOrganizationDto editOrganizationDto) {
        long count;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)editOrganizationDto);
        String organCode = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganCode());
        String newOrganCode = StringUtils.trimToEmpty((String)editOrganizationDto.getNewOrganCode());
        SysOrgan sysOrganTemp = (SysOrgan)((LambdaQueryChainWrapper)this.organService.lambdaQuery().eq(SysOrgan::getOrganCode, (Object)organCode)).one();
        if (sysOrganTemp == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)editOrganizationDto, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_ORG_CODE_FOUND.getMessage())});
        }
        if (HussarUtils.isNotBlank((CharSequence)newOrganCode) && !organCode.equals(newOrganCode) && (count = ((LambdaQueryChainWrapper)this.organService.lambdaQuery().eq(SysOrgan::getOrganCode, (Object)newOrganCode)).count().longValue()) > 0L) {
            OrganUtil.addErrorMsg((List)errors, (Object)editOrganizationDto, (String)"newOrganCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGANIZATION_CODE_DUPLICATION.getMessage())});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysOffice sysOffice = new SysOffice();
            SysOrgan sysOrgan = new SysOrgan();
            BeanUtils.copyProperties((Object)sysOrganTemp, (Object)sysOrgan);
            SysStru sysStru = new SysStru();
            this.initializationEdit(editOrganizationDto, sysStru, sysOrgan, sysOffice);
            this.sysStruMapper.updateById((Object)sysStru);
            this.organService.updateById((Object)sysOrgan);
            if (HussarUtils.isNotEmpty((Object)sysOffice)) {
                this.sysOfficeService.updateById((Object)sysOffice);
            }
            this.refreshStruSeq();
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationEdit(EditOutsideOrganizationDto editOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String organName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)editOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganDescription());
        String organAddress = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAddress());
        String parentOrganCode = editOrganizationDto.getParentOrganCode();
        String newOrganCode = StringUtils.trimToEmpty((String)editOrganizationDto.getNewOrganCode());
        Integer struOrder = editOrganizationDto.getStruOrder();
        Long parentId = this.getOrganId(parentOrganCode);
        SysStru sysStruT = (SysStru)((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().eq(SysStru::getOrganId, (Object)sysOrgan.getId())).one();
        Long struId = sysStruT.getId();
        SysOffice sysOfficeT = (SysOffice)((LambdaQueryChainWrapper)this.sysOfficeService.lambdaQuery().eq(SysOffice::getStruId, (Object)struId)).one();
        BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
        if (HussarUtils.isNotEmpty((Object)struOrder)) {
            sysStru.setStruOrder(struOrder);
        }
        if (!HussarUtils.equals((Object)parentId, (Object)sysStru.getParentId()) && !HussarUtils.isBlank((CharSequence)parentOrganCode)) {
            if (parentId.equals(Constants.ROOT_NODE_ID) || parentId.equals(Constants.OUT_STRU_NODE_ID)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
            }
            SysStru newSysStru = (SysStru)this.sysStruMapper.selectById((Serializable)parentId);
            SysOrgan sysOrganTemp = (SysOrgan)this.organService.getById((Serializable)newSysStru.getOrganId());
            if (!sysOrganTemp.getOrganProperty().equals(sysOrgan.getOrganProperty())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
            }
            this.validateTransferOrganization(sysStruT, newSysStru);
            if (HussarUtils.isEmpty((Object)struOrder)) {
                sysStru.setStruOrder((Integer)null);
            }
            this.doTransfer(sysOrgan, sysStru, newSysStru, newOrganCode);
        } else {
            String currentFname = sysOrgan.getOrganFname();
            String currentFCode = sysOrgan.getOrganFcode();
            String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + editOrganizationDto.getOrganName().trim();
            String newFCode = currentFCode;
            if (HussarUtils.isNotBlank((CharSequence)newOrganCode) && !sysOrgan.getOrganCode().equals(newOrganCode)) {
                SysOrgan parentOrg = this.sysStruMapper.getOrganInfoByDeparmentId(sysStru.getParentId());
                newFCode = parentOrg.getOrganFcode() + newOrganCode + "/";
                sysOrgan.setOrganCode(newOrganCode);
            }
            if (!Objects.equals(editOrganizationDto.getOrganName().trim(), sysOrgan.getOrganName()) || HussarUtils.isNotBlank((CharSequence)newOrganCode) && !currentFCode.equals(newOrganCode)) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode());
                wrapper.ne(SysOrgan::getId, (Object)sysOrgan.getId());
                List sysOrgans = this.organService.list((Wrapper)wrapper);
                for (SysOrgan temp : sysOrgans) {
                    temp.setOrganFname(temp.getOrganFname().replaceFirst(currentFname, newFname));
                    temp.setOrganFcode(temp.getOrganFcode().replace(currentFCode, newFCode));
                }
                this.organService.updateBatchById((Collection)sysOrgans);
            }
            sysOrgan.setOrganFname(currentFname.replaceFirst(currentFname, newFname));
            sysOrgan.setOrganFcode(newFCode);
        }
        sysStru.setOrganAlias(organAlias);
        sysOrgan.setShortName(organShortName);
        sysOffice.setOfficeAddress(organAddress);
        sysOffice.setOfficeAlias(organDescription);
        if (StringUtils.isNotBlank((CharSequence)userAccount)) {
            Long userId = this.getUserId(userAccount);
            sysStru.setPrincipalId(userId);
        } else {
            sysStru.setPrincipalId((Long)null);
        }
        if (StringUtils.isNotBlank((CharSequence)organName)) {
            sysOrgan.setOrganName(organName);
        }
    }

    private void validateTransferOrganization(SysStru oldSysStru, SysStru newSysStru) {
        if (newSysStru.getStruFid().contains(oldSysStru.getStruFid())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
        this.whetherComplianceWithOrganizationRule(oldSysStru, newSysStru);
    }

    private void whetherComplianceWithOrganizationRule(SysStru oldSysStru, SysStru newSysStru) {
        String oldOrganType = oldSysStru.getStruType();
        String newOrganType = newSysStru.getStruType();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruRule::getSysOrganType, (Object)newOrganType);
        wrapper.eq(SysStruRule::getOrganType, (Object)oldOrganType);
        long count = this.sysStruRuleMapper.selectCount((Wrapper)wrapper);
        if (count == 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MOVE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
    }

    private void doTransfer(SysOrgan sysOrgan, SysStru sysStru, SysStru newSysStru, String newOrganCode) {
        Long targetStruId = newSysStru.getId();
        AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
        Integer struOrder = sysStru.getStruOrder();
        if (HussarUtils.isEmpty((Object)struOrder)) {
            Integer maxOrder = this.sysStruMapper.getMaxOrderById(targetStruId);
            ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
            struOrder = orderTree.get();
        }
        this.organizationChange(sysOrgan, sysStru, newSysStru, struOrder, newOrganCode);
    }

    private void organizationChange(SysOrgan sysOrgan, SysStru sysStru, SysStru newSysStru, Integer order, String newOrganCode) {
        SysStru temp2;
        String struSeq;
        Long sourceStruId = sysStru.getId();
        Long targetStruId = newSysStru.getId();
        SysStru oldSysStru = (SysStru)this.sysStruMapper.selectById((Serializable)sourceStruId);
        SysOrgan parentOrg = this.sysStruMapper.getOrganInfoByDeparmentId(targetStruId);
        List strus = ((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().likeRight(SysStru::getStruFid, (Object)oldSysStru.getStruFid())).list();
        List organs = ((LambdaQueryChainWrapper)this.organService.lambdaQuery().likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode())).list();
        Map organsMap = organs.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity()));
        if (HussarUtils.isNotBlank((CharSequence)newOrganCode) && !sysOrgan.getOrganCode().equals(newOrganCode)) {
            ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganCode(newOrganCode);
            ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFcode(parentOrg.getOrganFcode() + newOrganCode + "/");
        } else {
            ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFcode(parentOrg.getOrganFcode() + sysOrgan.getOrganCode() + "/");
        }
        ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFname(parentOrg.getOrganFname() + "/" + sysOrgan.getOrganName());
        String struFid = newSysStru.getStruFid() + oldSysStru.getId() + "/";
        String struSeqT = struSeq = this.getStruSeq(newSysStru.getStruFid(), newSysStru.getStruSeq(), OrganUtil.getLevel((SysStru)newSysStru) + 1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(sourceStruId)).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            sysOrganT.setOrganProperty(parentOrg.getOrganProperty());
            stru.setStruFid(OrganUtil.convert((String)(struFid + stru.getId() + "/")));
            stru.setStruSeq(struSeqT + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            this.changeInfo((SysStru)stru, strus, organsMap);
            return stru;
        }).collect(Collectors.toList());
        for (SysStru temp2 : strus) {
            if (!Objects.equals(temp2.getId(), sourceStruId)) continue;
            temp2.setStruFid(OrganUtil.convert((String)struFid));
            temp2.setStruLevel(Integer.valueOf(temp2.getStruFid().split("/").length - 1));
            temp2.setStruSeq(struSeq);
            temp2.setStruOrder(order);
            temp2.setParentId(targetStruId);
        }
        SysOrgan organ = (SysOrgan)organsMap.get(sysOrgan.getId());
        temp2 = strus.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)oldSysStru.getId())).findFirst().get();
        BeanUtils.copyProperties((Object)organ, (Object)sysOrgan);
        BeanUtils.copyProperties((Object)temp2, (Object)sysStru);
        this.struService.updateBatchById((Collection)strus);
        this.organService.updateBatchById(organsMap.values());
        this.updateLeaf(oldSysStru, newSysStru);
    }

    private void changeInfo(SysStru root, List<SysStru> all, Map<Long, SysOrgan> organsMap) {
        SysOrgan rootOrgan = organsMap.get(root.getOrganId());
        all.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(rootOrgan.getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(rootOrgan.getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            stru.setStruFid(OrganUtil.convert((String)(root.getStruFid() + stru.getId() + "/")));
            stru.setStruSeq(root.getStruSeq() + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            if (Objects.equals(stru.getStruType(), "9")) {
                stru.setStruSeq(OrganUtil.getStruFidByLevel((String)stru.getStruSeq(), (int)(stru.getStruLevel() - 1)));
            }
            this.changeInfo((SysStru)stru, all, organsMap);
            return stru;
        }).collect(Collectors.toList());
    }

    private void updateLeaf(SysStru oldSysStru, SysStru newSysStru) {
        newSysStru.setIsLeaf("N");
        this.sysStruMapper.updateById((Object)newSysStru);
        Long sourceStruId = oldSysStru.getParentId();
        int struLevel = oldSysStru.getStruLevel();
        if (!oldSysStru.getStruType().equals("9") && struLevel > 1) {
            SysStru pSysStru = (SysStru)this.sysStruMapper.selectById((Serializable)sourceStruId);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStru::getParentId, (Object)sourceStruId);
            wrapper.ne(SysStru::getId, (Object)oldSysStru.getId());
            wrapper.ne(SysStru::getStruType, (Object)"9");
            Long count = this.sysStruMapper.selectCount((Wrapper)wrapper);
            pSysStru.setIsLeaf(count > 0L ? "N" : "Y");
            this.sysStruMapper.updateById((Object)pSysStru);
        }
    }

    private void refreshStruSeq() {
        List strus = this.sysStruMapper.selectList((Wrapper)null);
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(Constants.ROOT_NODE_ID) || organsEntity.getParentId().equals(Constants.OUT_STRU_NODE_ID)).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq("/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, strus);
            return stru;
        }).collect(Collectors.toList());
        this.struService.updateBatchById((Collection)strus);
    }

    private void setInfo(SysStru root, List<SysStru> strus) {
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq(root.getStruSeq() + "/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, strus);
            return stru;
        }).collect(Collectors.toList());
    }

    private String getStruSeq(String pFid, String pSeq, int level) {
        String maxStruSeq = this.sysStruMapper.getMaxStruSeq(pFid, level);
        return HussarUtils.isBlank((CharSequence)maxStruSeq) ? pSeq + "/0001" : this.getStruSeqByMaxStruSeq(maxStruSeq, pSeq, level);
    }

    private String getStruSeqByMaxStruSeq(String maxStruSeq, String pSeq, int level) {
        String struSeq = "";
        String[] arr = maxStruSeq.split("/");
        if (StringUtils.isNotBlank((CharSequence)pSeq)) {
            int len = arr.length - 1;
            if (len < level) {
                StringBuilder stringBuilder = new StringBuilder(maxStruSeq);
                for (int i = 0; i < level - len; ++i) {
                    stringBuilder.append("/0001");
                }
                struSeq = stringBuilder.toString();
            } else {
                struSeq = maxStruSeq.substring(0, maxStruSeq.lastIndexOf("/")) + "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
            }
        } else {
            struSeq = "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
        }
        return struSeq;
    }

    private Long getUserId(String userAccount) {
        if (HussarUtils.isBlank((CharSequence)userAccount)) {
            return null;
        }
        String userAccountTemp = userAccount;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            userAccountTemp = userAccountTemp.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)userAccountTemp)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode())).one();
        AssertUtil.isNotNull((Object)sysUsers, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        return sysUsers.getId();
    }

    private Long getOrganId(String organCode) {
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            return Constants.ROOT_NODE_ID;
        }
        if (organCode.equals(String.valueOf(Constants.ROOT_NODE_ID))) {
            return Constants.ROOT_NODE_ID;
        }
        if (organCode.equals(String.valueOf(Constants.OUT_STRU_NODE_ID))) {
            return Constants.OUT_STRU_NODE_ID;
        }
        SysOrgan sysOrganTemp = (SysOrgan)((LambdaQueryChainWrapper)this.organService.lambdaQuery().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)organCode))).one();
        AssertUtil.isNotNull((Object)sysOrganTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PARENT_ORGAN_NOT_FOUND.getMessage()));
        SysStru sysStruTemp = (SysStru)((LambdaQueryChainWrapper)this.struService.lambdaQuery().eq(SysStru::getOrganId, (Object)sysOrganTemp.getId())).one();
        AssertUtil.isNotNull((Object)sysStruTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PARENT_ORGAN_NOT_FOUND.getMessage()));
        return sysStruTemp.getId();
    }
}

