/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.eryuan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.sync.eryuan.dao.SyncUsersMapper;
import com.jxdinfo.hussar.sync.eryuan.service.ISyncUsersService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.SyncTenantStruUserStaffService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"springContextHolder"})
@Master
public class SyncUsersServiceImpl
extends HussarServiceImpl<SyncUsersMapper, SysUsers>
implements ISyncUsersService {
    @Autowired
    private SyncUsersMapper syncUsersMapper;
    @Autowired
    private ISysUsersAuditService sysUsersAuditService;
    @Autowired
    private ISysStaffAuditService sysStaffAuditService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private ISysStruStaffAuditService sysStruStaffAuditService;
    @Autowired
    private ISysStruUserAuditService sysStruUserAuditService;
    @Autowired
    private ICreateUserConfigService createUserConfigService;
    @Resource
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private SyncTenantStruUserStaffService syncTenantStruUserStaffService;

    public Integer getMaxOrder(Long corporationId) {
        return this.syncUsersMapper.getMaxOrder(corporationId);
    }

    public JSONObject deleteStaffAndUser(Long userId, Long staffId) {
        JSONObject result = new JSONObject();
        if (this.sysUsersAuditService.adjustEdit(userId)) {
            result.put("success", (Object)false);
            result.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
            return result;
        }
        if (!this.sysStaffAuditService.checkStaffCanOperate(staffId)) {
            result.put("success", (Object)false);
            result.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
            return result;
        }
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId), false);
        SysStaff staff = (SysStaff)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"staff_id", (Object)staffId), false);
        this.sysStaffAuditService.remove((Wrapper)new QueryWrapper().eq((Object)"staff_id", (Object)staffId));
        this.sysStruStaffAuditService.remove((Wrapper)new QueryWrapper().eq((Object)"staff_id", (Object)staffId));
        this.sysUsersAuditService.remove((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)staffId));
        this.sysStruUserAuditService.remove((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)staffId));
        if (ToolUtil.isNotEmpty((Object)user)) {
            user.setAccountStatus(UserStatus.DELETE.getCode());
            this.sysUsersService.updateById((Object)user);
        }
        if (ToolUtil.isNotEmpty((Object)staff)) {
            staff.setDelFlag("1");
            this.sysStaffService.updateById((Object)staff);
        }
        result.put("success", (Object)true);
        result.put("msg", (Object)"\u5220\u9664\u6210\u529f");
        return result;
    }

    public void addOrUpdateBatchStaffAndUser(List<SysUsers> userList, List<SysStaff> staffList, boolean opType) {
        ArrayList<SysStruStaff> struStaffList = new ArrayList<SysStruStaff>();
        ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
        ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
        if (opType) {
            this.sysStaffService.saveBatch(staffList);
            Iterator<SysStaff> iteratorStaff = staffList.iterator();
            for (SysUsers sysUser : userList) {
                while (iteratorStaff.hasNext()) {
                    if (!sysUser.getUserAccount().equals(iteratorStaff.next().getIdcard())) continue;
                    sysUser.setEmployeeId(iteratorStaff.next().getId());
                    iteratorStaff.remove();
                    break;
                }
                SysStruStaff sysStruStaff = new SysStruStaff();
                sysStruStaff.setStaffId(sysUser.getEmployeeId());
                sysStruStaff.setStruId(sysUser.getCorporationId());
                struStaffList.add(sysStruStaff);
                SysStruUser sysStruUser = new SysStruUser();
                sysStruUser.setStruId(sysUser.getCorporationId());
                sysStruUser.setUserId(sysUser.getId());
                struUserList.add(sysStruUser);
                SysUserRole userRole = new SysUserRole();
                userRole.setUserId(sysUser.getId());
                userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
                userRole.setAdminOption("1");
                userRole.setCreateTime(LocalDateTime.now());
                userRole.setLastTime(LocalDateTime.now());
                userRole.setCreator(sysUser.getId());
                userRole.setLastEditor(sysUser.getId());
                userRoleList.add(userRole);
                if (!this.createUserConfigService.getCreateUserSendEmail().booleanValue() || sysUser.geteMail() == null) continue;
                CreateUserSendMailUtil.sendMail((SysUsers)sysUser, (String)sysUser.getPassword());
            }
            this.sysUsersService.saveBatch(userList);
            this.sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue())).in(SysUserRole::getUserId, (Collection)userList.stream().map(SysUsers::getId).collect(Collectors.toList())));
            this.sysUserRoleService.saveBatch(userRoleList);
            this.sysStruStaffService.saveBatch(struStaffList);
            this.sysStruUserService.saveBatch(struUserList);
            this.syncTenantStruUserStaffService.syncAddUser(userList, struUserList, null);
        } else {
            List staffIds = staffList.stream().map(SysStaff::getId).collect(Collectors.toList());
            List userIds = userList.stream().map(SysUsers::getId).collect(Collectors.toList());
            List struIds = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getId, userIds)).stream().map(SysUsers::getCorporationId).collect(Collectors.toList());
            List delStruStaffList = this.sysStruStaffService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds)).in(SysStruStaff::getStruId, struIds));
            List delStruUserList = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds)).in(SysStruUser::getStruId, struIds));
            this.sysStruStaffService.removeByIds((Collection)delStruStaffList);
            this.sysStruUserService.removeByIds((Collection)delStruUserList);
            for (SysUsers sysUser : userList) {
                SysStruStaff sysStruStaff = new SysStruStaff();
                sysStruStaff.setStaffId(sysUser.getEmployeeId());
                sysStruStaff.setStruId(sysUser.getCorporationId());
                struStaffList.add(sysStruStaff);
                SysStruUser sysStruUser = new SysStruUser();
                sysStruUser.setStruId(sysUser.getCorporationId());
                sysStruUser.setUserId(sysUser.getId());
                struUserList.add(sysStruUser);
            }
            this.sysStaffService.updateBatchById(staffList);
            this.sysUsersService.updateBatchById(userList);
            this.sysStruStaffService.saveBatch(struStaffList);
            this.sysStruUserService.saveBatch(struUserList);
            List oldUserList = this.sysUsersService.listByIds(userIds);
            this.syncTenantStruUserStaffService.syncUpdateUser(userList, oldUserList, struUserList, delStruUserList, null);
        }
    }
}

