/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.eryuan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.authorization.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.handler.LogObjectHolder;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.organmanager.OrganChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.sync.eryuan.dao.SyncStruMapper;
import com.jxdinfo.hussar.sync.eryuan.dao.SysFormerlyStruRuleMapper;
import com.jxdinfo.hussar.sync.eryuan.service.ISyncFormerlyOrgService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncFormerlyOrgServiceImpl
extends HussarServiceImpl<SyncStruMapper, SysStru>
implements ISyncFormerlyOrgService {
    @Resource
    private ISysOrgEventService iSysOrgEventService;
    @Autowired
    private SysFormerlyStruRuleMapper sysStruRuleMapper;
    @Autowired
    private SyncStruMapper sysStruMapper;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Autowired
    private TransferOrganizationManager transferOrganizationManager;
    @Autowired
    private SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Autowired
    private OrganChangeNotify organChangeNotify;
    @Autowired
    private ISysStruAuditService sysStruAuditService;

    @Transactional(rollbackFor={Exception.class})
    public JSONObject orgTreeChangeVue(Long struId, Long parentId, String orgType, String isRoot, String parentStruLevel, Boolean ignoreFlag) {
        try {
            LogObjectHolder.me().set("transfer_before_parent", (Object)this.iSysOrgEventService.beforeOrgChange(struId, parentId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Map<String, Object>> map = this.sysStruRuleMapper.getOrgRoleById(parentId, orgType);
        if (ToolUtil.isNotEmpty((Object)isRoot) && "1".equals(isRoot)) {
            map = this.sysStruRuleMapper.getOrgTypeByType(orgType, isRoot);
        }
        JSONObject json = new JSONObject();
        if (!this.sysStruAuditService.checkCanOperate(struId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
            return json;
        }
        if (!this.sysStruAuditService.checkCanOperate(parentId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
            return json;
        }
        if (map.isEmpty()) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u8f6c\u79fb\u5931\u8d25\uff01\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01");
            return json;
        }
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = orderTree + maxOrder;
        }
        Integer level = Integer.parseInt(parentStruLevel) + 1;
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(struId);
        SysStru parentStru = (SysStru)this.sysStruMapper.selectById(parentId);
        if (parentStru.getStruFid().contains(sysStru.getStruFid())) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u8f6c\u79fb\u5931\u8d25\uff01\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01");
            return json;
        }
        this.orgCodeChange(sysStru, parentStru);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysStruAssistOrgan::getStruId, (Object)struId)).eq(SysStruAssistOrgan::getAssistParentId, (Object)parentId);
        this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
        SysOrgan sysOrgan = this.sysStruMapper.getOrganInfoByDeparmentId(struId);
        this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{struId, sysOrgan, null});
        this.iSysOrgEventService.afterOrgChangeVue(struId, parentId);
        try {
            LogObjectHolder.me().set("transfer_after_parent", (Object)this.iSysOrgEventService.afterOrgChange(struId, parentId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        json.put("success", (Object)true);
        json.put("msg", (Object)"");
        return json;
    }

    public void orgCodeChange(SysStru sysStru, SysStru parentStru) {
        Long struId = sysStru.getId();
        Long parentId = parentStru.getId();
        Integer changeLevel = parentStru.getStruLevel();
        AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
        ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
        Integer struOrder = orderTree.get();
        Integer level = changeLevel + 1;
        this.transferOrganizationManager.organizationChange(struId, parentId, sysStru.getStruType(), struOrder);
    }
}

