/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sso.service.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.sso.bo.HttpRequestBO;
import com.jxdinfo.hussar.sso.properties.SsoLoginProperty;
import com.jxdinfo.hussar.sso.utils.HttpURLConnectionUtil;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class SsoLoginServiceImpl
implements HussarLoginValidateService {
    @Resource
    private SsoLoginProperty ssoLoginProperties;

    public String getLoginType() {
        return "htszSsoLogin";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        return this.getUserAccount(this.getAccessToken(loginCode));
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    private String getAccessToken(String loginCode) {
        ImmutableMap params = ImmutableMap.of((Object)"code", (Object)loginCode, (Object)"client_id", (Object)this.ssoLoginProperties.getAppId(), (Object)"client_secret", (Object)this.ssoLoginProperties.getAppSecret(), (Object)"grant_type", (Object)this.ssoLoginProperties.getGrantType());
        HttpRequestBO requestDto = new HttpRequestBO.HttpRequestDtoBuilder().url(this.ssoLoginProperties.getTokenUrl()).params((Map<String, Object>)params).request();
        ObjectNode responseObj = (ObjectNode)HttpURLConnectionUtil.sendPost(requestDto);
        return responseObj.get("access_token").asText();
    }

    private String getUserAccount(String token) {
        ImmutableMap acquireUserInfoParams = ImmutableMap.of((Object)"access_token", (Object)token, (Object)"client_id", (Object)this.ssoLoginProperties.getAppId());
        HttpRequestBO acquireUserInfoRequestDto = new HttpRequestBO.HttpRequestDtoBuilder().url(this.ssoLoginProperties.getUserInfoUrl()).params((Map<String, Object>)acquireUserInfoParams).request();
        ObjectNode userInfoObj = (ObjectNode)HttpURLConnectionUtil.sendGet(acquireUserInfoRequestDto);
        return Optional.ofNullable(userInfoObj.get("loginName").asText()).orElse("");
    }
}

