/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.schedule.job;

import com.jxdinfo.hussar.audit.service.IBaseAuditLogService;
import com.jxdinfo.hussar.audit.vo.AuditLogSpaceUsageVo;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveJobService;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogArchiveProperties;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.schedule.job.auditSpaceUsageJob")
public class AuditSpaceUsageJob
implements BasicProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AuditSpaceUsageJob.class);
    @Autowired
    private IBaseAuditLogService baseAuditLogService;
    @Autowired
    private AuditLogProperties auditLogProperties;
    @Autowired
    private AuditLogArchiveProperties auditLogArchiveProperties;
    @Autowired
    private ISysBaseConfigService sysBaseConfigService;
    @Autowired(required=false)
    private ArchiveJobService archiveJobService;

    public ProcessResult process(TaskContext context) throws Exception {
        if (!this.auditLogProperties.getEnable()) {
            return new ProcessResult(true, "\u5ba1\u8ba1\u65e5\u5fd7\u672a\u5f00\u542f");
        }
        if (!this.auditLogArchiveProperties.getEnable()) {
            return new ProcessResult(true, "\u5ba1\u8ba1\u65e5\u5fd7\u5f52\u6863\u672a\u5f00\u542f");
        }
        if ("mongo".equals(this.auditLogProperties.getStorageType())) {
            return new ProcessResult(true, "\u5ba1\u8ba1\u65e5\u5fd7\u4f7f\u7528MongoDB\u5b58\u50a8\uff0c\u4e0d\u68c0\u67e5\u8868\u7a7a\u95f4\u5229\u7528\u7387");
        }
        logger.info("=================\u5f00\u59cb\u6267\u884c\u5ba1\u8ba1\u65e5\u5fd7\u8868\u7a7a\u95f4\u4f7f\u7528\u7387\u68c0\u67e5\u4efb\u52a1================");
        AuditLogSpaceUsageVo auditLogSpaceUsageVo = this.baseAuditLogService.getAuditLogSpaceUsageInfo();
        if (HussarUtils.isBlank((CharSequence)auditLogSpaceUsageVo.getLogAll()) || HussarUtils.isBlank((CharSequence)auditLogSpaceUsageVo.getLogUsed())) {
            return new ProcessResult(false, "\u672a\u83b7\u53d6\u5230\u5ba1\u8ba1\u65e5\u5fd7\u8868\u7a7a\u95f4\u4fe1\u606f\uff0cauditSpaceUsageVo:" + JsonUtil.toJson((Object)auditLogSpaceUsageVo));
        }
        SysBaseConfig threshold = this.sysBaseConfigService.getSysBaseConfig("master", "audit_log_threshold");
        if (HussarUtils.isEmpty((Object)threshold) || HussarUtils.isBlank((CharSequence)threshold.getConfigValue())) {
            return new ProcessResult(false, "\u672a\u83b7\u53d6\u5230\u5ba1\u8ba1\u65e5\u5fd7\u8868\u7a7a\u95f4\u4f7f\u7528\u7387\u9608\u503c");
        }
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("master", "over_threshold_auto_archive");
        if (HussarUtils.isEmpty((Object)baseConfig) || HussarUtils.isBlank((CharSequence)baseConfig.getConfigValue())) {
            return new ProcessResult(false, "\u672a\u83b7\u53d6\u5230[\u5230\u8fbe\u9608\u503c\u662f\u5426\u81ea\u52a8\u89e6\u53d1\u5f52\u6863\u914d\u7f6e]");
        }
        if (!"0".equals(baseConfig.getConfigValue())) {
            logger.info("[\u5230\u8fbe\u9608\u503c\u662f\u5426\u81ea\u52a8\u89e6\u53d1\u5f52\u6863\u914d\u7f6e]\u4e3a\u3010\u5173\u95ed\u3011\u72b6\u6001\uff0c\u65e0\u6cd5\u81ea\u52a8\u89e6\u53d1\u5f52\u6863\u4efb\u52a1");
            return new ProcessResult(false, "[\u5230\u8fbe\u9608\u503c\u662f\u5426\u81ea\u52a8\u89e6\u53d1\u5f52\u6863\u914d\u7f6e]\u4e3a\u3010\u5173\u95ed\u3011\u72b6\u6001\uff0c\u65e0\u6cd5\u81ea\u52a8\u89e6\u53d1\u5f52\u6863\u4efb\u52a1");
        }
        double logAll = Double.parseDouble(auditLogSpaceUsageVo.getLogAll());
        double logUsed = Double.parseDouble(auditLogSpaceUsageVo.getLogUsed());
        double logUsedPercent = logUsed / logAll * 100.0;
        logger.info("\u5ba1\u8ba1\u65e5\u5fd7\u8868\u7a7a\u95f4\u4f7f\u7528\u7387\uff1a{}%", (Object)logUsedPercent);
        int thresholdValue = Integer.parseInt(threshold.getConfigValue());
        if (logUsedPercent >= (double)thresholdValue) {
            logger.info("\u5ba1\u8ba1\u65e5\u5fd7\u8868\u7a7a\u95f4\u4f7f\u7528\u7387\u8d85\u51fa\u9608\u503c\uff0c\u9608\u503c\u4e3a{}%", (Object)thresholdValue);
            this.archiveJobService.archive();
        }
        logger.info("=================\u7ed3\u675f\u6267\u884c\u5ba1\u8ba1\u65e5\u5fd7\u8868\u7a7a\u95f4\u4f7f\u7528\u7387\u68c0\u67e5\u4efb\u52a1================");
        return new ProcessResult(true, "success");
    }
}

