/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.schedule.util;

import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.utils.PlaceholderFormatUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.mail.core.exceptions.MailException;
import com.jxdinfo.hussar.mail.util.HussarMailUtils;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class AccountStatusChangeMailUtil {
    private static final Logger logger = LoggerFactory.getLogger(AccountStatusChangeMailUtil.class);
    private static ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);

    public static void sendMail(String connName, SysUsers sysUsers, String status) {
        String mailSubject = "";
        String content = "";
        HashMap<String, String> map = new HashMap<String, String>();
        if (UserStatus.DORMANCY.getCode().equals(status)) {
            mailSubject = iSysBaseConfigService.getSysBaseConfig(connName, "status_change_email_title").getConfigValue();
            SysBaseConfig sysBaseConfig = iSysBaseConfigService.getSysBaseConfig(connName, "nologin_day");
            String noLoginDay = sysBaseConfig.getConfigValue();
            String statusName = UserStatus.DORMANCY.getMessage();
            content = iSysBaseConfigService.getSysBaseConfig(connName, "status_change_email").getConfigValue();
            map.put("nologin_day", noLoginDay);
            map.put("user_account_status", statusName);
            map.put("user_account", sysUsers.getUserAccount());
        }
        if (UserStatus.CANCEL.getCode().equals(status)) {
            mailSubject = iSysBaseConfigService.getSysBaseConfig(connName, "logout_warn_email_title").getConfigValue();
            String beforeLogout = iSysBaseConfigService.getSysBaseConfig(connName, "email_before_logout_day").getConfigValue();
            content = iSysBaseConfigService.getSysBaseConfig(connName, "logout_warn_email").getConfigValue();
            map.put("user_account", sysUsers.getUserAccount());
            map.put("email_before_logout_day", beforeLogout);
        }
        content = PlaceholderFormatUtils.format((String)content, map);
        try {
            HussarMailUtils.send((String)sysUsers.geteMail(), (String)mailSubject, (String)content, (boolean)true, (File[])new File[0]);
        }
        catch (MailException e) {
            logger.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff1a{}" + e.getMessage());
        }
    }

    public static void sendMail(SysUsers sysUsers, String status) {
        AccountStatusChangeMailUtil.sendMail("master", sysUsers, status);
    }
}

