/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.schedule.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.audit.service.IBaseAuditLogService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.schedule.util.SysAuditLogMailUtil;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.enums.AuditSeverityLevel;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.schedule.job.auditCountJob")
public class AuditCountJob
implements BasicProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AuditCountJob.class);
    @Autowired
    private IBaseAuditLogService baseAuditLogService;
    @Autowired
    private IGlobalService globalService;
    @Autowired(required=false)
    private ISysTenantService sysTenantService;

    public ProcessResult process(TaskContext context) throws Exception {
        String tenantCode = context.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode) || "0".equals(tenantCode)) {
            boolean tenantOpen = TenantCacheUtil.openTenant();
            HashSet<String> connNameList = new HashSet<String>();
            Map normalTenants = new HashMap<String, DefaultTenant>();
            if (tenantOpen) {
                Set tenantConnNameList = this.sysTenantService.getConnNameList();
                if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                    connNameList.addAll(tenantConnNameList);
                }
                normalTenants = this.sysTenantService.getNormalTenants();
            } else {
                connNameList.add("master");
                normalTenants.put("master", new DefaultTenant());
            }
            for (String connName : connNameList) {
                long count;
                HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
                if (hussarTenantDefinition == null) {
                    throw new BaseException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
                }
                HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
                Long tenantId = hussarTenantDefinition.getTenantId();
                if (tenantOpen) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(AuditLogEntity::getTenantId, (Object)tenantId);
                    count = this.baseAuditLogService.count((Wrapper)wrapper);
                } else {
                    count = this.baseAuditLogService.count();
                }
                int alertCount = this.globalService.getSecuritylogCountAlert(connName);
                if (alertCount != -1 && count >= (long)alertCount) {
                    if (tenantOpen) {
                        logger.info("===================\u79df\u6237ID:{} \u65e5\u5fd7\u62a5\u8b66\u9608\u503c\u53d1\u9001\u7ed9\u90ae\u4ef6START===================", (Object)tenantId);
                    } else {
                        logger.info("===================\u65e5\u5fd7\u62a5\u8b66\u9608\u503c\u53d1\u9001\u7ed9\u90ae\u4ef6START===================");
                    }
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u65e5\u5fd7\u544a\u8b66");
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.SECURITY_LOG);
                    auditLogModel.setSeverityLevel(AuditSeverityLevel.SERIOUS);
                    auditLogModel.setEventDesc("\u5ba1\u8ba1\u65e5\u5fd7\u8bb0\u5f55\u6570\u8d85\u51fa\u9608\u503c\u544a\u8b66");
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    SysAuditLogMailUtil.sendMail(connName, count);
                    if (tenantOpen) {
                        logger.info("===================\u79df\u6237ID:{} \u65e5\u5fd7\u62a5\u8b66\u9608\u503c\u53d1\u9001\u7ed9\u90ae\u4ef6END===================", (Object)tenantId);
                    } else {
                        logger.info("===================\u65e5\u5fd7\u62a5\u8b66\u9608\u503c\u53d1\u9001\u7ed9\u90ae\u4ef6END===================");
                    }
                }
                HussarContextHolder.remove();
            }
        }
        return new ProcessResult(true, "success");
    }
}

