/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.schedule.job;

import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.schedule.util.AccountStatusChangeMailUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountJob
implements BasicProcessor {
    private static Logger logger = LoggerFactory.getLogger(AccountJob.class);
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 1450757481235202050L, 1450757527330615298L, 1450757604556025858L, 1450757642371981314L, 679338378499727360L};
    @Autowired
    private ISysUsersService iSysUsersService;
    @Autowired(required=false)
    private ISysTenantService sysTenantService;

    public ProcessResult process(TaskContext context) throws Exception {
        String tenantCode = context.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode) || "0".equals(tenantCode)) {
            this.quartzJob();
        }
        return new ProcessResult(true, "success");
    }

    private void quartzJob() {
        boolean tenantOpen = TenantCacheUtil.openTenant();
        HashSet<String> connNameList = new HashSet<String>();
        Map normalTenants = new HashMap<String, DefaultTenant>();
        if (tenantOpen) {
            Set tenantConnNameList = this.sysTenantService.getConnNameList();
            if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                connNameList.addAll(tenantConnNameList);
            }
            normalTenants = this.sysTenantService.getNormalTenants();
        } else {
            connNameList.add("master");
            normalTenants.put("master", new DefaultTenant());
        }
        for (String connName : connNameList) {
            HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
            if (hussarTenantDefinition == null) {
                throw new BaseException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
            }
            HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
            try {
                List expireList = this.iSysUsersService.getExpireTemporaty(connName, Java8DateUtils.currentLocalDateTime());
                if (HussarUtils.isNotEmpty((Object)expireList)) {
                    expireList.removeIf(sysUsers -> ArrayUtils.contains((Object[])ADMINS, (Object)sysUsers.getId()));
                    expireList.forEach(o -> {
                        o.setAccountStatus(UserStatus.CANCEL.getCode());
                        o.setLockTime(Java8DateUtils.currentLocalDateTime());
                    });
                    this.iSysUsersService.updateBatchById(connName, (Collection)expireList);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            String status_dormancy = UserStatus.DORMANCY.getCode();
            List notLoginList = this.iSysUsersService.updateUserStatusToDormancy(connName, status_dormancy);
            if (CollectionUtils.isNotEmpty((Collection)notLoginList)) {
                for (SysUsers sysUsers2 : notLoginList) {
                    if (!StringUtils.isNotBlank((CharSequence)sysUsers2.geteMail())) continue;
                    AccountStatusChangeMailUtil.sendMail(connName, sysUsers2, status_dormancy);
                }
            }
            this.iSysUsersService.updateUserStatusToCancel(connName);
            String status_cancel = UserStatus.CANCEL.getCode();
            List logoutWarnList = this.iSysUsersService.getWillCancel(connName);
            if (CollectionUtils.isNotEmpty((Collection)logoutWarnList)) {
                for (SysUsers sysUsers3 : logoutWarnList) {
                    if (!StringUtils.isNotBlank((CharSequence)sysUsers3.geteMail())) continue;
                    AccountStatusChangeMailUtil.sendMail(connName, sysUsers3, status_cancel);
                }
            }
            HussarContextHolder.remove();
        }
    }
}

