/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.schedule.job;

import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.schedule.util.AccountStatusChangeMailUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountJob
implements BasicProcessor {
    private static Logger logger = LoggerFactory.getLogger(AccountJob.class);
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 1450757481235202050L, 1450757527330615298L, 1450757604556025858L, 1450757642371981314L, 679338378499727360L};
    private IDynamicDataSourceService dynamicDataSourceService = (IDynamicDataSourceService)SpringContextHolder.getBean(IDynamicDataSourceService.class);

    public ProcessResult process(TaskContext context) throws Exception {
        this.quartzJob();
        return new ProcessResult(true, "success");
    }

    private void quartzJob() {
        ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
        try {
            List expireList = iSysUsersService.getExpireTemporaty(Java8DateUtils.currentLocalDateTime());
            if (HussarUtils.isNotEmpty((Object)expireList)) {
                expireList.removeIf(sysUsers -> ArrayUtils.contains((Object[])ADMINS, (Object)sysUsers.getId()));
                expireList.forEach(o -> {
                    o.setAccountStatus(UserStatus.CANCEL.getCode());
                    o.setLockTime(Java8DateUtils.currentLocalDateTime());
                });
                iSysUsersService.updateBatchById((Collection)expireList);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String status_dormancy = UserStatus.DORMANCY.getCode();
        List notLoginList = iSysUsersService.updateUserStatusToDormancy(status_dormancy);
        if (CollectionUtils.isNotEmpty((Collection)notLoginList)) {
            for (SysUsers sysUsers2 : notLoginList) {
                if (!StringUtils.isNotBlank((CharSequence)sysUsers2.geteMail())) continue;
                AccountStatusChangeMailUtil.sendMail(sysUsers2, status_dormancy);
            }
        }
        iSysUsersService.updateUserStatusToCancel();
        String status_cancel = UserStatus.CANCEL.getCode();
        List logoutWarnList = iSysUsersService.getWillCancel();
        if (CollectionUtils.isNotEmpty((Collection)logoutWarnList)) {
            for (SysUsers sysUsers3 : logoutWarnList) {
                if (!StringUtils.isNotBlank((CharSequence)sysUsers3.geteMail())) continue;
                AccountStatusChangeMailUtil.sendMail(sysUsers3, status_cancel);
            }
        }
    }
}

