/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.schedule.job;

import com.jxdinfo.hussar.audit.service.IBaseAuditLogService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.schedule.util.SysAuditLogMailUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditCountJob
implements BasicProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AuditCountJob.class);
    private IBaseAuditLogService baseAuditLogService = (IBaseAuditLogService)SpringContextHolder.getBean(IBaseAuditLogService.class);
    private static IGlobalService globalService = (IGlobalService)SpringContextHolder.getBean(IGlobalService.class);

    public ProcessResult process(TaskContext taskContext) throws Exception {
        long now = this.baseAuditLogService.count();
        int alertCount = globalService.getSecuritylogCountAlert();
        if (alertCount != -1 && now >= (long)alertCount) {
            logger.info("===================\u65e5\u5fd7\u62a5\u8b66\u9608\u503c\u53d1\u9001\u7ed9\u90ae\u4ef6START===================");
            SysAuditLogMailUtil.sendMail(now);
            logger.info("===================\u65e5\u5fd7\u62a5\u8b66\u9608\u503c\u53d1\u9001\u7ed9\u90ae\u4ef6END===================");
        }
        return new ProcessResult(true, "success");
    }
}

