/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.schedule.job;

import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.schedule.util.AccountStatusChangeMailUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountJob
implements BasicProcessor {
    private static Logger logger = LoggerFactory.getLogger(AccountJob.class);
    private HussarBaseProperties hussarBaseProperties = (HussarBaseProperties)SpringContextHolder.getBean(HussarBaseProperties.class);
    private IDynamicDataSourceService dynamicDataSourceService = (IDynamicDataSourceService)SpringContextHolder.getBean(IDynamicDataSourceService.class);
    private static CountDownLatch latch;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        if (this.hussarBaseProperties.isTenantOpen()) {
            this.createThread();
        } else {
            this.quartzJob();
        }
        return new ProcessResult(true, "success");
    }

    private void quartzJob() {
        ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
        try {
            List expireList = iSysUsersService.getExpireTemporaty(Java8DateUtils.currentLocalDateTime());
            expireList.forEach(o -> o.setAccountStatus(UserStatus.CANCEL.getCode()));
            iSysUsersService.updateBatchById((Collection)expireList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String status_dormancy = UserStatus.DORMANCY.getCode();
        List notLoginList = iSysUsersService.updateUserStatusToDormancy(status_dormancy);
        if (CollectionUtils.isNotEmpty((Collection)notLoginList)) {
            for (SysUsers sysUsers : notLoginList) {
                if (!StringUtils.isNotBlank((CharSequence)sysUsers.geteMail())) continue;
                AccountStatusChangeMailUtil.sendMail(sysUsers, status_dormancy);
            }
        }
        iSysUsersService.updateUserStatusToCancel();
        String status_cancel = UserStatus.CANCEL.getCode();
        List logoutWarnList = iSysUsersService.getWillCancel();
        if (CollectionUtils.isNotEmpty((Collection)logoutWarnList)) {
            for (SysUsers sysUsers : logoutWarnList) {
                if (!StringUtils.isNotBlank((CharSequence)sysUsers.geteMail())) continue;
                AccountStatusChangeMailUtil.sendMail(sysUsers, status_cancel);
            }
        }
    }

    private void createThread() {
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextHolder.getBean(SysDataSourceService.class);
        List sysDataSourceList = sysDataSourceService.getAllTenantDataSource();
        latch = new CountDownLatch(sysDataSourceList.size() + 1);
        QuartzThread quartzThread = new QuartzThread(null);
        quartzThread.start();
        if (ToolUtil.isNotEmpty((Object)sysDataSourceList)) {
            DruidProperties druidProperties = (DruidProperties)SpringContextHolder.getBean(DruidProperties.class);
            for (SysDataSource sysDataSource : sysDataSourceList) {
                boolean flag = true;
                try {
                    if (ToolUtil.isEmpty((Object)this.dynamicDataSourceService.getDataSource(sysDataSource.getConnName()))) {
                        flag = false;
                    }
                }
                catch (RuntimeException ex) {
                    logger.error(ex.getMessage());
                    flag = false;
                }
                if (!flag) {
                    DynamicDataSourceDto dynamicDataSourceDto = new DynamicDataSourceDto();
                    dynamicDataSourceDto.setPoolName(sysDataSource.getConnName());
                    dynamicDataSourceDto.setDriverClassName(sysDataSource.getDriverClass());
                    dynamicDataSourceDto.setUrl(sysDataSource.getJdbcUrl());
                    dynamicDataSourceDto.setUserName(sysDataSource.getUserName());
                    dynamicDataSourceDto.setPassword(sysDataSource.getPassword());
                    this.dynamicDataSourceService.addDataSource(dynamicDataSourceDto);
                }
                QuartzThread tenantThread = new QuartzThread(sysDataSource.getConnName());
                tenantThread.start();
            }
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    @HussarDs(value="#dbName")
    private void changeTempDs(String dbName) {
        try {
            this.quartzJob();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            latch.countDown();
        }
    }

    private class QuartzThread
    extends Thread {
        private String dbName;

        @Override
        public void run() {
            if (this.dbName != null) {
                AccountJob.this.changeTempDs(this.dbName);
            } else {
                try {
                    AccountJob.this.quartzJob();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
            }
        }

        QuartzThread(String dbName) {
            this.dbName = dbName;
        }
    }
}

