/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ureport.provider;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.ReportProvider;
import com.jxdinfo.hussar.ureport.dao.UreportFileMapper;
import com.jxdinfo.hussar.ureport.model.UreportFileEntity;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UreportProvider
implements ReportProvider {
    private static final String NAME = "provider";
    private String prefix = "report";
    private boolean disabled = false;
    @Autowired
    private UreportFileMapper ureportFileMapper;

    public InputStream loadReport(String file) {
        UreportFileEntity ureportFileEntity = this.ureportFileMapper.queryUreportFileEntityByName(this.getCorrectName(file));
        byte[] content = ureportFileEntity.getContent();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        return inputStream;
    }

    public void deleteReport(String file) {
        this.ureportFileMapper.deleteReportFileByName(this.getCorrectName(file));
    }

    public List<ReportFile> getReportFiles() {
        List<UreportFileEntity> list = this.ureportFileMapper.queryReportFileList();
        ArrayList<ReportFile> reportList = new ArrayList<ReportFile>();
        for (UreportFileEntity ureportFileEntity : list) {
            reportList.add(new ReportFile(ureportFileEntity.getName(), ureportFileEntity.getUpdateTime()));
        }
        return reportList;
    }

    public void saveReport(String file, String content) {
        file = this.getCorrectName(file);
        UreportFileEntity ureportFileEntity = this.ureportFileMapper.queryUreportFileEntityByName(file);
        Date currentDate = new Date();
        if (ureportFileEntity == null) {
            ureportFileEntity = new UreportFileEntity();
            ureportFileEntity.setId(IdWorker.get32UUID());
            ureportFileEntity.setName(file);
            ureportFileEntity.setContent(content.getBytes());
            ureportFileEntity.setCreateTime(currentDate);
            ureportFileEntity.setUpdateTime(currentDate);
            this.ureportFileMapper.insertReportFile(ureportFileEntity);
        } else {
            ureportFileEntity.setContent(content.getBytes());
            ureportFileEntity.setUpdateTime(currentDate);
            this.ureportFileMapper.updateReportFile(ureportFileEntity);
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean disabled() {
        return this.disabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private String getCorrectName(String name) {
        if (name.startsWith(this.prefix)) {
            name = name.substring(this.prefix.length(), name.length());
        }
        return name;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setUreportFileMapper(UreportFileMapper ureportFileMapper) {
        this.ureportFileMapper = ureportFileMapper;
    }
}

