/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.sync.union.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.authorization.permit.dto.UpdateResourceDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.sync.sync.union.dto.ConversionProduct;
import com.jxdinfo.hussar.sync.sync.union.dto.SyncGroupDto;
import com.jxdinfo.hussar.sync.sync.union.dto.SyncReportDto;
import com.jxdinfo.hussar.sync.sync.union.service.ReportSyncService;
import com.jxdinfo.hussar.sync.sync.union.util.SyncUnionConverter;
import com.jxdinfo.hussar.sync.sync.union.util.SyncUnionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ReportSyncUnionServiceImpl
implements ReportSyncService {
    @Resource
    private ISysFunctionModulesBoService functionModulesBoService;
    @Resource
    private ISysFunctionsBoService functionsBoService;
    @Resource
    private ISysResourceMosulesBoService resourceMosulesBoService;
    @Autowired
    private IHussarBaseResourceService hussarBaseResourceService;
    @Resource
    private ISysFunctionResourcesBoService functionResourcesBoService;
    @Resource(name="com.jxdinfo.hussar.sync.sync.union.util.SyncUnionConverter")
    private SyncUnionConverter syncUnionConverter;
    @Resource
    private ISysMenuManageBoService menuBoService;
    @Resource(name="com.jxdinfo.hussar.sync.sync.union.util.SyncUnionHelper")
    private SyncUnionHelper syncHelper;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysRolesExternalService rolesExternalService;
    private static final Integer REPORT_ORDER = 999;
    private static final Integer GROUP_ORDER = 666;
    private static final Long SUPERADMIN_ID = 1450785135866925066L;
    private static final Long DEVELOP_ID = 690264237607755776L;
    private final Logger LOGGER = LoggerFactory.getLogger(ReportSyncUnionServiceImpl.class);

    @Override
    @HussarTransactional(rollbackFor={Exception.class})
    public void syncReportGroup(String type, SyncGroupDto sysReportGroup) {
        switch (type) {
            case "add": {
                this.addReportGroup(sysReportGroup);
                break;
            }
            case "edit": {
                this.editReportGroup(sysReportGroup);
                break;
            }
            case "del": {
                this.delReportGroup(sysReportGroup);
                break;
            }
            default: {
                throw new HussarException("\u8868\u5355\u5206\u7ec4\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void addReportGroup(SyncGroupDto sysReportGroup) {
        this.saveConversionProduct(this.syncUnionConverter.reportGroupToModule(sysReportGroup, null));
    }

    private void editReportGroup(SyncGroupDto sysReportGroup) {
        if (HussarUtils.isNotEmpty((Object)sysReportGroup.getGroupName())) {
            UpdateResourceDto updateResourceDto = new UpdateResourceDto();
            updateResourceDto.setName(sysReportGroup.getGroupName());
            updateResourceDto.setLangKey("");
            if (ReportSyncUnionServiceImpl.hasField(updateResourceDto, "id")) {
                updateResourceDto.setId(sysReportGroup.getGroupId());
                this.functionModulesBoService.updateNameById(updateResourceDto);
                this.resourceMosulesBoService.updateNameById(updateResourceDto);
            } else {
                LambdaUpdateWrapper funWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)funWrapper.eq(SysFunctionModules::getId, (Object)sysReportGroup.getGroupId())).set(HussarUtils.isNotBlank((CharSequence)sysReportGroup.getGroupName()), SysFunctionModules::getFunctionModuleName, (Object)sysReportGroup.getGroupName());
                this.sysFunctionModulesService.update((Wrapper)funWrapper);
                LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(HussarUtils.isNotBlank((CharSequence)sysReportGroup.getGroupName()), SysResourceModules::getModuleName, (Object)sysReportGroup.getGroupName())).eq(SysResourceModules::getId, (Object)sysReportGroup.getGroupId());
                this.sysResourceMosulesService.update((Wrapper)wrapper);
            }
        }
    }

    private void delReportGroup(SyncGroupDto sysReportGroup) {
        this.functionModulesBoService.deleteById(sysReportGroup.getGroupId());
        this.resourceMosulesBoService.deleteOneResourceModulesById(sysReportGroup.getGroupId());
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
    }

    @Override
    @HussarTransactional(rollbackFor={Exception.class})
    public void syncReport(String type, SyncReportDto sysReport) {
        switch (type) {
            case "add": {
                this.addReport(sysReport);
                break;
            }
            case "edit": {
                this.editReport(sysReport);
                break;
            }
            case "del": {
                this.delReport(sysReport);
                break;
            }
            case "sort": {
                this.sortReport(sysReport);
                break;
            }
            default: {
                throw new HussarException("\u8868\u5355\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void addReport(SyncReportDto sysReport) {
        ConversionProduct conversionProduct = new ConversionProduct();
        this.syncUnionConverter.reportToModule(sysReport, conversionProduct);
        String resourceCode = "menu_" + sysReport.getReportId();
        String functionCode = "menu_" + sysReport.getReportId();
        SysResources res = new SysResources();
        SysResources sysResources = this.hussarBaseResourceService.getResourcesByCode(resourceCode);
        Long resId = HussarUtils.isNotEmpty((Object)sysResources) ? sysResources.getId() : IdWorker.getId((Object)res);
        res.setId(resId);
        res.setResourceName(sysReport.getReportName());
        res.setResourceAlias(sysReport.getReportName());
        res.setModuleId(sysReport.getReportId());
        res.setPath(sysReport.getPath() + sysReport.getReportId());
        res.setComponent(sysReport.getPath() + sysReport.getReportId());
        res.setResTypeId("res_menu");
        res.setStrategy(sysReport.getStrategy());
        res.setResourceCode(resourceCode);
        res.setSeq(Integer.valueOf(conversionProduct.getResourceList().size() + 1));
        res.setApplicationId(Long.valueOf(1L));
        if (ReportSyncUnionServiceImpl.hasField(res, "appId")) {
            res.setAppId(null);
            if (ReportSyncUnionServiceImpl.hasField(res, "report")) {
                res.setResSource("report");
            }
        }
        res.setKeepAlive("1");
        conversionProduct.getResourceList().add(res);
        SysFunctions sysFunctions = this.functionsBoService.getOneByCode(functionCode);
        SysFunctions fun = new SysFunctions();
        Long funId = HussarUtils.isNotEmpty((Object)sysFunctions) ? sysFunctions.getId() : IdWorker.getId((Object)fun);
        fun.setId(funId);
        fun.setFunctionCode(functionCode);
        fun.setFunctionModuleId(sysReport.getReportId());
        fun.setFunctionName(sysReport.getReportName());
        fun.setDefaultResourceId(res.getId());
        fun.setSeq(Integer.valueOf(conversionProduct.getFunctionList().size() + 1));
        fun.setApplicationId(Long.valueOf(1L));
        if (ReportSyncUnionServiceImpl.hasField(fun, "appId")) {
            fun.setAppId(null);
            if (ReportSyncUnionServiceImpl.hasField(fun, "report")) {
                fun.setFunSource("report");
            }
        }
        conversionProduct.getFunctionList().add(fun);
        conversionProduct.getFunctionResourceList().add(this.syncUnionConverter.newFunRes(fun.getId(), res.getId()));
        this.saveConversionProduct(conversionProduct);
    }

    private void editReport(SyncReportDto sysReport) {
        boolean haveGroup = HussarUtils.isNotEmpty((Object)sysReport.getGroupId());
        Long moduleId = haveGroup ? sysReport.getGroupId() : sysReport.getParentModelId();
        this.functionModulesBoService.updateParentAndNameById(sysReport.getReportId(), moduleId, null);
        this.resourceMosulesBoService.updateParentAndNameById(sysReport.getReportId(), moduleId, null);
        if (HussarUtils.isNotEmpty((Object)sysReport.getReportName())) {
            UpdateResourceDto updateResourceDto = new UpdateResourceDto();
            updateResourceDto.setName(sysReport.getReportName());
            updateResourceDto.setLangKey("");
            updateResourceDto.setCode("menu_" + sysReport.getReportId());
            if (ReportSyncUnionServiceImpl.hasField(updateResourceDto, "id")) {
                updateResourceDto.setId(sysReport.getReportId());
                this.functionModulesBoService.updateNameById(updateResourceDto);
                this.resourceMosulesBoService.updateNameById(updateResourceDto);
                this.functionsBoService.updateNameByCode(updateResourceDto);
            } else {
                LambdaUpdateWrapper funWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)funWrapper.eq(SysFunctionModules::getId, (Object)sysReport.getReportId())).set(HussarUtils.isNotBlank((CharSequence)sysReport.getReportName()), SysFunctionModules::getFunctionModuleName, (Object)sysReport.getReportName());
                this.sysFunctionModulesService.update((Wrapper)funWrapper);
                LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(HussarUtils.isNotBlank((CharSequence)sysReport.getReportName()), SysResourceModules::getModuleName, (Object)sysReport.getReportName())).eq(SysResourceModules::getId, (Object)sysReport.getReportId());
                this.sysResourceMosulesService.update((Wrapper)wrapper);
                LambdaUpdateWrapper funcUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysFunctions::getFunctionCode, (Object)("menu_" + sysReport.getReportId()))).set(HussarUtils.isNotBlank((CharSequence)sysReport.getReportName()), SysFunctions::getFunctionName, (Object)sysReport.getReportName());
                this.sysFunctionsService.update((Wrapper)funcUpdateWrapper);
            }
            updateResourceDto.setAlias(sysReport.getReportName());
            this.hussarBaseResourceService.updateNameAliasByCode(updateResourceDto);
            HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
        }
    }

    private void delReport(SyncReportDto sysReport) {
        Long reportId = sysReport.getReportId();
        Long menuFunId = this.syncHelper.getMenuFunId(reportId);
        List<Long> allFunIdsByForm = this.syncHelper.listFunIdsByForm(reportId);
        List<Long> allResIdsByForm = this.syncHelper.listResIdsByForm(reportId);
        this.functionModulesBoService.deleteById(reportId);
        this.resourceMosulesBoService.deleteOneResourceModulesById(reportId);
        this.functionsBoService.deleteByid(allFunIdsByForm);
        this.hussarBaseResourceService.deleteResourcesByIds(allResIdsByForm);
        if (HussarUtils.isNotEmpty(allFunIdsByForm) && HussarUtils.isNotEmpty(allResIdsByForm)) {
            this.functionResourcesBoService.deleteByFunAndResId(allFunIdsByForm, allResIdsByForm);
        }
        if (HussarUtils.isNotEmpty((Object)menuFunId)) {
            this.menuBoService.delByFunId(Collections.singletonList(menuFunId));
            HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
        }
        HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
    }

    private void sortReport(SyncReportDto sysReport) {
        boolean haveGroup = HussarUtils.isNotEmpty((Object)sysReport.getGroupId());
        Long moduleId = haveGroup ? sysReport.getGroupId() : sysReport.getParentModelId();
        this.functionModulesBoService.updateParentAndNameById(sysReport.getReportId(), moduleId, null);
        this.resourceMosulesBoService.updateParentAndNameById(sysReport.getReportId(), moduleId, null);
    }

    private void saveConversionProduct(ConversionProduct conversionProduct) {
        if (HussarUtils.isNotEmpty(conversionProduct.getFunctionModulesList())) {
            this.functionModulesBoService.saveAll(conversionProduct.getFunctionModulesList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getResourceModulesList())) {
            this.resourceMosulesBoService.saveResourceModules(conversionProduct.getResourceModulesList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getFunctionList())) {
            this.functionsBoService.saveAllFunctions(conversionProduct.getFunctionList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getResourceList())) {
            this.hussarBaseResourceService.saveBatchResource(conversionProduct.getResourceList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getFunctionResourceList())) {
            this.functionResourcesBoService.saveAllFunRes(conversionProduct.getFunctionResourceList());
        }
    }

    public static boolean hasField(Object obj, String fieldName) {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                clazz.getDeclaredField(fieldName);
                return true;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return false;
    }

    @Override
    public void addMenu(SyncReportDto report) {
        if (!this.hasMethod(this.menuBoService, "insertOrUpdateMenuList", List.class)) {
            return;
        }
        SysMenu sysMenu = this.reportToMenu(report);
        ArrayList<SysMenu> menuList = new ArrayList<SysMenu>();
        if (HussarUtils.isNotEmpty((Object)report.getGroupId())) {
            SysMenu groupMenu = this.groupToMenu(report);
            menuList.add(groupMenu);
        }
        List<Long> allFunIdsByForm = this.syncHelper.listFunIdsByForm(report.getReportId());
        List<Long> allResIdsByForm = this.syncHelper.listResIdsByForm(report.getReportId());
        menuList.add(sysMenu);
        this.menuBoService.insertOrUpdateMenuList(menuList);
        ArrayList<SysRoleFunctions> roleFunctions = new ArrayList<SysRoleFunctions>();
        if (HussarUtils.isNotEmpty(allFunIdsByForm)) {
            for (Long funId : allFunIdsByForm) {
                roleFunctions.add(this.syncUnionConverter.newRoleFun(SUPERADMIN_ID, funId));
                roleFunctions.add(this.syncUnionConverter.newRoleFun(DEVELOP_ID, funId));
            }
        }
        if (HussarUtils.isNotEmpty(roleFunctions)) {
            this.rolesExternalService.saveAllRoleFun(roleFunctions);
        }
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        if (HussarUtils.isNotEmpty(allResIdsByForm)) {
            for (Long resId : allResIdsByForm) {
                roleResourceList.add(this.syncUnionConverter.newRoleRes(SUPERADMIN_ID, resId));
                roleResourceList.add(this.syncUnionConverter.newRoleRes(DEVELOP_ID, resId));
            }
        }
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
    }

    @Override
    public void delMenu(Long reportId) {
        Long menuFunId = this.syncHelper.getMenuFunId(reportId);
        this.menuBoService.delByFunId(Collections.singletonList(menuFunId));
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
    }

    public SysMenu reportToMenu(SyncReportDto report) {
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(report.getReportId());
        sysMenu.setText(report.getReportName());
        sysMenu.setMenuAlias(report.getReportName());
        if (HussarUtils.isNotEmpty((Object)report.getGroupId())) {
            sysMenu.setParentId(report.getGroupId());
        } else {
            sysMenu.setParentId(Long.valueOf(3L));
        }
        sysMenu.setIsLeaf("1");
        sysMenu.setIcons(report.getReportIcon());
        sysMenu.setOpenType("inside");
        sysMenu.setMenuType("1");
        sysMenu.setOpenMode("0");
        sysMenu.setIfDisplay("1");
        sysMenu.setPath(ReportSyncUnionServiceImpl.asmResPath(report));
        sysMenu.setComponent(null);
        SysFunctions sysFunctions = this.functionsBoService.getOneByCode("menu_" + report.getReportId());
        sysMenu.setFunctionId(sysFunctions.getId());
        return sysMenu;
    }

    public SysMenu groupToMenu(SyncGroupDto reportGroup) {
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(reportGroup.getGroupId());
        sysMenu.setText(reportGroup.getGroupName());
        sysMenu.setMenuAlias(reportGroup.getGroupName());
        sysMenu.setParentId(Long.valueOf(3L));
        sysMenu.setIsLeaf("0");
        if (HussarUtils.equals((Object)"2", (Object)reportGroup.getGroupIcon())) {
            sysMenu.setIcons("caidan-1Jmoren");
        } else {
            sysMenu.setIcons(reportGroup.getGroupIcon());
        }
        sysMenu.setOpenType("inside");
        sysMenu.setMenuType("1");
        sysMenu.setOpenMode("0");
        sysMenu.setIfDisplay("1");
        return sysMenu;
    }

    public static String asmResPath(SyncReportDto report) {
        return report.getPath() + report.getReportId();
    }

    private boolean hasMethod(Object obj, String methodName, Class<?> ... paramTypes) {
        try {
            obj.getClass().getMethod(methodName, paramTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

