/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.report.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.application.Util.HussarReportThreadUtil;
import com.jxdinfo.hussar.application.enums.ReportErrorCodeEnum;
import com.jxdinfo.hussar.application.report.Dto.ReportErrorDto;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportExpImpService;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.application.reportgroup.model.SysReportGroup;
import com.jxdinfo.hussar.application.reportgroup.service.ISysReportGroupService;
import com.jxdinfo.hussar.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.mail.core.exceptions.IORuntimeException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.report.service.impl.SysReportExpImpServiceImpl")
public class SysReportExpImpServiceImpl
implements ISysReportExpImpService {
    @Value(value="${hussar-formdesign.workspace}")
    private String workspace;
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private ISysReportService sysReportService;
    @Resource
    private ISysReportGroupService sysReportGroupService;
    @Resource
    private IDataSetService dataSetService;
    private static Logger logger = LoggerFactory.getLogger(SysReportExpImpServiceImpl.class);
    @Autowired
    private OssService ossService;
    private static final int MAX_NAME = 50;
    private static final int START_NAME = 0;

    public Void export(List<Long> reportId) {
        HussarReportThreadUtil.executeDesignTask(() -> {
            try {
                this.exportReport(reportId);
            }
            catch (Exception e) {
                ToolUtil.getLogger(SysReportExpImpServiceImpl.class).error("\u5bfc\u51fa\u62a5\u8868\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            TransmittableThreadLocalHolder.clear((String)"exportCacheKey");
        });
        return null;
    }

    public Void importReport(List<MultipartFile> files) {
        String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
        String tempFileName = this.workspace + File.separator + "report_import";
        String basePath = FileUtil.posixPath((String[])new String[]{tempFileName, UUID.randomUUID().toString()});
        File tempRootDir = null;
        try {
            tempRootDir = Files.createDirectories(Paths.get(basePath, new String[0]), new FileAttribute[0]).toFile();
            for (MultipartFile file : files) {
                String originalFilename = file.getOriginalFilename();
                if (originalFilename == null || !originalFilename.endsWith(".hussar")) {
                    ImportStatusVo importStatusVo = ImportStatusVo.put((int)0, (String)"\u5bfc\u5165\u5931\u8d25", (boolean)false, (boolean)true);
                    Map<String, ReportErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                    ReportErrorDto error = new ReportErrorDto();
                    error.setName(originalFilename);
                    HashMap<String, Integer> reportError = new HashMap<String, Integer>();
                    reportError.put("reportError", ReportErrorCodeEnum.FILE_NOT_HUSSAR.getCode());
                    error.setError(reportError);
                    errors.put(UUID.randomUUID().toString(), error);
                    HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
                    throw new BaseException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3a .hussar \u6587\u4ef6");
                }
                File tempFile = new File(tempRootDir, originalFilename);
                file.transferTo(tempFile);
            }
        }
        catch (IOException e) {
            logger.error("\u5b58\u50a8\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            ImportStatusVo importStatusVo = ImportStatusVo.put((int)0, (String)"\u5bfc\u5165\u5931\u8d25", (boolean)false, (boolean)true);
            Map<String, ReportErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
            ReportErrorDto error = new ReportErrorDto();
            error.setName("file");
            HashMap<String, Integer> reportError = new HashMap<String, Integer>();
            reportError.put("reportError", ReportErrorCodeEnum.FILE_NOT_CREATE.getCode());
            error.setError(reportError);
            errors.put(UUID.randomUUID().toString(), error);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
            throw new BaseException("\u5b58\u50a8\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        File finalTempRootDir = tempRootDir;
        HussarReportThreadUtil.executeDesignTask(() -> {
            try {
                this.importReports(finalTempRootDir);
            }
            catch (Exception e) {
                ToolUtil.getLogger(SysReportExpImpServiceImpl.class).error("\u5bfc\u5165\u62a5\u8868\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                if (HussarUtils.isNotEmpty((Object)importCacheKey)) {
                    HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put((int)0, (String)"\u5bfc\u5165\u62a5\u8868\u65f6\u53d1\u751f\u5f02\u5e38", (boolean)false, (boolean)true));
                }
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        return null;
    }

    public ApiResponse<ExportStatusVo> getExportProgress(String exportCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"export_progress", (Object)exportCacheKey, ExportStatusVo.class));
    }

    public ApiResponse<ImportStatusVo> getImportProgress(String importCacheKey) {
        return ApiResponse.success((Object)(HussarUtils.isNotEmpty((Object)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class)) ? (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class) : ImportStatusVo.put((int)1, (String)"\u6b63\u5728\u5bfc\u5165", (boolean)false, (boolean)false)));
    }

    public Long exportReport(List<Long> reportId) {
        String tempFileName = this.workspace + File.separator + "report";
        String basePath = FileUtil.posixPath((String[])new String[]{tempFileName, UUID.randomUUID().toString()});
        ArrayList<Long> fileIds = new ArrayList<Long>();
        Long zipId = null;
        String exportCacheKey = (String)TransmittableThreadLocalHolder.get((String)"exportCacheKey");
        try {
            int index = 1;
            for (Long id : reportId) {
                String reportPath = FileUtil.posixPath((String[])new String[]{basePath, id.toString()});
                String reportName = this.exportReportInfo(id, reportPath, index, exportCacheKey);
                index += 2;
                fileIds.add(this.fileEncrypt(reportName, reportPath));
            }
            HashMap<String, Integer> nameRepeat = new HashMap<String, Integer>();
            String projectBackPath = basePath;
            projectBackPath = projectBackPath + File.separator + System.currentTimeMillis() + File.separator;
            String zipFolderPath = FileUtil.posixPath((String[])new String[]{projectBackPath, "exportReportBatch"});
            Files.createDirectories(Paths.get(zipFolderPath, new String[0]), new FileAttribute[0]);
            HashMap<Long, String> idMaps = new HashMap<Long, String>();
            for (Long id : fileIds) {
                idMaps.put(id, "");
            }
            this.copyFilesToFolder(idMaps, zipFolderPath, nameRepeat);
            zipId = this.fileEncrypt("\u62a5\u8868\u6279\u91cf\u5bfc\u51fa", zipFolderPath);
            File file = new File(zipFolderPath);
            if (HussarUtils.isNotEmpty((Object)exportCacheKey)) {
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)index, (String)"\u5bfc\u51fa\u6210\u529f", (Long)zipId, (boolean)false));
            }
            if (file.exists()) {
                FileUtils.deleteDirectory((File)file);
            }
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38\uff1a{}", (Throwable)e);
            if (HussarUtils.isNotEmpty((Object)exportCacheKey)) {
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)0, (String)"\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38", null, (boolean)true));
            }
            throw new BaseException("\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38");
        }
        try {
            File baseFile = new File(basePath);
            if (baseFile.exists()) {
                FileUtils.deleteDirectory((File)baseFile);
            }
        }
        catch (IOException e) {
            logger.error("\u6e05\u7406\u4e34\u65f6\u76ee\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return zipId;
    }

    public String exportReportInfos(List<Long> reportId, String basePath) {
        HashMap map = new HashMap();
        ArrayList<SysReport> sysReportList = new ArrayList<SysReport>();
        for (Long id : reportId) {
            SysReport sysReport = this.sysReportService.getSysReportById(id);
            sysReportList.add(sysReport);
        }
        List<Long> uniqueDatasetIds = sysReportList.stream().map(SysReport::getDataset).filter(Objects::nonNull).map(datasetJson -> (List)JSON.parseObject((String)datasetJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0])).filter(Objects::nonNull).flatMap(Collection::stream).map(item -> Long.parseLong((String)item.get("id"))).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(uniqueDatasetIds)) {
            this.exportDataSet(uniqueDatasetIds, basePath);
        }
        List<Long> uniqueGroupIds = sysReportList.stream().map(SysReport::getReportGroupId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.exportReportGroup(uniqueGroupIds, basePath);
        map.put("report", sysReportList);
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "report.json"}));
        return ((SysReport)sysReportList.get(0)).getReportName();
    }

    public String exportReportInfo(Long reportId, String basePath, int index, String exportCacheKey) {
        HashMap<String, SysReport> map = new HashMap<String, SysReport>();
        SysReport sysReport = this.sysReportService.getSysReportById(reportId);
        ArrayList<Long> uniqueDatasetIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)exportCacheKey)) {
            HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)index, (String)("\u6b63\u5728\u5bfc\u51fa" + sysReport.getReportName() + "\u8bbe\u8ba1\u5668\u4fe1\u606f"), null, (boolean)false));
        }
        try {
            Optional.ofNullable(sysReport.getDataset()).map(datasetJson -> (List)JSON.parseObject((String)datasetJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0])).filter(Objects::nonNull).ifPresent(datasetList -> uniqueDatasetIds.addAll(datasetList.stream().map(item -> (String)item.get("id")).map(Long::valueOf).distinct().collect(Collectors.toList())));
            if (HussarUtils.isNotEmpty(uniqueDatasetIds)) {
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)index, (String)("\u6b63\u5728\u5bfc\u51fa" + sysReport.getReportName() + "\u6570\u636e\u96c6\u4fe1\u606f"), null, (boolean)false));
                this.exportDataSet(uniqueDatasetIds, basePath);
            }
            ArrayList<Long> uniqueGroupIds = new ArrayList<Long>();
            if (HussarUtils.isNotEmpty((Object)sysReport.getReportGroupId())) {
                uniqueGroupIds.add(sysReport.getReportGroupId());
                this.exportReportGroup(uniqueGroupIds, basePath);
            }
            map.put("report", sysReport);
            this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "report.json"}));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38\uff1a{}", (Throwable)e);
            if (HussarUtils.isEmpty((Object)exportCacheKey)) {
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)0, (String)"\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38", null, (boolean)true));
            }
            throw new BaseException("\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38");
        }
        return sysReport.getReportName();
    }

    public void exportReportGroup(List<Long> groupIds, String basePath) {
        HashMap map = new HashMap();
        ArrayList<SysReportGroup> sysReportGroupList = new ArrayList<SysReportGroup>();
        if (HussarUtils.isNotEmpty(groupIds)) {
            for (Long groupId : groupIds) {
                SysReportGroup sysReportGroup = (SysReportGroup)this.sysReportGroupService.getById((Serializable)groupId);
                sysReportGroupList.add(sysReportGroup);
            }
        }
        map.put("reportGroup", sysReportGroupList);
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "reportGroup.json"}));
    }

    public void exportDataSet(List<Long> dataSetIds, String basePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataSet", this.dataSetService.processDataSetExport(dataSetIds));
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "dataSet.json"}));
    }

    private void writeToFile(Object object, String path) {
        String json = JSON.toJSONStringWithDateFormat((Object)object, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        this.filePublishService.writeStringToFile(json, path);
    }

    public Long fileEncrypt(String appName, String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                String oldFormat = DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss");
                String fileName = appName + "_" + oldFormat + ".hussar";
                File parentDir = new File(path).getParentFile();
                String zipPath = parentDir.getAbsolutePath() + File.separator + fileName;
                ZipUtil.zip((String)path, (String)zipPath);
                Long id = this.fileUpload(zipPath);
                File zipFile = new File(zipPath);
                zipFile.delete();
                return id;
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    private Long fileUpload(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), "application/form-data", FileUtils.readFileToByteArray((File)file));
                return (Long)this.ossService.backgroundUpload((MultipartFile)mockMultipartFile).getData();
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean importReports(File tempRootDir) {
        int index = 1;
        String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
        String originalFilename = null;
        HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put((int)index, null, (boolean)false, (boolean)false));
        ImportStatusVo importStatusVo = (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey);
        File[] tempFiles = tempRootDir.listFiles();
        if (tempFiles != null) {
            try {
                for (File tempFile : tempFiles) {
                    originalFilename = tempFile.getName();
                    String unZipPath = tempRootDir.getAbsolutePath() + File.separator + "unzip_" + System.currentTimeMillis();
                    com.jxdinfo.hussar.platform.core.utils.file.ZipUtil.unzip((String)tempFile.getAbsolutePath(), (String)unZipPath);
                    File unZipDirectory = new File(unZipPath);
                    Collection filesInZip = FileUtils.listFiles((File)unZipDirectory, null, (boolean)true);
                    for (File fileInZip : filesInZip) {
                        if (!fileInZip.getName().endsWith(".hussar")) continue;
                        this.importSingleReportFile(fileInZip, importCacheKey, index);
                        index += 2;
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                Map<String, ReportErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                ReportErrorDto error = new ReportErrorDto();
                error.setName(originalFilename);
                HashMap<String, Integer> reportError = new HashMap<String, Integer>();
                reportError.put("reportError", ReportErrorCodeEnum.FILE_NOT_IMPORT.getCode());
                error.setError(reportError);
                errors.put(UUID.randomUUID().toString(), error);
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
            }
            finally {
                if (tempRootDir.exists()) {
                    FileUtils.deleteQuietly((File)tempRootDir);
                }
            }
        }
        importStatusVo.setMsg("\u5bfc\u5165\u5b8c\u6210");
        importStatusVo.setFinishFlag(true);
        importStatusVo.setStatus(index);
        HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
        return true;
    }

    private Boolean importSingleReportFile(File file, String importCacheKey, int index) {
        String reportName = null;
        Long reportId = null;
        ImportStatusVo importStatusVo = (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey);
        try {
            List errorResultDtos;
            File tempDir = Files.createTempDirectory("reportImport_", new FileAttribute[0]).toFile();
            String originalFilename = file.getName();
            if (HussarUtils.isEmpty((Object)originalFilename) || !originalFilename.endsWith(".hussar")) {
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
            }
            File tempFile = new File(tempDir, originalFilename);
            FileUtils.copyFile((File)file, (File)tempFile);
            String unZipPath = tempDir.getAbsolutePath();
            com.jxdinfo.hussar.platform.core.utils.file.ZipUtil.unzip((String)tempFile.getAbsolutePath(), (String)unZipPath);
            String reportPath = FileUtil.posixPath((String[])new String[]{unZipPath, "report.json"});
            String reportGroupPath = FileUtil.posixPath((String[])new String[]{unZipPath, "reportGroup.json"});
            String dataSetPath = FileUtil.posixPath((String[])new String[]{unZipPath, "dataSet.json"});
            Map sysReportMap = SysReportExpImpServiceImpl.readFileToObject(reportPath, Map.class);
            if (HussarUtils.isEmpty((Object)sysReportMap)) {
                Map<String, ReportErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                ReportErrorDto error = new ReportErrorDto();
                error.setName(originalFilename);
                HashMap<String, Integer> reportError = new HashMap<String, Integer>();
                reportError.put("reportError", ReportErrorCodeEnum.REPORT_NOT_EXIT.getCode());
                error.setError(reportError);
                errors.put(UUID.randomUUID().toString(), error);
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
                return false;
            }
            SysReport sysReport = (SysReport)JSON.parseObject((String)((JSONObject)sysReportMap.get("report")).toString(), SysReport.class);
            reportName = sysReport.getReportName();
            reportId = sysReport.getReportId();
            Map dataSet = SysReportExpImpServiceImpl.readFileToObject(dataSetPath, Map.class);
            importStatusVo.setMsg("\u6b63\u5728\u5bfc\u5165" + reportName + "\u6570\u636e\u96c6");
            importStatusVo.setStatus(index++);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
            if (HussarUtils.isNotEmpty((Object)dataSet) && HussarUtils.isNotEmpty((Object)(errorResultDtos = this.dataSetService.importDataSet((String)dataSet.get("dataSet"))))) {
                Map<String, ReportErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                ReportErrorDto error = new ReportErrorDto();
                error.setName(reportName);
                if (HussarUtils.isNotEmpty((Object)reportId)) {
                    error.setId(reportId);
                }
                HashMap<String, List> reportError = new HashMap<String, List>();
                reportError.put("dataSetError", errorResultDtos);
                error.setError(reportError);
                errors.put(UUID.randomUUID().toString(), error);
                importStatusVo.setData(errors);
                return false;
            }
            importStatusVo.setMsg("\u6b63\u5728\u5bfc\u5165" + reportName + "\u8bbe\u8ba1\u5668\u4fe1\u606f");
            importStatusVo.setStatus(index++);
            sysReport.setIsMenu("0");
            if (HussarUtils.isNotEmpty((Object)this.sysReportService.getSysReportById(sysReport.getReportId()))) {
                this.sysReportService.editReport(sysReport);
            } else {
                this.sysReportService.addReport(sysReport);
            }
            Map sysReportGroup = SysReportExpImpServiceImpl.readFileToObject(reportGroupPath, Map.class);
            if (HussarUtils.isNotEmpty((Object)sysReportGroup)) {
                List sysReportGroupList = JSON.parseArray((String)((JSONArray)sysReportGroup.get("reportGroup")).toString(), SysReportGroup.class);
                this.sysReportGroupService.saveOrUpdateBatch((Collection)sysReportGroupList);
            }
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6IO\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            Map<String, ReportErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
            ReportErrorDto error = new ReportErrorDto();
            error.setName(reportName);
            if (HussarUtils.isNotEmpty(reportId)) {
                error.setId(reportId);
            }
            HashMap<String, Integer> reportError = new HashMap<String, Integer>();
            reportError.put("reportError", ReportErrorCodeEnum.FILE_IO.getCode());
            error.setError(reportError);
            errors.put(UUID.randomUUID().toString(), error);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
        }
        catch (IORuntimeException e) {
            logger.error("ZIP\u6587\u4ef6\u89e3\u538b\u5f02\u5e38", (Throwable)e);
            Map<String, ReportErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
            ReportErrorDto error = new ReportErrorDto();
            error.setName(file.getName());
            if (HussarUtils.isNotEmpty(reportId)) {
                error.setId(reportId);
            }
            HashMap<String, Integer> reportError = new HashMap<String, Integer>();
            reportError.put("reportError", ReportErrorCodeEnum.FILE_NOT_UNZIP.getCode());
            error.setError(reportError);
            errors.put(UUID.randomUUID().toString(), error);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
        }
        return true;
    }

    public static <T> T readFileToObject(String filePath, Class<T> clazz) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            try {
                String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
                return (T)JSON.parseObject((String)text, clazz);
            }
            catch (IOException e) {
                ToolUtil.getLogger(SysReportExpImpServiceImpl.class).error("\u8bfb\u53d6\u6587\u4ef6\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}" + e.getMessage());
                throw new RuntimeException();
            }
        }
        return null;
    }

    public void copyFilesToFolder(Map<Long, String> fileIds, String basicPath, Map<String, Integer> nameRepeat) {
        String[] ids = new String[fileIds.size()];
        ArrayList<Long> idList = new ArrayList<Long>(fileIds.keySet());
        for (int i = 0; i < idList.size(); ++i) {
            ids[i] = String.valueOf(idList.get(i));
        }
        List attachmentManagerModels = this.ossService.getByFileIds(ids);
        for (AttachmentManagerModel attachmentManagerModel : attachmentManagerModels) {
            Long id = attachmentManagerModel.getId();
            String name = fileIds.get(id);
            if (HussarUtils.isNotEmpty((Object)(name = this.verifyName(name)))) {
                String modelAttachmentName = attachmentManagerModel.getAttachmentName();
                String[] split = modelAttachmentName.split("\\.");
                String splitLast = split[split.length - 1];
                attachmentManagerModel.setAttachmentName(name + "." + splitLast);
            }
            Long attachmentId = attachmentManagerModel.getId();
            String attachmentType = attachmentManagerModel.getAttachmentType();
            String attachmentName = attachmentManagerModel.getAttachmentName();
            String pre = "";
            int index = attachmentName.lastIndexOf(".");
            if (index > -1) {
                pre = attachmentName.substring(0, index);
            }
            if (pre.length() > 50) {
                pre = pre.substring(0, 50);
            }
            attachmentName = pre + "." + attachmentManagerModel.getAttachmentType();
            attachmentManagerModel.setAttachmentName(attachmentName);
            String destinationPath = FileUtil.posixPath((String[])new String[]{basicPath, attachmentName});
            if (new File(destinationPath).exists()) {
                String fileName;
                if (nameRepeat.containsKey(destinationPath)) {
                    Integer repeatCount = nameRepeat.get(destinationPath);
                    fileName = attachmentManagerModel.getAttachmentName().substring(0, attachmentManagerModel.getAttachmentName().lastIndexOf(".")) + "(" + (repeatCount + 1) + ")." + attachmentType;
                    nameRepeat.put(destinationPath, repeatCount + 1);
                } else {
                    fileName = attachmentManagerModel.getAttachmentName().substring(0, attachmentManagerModel.getAttachmentName().lastIndexOf(".")) + "(1)." + attachmentType;
                    nameRepeat.put(destinationPath, 1);
                }
                destinationPath = FileUtil.posixPath((String[])new String[]{basicPath, fileName});
            }
            this.copyFileById(attachmentId, destinationPath);
        }
    }

    private void copyFileById(Long sourceFileId, String destinationPath) {
        ApiResponse download = this.ossService.backgroundDownload(sourceFileId);
        byte[] data = (byte[])download.getData();
        try {
            FileUtils.writeByteArrayToFile((File)new File(destinationPath), (byte[])data);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u5199\u5165\u5f02\u5e38", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
    }

    private String verifyName(String name) {
        if (HussarUtils.isNotEmpty((Object)name)) {
            name = name.replace("\\", "");
            name = name.replace("/", "");
            name = name.replace(":", "");
            name = name.replace("*", "");
            name = name.replace("?", "");
            name = name.replace("\"", "");
            name = name.replace(">", "");
            name = name.replace("<", "");
            name = name.replace("|", "");
            name = name.replace("$", "");
            name = name.replace("#", "");
            name = name.replace("&", "");
            name = name.replace("%", "");
            name = name.replace("~", "");
            name = name.replace("{", "");
            name = name.replace("}", "");
            name = name.replace("[", "");
            name = name.replace("]", "");
        }
        return name;
    }

    public Long zipFile(String zipFolderPath, String zipFolderName) throws Exception {
        File parentDir = new File(zipFolderPath).getParentFile();
        String zipPath = parentDir.getAbsolutePath() + File.separator + zipFolderName + ".zip";
        ZipUtil.zip((String)zipFolderPath, (String)zipPath);
        MockMultipartFile multipartFile = new MockMultipartFile(zipFolderName + ".zip", zipFolderName + ".zip", ".zip", Files.newInputStream(Paths.get(zipPath, new String[0]), new OpenOption[0]));
        ApiResponse longApiResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        Long data = (Long)longApiResponse.getData();
        return data;
    }
}

