/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.tool.aspect;

import com.jxdinfo.hussar.application.tool.annotation.ImportProgressCache;
import com.jxdinfo.hussar.application.tool.annotation.ProgressCache;
import com.jxdinfo.hussar.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="com.jxdinfo.hussar.application.tool.aspect.ProgressCacheAspect")
public class ProgressCacheAspect {
    public static final String EXPORT_CACHE_NAME = "export_progress";
    public static final String EXPORT_CACHE_KEY = "export_progress";
    public static final String IMPORT_CACHE_NAME = "import_progress";
    public static final String IMPORT_CACHE_KEY = "import_progress";

    @Around(value="execution(* *(..)) && @annotation(annotation)", argNames="joinPoint,annotation")
    public Object around(ProceedingJoinPoint joinPoint, ProgressCache annotation) throws Throwable {
        String exportCacheKey;
        ToolUtil.getLogger(ProgressCacheAspect.class).info("\u5bfc\u51fa\u5e94\u7528\uff1a{}", (Object)annotation.msg());
        Object proceed = joinPoint.proceed();
        long fileId = 0L;
        if (annotation.finish() && proceed instanceof Long) {
            fileId = Long.parseLong(String.valueOf(proceed));
        }
        if (HussarUtils.isEmpty((Object)(exportCacheKey = (String)TransmittableThreadLocalHolder.get((String)"exportCacheKey")))) {
            return proceed;
        }
        HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)annotation.status(), (String)annotation.msg(), (Long)fileId, (boolean)false));
        return proceed;
    }

    @AfterThrowing(pointcut="execution(* *(..)) && @annotation(annotation)", throwing="exception")
    public void afterThrowing(ProgressCache annotation, Exception exception) {
        String exportCacheKey = (String)TransmittableThreadLocalHolder.get((String)"exportCacheKey");
        if (HussarUtils.isEmpty((Object)exportCacheKey)) {
            return;
        }
        HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)annotation.status(), (String)exception.getMessage(), (Long)0L, (boolean)true));
    }

    @Around(value="execution(* *(..)) && @annotation(annotation)", argNames="joinPoint,annotation")
    public Object around(ProceedingJoinPoint joinPoint, ImportProgressCache annotation) throws Throwable {
        ToolUtil.getLogger(ProgressCacheAspect.class).info("\u5bfc\u5165\u5e94\u7528\uff1a{}", (Object)annotation.msg());
        String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
        if (CollectionUtil.isNotEmpty((Object)importCacheKey)) {
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put((int)annotation.status(), (String)annotation.msg(), (boolean)annotation.finish(), (boolean)false));
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable e) {
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put((int)annotation.status(), (String)e.getMessage(), (boolean)annotation.finish(), (boolean)true));
            throw e;
        }
    }
}

