/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.excel.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.application.Util.FormulaUtils;
import com.jxdinfo.hussar.application.dataset.service.IDatasetService;
import com.jxdinfo.hussar.application.enums.FrontDataTypeEnum;
import com.jxdinfo.hussar.application.excel.Dto.ExcelExporterDto;
import com.jxdinfo.hussar.application.excel.Vo.BorderData;
import com.jxdinfo.hussar.application.excel.Vo.BorderStyleData;
import com.jxdinfo.hussar.application.excel.Vo.ICellData;
import com.jxdinfo.hussar.application.excel.Vo.IMergeData;
import com.jxdinfo.hussar.application.excel.Vo.IStyleData;
import com.jxdinfo.hussar.application.excel.Vo.IWorkbookData;
import com.jxdinfo.hussar.application.excel.Vo.IWorksheetData;
import com.jxdinfo.hussar.application.excel.enums.Arrangement;
import com.jxdinfo.hussar.application.excel.service.IExcelExporterService;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.application.reportsnapshot.model.SysReportSnapshot;
import com.jxdinfo.hussar.application.reportsnapshot.service.ISysReportSnapShotService;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ptg.AreaPtgBase;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.RefPtgBase;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressBase;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.excel.service.impl.ExcelExporter")
public class ExcelExporterServiceImpl
implements IExcelExporterService {
    private static Logger logger = LoggerFactory.getLogger(ExcelExporterServiceImpl.class);
    @Resource
    private ISysReportService reportService;
    @Resource
    private ISysReportSnapShotService sysReportSnapShotService;
    @Value(value="${hussar-formdesign.workspace}")
    private String workspace;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private IDatasetService datasetService;
    private static final int MAX_SELECT_COUNT = 10000000;

    public Long exportExcel(Long reportId) {
        SysReport report = (SysReport)this.reportService.getById((Serializable)reportId);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map designMap = null;
        try {
            designMap = (Map)objectMapper.readValue(report.getDesignInformation(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        IWorkbookData workbookData = (IWorkbookData)objectMapper.convertValue(designMap.get("workBook"), IWorkbookData.class);
        List loopAreas = (List)designMap.get("loopArea");
        return this.exportWorkbook(workbookData, report.getReportName(), loopAreas, null, null, true);
    }

    public Long exportSnapshot(Long snapshotId) {
        SysReportSnapshot snapshot = (SysReportSnapshot)this.sysReportSnapShotService.getById((Serializable)snapshotId);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map designMap = null;
        try {
            designMap = (Map)objectMapper.readValue(snapshot.getDesignInformation(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        IWorkbookData workbookData = (IWorkbookData)objectMapper.convertValue((Object)designMap, IWorkbookData.class);
        return this.exportWorkbook(workbookData, snapshot.getSnapshotName(), new ArrayList<Map<String, String>>(), null, null, false);
    }

    public Long exportSnapshotSheet(Long snapshotId, List<String> sheetIds) {
        SysReportSnapshot snapshot = (SysReportSnapshot)this.sysReportSnapShotService.getById((Serializable)snapshotId);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map designMap = null;
        try {
            designMap = (Map)objectMapper.readValue(snapshot.getDesignInformation(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        IWorkbookData workbookData = (IWorkbookData)objectMapper.convertValue((Object)designMap, IWorkbookData.class);
        return this.exportWorkbook(workbookData, snapshot.getSnapshotName(), new ArrayList<Map<String, String>>(), null, sheetIds, false);
    }

    public Long reportExportByConfig(ExcelExporterDto excelExporterDto) {
        SysReport report = (SysReport)this.reportService.getById((Serializable)excelExporterDto.getReportId());
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map designMap = null;
        try {
            designMap = (Map)objectMapper.readValue(report.getDesignInformation(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        IWorkbookData workbookData = (IWorkbookData)objectMapper.convertValue(designMap.get("workBook"), IWorkbookData.class);
        List loopAreas = (List)designMap.get("loopArea");
        return this.exportWorkbook(workbookData, report.getReportName(), loopAreas, excelExporterDto.getDataSetCommonParams(), excelExporterDto.getSheetIds(), true);
    }

    public Long exportWorkbook(IWorkbookData workbookData, String fileName, List<Map<String, String>> loopAreas, List<DataSetCommonParam> dataSetCommonParamConfig, List<String> sheetIds, Boolean isdynamic) {
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        Long fileId = 0L;
        List resources = workbookData.getResources();
        HashMap<String, Object> autoFilter = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)resources)) {
            Optional<String> sheetFilterPluginData = resources.stream().filter(resource -> "SHEET_FILTER_PLUGIN".equals(resource.get("name"))).map(resource -> (String)resource.get("data")).findFirst();
            sheetFilterPluginData.ifPresent(data -> {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    if (HussarUtils.isNotEmpty((Object)data)) {
                        Map filter = (Map)objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        autoFilter.putAll(filter);
                    }
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            workbook.setForceFormulaRecalculation(true);
            for (String sheetId : workbookData.getSheetOrder()) {
                this.processSheet(workbook, sheetId, workbookData, loopAreas, dataSetCommonParamConfig, sheetIds, isdynamic, autoFilter);
            }
            String tempFileName = this.workspace + File.separator + "export";
            File file1 = new File(tempFileName);
            if (!file1.exists()) {
                file1.mkdirs();
            }
            tempFileName = tempFileName + File.separator + taskId + ".xlsx";
            try (FileOutputStream fos = new FileOutputStream(tempFileName);){
                workbook.write((OutputStream)fos);
            }
            catch (IOException e) {
                logger.error("\u5bfc\u51fa Excel \u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u5bfc\u51fa Excel \u6587\u4ef6\u5931\u8d25", e);
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(new File(tempFileName));
                MockMultipartFile multipartFile = new MockMultipartFile(fileName + ".xlsx", fileName + ".xlsx", ".xlsx", (InputStream)fileInputStream);
                fileId = (Long)this.attachmentManagerService.backgroundUpload((MultipartFile)multipartFile).getData();
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6\u4e34\u65f6\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u8bfb\u53d6\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", e);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        logger.error("\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51fa Excel \u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u5bfc\u51fa Excel \u6587\u4ef6\u5931\u8d25", e);
        }
        return fileId;
    }

    public Sheet processSheet(XSSFWorkbook workbook, String sheetId, IWorkbookData workbookData, List<Map<String, String>> loopAreas, List<DataSetCommonParam> dataSetCommonParamConfig, List<String> sheetIds, Boolean isdynamic, Map<String, Object> autoFilter) {
        Object filter;
        if (HussarUtils.isNotEmpty(sheetIds) && !sheetIds.contains(sheetId)) {
            return null;
        }
        HashMap<Integer, Integer> offsetDown = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> offsetRight = new HashMap<Integer, Integer>();
        ArrayList<IMergeData> mergeDataList = new ArrayList<IMergeData>();
        if (HussarUtils.isNotEmpty((Object)((IWorksheetData)workbookData.getSheets().get(sheetId)).getMergeData())) {
            mergeDataList.addAll(((IWorksheetData)workbookData.getSheets().get(sheetId)).getMergeData());
        }
        ArrayList<Integer> rowGroup = new ArrayList<Integer>();
        ArrayList<Integer> cellGroup = new ArrayList<Integer>();
        HashMap<String, Map<String, List<Map<String, Object>>>> valueMap = new HashMap<String, Map<String, List<Map<String, Object>>>>();
        HashMap<String, Map<String, List<Map<String, Object>>>> notGroupsvalueMap = new HashMap<String, Map<String, List<Map<String, Object>>>>();
        HashMap<String, Map<String, List<String>>> groupField = new HashMap<String, Map<String, List<String>>>();
        IWorksheetData sheetData = (IWorksheetData)workbookData.getSheets().get(sheetId);
        LinkedHashMap<String, Map> groupCustomCells = new LinkedHashMap<String, Map>();
        LinkedHashMap<String, Map> notGroupsCustomCells = new LinkedHashMap<String, Map>();
        LinkedHashMap<String, Map<String, Object>> customCells = new LinkedHashMap<String, Map<String, Object>>();
        HashMap<String, List<Map<String, Object>>> formulaStyles = new HashMap<String, List<Map<String, Object>>>();
        HashMap<String, String> formulaList = new HashMap<String, String>();
        HashMap<String, Map<String, String>> loopFormulaList = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, Object>> loopFormulaStyles = new HashMap<String, Map<String, Object>>();
        ArrayList<DataSetExecuteVO> dataSetExecuteVOList = new ArrayList();
        if (isdynamic.booleanValue()) {
            List dataSetCommonParams = this.datasetService.getDataSetCommonParamsByPage(sheetData, dataSetCommonParamConfig);
            for (DataSetCommonParam dataSetCommonParam : dataSetCommonParams) {
                dataSetCommonParam.getDataSetCondition().setSize(10000000);
            }
            if (HussarUtils.isNotEmpty((Object)dataSetCommonParams)) {
                dataSetExecuteVOList = this.datasetService.formatResult(dataSetCommonParams);
            }
        }
        HashSet loopAreaSheet = new HashSet();
        XSSFSheet sheet = workbook.createSheet(sheetData.getName());
        if (HussarUtils.isNotEmpty(autoFilter) && (filter = autoFilter.get(sheetId)) instanceof Map) {
            Map ref = (Map)((Map)filter).get("ref");
            sheet.setAutoFilter(new CellRangeAddress(((Integer)ref.get("startRow")).intValue(), ((Integer)ref.get("endRow")).intValue(), ((Integer)ref.get("startColumn")).intValue(), ((Integer)ref.get("endColumn")).intValue()));
        }
        if (HussarUtils.isNotEmpty((Object)sheetData.getFreeze()) && HussarUtils.isNotEmpty(sheetData.getFreeze().get("startRow")) && HussarUtils.isNotEmpty(sheetData.getFreeze().get("startColumn"))) {
            sheet.createFreezePane(((Integer)sheetData.getFreeze().get("startColumn")).intValue(), ((Integer)sheetData.getFreeze().get("startRow")).intValue());
        }
        Map cellDataMap = sheetData.getCellData();
        for (int rowNum = 0; rowNum < sheetData.getRowCount(); ++rowNum) {
            Map map;
            Row row = sheet.createRow(rowNum);
            if (sheetData.getRowData() != null && sheetData.getRowData().containsKey(String.valueOf(rowNum)) && (map = (Map)sheetData.getRowData().get(String.valueOf(rowNum))) != null && map.containsKey("h")) {
                double heightInPx = (Double)map.get("h");
                row.setHeight((short)(heightInPx * 20.0 / 1.333));
            }
            if (cellDataMap == null || !cellDataMap.containsKey(rowNum)) continue;
            Map map2 = (Map)cellDataMap.get(rowNum);
            for (Map.Entry entry : map2.entrySet()) {
                Map custom;
                IStyleData styleData;
                int cellNum = (Integer)entry.getKey();
                ICellData cellData = (ICellData)entry.getValue();
                if (HussarUtils.isEmpty((Object)cellData)) continue;
                Cell cell = row.createCell(cellNum);
                if (cellData.getS() != null && workbookData.getStyles() != null && (styleData = (IStyleData)workbookData.getStyles().get(cellData.getS())) != null) {
                    CellStyle cellStyle = this.createCellStyle(workbook, styleData);
                    if (HussarUtils.isNotEmpty((Object)cellStyle) && cellStyle.getWrapText()) {
                        row.setHeight((short)-1);
                    }
                    cell.setCellStyle(cellStyle);
                }
                if (HussarUtils.isNotEmpty((Object)cellData.getCustom()) && HussarUtils.isNotEmpty((Object)(custom = cellData.getCustom())) && isdynamic.booleanValue()) {
                    if (HussarUtils.isNotEmpty(custom.get("loopArea"))) {
                        loopAreaSheet.add(((Map)custom.get("loopArea")).get("id"));
                    }
                    if (HussarUtils.isNotEmpty(custom.get("groupDataSet")) && HussarUtils.equals((Object)Arrangement.GROUP.getValue(), custom.get("groupDataSet"))) {
                        Map cellGroupMap = (Map)cellDataMap.get(rowNum + 1);
                        groupCustomCells.put(String.valueOf(rowNum) + ',' + cellNum, custom);
                        if (HussarUtils.isNotEmpty((Object)cellGroupMap) && cellGroupMap.containsKey(cellNum)) {
                            ICellData cellDataGroup = (ICellData)cellGroupMap.get(cellNum);
                            Map customGroup = cellDataGroup.getCustom();
                            if (HussarUtils.isNotEmpty((Object)customGroup) && ((Boolean)customGroup.get("transverseGroupField")).booleanValue()) {
                                custom.put("isMerge", true);
                                notGroupsCustomCells.put(String.valueOf(rowNum) + ',' + cellNum, custom);
                                groupCustomCells.remove(String.valueOf(rowNum) + ',' + cellNum);
                            }
                        } else {
                            ICellData cellDataGroup;
                            Map customGroup;
                            Map cellGroupMapCell = (Map)cellDataMap.get(rowNum);
                            if (HussarUtils.isNotEmpty((Object)cellGroupMapCell) && cellGroupMapCell.containsKey(cellNum + 1) && HussarUtils.isNotEmpty((Object)(customGroup = (cellDataGroup = (ICellData)cellGroupMapCell.get(cellNum + 1)).getCustom())) && ((Boolean)customGroup.get("transverseGroupField")).booleanValue()) {
                                custom.put("isMerge", true);
                                notGroupsCustomCells.put(String.valueOf(rowNum) + ',' + cellNum, custom);
                                groupCustomCells.remove(String.valueOf(rowNum) + ',' + cellNum);
                            }
                        }
                    }
                    if (HussarUtils.isNotEmpty(custom.get("formulaStyles"))) {
                        formulaStyles.put(String.valueOf(rowNum) + ',' + cellNum, (List)custom.get("formulaStyles"));
                    }
                    customCells.put(String.valueOf(rowNum) + ',' + cellNum, custom);
                }
                this.setCellValueBasedOnType(cell, cellData);
                if (!HussarUtils.isNotEmpty((Object)cellData.getF()) || !isdynamic.booleanValue()) continue;
                String formula = cellData.getF().substring(1);
                formulaList.put(String.valueOf(rowNum) + ',' + cellNum, formula);
            }
        }
        Map columnData = sheetData.getColumnData();
        if (columnData != null) {
            for (Map.Entry entry : columnData.entrySet()) {
                int colNum = Integer.parseInt((String)entry.getKey());
                if (!HussarUtils.isNotEmpty(((Map)entry.getValue()).get("w"))) continue;
                double widthInPx = (Double)((Map)entry.getValue()).get("w");
                sheet.setColumnWidth(colNum, (int)(widthInPx * 256.0 / 7.0));
            }
        }
        if (HussarUtils.isNotEmpty(loopAreas) && HussarUtils.isNotEmpty(loopAreaSheet)) {
            for (Map map : loopAreas) {
                String areaId = (String)map.get("id");
                if (!loopAreaSheet.contains(areaId)) continue;
                String activeRangeA1Notation = (String)map.get("activeRangeA1Notation");
                CellRangeAddress region = CellRangeAddress.valueOf((String)activeRangeA1Notation);
                int startRow = region.getFirstRow();
                int endRow = region.getLastRow();
                int startCol = region.getFirstColumn();
                int endCol = region.getLastColumn();
                int cycleNum = 1;
                if (HussarUtils.isNotEmpty(map.get("loopNum"))) {
                    cycleNum = Integer.parseInt((String)map.get("loopNum"));
                }
                this.processAndFillLoopAreaData((Sheet)sheet, startRow, startCol, endRow, endCol, customCells, dataSetExecuteVOList, cycleNum, offsetDown, offsetRight, mergeDataList, rowGroup, cellGroup, formulaList, formulaStyles, loopFormulaList, loopFormulaStyles);
            }
        }
        if (HussarUtils.isNotEmpty(customCells)) {
            if (HussarUtils.isNotEmpty(groupCustomCells)) {
                for (Map.Entry entry : groupCustomCells.entrySet()) {
                    String key = (String)entry.getKey();
                    String[] parts = key.split(",");
                    int rowNum = Integer.parseInt(parts[0]);
                    int cellNum = Integer.parseInt(parts[1]);
                    Map custom = (Map)entry.getValue();
                    this.processAndSortGroupedData(custom, valueMap, groupField, dataSetExecuteVOList, rowNum, cellNum, true);
                }
            }
            if (HussarUtils.isNotEmpty(notGroupsCustomCells)) {
                for (Map.Entry entry : notGroupsCustomCells.entrySet()) {
                    String key = (String)entry.getKey();
                    String[] parts = key.split(",");
                    int rowNum = Integer.parseInt(parts[0]);
                    int cellNum = Integer.parseInt(parts[1]);
                    Map custom = (Map)entry.getValue();
                    this.processAndSortGroupedData(custom, notGroupsvalueMap, groupField, dataSetExecuteVOList, rowNum, cellNum, false);
                }
            }
            for (Map.Entry entry : customCells.entrySet()) {
                String key = (String)entry.getKey();
                Map custom = (Map)entry.getValue();
                String[] parts = key.split(",");
                int rowNum = Integer.parseInt(parts[0]);
                int cellNum = Integer.parseInt(parts[1]);
                String direction = (String)custom.get("direction");
                Map field = (Map)custom.get("field");
                if (HussarUtils.isEmpty((Object)field)) continue;
                Map valueListMap = valueMap.getOrDefault(field.get("dataSetId"), new HashMap());
                Map valueNotGroupsListMap = notGroupsvalueMap.getOrDefault(field.get("dataSetId"), new HashMap());
                List valueList = this.getValueListMapFromCustom(custom, dataSetExecuteVOList);
                if (HussarUtils.isNotEmpty((Object)valueListMap) && HussarUtils.isEmpty(custom.get("isMerge"))) {
                    if (Arrangement.HORIZONTAL.getValue().equals(direction) && HussarUtils.isNotEmpty(valueListMap.get(Arrangement.HORIZONTAL.getValue() + cellNum))) {
                        valueList = (List)valueListMap.get(Arrangement.HORIZONTAL.getValue() + cellNum);
                    } else if (HussarUtils.isNotEmpty(valueListMap.get(Arrangement.VERTICAL.getValue() + rowNum))) {
                        valueList = (List)valueListMap.get(Arrangement.VERTICAL.getValue() + rowNum);
                    }
                } else if (HussarUtils.isNotEmpty((Object)valueNotGroupsListMap) && HussarUtils.isNotEmpty(custom.get("isMerge"))) {
                    if (Arrangement.HORIZONTAL.getValue().equals(direction + "," + (rowNum + 1) + "," + cellNum) && HussarUtils.isNotEmpty(valueListMap.get(Arrangement.HORIZONTAL.getValue() + "," + (rowNum + 1) + "," + cellNum))) {
                        valueList = (List)valueNotGroupsListMap.get(Arrangement.HORIZONTAL.getValue() + "," + (rowNum + 1) + "," + cellNum);
                    } else if (HussarUtils.isNotEmpty(valueListMap.get(Arrangement.VERTICAL.getValue() + "," + rowNum + "," + (cellNum + 1)))) {
                        valueList = (List)valueNotGroupsListMap.get(Arrangement.VERTICAL.getValue() + "," + rowNum + "," + (cellNum + 1));
                    }
                }
                if (((Boolean)custom.get("transverseGroupField")).booleanValue()) {
                    Map customGroup = (Map)customCells.get(rowNum - 1 + "," + cellNum);
                    Map customGroupNum = (Map)customCells.get(rowNum + "," + (cellNum - 1));
                    valueList = (List)valueNotGroupsListMap.get(Arrangement.VERTICAL.getValue() + "," + rowNum + "," + cellNum);
                    custom.put("fieldGroup", ((Map)customGroup.get("field")).get("field"));
                    custom.put("fieldGroupSort", valueNotGroupsListMap.get(Arrangement.HORIZONTAL.getValue() + "," + rowNum + "," + cellNum));
                    custom.put("fieldGroupNum", ((Map)customGroupNum.get("field")).get("field"));
                }
                this.processFieldData((Sheet)sheet, rowNum, cellNum, custom, valueList, offsetDown, offsetRight, mergeDataList, rowGroup, cellGroup);
            }
            if (HussarUtils.isNotEmpty(loopFormulaList)) {
                for (Map.Entry entry : loopFormulaList.entrySet()) {
                    String key = (String)entry.getKey();
                    Map formulaParameter = (Map)entry.getValue();
                    String formula = (String)formulaParameter.get("formula");
                    List<String> references = ExcelExporterServiceImpl.extractCellReferences(formula, (Sheet)sheet);
                    String[] parts = key.split(",");
                    int rowNum = Integer.parseInt(parts[0]);
                    int cellNum = Integer.parseInt(parts[1]);
                    if (HussarUtils.isNotEmpty(references)) {
                        this.processFormulaForLoop((Sheet)sheet, rowNum, cellNum, formula, references, offsetDown, offsetRight, formulaParameter);
                    }
                    formulaList.remove(key);
                }
            }
            if (HussarUtils.isNotEmpty(formulaList)) {
                for (Map.Entry entry : formulaList.entrySet()) {
                    String key = (String)entry.getKey();
                    String formula = (String)entry.getValue();
                    List<String> references = ExcelExporterServiceImpl.extractCellReferences(formula, (Sheet)sheet);
                    String[] parts = key.split(",");
                    int rowNum = Integer.parseInt(parts[0]);
                    int cellNum = Integer.parseInt(parts[1]);
                    if (!HussarUtils.isNotEmpty(references)) continue;
                    this.processFormula((Sheet)sheet, rowNum, cellNum, formula, references, offsetDown, offsetRight, customCells);
                }
            }
        }
        if (HussarUtils.isNotEmpty(loopFormulaStyles)) {
            this.processFormulaStylesForLoop((Sheet)sheet, loopFormulaStyles, offsetDown, offsetRight, formulaStyles);
        }
        if (HussarUtils.isNotEmpty(formulaStyles)) {
            this.processFormulaStyles((Sheet)sheet, formulaStyles, offsetDown, offsetRight);
        }
        for (IMergeData iMergeData : mergeDataList) {
            CellRangeAddress region = new CellRangeAddress(iMergeData.getStartRow(), iMergeData.getEndRow(), iMergeData.getStartColumn(), iMergeData.getEndColumn());
            int firstRow = region.getFirstRow();
            int lastRow = region.getLastRow();
            int firstCol = region.getFirstColumn();
            int lastCol = region.getLastColumn();
            int cellCount = (lastRow - firstRow + 1) * (lastCol - firstCol + 1);
            if (cellCount > 1) {
                try {
                    sheet.addMergedRegion(region);
                }
                catch (Exception e) {
                    logger.warn("\u6dfb\u52a0\u5408\u5e76\u533a\u57df\u5931\u8d25\uff0c\u5df2\u8df3\u8fc7: {}\uff0c\u9519\u8bef\u4fe1\u606f: {}", (Object)region.formatAsString(), (Object)e.getMessage());
                }
                continue;
            }
            logger.warn("\u8df3\u8fc7\u65e0\u6548\u5408\u5e76\u533a\u57df\uff08\u4ec5\u4e00\u4e2a\u5355\u5143\u683c\uff09\uff1a{}", (Object)region.formatAsString());
        }
        return sheet;
    }

    private CellStyle createCellStyle(XSSFWorkbook workbook, IStyleData styleData) {
        String hexColor;
        int strikeoutFlag;
        Map stMap;
        int underlineFlag;
        Map ulMap;
        XSSFCellStyle style = workbook.createCellStyle();
        if (HussarUtils.isNotEmpty((Object)styleData.getTb()) && HussarUtils.equals((Object)styleData.getTb(), (Object)3)) {
            style.setWrapText(true);
        }
        XSSFFont font = workbook.createFont();
        if (styleData.getFf() != null) {
            font.setFontName(styleData.getFf());
        } else {
            font.setFontName("Arial");
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getFs()) && styleData.getFs() > 0) {
            font.setFontHeightInPoints(styleData.getFs().shortValue());
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getBl()) && styleData.getBl() == 1) {
            font.setBold(true);
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getIt()) && styleData.getIt() == 1) {
            font.setItalic(true);
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getTr()) && HussarUtils.isNotEmpty(styleData.getTr().get("a"))) {
            Short rotation = -((Short)styleData.getTr().get("a")).shortValue();
            style.setRotation(rotation.shortValue());
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getUl()) && (ulMap = styleData.getUl()).containsKey("s") && (underlineFlag = Integer.parseInt(ulMap.get("s").toString())) == 1) {
            font.setUnderline((byte)1);
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getSt()) && (stMap = styleData.getSt()).containsKey("s") && (strikeoutFlag = Integer.parseInt(stMap.get("s").toString())) == 1) {
            font.setStrikeout(true);
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getCl()) && (hexColor = (String)styleData.getCl().get("rgb")) != null) {
            byte[] rgb = this.hexToRgb(hexColor);
            XSSFColor fontColor = new XSSFColor(rgb, null);
            font.setColor(fontColor);
        }
        style.setFont((Font)font);
        if (HussarUtils.isNotEmpty((Object)styleData.getBg()) && (hexColor = (String)styleData.getBg().get("rgb")) != null) {
            byte[] rgb = this.hexToRgb(hexColor);
            XSSFColor bgColor = new XSSFColor(rgb, null);
            style.setFillForegroundColor(bgColor);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getHt())) {
            style.setAlignment(HorizontalAlignment.values()[styleData.getHt()]);
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getVt()) && styleData.getVt() > 0) {
            style.setVerticalAlignment(VerticalAlignment.values()[styleData.getVt() - 1]);
        }
        if (HussarUtils.isNotEmpty((Object)styleData.getBd())) {
            BorderStyleData borderStyle = styleData.getBd();
            if (borderStyle.getT() != null) {
                BorderStyle topStyle = BorderStyle.values()[borderStyle.getT().getS()];
                XSSFColor topColor = this.getColorFromBorderStyle(borderStyle.getT());
                style.setBorderTop(topStyle);
                if (topColor != null) {
                    style.setTopBorderColor(topColor);
                }
            }
            if (borderStyle.getB() != null) {
                BorderStyle bottomStyle = BorderStyle.values()[borderStyle.getB().getS()];
                XSSFColor bottomColor = this.getColorFromBorderStyle(borderStyle.getB());
                style.setBorderBottom(bottomStyle);
                if (bottomColor != null) {
                    style.setBottomBorderColor(bottomColor);
                }
            }
            if (borderStyle.getL() != null) {
                BorderStyle leftStyle = BorderStyle.values()[borderStyle.getL().getS()];
                XSSFColor leftColor = this.getColorFromBorderStyle(borderStyle.getL());
                style.setBorderLeft(leftStyle);
                if (leftColor != null) {
                    style.setLeftBorderColor(leftColor);
                }
            }
            if (borderStyle.getR() != null) {
                BorderStyle rightStyle = BorderStyle.values()[borderStyle.getR().getS()];
                XSSFColor rightColor = this.getColorFromBorderStyle(borderStyle.getR());
                style.setBorderRight(rightStyle);
                if (rightColor != null) {
                    style.setRightBorderColor(rightColor);
                }
            }
        }
        if (styleData.getN() != null && styleData.getN().containsKey("pattern")) {
            String pattern = (String)styleData.getN().get("pattern");
            XSSFDataFormat dataFormat = workbook.createDataFormat();
            short formatIndex = dataFormat.getFormat(pattern);
            style.setDataFormat(formatIndex);
        }
        return style;
    }

    private XSSFColor getColorFromBorderStyle(BorderData borderDetail) {
        if (borderDetail.getCl() != null && borderDetail.getCl().containsKey("rgb")) {
            String hexColor = (String)borderDetail.getCl().get("rgb");
            byte[] rgb = this.hexToRgb(hexColor);
            return new XSSFColor(rgb, null);
        }
        return null;
    }

    private byte[] hexToRgb(String hex) {
        String[] rgbValues;
        if (hex.startsWith("rgb") && (rgbValues = hex.replaceAll("[^0-9,]", "").split(",")).length == 3) {
            return new byte[]{(byte)Integer.parseInt(rgbValues[0]), (byte)Integer.parseInt(rgbValues[1]), (byte)Integer.parseInt(rgbValues[2])};
        }
        hex = hex.replace("#", "");
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return new byte[]{(byte)(r & 0xFF), (byte)(g & 0xFF), (byte)(b & 0xFF)};
    }

    private void setCellValueBasedOnType(Cell cell, ICellData cellData) {
        String value;
        if (cellData.getF() != null && !cellData.getF().isEmpty()) {
            String formula = cellData.getF().substring(1);
            cell.setCellFormula(formula);
        } else if (cellData.getV() != null && (value = cellData.getV()) != null) {
            switch (cellData.getT()) {
                case 2: {
                    double numericValue;
                    if (value instanceof Number) {
                        numericValue = ((Number)((Object)value)).doubleValue();
                    } else {
                        try {
                            numericValue = Double.parseDouble(value.toString());
                        }
                        catch (NumberFormatException e) {
                            cell.setCellValue(value.toString());
                            break;
                        }
                    }
                    cell.setCellValue(numericValue);
                    break;
                }
                case 3: {
                    if (value instanceof Boolean) {
                        cell.setCellValue(((Boolean)((Object)value)).booleanValue());
                        break;
                    }
                    cell.setCellValue(Boolean.parseBoolean(value.toString()));
                    break;
                }
                default: {
                    cell.setCellValue(value.toString());
                }
            }
        }
    }

    private void processFieldData(Sheet sheet, int rowNum, int cellNum, Map<String, Object> custom, List<Map<String, Object>> valueListMap, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, List<IMergeData> mergeDataList, List<Integer> rowGroup, List<Integer> cellGroup) {
        Map field = (Map)custom.get("field");
        if (HussarUtils.isNotEmpty((Object)field)) {
            int offDownNum = 0;
            int offRightNum = 0;
            if (HussarUtils.isNotEmpty(offsetDown)) {
                offDownNum = this.getSumOfValuesLessThanNum(offsetDown, rowNum);
            }
            if (HussarUtils.isNotEmpty(offsetRight)) {
                offRightNum = this.getSumOfValuesLessThanNum(offsetRight, cellNum);
            }
            int lastRowNum = sheet.getLastRowNum();
            String groupDataSet = (String)custom.get("groupDataSet");
            String direction = (String)custom.get("direction");
            Boolean transverseGroupField = (Boolean)custom.get("transverseGroupField");
            String fieldName = (String)field.get("field");
            String dataType = (String)field.get("dataType");
            if (HussarUtils.isNotEmpty(valueListMap) && HussarUtils.isNotEmpty((Object)fieldName)) {
                List<Object> fieldValueList = new ArrayList();
                ArrayList<List<Object>> fieldValueMatrix = new ArrayList<List<Object>>();
                fieldValueList = HussarUtils.isNotEmpty((Object)custom.get("isMerge")) && (Boolean)custom.get("isMerge") != false ? valueListMap.stream().filter(map -> map.containsKey(fieldName)).map(map -> map.get(fieldName)).distinct().collect(Collectors.toList()) : valueListMap.stream().filter(map -> map.containsKey(fieldName)).map(map -> map.get(fieldName)).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty((Object)custom.get("fieldGroup"))) {
                    String fieldGroup = (String)custom.get("fieldGroup");
                    String fieldGroupNum = (String)custom.get("fieldGroupNum");
                    List fieldGroupSort = (List)custom.get("fieldGroupSort");
                    List fieldValueListGroup = fieldGroupSort.stream().filter(map -> map.containsKey(fieldGroup)).map(map -> map.get(fieldGroup)).collect(Collectors.toCollection(LinkedHashSet::new)).stream().collect(Collectors.toList());
                    List fieldValueNum = valueListMap.stream().filter(map -> map.containsKey(fieldGroupNum)).map(map -> map.get(fieldGroupNum)).collect(Collectors.toList());
                    ArrayList<Long> fieldValueCount = new ArrayList<Long>();
                    if (!fieldValueNum.isEmpty()) {
                        long count = 1L;
                        for (int i = 1; i < fieldValueNum.size(); ++i) {
                            if (fieldValueNum.get(i).equals(fieldValueNum.get(i - 1))) {
                                ++count;
                                continue;
                            }
                            fieldValueCount.add(count);
                            count = 1L;
                        }
                        fieldValueCount.add(count);
                    }
                    int num = 0;
                    for (int i = 0; i < fieldValueCount.size(); ++i) {
                        int k;
                        Object value;
                        int j;
                        ArrayList<Object> row = new ArrayList<Object>();
                        num = (int)((long)num + (Long)fieldValueCount.get(i));
                        if (HussarUtils.equals((Object)dataType, (Object)"int") || HussarUtils.equals((Object)dataType, (Object)"double") || HussarUtils.equals((Object)dataType, (Object)"long")) {
                            for (j = 0; j < fieldValueListGroup.size(); ++j) {
                                value = new BigDecimal(0);
                                for (k = (int)((long)num - (Long)fieldValueCount.get(i)); k < num && k < valueListMap.size(); ++k) {
                                    if (!fieldValueListGroup.get(j).equals(valueListMap.get(k).get(fieldGroup)) || !HussarUtils.isNotEmpty((Object)fieldValueList.get(k))) continue;
                                    value = ((BigDecimal)value).add(new BigDecimal(String.valueOf(fieldValueList.get(k))));
                                }
                                row.add(value);
                            }
                        } else {
                            for (j = 0; j < fieldValueListGroup.size(); ++j) {
                                value = "";
                                for (k = (int)((long)num - (Long)fieldValueCount.get(i)); k < num && k < valueListMap.size(); ++k) {
                                    if (!fieldValueListGroup.get(j).equals(valueListMap.get(k).get(fieldGroup)) || !HussarUtils.isNotEmpty((Object)fieldValueList.get(k))) continue;
                                    value = HussarUtils.isNotEmpty((Object)value) ? (String)value + "," + fieldValueList.get(k) : fieldValueList.get(k).toString();
                                }
                                if (HussarUtils.isEmpty((Object)value)) {
                                    row.add(null);
                                    continue;
                                }
                                row.add(value);
                            }
                        }
                        fieldValueMatrix.add(row);
                    }
                }
                int startRow = rowNum + offDownNum;
                int startCol = cellNum + offRightNum;
                Cell templateCell = sheet.getRow(startRow).getCell(startCol);
                Map mergeRule = (Map)custom.get("mergeRule");
                Map slaveColumnConfig = (Map)custom.get("slaveColumnConfig");
                Boolean msMerge = false;
                ArrayList<Integer> mMergeRow = new ArrayList();
                if (HussarUtils.isNotEmpty((Object)mergeRule)) {
                    msMerge = (Boolean)mergeRule.get("enable");
                } else if (HussarUtils.isNotEmpty((Object)slaveColumnConfig) && (msMerge = (Boolean)slaveColumnConfig.get("enable")).booleanValue()) {
                    mMergeRow = this.processMasterColumnConfig(slaveColumnConfig, valueListMap, startRow);
                }
                if (HussarUtils.isNotEmpty((Object)groupDataSet)) {
                    if (Arrangement.LIST.getValue().equals(groupDataSet) && !transverseGroupField.booleanValue() && !msMerge.booleanValue()) {
                        Integer offDownValue = offsetDown.getOrDefault(rowNum, 0);
                        if (offDownValue < fieldValueList.size() - 1) {
                            offsetDown.put(rowNum, fieldValueList.size() - 1);
                            this.shiftDownAndCopyEntireRow(sheet, lastRowNum, startRow, fieldValueList.size() - 1 - offDownValue, offsetDown, offsetRight);
                            this.shiftMergeDown(startRow, fieldValueList.size() - 1 - offDownValue, mergeDataList);
                        }
                        this.shiftDownAndFillData(sheet, startRow, startCol, fieldValueList, templateCell, dataType, offsetDown, offsetRight, mergeDataList, rowGroup, cellGroup);
                    } else if (Arrangement.LIST.getValue().equals(groupDataSet) && transverseGroupField.booleanValue() && !msMerge.booleanValue()) {
                        this.shiftDownAndFillDataByRowCol(sheet, startRow, startCol, fieldValueMatrix, templateCell, dataType, offsetDown, offsetRight, mergeDataList, rowGroup, cellGroup);
                    } else if (Arrangement.GROUP.getValue().equals(groupDataSet) && Arrangement.VERTICAL.getValue().equals(direction)) {
                        Integer offDownValue = offsetDown.getOrDefault(rowNum, 0);
                        if (offDownValue < fieldValueList.size() - 1) {
                            offsetDown.put(rowNum, fieldValueList.size() - 1);
                            this.shiftDownAndCopyEntireRow(sheet, lastRowNum, startRow, fieldValueList.size() - 1 - offDownValue, offsetDown, offsetRight);
                            this.shiftMergeDown(startRow, fieldValueList.size() - 1 - offDownValue, mergeDataList);
                        }
                        this.mergeSameValuesAndFillData(sheet, startRow, startCol, fieldValueList, templateCell, true, dataType, offsetDown, offsetRight, mergeDataList, rowGroup, cellGroup);
                    } else if (Arrangement.GROUP.getValue().equals(groupDataSet) && Arrangement.HORIZONTAL.getValue().equals(direction)) {
                        Integer offRightValue = offsetRight.getOrDefault(cellNum, 0);
                        if (offRightValue < fieldValueList.size() - 1) {
                            offsetRight.put(cellNum, fieldValueList.size() - 1);
                            this.shiftRightAndCopyEntireCells(sheet, startCol, fieldValueList.size() - 1 - offRightValue, offsetDown, offsetRight);
                            this.shiftMergeRight(startCol, fieldValueList.size() - 1 - offRightValue, mergeDataList);
                        }
                        this.mergeSameValuesAndFillData(sheet, startRow, startCol, fieldValueList, templateCell, false, dataType, offsetDown, offsetRight, mergeDataList, rowGroup, cellGroup);
                    } else if (msMerge.booleanValue()) {
                        Integer offDownValue = offsetDown.getOrDefault(rowNum, 0);
                        if (offDownValue < fieldValueList.size() - 1) {
                            offsetDown.put(rowNum, fieldValueList.size() - 1);
                            this.shiftDownAndCopyEntireRow(sheet, lastRowNum, startRow, fieldValueList.size() - 1 - offDownValue, offsetDown, offsetRight);
                            this.shiftMergeDown(startRow, fieldValueList.size() - 1 - offDownValue, mergeDataList);
                        }
                        this.mergeSameValuesAndFillData(sheet, startRow, startCol, fieldValueList, templateCell, true, dataType, offsetDown, offsetRight, mergeDataList, mMergeRow, new ArrayList<Integer>());
                    }
                }
            }
        }
    }

    private void copyCell(Cell sourceCell, Cell targetCell) {
        targetCell.setCellStyle(sourceCell.getCellStyle());
        switch (sourceCell.getCellType()) {
            case STRING: {
                targetCell.setCellValue(sourceCell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                targetCell.setCellValue(sourceCell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                targetCell.setCellValue(sourceCell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                targetCell.setCellFormula(sourceCell.getCellFormula());
                break;
            }
            case BLANK: {
                targetCell.setBlank();
                break;
            }
            case ERROR: {
                targetCell.setCellErrorValue(sourceCell.getErrorCellValue());
                break;
            }
            default: {
                targetCell.setBlank();
            }
        }
    }

    private void shiftDownAndFillData(Sheet sheet, int startRow, int startCol, List<Object> fieldValueList, Cell templateCell, String dataType, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, List<IMergeData> mergeDataList, List<Integer> rowGroup, List<Integer> cellGroup) {
        this.fillDataWithTemplate(sheet, startRow, startCol, fieldValueList, templateCell, dataType);
    }

    private void shiftDownAndFillDataByRowCol(Sheet sheet, int startRow, int startCol, List<List<Object>> fieldValueMatrix, Cell templateCell, String dataType, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, List<IMergeData> mergeDataList, List<Integer> rowGroup, List<Integer> cellGroup) {
        this.fillDataWithTemplateByRowCol(sheet, startRow, startCol, fieldValueMatrix, templateCell, dataType);
    }

    private void mergeSameValuesAndFillData(Sheet sheet, int startRow, int startCol, List<Object> fieldValueList, Cell templateCell, Boolean vertical, String dataType, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, List<IMergeData> mergeDataList, List<Integer> rowGroup, List<Integer> cellGroup) {
        if (fieldValueList == null || fieldValueList.isEmpty()) {
            return;
        }
        if (vertical.booleanValue()) {
            Map<Object, List<Integer>> valueGroups = this.groupConsecutiveValues(fieldValueList, startRow, rowGroup);
            this.fillDataWithTemplate(sheet, startRow, startCol, fieldValueList, templateCell, dataType);
            for (Map.Entry<Object, List<Integer>> entry : valueGroups.entrySet()) {
                List<Integer> rows = entry.getValue();
                if (rows.size() <= 1) continue;
                IMergeData mergeData = new IMergeData();
                mergeData.setStartRow(rows.get(0).intValue());
                mergeData.setEndRow(rows.get(rows.size() - 1).intValue());
                mergeData.setStartColumn(startCol);
                mergeData.setEndColumn(startCol);
                mergeDataList.add(mergeData);
            }
        } else {
            Map<Object, List<Integer>> valueGroups = this.groupConsecutiveValues(fieldValueList, startCol, cellGroup);
            this.fillDataWithTemplateHorizontal(sheet, startRow, startCol, fieldValueList, templateCell, dataType);
            for (Map.Entry<Object, List<Integer>> entry : valueGroups.entrySet()) {
                List<Integer> cols = entry.getValue();
                if (cols.size() <= 1) continue;
                IMergeData mergeData = new IMergeData();
                mergeData.setStartRow(startRow);
                mergeData.setEndRow(startRow);
                mergeData.setStartColumn(cols.get(0).intValue());
                mergeData.setEndColumn(cols.get(cols.size() - 1).intValue());
                mergeDataList.add(mergeData);
            }
        }
    }

    private List<Integer> processMasterColumnConfig(Map<String, Object> slaveColumnConfig, List<Map<String, Object>> valueListMap, int startRow) {
        String masterName;
        Map masterField;
        ArrayList<Integer> mMergeRow = new ArrayList<Integer>();
        List<Object> masterList = new ArrayList<Object>();
        Map mainColumnInfo = (Map)slaveColumnConfig.get("mainColumnInfo");
        if (HussarUtils.isNotEmpty((Object)mainColumnInfo) && HussarUtils.isNotEmpty((Object)(masterField = (Map)mainColumnInfo.get("field"))) && HussarUtils.isNotEmpty((Object)(masterName = (String)masterField.get("field")))) {
            masterList = valueListMap.stream().filter(map -> map.containsKey(masterName)).map(map -> map.get(masterName)).collect(Collectors.toList());
        }
        Map<Object, List<Integer>> valueGroups = this.groupConsecutiveValues(masterList, startRow, new ArrayList<Integer>());
        for (Map.Entry<Object, List<Integer>> entry : valueGroups.entrySet()) {
            List<Integer> rows = entry.getValue();
            mMergeRow.add(rows.get(0));
        }
        return mMergeRow;
    }

    private void shiftDownAndCopyCells(Sheet sheet, int startCol, int lastRowNum, int startRow, int down, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight) {
        if (down <= 0) {
            return;
        }
        for (int i = lastRowNum; i > startRow; --i) {
            Cell oldCell;
            Row row = sheet.getRow(i);
            if (row == null || (oldCell = row.getCell(startCol)) == null) continue;
            Row newRow = sheet.getRow(i + down);
            if (newRow == null) {
                newRow = sheet.createRow(i + down);
            }
            Cell newCell = newRow.createCell(startCol);
            this.copyCell(oldCell, newCell);
            oldCell.setCellType(CellType.BLANK);
            oldCell.setCellStyle(sheet.getWorkbook().createCellStyle());
        }
    }

    private void shiftDownAndCopyEntireRowExCol(Sheet sheet, int lastRowNum, int startRow, int down, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, int startCol, int endCol) {
        if (down <= 0) {
            return;
        }
        for (int i = lastRowNum; i > startRow; --i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            Row newRow = sheet.getRow(i + down);
            if (newRow == null) {
                newRow = sheet.createRow(i + down);
            }
            for (Cell cell : row) {
                int colIndex = cell.getColumnIndex();
                if (startCol <= colIndex && colIndex <= endCol) continue;
                Cell newCell = newRow.createCell(cell.getColumnIndex());
                this.copyCell(cell, newCell);
                cell.setCellType(CellType.BLANK);
                cell.setCellStyle(sheet.getWorkbook().createCellStyle());
            }
        }
    }

    private void shiftDownAndCopyEntireRow(Sheet sheet, int lastRowNum, int startRow, int down, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight) {
        if (down <= 0) {
            return;
        }
        for (int i = lastRowNum; i > startRow; --i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            Row newRow = sheet.getRow(i + down);
            if (newRow == null) {
                newRow = sheet.createRow(i + down);
            }
            for (Cell cell : row) {
                Cell newCell = newRow.createCell(cell.getColumnIndex());
                this.copyCell(cell, newCell);
                cell.setCellType(CellType.BLANK);
                cell.setCellStyle(sheet.getWorkbook().createCellStyle());
            }
        }
    }

    private void shiftRightAndCopyCells(Sheet sheet, int startRow, int lastColNum, int startCol, int rightNum, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight) {
        Row row = sheet.getRow(startRow);
        if (row == null) {
            return;
        }
        if (rightNum == 0) {
            return;
        }
        for (int i = lastColNum; i > startCol; --i) {
            Cell oldCell = row.getCell(i);
            if (oldCell == null) continue;
            Cell newCell = row.createCell(i + rightNum);
            this.copyCell(oldCell, newCell);
            oldCell.setCellType(CellType.BLANK);
            oldCell.setCellStyle(sheet.getWorkbook().createCellStyle());
        }
    }

    private void shiftRightAndCopyEntireCellsExRow(Sheet sheet, int startCol, int rightNum, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, int startRow, int endRow) {
        if (rightNum == 0 || startCol < 0) {
            return;
        }
        int lastRowNum = sheet.getLastRowNum();
        for (int rowNum = 0; rowNum <= lastRowNum; ++rowNum) {
            int endCol;
            Row row;
            if (startRow <= rowNum && rowNum <= endRow || (row = sheet.getRow(rowNum)) == null) continue;
            for (int i = endCol = row.getLastCellNum(); i > startCol; --i) {
                Cell oldCell = row.getCell(i);
                if (oldCell == null) continue;
                Cell newCell = row.createCell(i + rightNum);
                this.copyCell(oldCell, newCell);
                oldCell.setCellType(CellType.BLANK);
                oldCell.setCellStyle(sheet.getWorkbook().createCellStyle());
            }
        }
    }

    private void shiftRightAndCopyEntireCells(Sheet sheet, int startCol, int rightNum, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight) {
        if (rightNum == 0 || startCol < 0) {
            return;
        }
        int lastRowNum = sheet.getLastRowNum();
        for (int rowNum = 0; rowNum <= lastRowNum; ++rowNum) {
            int endCol;
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            for (int i = endCol = row.getLastCellNum(); i > startCol; --i) {
                Cell oldCell = row.getCell(i);
                if (oldCell == null) continue;
                Cell newCell = row.createCell(i + rightNum);
                this.copyCell(oldCell, newCell);
                oldCell.setCellType(CellType.BLANK);
                oldCell.setCellStyle(sheet.getWorkbook().createCellStyle());
            }
        }
    }

    private void fillDataWithTemplate(Sheet sheet, int startRow, int startCol, List<Object> fieldValueList, Cell templateCell, String dataType) {
        Row templateRow = templateCell.getRow();
        short templateRowHeight = templateCell.getCellStyle().getWrapText() || templateRow.getHeight() == sheet.getDefaultRowHeight() ? (short)-1 : (short)templateRow.getHeight();
        boolean isColumnWidthSet = false;
        for (int i = 0; i < fieldValueList.size(); ++i) {
            Object val;
            Cell targetCell;
            int currentRowNum = startRow + i;
            Row targetRow = sheet.getRow(currentRowNum);
            if (targetRow == null) {
                targetRow = sheet.createRow(currentRowNum);
            }
            if (i != 0 && templateRow != null) {
                targetRow.setHeight(templateRowHeight);
            }
            if ((targetCell = targetRow.getCell(startCol)) == null) {
                targetCell = targetRow.createCell(startCol);
            }
            if (templateCell != null && i != 0) {
                this.copyCell(templateCell, targetCell);
                if (!isColumnWidthSet) {
                    int templateColWidth = sheet.getColumnWidth(templateCell.getColumnIndex());
                    sheet.setColumnWidth(startCol, templateColWidth);
                    isColumnWidthSet = true;
                }
            }
            if ((val = fieldValueList.get(i)) == null) continue;
            this.setCellValueByDataType(targetCell, val, dataType);
        }
    }

    private void fillDataWithTemplateByRowCol(Sheet sheet, int startRow, int startCol, List<List<Object>> fieldValueMatrix, Cell templateCell, String dataType) {
        short templateRowHeight = -1;
        HashMap<Integer, Integer> templateColWidths = new HashMap<Integer, Integer>();
        if (templateCell != null && !templateCell.getCellStyle().getWrapText() && templateCell.getRow().getHeight() != sheet.getDefaultRowHeight()) {
            templateRowHeight = templateCell.getRow().getHeight();
        }
        for (int i = 0; i < fieldValueMatrix.size(); ++i) {
            int currentRowNum = startRow + i;
            Row targetRow = sheet.getRow(currentRowNum);
            if (targetRow == null) {
                targetRow = sheet.createRow(currentRowNum);
            }
            if (i != 0 && templateCell != null) {
                targetRow.setHeight(templateRowHeight);
            }
            List<Object> rowData = fieldValueMatrix.get(i);
            for (int j = 0; j < rowData.size(); ++j) {
                Object val;
                int currentColNum = startCol + j;
                Cell targetCell = targetRow.getCell(currentColNum);
                if (targetCell == null) {
                    targetCell = targetRow.createCell(currentColNum);
                }
                if (templateCell != null && (i != 0 || j != 0)) {
                    this.copyCell(templateCell, targetCell);
                }
                if (templateCell != null && !templateColWidths.containsKey(currentColNum)) {
                    int templateColWidth = sheet.getColumnWidth(templateCell.getColumnIndex());
                    int currentColWidth = sheet.getColumnWidth(currentColNum);
                    if (currentColWidth <= 0 || currentColWidth == sheet.getDefaultColumnWidth()) {
                        sheet.setColumnWidth(currentColNum, templateColWidth);
                    }
                    templateColWidths.put(currentColNum, templateColWidth);
                }
                if ((val = rowData.get(j)) != null) {
                    this.setCellValueByDataType(targetCell, val, dataType);
                    continue;
                }
                targetCell.setCellValue("");
            }
        }
    }

    private void fillDataWithTemplateHorizontal(Sheet sheet, int startRow, int startCol, List<Object> fieldValueList, Cell templateCell, String dataType) {
        Row templateRow = templateCell.getRow();
        short templateRowHeight = templateCell.getCellStyle().getWrapText() || templateRow.getHeight() == sheet.getDefaultRowHeight() ? (short)-1 : (short)templateRow.getHeight();
        int templateColWidth = sheet.getColumnWidth(templateCell.getColumnIndex());
        for (int i = 0; i < fieldValueList.size(); ++i) {
            Object val;
            Cell targetCell;
            Row targetRow = sheet.getRow(startRow);
            if (targetRow == null) {
                targetRow = sheet.createRow(startRow);
            }
            if (i == 0 && templateRow != null) {
                targetRow.setHeight(templateRowHeight);
            }
            if ((targetCell = targetRow.getCell(startCol + i)) == null) {
                targetCell = targetRow.createCell(startCol + i);
            }
            if (templateCell != null) {
                this.copyCell(templateCell, targetCell);
                sheet.setColumnWidth(startCol + i, templateColWidth);
            }
            if ((val = fieldValueList.get(i)) == null) continue;
            this.setCellValueByDataType(targetCell, val, dataType);
        }
    }

    private void fillDataWithTemplateAll(Sheet sheet, int startRow, int startCol, List<Object> fieldValueList, Cell templateCell, int overRow, int overCol, int cycleNum, int count, String dataType) {
        short templateRowHeight;
        Row templateRow = templateCell.getRow();
        short s = templateRowHeight = templateRow != null ? (short)templateRow.getHeight() : (short)-1;
        if (templateCell.getCellStyle().getWrapText() || templateRow.getHeight() == sheet.getDefaultRowHeight()) {
            templateRowHeight = -1;
        }
        int templateColWidth = sheet.getColumnWidth(templateCell.getColumnIndex());
        block0: for (int i = 0; i < (count + cycleNum - 1) / cycleNum; ++i) {
            int targetRowNum = startRow + overRow * i;
            Row targetRow = sheet.getRow(targetRowNum);
            if (targetRow == null) {
                targetRow = sheet.createRow(targetRowNum);
            }
            if (i == 0 && templateRow != null) {
                targetRow.setHeight(templateRowHeight);
            }
            for (int j = 0; j < cycleNum; ++j) {
                int index = i * cycleNum + j;
                if (HussarUtils.isNotEmpty(fieldValueList) && index >= fieldValueList.size() || index >= count) continue block0;
                int targetColNum = startCol + overCol * j;
                Cell targetCell = targetRow.getCell(targetColNum);
                if (targetCell == null) {
                    targetCell = targetRow.createCell(targetColNum);
                }
                if (templateCell != null && (i != 0 || j != 0)) {
                    int currentColWidth;
                    this.copyCell(templateCell, targetCell);
                    if (j != 0 && ((currentColWidth = sheet.getColumnWidth(targetColNum)) <= 0 || currentColWidth != templateColWidth)) {
                        sheet.setColumnWidth(targetColNum, templateColWidth);
                    }
                }
                if (!HussarUtils.isNotEmpty(fieldValueList)) continue;
                Object val = fieldValueList.get(index);
                if (val != null) {
                    this.setCellValueByDataType(targetCell, val, dataType);
                    continue;
                }
                targetCell.setCellValue("");
            }
        }
    }

    private void processAndFillLoopAreaData(Sheet sheet, int startRow, int startCol, int endRow, int endCol, Map<String, Map<String, Object>> customCells, List<DataSetExecuteVO> dataSetExecuteVOList, int cycleNum, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, List<IMergeData> mergeDataList, List<Integer> rowGroup, List<Integer> cellGroup, Map<String, String> formulaList, Map<String, List<Map<String, Object>>> formulaStyles, Map<String, Map<String, String>> loopFormulaList, Map<String, Map<String, Object>> loopFormulaStyles) {
        int cellNum;
        int rowNum;
        String[] parts;
        Integer offRightValue;
        Integer offDownValue;
        int count = 0;
        Collection valueListMap = null;
        int overRow = endRow - startRow + 1;
        int overCol = endCol - startCol + 1;
        HashMap<String, List<Object>> fieldValueListMap = new HashMap<String, List<Object>>();
        HashMap<String, String> dataTypeMap = new HashMap<String, String>();
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startCol; j <= endCol; ++j) {
                Map<String, Object> custom;
                List<Object> fieldValueList = new ArrayList();
                String key = i + "," + j;
                if (!customCells.containsKey(key) || !HussarUtils.isNotEmpty(custom = customCells.get(key))) continue;
                Map field = (Map)custom.get("field");
                if (HussarUtils.isNotEmpty((Object)field)) {
                    String dataSetId = (String)field.get("dataSetId");
                    Iterator<Map.Entry<String, Object>> fieldName = (String)field.get("field");
                    String string = (String)field.get("dataType");
                    if (HussarUtils.isEmpty(fieldValueList)) {
                        String value = dataSetExecuteVOList.stream().filter(vo -> dataSetId.equals(vo.getDataSetId())).map(DataSetExecuteVO::getReturnValue).findFirst().orElse(null);
                        ObjectMapper objectMapper = new ObjectMapper();
                        try {
                            valueListMap = (List)objectMapper.convertValue((Object)objectMapper.readTree(value), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                        }
                        catch (JsonProcessingException e) {
                            logger.error("\u65e0\u6cd5\u5c06 value \u8f6c\u6362\u4e3a List<Map<String, Object>>\uff1a{}", (Object)value, (Object)e);
                        }
                    }
                    if (HussarUtils.isNotEmpty(valueListMap) && HussarUtils.isNotEmpty((Object)fieldName)) {
                        fieldValueList = valueListMap.stream().filter(arg_0 -> ExcelExporterServiceImpl.lambda$processAndFillLoopAreaData$14((String)((Object)fieldName), arg_0)).map(arg_0 -> ExcelExporterServiceImpl.lambda$processAndFillLoopAreaData$15((String)((Object)fieldName), arg_0)).collect(Collectors.toList());
                        fieldValueListMap.put(key, fieldValueList);
                        dataTypeMap.put(key, string);
                        if (count < fieldValueList.size()) {
                            count = fieldValueList.size();
                        }
                    }
                }
                customCells.remove(key);
            }
        }
        int downcyc = (int)Math.ceil((double)count / (double)cycleNum) - 1;
        if (count < cycleNum) {
            cycleNum = count;
        }
        int lastRowNum = sheet.getLastRowNum();
        int offDownNum = 0;
        int offRightNum = 0;
        if (HussarUtils.isNotEmpty(offsetDown)) {
            offDownNum = this.getSumOfValuesLessThanNum(offsetDown, endRow);
        }
        if (HussarUtils.isNotEmpty(offsetRight)) {
            offRightNum = this.getSumOfValuesLessThanNum(offsetRight, endCol);
        }
        if ((offDownValue = offsetDown.getOrDefault(endRow + offDownNum, 0)) < downcyc * (endRow - startRow + 1)) {
            offsetDown.put(endRow, downcyc * (endRow - startRow + 1));
            this.shiftDownAndCopyEntireRow(sheet, lastRowNum, endRow + offDownNum, downcyc * (endRow - startRow + 1) - offDownValue, offsetDown, offsetRight);
            this.shiftMergeDown(endRow + offDownNum, downcyc * (endRow - startRow + 1) - offDownValue, mergeDataList);
        }
        if ((offRightValue = offsetRight.getOrDefault(endCol + offRightNum, 0)) < overCol * (cycleNum - 1)) {
            offsetRight.put(endCol, overCol * (cycleNum - 1));
            this.shiftRightAndCopyEntireCells(sheet, endCol + offRightNum, overCol * (cycleNum - 1) - offRightValue, offsetDown, offsetRight);
            this.shiftMergeRight(endCol + offRightNum, overCol * (cycleNum - 1) - offRightValue, mergeDataList);
        }
        ArrayList<IMergeData> mergeDataListCyc = new ArrayList<IMergeData>();
        for (IMergeData iMergeData : mergeDataList) {
            if (iMergeData.getStartRow() < startRow + offDownNum || iMergeData.getStartRow() > endRow + offDownNum || iMergeData.getStartColumn() < startCol + offRightNum || iMergeData.getStartColumn() > endCol + offRightNum) continue;
            for (int i = 0; i < (count + cycleNum - 1) / cycleNum; ++i) {
                for (int j = 0; j < cycleNum; ++j) {
                    IMergeData mergeDataCyc = new IMergeData();
                    mergeDataCyc.setStartRow(iMergeData.getStartRow() + i * overRow + offDownNum);
                    mergeDataCyc.setStartColumn(iMergeData.getStartColumn() + j * overCol + offRightNum);
                    mergeDataCyc.setEndRow(iMergeData.getEndRow() + i * overRow + offDownNum);
                    mergeDataCyc.setEndColumn(iMergeData.getEndColumn() + j * overCol + offRightNum);
                    mergeDataListCyc.add(mergeDataCyc);
                }
            }
        }
        mergeDataList.addAll(mergeDataListCyc);
        for (Map.Entry<String, String> entry : formulaList.entrySet()) {
            String key = entry.getKey();
            String formula = entry.getValue();
            parts = key.split(",");
            rowNum = Integer.parseInt(parts[0]);
            cellNum = Integer.parseInt(parts[1]);
            if (rowNum < startRow || rowNum > endRow || cellNum < startCol || cellNum > endCol) continue;
            HashMap<String, String> formulaParameter = new HashMap<String, String>();
            formulaParameter.put("overRow", String.valueOf(overRow));
            formulaParameter.put("overCol", String.valueOf(overCol));
            formulaParameter.put("cycleNum", String.valueOf(cycleNum));
            formulaParameter.put("count", String.valueOf(count));
            formulaParameter.put("formula", formula);
            loopFormulaList.put(key, formulaParameter);
        }
        for (Map.Entry<String, Object> entry : formulaStyles.entrySet()) {
            String key = entry.getKey();
            List formulaStyle = (List)entry.getValue();
            parts = key.split(",");
            rowNum = Integer.parseInt(parts[0]);
            cellNum = Integer.parseInt(parts[1]);
            if (rowNum < startRow || rowNum > endRow || cellNum < startCol || cellNum > endCol) continue;
            HashMap<String, Object> formulaStyleParameter = new HashMap<String, Object>();
            formulaStyleParameter.put("overRow", overRow);
            formulaStyleParameter.put("overCol", overCol);
            formulaStyleParameter.put("cycleNum", cycleNum);
            formulaStyleParameter.put("count", count);
            formulaStyleParameter.put("formulaStyle", formulaStyle);
            loopFormulaStyles.put(key, formulaStyleParameter);
        }
        endRow += offDownNum;
        startCol += offRightNum;
        endCol += offRightNum;
        for (int i = startRow += offDownNum; i <= endRow; ++i) {
            for (int j = startCol; j <= endCol; ++j) {
                ArrayList<Object> fieldValueList = new ArrayList();
                String dataType = null;
                String key = i - offDownNum + "," + (j - offRightNum);
                if (fieldValueListMap.containsKey(key)) {
                    fieldValueList = (List)fieldValueListMap.get(key);
                }
                if (dataTypeMap.containsKey(key)) {
                    dataType = (String)dataTypeMap.get(key);
                }
                Cell cell = sheet.getRow(i).getCell(j);
                this.fillDataWithTemplateAll(sheet, i, j, fieldValueList, cell, overRow, overCol, cycleNum, count, dataType);
            }
        }
    }

    private List<Map<String, Object>> getValueListMapFromCustom(Map<String, Object> custom, List<DataSetExecuteVO> dataSetExecuteVOList) {
        Map field = (Map)custom.get("field");
        List valueListMap = null;
        if (HussarUtils.isNotEmpty((Object)field)) {
            String dataSetId = (String)field.get("dataSetId");
            String value = dataSetExecuteVOList.stream().filter(vo -> dataSetId.equals(vo.getDataSetId())).map(DataSetExecuteVO::getReturnValue).findFirst().orElse(null);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                if (HussarUtils.isNotEmpty((Object)value)) {
                    valueListMap = (List)objectMapper.convertValue((Object)objectMapper.readTree(value), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                }
            }
            catch (JsonProcessingException e) {
                logger.error("\u65e0\u6cd5\u5c06 value \u8f6c\u6362\u4e3a List<Map<String, Object>>\uff1a{}", (Object)value, (Object)e);
            }
        }
        return valueListMap;
    }

    private List<Map<String, Object>> sortValueListByFieldList(List<Map<String, Object>> valueList, List<String> fieldList) {
        if (valueList == null || fieldList == null || fieldList.isEmpty()) {
            return valueList;
        }
        return this.recursiveGrouping(valueList, fieldList, 0);
    }

    private List<Map<String, Object>> recursiveGrouping(List<Map<String, Object>> valueList, List<String> fieldList, int level) {
        if (level >= fieldList.size() || valueList.isEmpty()) {
            return valueList;
        }
        LinkedHashMap<String, List> groupedMap = new LinkedHashMap<String, List>();
        String currentFieldName = fieldList.get(level);
        for (Map<String, Object> item : valueList) {
            if (!item.containsKey(currentFieldName)) continue;
            Object key = item.get(currentFieldName);
            groupedMap.computeIfAbsent(key.toString(), k -> new ArrayList()).add(item);
        }
        ArrayList<Map<String, Object>> sortedList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : groupedMap.entrySet()) {
            List group = (List)entry.getValue();
            List<Map<String, Object>> sortedGroup = this.recursiveGrouping(group, fieldList, level + 1);
            sortedList.addAll(sortedGroup);
        }
        return sortedList;
    }

    private void processAndSortGroupedData(Map<String, Object> custom, Map<String, Map<String, List<Map<String, Object>>>> valueMap, Map<String, Map<String, List<String>>> groupField, List<DataSetExecuteVO> dataSetExecuteVOList, int rowNum, int cellNum, Boolean isGroup) {
        String direction = (String)custom.get("direction");
        Map field = (Map)custom.get("field");
        if (field == null || field.get("dataSetId") == null) {
            return;
        }
        String dataSetId = (String)field.get("dataSetId");
        String fieldName = (String)field.get("field");
        Map valueListMap = valueMap.getOrDefault(dataSetId, new HashMap());
        Map fieldListMap = groupField.getOrDefault(dataSetId, new HashMap());
        List<Map<String, Object>> valueList = this.getValueListMapFromCustom(custom, dataSetExecuteVOList);
        List<String> fieldList = new ArrayList<String>();
        if (Arrangement.VERTICAL.getValue().equals(direction)) {
            if (HussarUtils.isNotEmpty((Object)fieldListMap) && HussarUtils.isNotEmpty(valueListMap.get(Arrangement.VERTICAL.getValue() + rowNum))) {
                fieldList = (List)fieldListMap.get(Arrangement.VERTICAL.getValue() + rowNum);
            }
            fieldList.add(fieldName);
            valueList = this.sortValueListByFieldList(valueList, fieldList);
            if (isGroup.booleanValue()) {
                valueListMap.put(Arrangement.VERTICAL.getValue() + rowNum, valueList);
                valueMap.put(dataSetId, valueListMap);
                fieldListMap.put(Arrangement.VERTICAL.getValue() + rowNum, fieldList);
                groupField.put(dataSetId, fieldListMap);
            } else {
                valueListMap.put(Arrangement.VERTICAL.getValue() + "," + rowNum + "," + (cellNum + 1), valueList);
                valueMap.put(dataSetId, valueListMap);
                fieldListMap.put(Arrangement.VERTICAL.getValue() + "," + rowNum + "," + (cellNum + 1), fieldList);
                groupField.put(dataSetId, fieldListMap);
            }
        } else if (Arrangement.HORIZONTAL.getValue().equals(direction)) {
            if (HussarUtils.isNotEmpty((Object)fieldListMap) && HussarUtils.isNotEmpty(valueListMap.get(Arrangement.HORIZONTAL.getValue() + cellNum))) {
                fieldList = (List)fieldListMap.get(Arrangement.HORIZONTAL.getValue() + cellNum);
            }
            fieldList.add(fieldName);
            valueList = this.sortValueListByFieldList(valueList, fieldList);
            if (isGroup.booleanValue()) {
                valueListMap.put(Arrangement.HORIZONTAL.getValue() + cellNum, valueList);
                valueMap.put(dataSetId, valueListMap);
                fieldListMap.put(Arrangement.HORIZONTAL.getValue() + cellNum, fieldList);
                groupField.put(dataSetId, fieldListMap);
            } else {
                valueListMap.put(Arrangement.HORIZONTAL.getValue() + "," + (rowNum + 1) + "," + cellNum, valueList);
                valueMap.put(dataSetId, valueListMap);
                fieldListMap.put(Arrangement.HORIZONTAL.getValue() + "," + (rowNum + 1) + "," + cellNum, fieldList);
                groupField.put(dataSetId, fieldListMap);
            }
        }
    }

    public Map<Object, List<Integer>> groupConsecutiveValues(List<Object> fieldValueList, int startIdx, List<Integer> indexList) {
        if (fieldValueList == null || fieldValueList.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, List<Integer>> valueGroups = new LinkedHashMap<Object, List<Integer>>();
        Object previousValue = null;
        ArrayList<Integer> currentGroup = null;
        for (int i = 0; i < fieldValueList.size(); ++i) {
            Object value = fieldValueList.get(i);
            int currentIndex = startIdx + i;
            if (HussarUtils.isNotEmpty(indexList) && indexList.contains(currentIndex)) {
                if (currentGroup != null) {
                    valueGroups.put(i, currentGroup);
                }
                currentGroup = new ArrayList();
                currentGroup.add(currentIndex);
                previousValue = value;
            }
            if (value.equals(previousValue)) {
                currentGroup.add(currentIndex);
                continue;
            }
            if (currentGroup != null) {
                valueGroups.put(i, currentGroup);
            }
            currentGroup = new ArrayList<Integer>();
            currentGroup.add(currentIndex);
            previousValue = value;
            indexList.add(currentIndex);
        }
        if (currentGroup != null && !currentGroup.isEmpty()) {
            valueGroups.put(previousValue, (List<Integer>)currentGroup);
        }
        return valueGroups;
    }

    private boolean isOverlapping(Sheet sheet, CellRangeAddress newRegion) {
        for (CellRangeAddress existing : sheet.getMergedRegions()) {
            if (!newRegion.intersects((CellRangeAddressBase)existing)) continue;
            return true;
        }
        return false;
    }

    private CellStyle createDateCellStyle(XSSFWorkbook workbook, String pattern) {
        XSSFCellStyle dateStyle = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        font.setFontName("Arial");
        font.setFontHeightInPoints((short)10);
        dateStyle.setFont((Font)font);
        XSSFDataFormat dataFormat = workbook.createDataFormat();
        dateStyle.setDataFormat(dataFormat.getFormat(pattern));
        return dateStyle;
    }

    private void processFormulaStyles(Sheet sheet, Map<String, List<Map<String, Object>>> formulaStyles, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight) {
        for (Map.Entry<String, List<Map<String, Object>>> outerEntry : formulaStyles.entrySet()) {
            String key = outerEntry.getKey();
            String[] parts = key.split(",");
            int startRow = Integer.parseInt(parts[0]);
            int startCell = Integer.parseInt(parts[1]);
            int offDownNum = 0;
            int offRightNum = 0;
            if (HussarUtils.isNotEmpty(offsetDown)) {
                offDownNum = this.getSumOfValuesLessThanNum(offsetDown, startRow);
            }
            if (HussarUtils.isNotEmpty(offsetRight)) {
                offRightNum = this.getSumOfValuesLessThanNum(offsetRight, startCell);
            }
            int formulaNum = 0;
            if (HussarUtils.isNotEmpty(offsetDown)) {
                formulaNum = HussarUtils.isNotEmpty((Object)offsetDown.get(startRow)) ? offsetDown.get(startRow) : 0;
            }
            startCell += offRightNum;
            List<Map<String, Object>> innerMap = outerEntry.getValue();
            innerMap.removeIf(innerMapEntry -> (Boolean)innerMapEntry.get("active") == false);
            block1: for (int rowNum = startRow += offDownNum; rowNum <= startRow + formulaNum; ++rowNum) {
                for (Map<String, Object> innerMapEntry2 : innerMap) {
                    String formulaStr;
                    Map formula = (Map)innerMapEntry2.get("formula");
                    if (!HussarUtils.isNotEmpty((Object)formula) || !HussarUtils.isNotEmpty((Object)(formulaStr = (String)formula.get("formulaStr")))) continue;
                    formulaStr = formulaStr.replace("'", "\"");
                    List formulaParam = (List)formula.get("formulaParam");
                    if (HussarUtils.isNotEmpty((Object)formulaParam)) {
                        for (Map param : formulaParam) {
                            formulaStr = formulaStr.replace((CharSequence)param.get("replacedStr"), ExcelExporterServiceImpl.numberToExcelColumn(Integer.parseInt((String)param.get("configData")) + offRightNum) + (rowNum + 1));
                        }
                    }
                    if (HussarUtils.equals((Object)FormulaUtils.evaluateFormula(formulaStr, sheet), (Object)false)) continue;
                    Map colorPresets = (Map)innerMapEntry2.get("colorPresets");
                    if (!HussarUtils.isNotEmpty((Object)colorPresets)) continue block1;
                    this.modifyCellColors(sheet.getRow(rowNum).getCell(startCell), (String)colorPresets.get("background"), (String)colorPresets.get("color"));
                    continue block1;
                }
            }
        }
    }

    private void processFormulaStylesForLoop(Sheet sheet, Map<String, Map<String, Object>> loopFormulaStyles, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, Map<String, List<Map<String, Object>>> formulaStyles) {
        for (Map.Entry<String, Map<String, Object>> outerEntry : loopFormulaStyles.entrySet()) {
            String key = outerEntry.getKey();
            formulaStyles.remove(key);
            String[] parts = key.split(",");
            int startRow = Integer.parseInt(parts[0]);
            int startCell = Integer.parseInt(parts[1]);
            int offDownNum = 0;
            int offRightNum = 0;
            if (HussarUtils.isNotEmpty(offsetDown)) {
                offDownNum = this.getSumOfValuesLessThanNum(offsetDown, startRow);
            }
            if (HussarUtils.isNotEmpty(offsetRight)) {
                offRightNum = this.getSumOfValuesLessThanNum(offsetRight, startCell);
            }
            startRow += offDownNum;
            startCell += offRightNum;
            Map<String, Object> innerMapValue = outerEntry.getValue();
            List innerMap = (List)innerMapValue.get("formulaStyle");
            innerMap.removeIf(innerMapEntry -> (Boolean)innerMapEntry.get("active") == false);
            int count = (Integer)innerMapValue.get("count");
            int overRow = (Integer)innerMapValue.get("overRow");
            int overCol = (Integer)innerMapValue.get("overCol");
            int cycleNum = (Integer)innerMapValue.get("cycleNum");
            for (int i = 0; i < count; ++i) {
                int index;
                block2: for (int j = 0; j < cycleNum && (index = i * cycleNum + j) < count; ++j) {
                    int targetRowNum = startRow + overRow * i;
                    int targetColNum = startCell + overCol * j;
                    for (Map innerMapEntry2 : innerMap) {
                        String formulaStr;
                        Map formula = (Map)innerMapEntry2.get("formula");
                        if (!HussarUtils.isNotEmpty((Object)formula) || !HussarUtils.isNotEmpty((Object)(formulaStr = (String)formula.get("formulaStr")))) continue;
                        formulaStr = formulaStr.replace("'", "\"");
                        List formulaParam = (List)formula.get("formulaParam");
                        if (HussarUtils.isNotEmpty((Object)formulaParam)) {
                            for (Map param : formulaParam) {
                                int configRow = startRow;
                                if (HussarUtils.isNotEmpty(param.get("configRow"))) {
                                    configRow = Integer.parseInt((String)param.get("configRow")) + offDownNum;
                                }
                                formulaStr = formulaStr.replace((CharSequence)param.get("replacedStr"), ExcelExporterServiceImpl.numberToExcelColumn(Integer.parseInt((String)param.get("configData")) + offRightNum + overCol * j) + (configRow + overRow * i + 1));
                            }
                        }
                        if (HussarUtils.equals((Object)FormulaUtils.evaluateFormula(formulaStr, sheet), (Object)false)) continue;
                        Map colorPresets = (Map)innerMapEntry2.get("colorPresets");
                        if (!HussarUtils.isNotEmpty((Object)colorPresets)) continue block2;
                        this.modifyCellColors(sheet.getRow(targetRowNum).getCell(targetColNum), (String)colorPresets.get("background"), (String)colorPresets.get("color"));
                        continue block2;
                    }
                }
            }
        }
    }

    public void modifyCellColors(Cell cell, String bgColor, String fontColor) {
        if (cell == null) {
            return;
        }
        XSSFWorkbook workbook = (XSSFWorkbook)cell.getSheet().getWorkbook();
        CellStyle originalStyle = cell.getCellStyle();
        XSSFCellStyle newStyle = workbook.createCellStyle();
        newStyle.cloneStyleFrom(originalStyle);
        if (bgColor != null && !bgColor.isEmpty()) {
            byte[] bgRgb = this.hexToRgb(bgColor);
            XSSFColor backgroundColor = new XSSFColor(bgRgb, null);
            newStyle.setFillForegroundColor(backgroundColor);
            newStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (fontColor != null && !fontColor.isEmpty()) {
            XSSFFont originalFont = workbook.getFontAt(originalStyle.getFontIndex());
            XSSFFont newFont = workbook.createFont();
            newFont.setFontName(originalFont.getFontName());
            newFont.setFontHeightInPoints(originalFont.getFontHeightInPoints());
            newFont.setBold(originalFont.getBold());
            newFont.setItalic(originalFont.getItalic());
            newFont.setUnderline(originalFont.getUnderline());
            newFont.setStrikeout(originalFont.getStrikeout());
            byte[] fontRgb = this.hexToRgb(fontColor);
            XSSFColor fontColorXSSF = new XSSFColor(fontRgb, null);
            newFont.setColor(fontColorXSSF);
            newStyle.setFont((Font)newFont);
        }
        cell.setCellStyle((CellStyle)newStyle);
    }

    public static String numberToExcelColumn(int num) {
        StringBuilder result = new StringBuilder();
        ++num;
        while (num > 0) {
            char ch = (char)(65 + --num % 26);
            result.insert(0, ch);
            num /= 26;
        }
        return result.toString();
    }

    public static int excelColumnToNumber(String column) {
        int result = 0;
        for (int i = 0; i < column.length(); ++i) {
            char ch = column.charAt(i);
            int value = ch - 65 + 1;
            result = result * 26 + value;
        }
        return result - 1;
    }

    public static String extractLetters(String reference) {
        if (reference == null || reference.isEmpty()) {
            return "";
        }
        StringBuilder letters = new StringBuilder();
        for (char ch : reference.toCharArray()) {
            if (!Character.isLetter(ch)) break;
            letters.append(ch);
        }
        return letters.toString();
    }

    public static int extractNumbers(String reference) {
        try {
            if (reference == null || reference.isEmpty()) {
                return -1;
            }
            StringBuilder numbers = new StringBuilder();
            for (char ch : reference.toCharArray()) {
                if (!Character.isDigit(ch)) continue;
                numbers.append(ch);
            }
            return Integer.parseInt(numbers.toString());
        }
        catch (NumberFormatException e) {
            System.err.println("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u6570\u5b57: " + reference);
            return -1;
        }
    }

    public int getSumOfValuesLessThanNum(Map<Integer, Integer> offMap, int num) {
        return offMap.entrySet().stream().filter(entry -> (Integer)entry.getKey() < num).map(Map.Entry::getValue).mapToInt(Integer::intValue).sum();
    }

    public void shiftMergeDownExArea(int startRow, int down, List<IMergeData> mergeDataList, int exStartRow, int exEndRow, int exStartCol, int exEndCol) {
        if (HussarUtils.isNotEmpty(mergeDataList)) {
            for (IMergeData mergeData : mergeDataList) {
                if (mergeData.getStartRow() <= startRow || mergeData.getStartRow() >= exStartRow && mergeData.getStartRow() <= exEndRow && mergeData.getStartColumn() >= exStartCol && mergeData.getEndColumn() <= exEndCol) continue;
                mergeData.setStartRow(mergeData.getStartRow() + down);
                mergeData.setEndRow(mergeData.getEndRow() + down);
            }
        }
    }

    public void shiftMergeRightExArea(int startCol, int right, List<IMergeData> mergeDataList, int exStartRow, int exEndRow, int exStartCol, int exEndCol) {
        if (HussarUtils.isNotEmpty(mergeDataList)) {
            for (IMergeData mergeData : mergeDataList) {
                if (mergeData.getStartColumn() <= startCol || mergeData.getStartRow() >= exStartRow && mergeData.getStartRow() <= exEndRow && mergeData.getStartColumn() >= exStartCol && mergeData.getEndColumn() <= exEndCol) continue;
                mergeData.setStartColumn(mergeData.getStartColumn() + right);
                mergeData.setEndColumn(mergeData.getEndColumn() + right);
            }
        }
    }

    public void shiftMergeDown(int startRow, int down, List<IMergeData> mergeDataList) {
        if (HussarUtils.isNotEmpty(mergeDataList)) {
            for (IMergeData mergeData : mergeDataList) {
                if (mergeData.getStartRow() <= startRow) continue;
                mergeData.setStartRow(mergeData.getStartRow() + down);
                mergeData.setEndRow(mergeData.getEndRow() + down);
            }
        }
    }

    public void shiftMergeRight(int startCol, int right, List<IMergeData> mergeDataList) {
        if (HussarUtils.isNotEmpty(mergeDataList)) {
            for (IMergeData mergeData : mergeDataList) {
                if (mergeData.getStartColumn() <= startCol) continue;
                mergeData.setStartColumn(mergeData.getStartColumn() + right);
                mergeData.setEndColumn(mergeData.getEndColumn() + right);
            }
        }
    }

    private void setCellValueByDataType(Cell targetCell, Object val, String dataType) {
        if (val == null) {
            targetCell.setCellValue("");
            return;
        }
        try {
            if (FrontDataTypeEnum.DATE.getValue().equals(dataType)) {
                targetCell.setCellValue(DateUtil.parseDateTime((String)val.toString()).doubleValue());
            } else if (FrontDataTypeEnum.INTEGER.getValue().equals(dataType) || FrontDataTypeEnum.LONG.getValue().equals(dataType)) {
                targetCell.setCellValue((double)Integer.parseInt(val.toString()));
            } else if (FrontDataTypeEnum.DOUBLE.getValue().equals(dataType)) {
                targetCell.setCellValue(Double.parseDouble(val.toString()));
            } else {
                targetCell.setCellValue(val.toString());
            }
        }
        catch (Exception e) {
            targetCell.setCellValue(val.toString());
        }
    }

    public static List<String> extractCellReferences(String formula, Sheet sheet) {
        Ptg[] ptgs;
        ArrayList<String> cellReferences = new ArrayList<String>();
        Workbook workbook = sheet.getWorkbook();
        XSSFEvaluationWorkbook evaluationWorkbook = XSSFEvaluationWorkbook.create((XSSFWorkbook)((XSSFWorkbook)workbook));
        int sheetIndex = workbook.getSheetIndex(sheet);
        for (Ptg ptg : ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)evaluationWorkbook, (FormulaType)FormulaType.CELL, (int)sheetIndex)) {
            if (ptg instanceof RefPtgBase) {
                RefPtgBase refPtg = (RefPtgBase)ptg;
                String cellAddress = refPtg.toFormulaString();
                cellReferences.add(cellAddress);
                continue;
            }
            if (!(ptg instanceof AreaPtgBase)) continue;
            AreaPtgBase areaPtg = (AreaPtgBase)ptg;
            int firstRow = areaPtg.getFirstRow();
            int firstColumn = areaPtg.getFirstColumn();
            String startCell = new CellReference(firstRow, firstColumn).formatAsString();
            int endRow = areaPtg.getLastRow();
            int endColumn = areaPtg.getLastColumn();
            String endCell = new CellReference(endRow, endColumn).formatAsString();
            cellReferences.add(startCell);
            cellReferences.add(endCell);
        }
        return cellReferences;
    }

    private void processFormula(Sheet sheet, int rowNum, int cellNum, String formula, List<String> references, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, Map<String, Map<String, Object>> customCells) {
        int offDownNum = 0;
        int offRightNum = 0;
        int num = 0;
        Boolean cycle = false;
        if (HussarUtils.isNotEmpty(offsetDown)) {
            offDownNum = this.getSumOfValuesLessThanNum(offsetDown, rowNum);
        }
        if (HussarUtils.isNotEmpty(offsetRight)) {
            offRightNum = this.getSumOfValuesLessThanNum(offsetRight, cellNum);
        }
        int startRow = rowNum + offDownNum;
        int startCol = cellNum + offRightNum;
        for (String reference : references) {
            String letter = ExcelExporterServiceImpl.extractLetters(reference);
            int referenceRow = ExcelExporterServiceImpl.extractNumbers(reference) - 1;
            int referenceCell = ExcelExporterServiceImpl.excelColumnToNumber(letter);
            if (!customCells.containsKey(referenceRow + "," + referenceCell)) continue;
            cycle = true;
            break;
        }
        if (cycle.booleanValue() && HussarUtils.isNotEmpty(offsetDown) && offsetDown.containsKey(rowNum)) {
            num = offsetDown.get(rowNum);
        }
        Cell templateCell = sheet.getRow(startRow).getCell(startCol);
        this.shiftDownAndFillFormula(sheet, startRow, startCol, templateCell, offsetDown, offsetRight, ++num, references, formula);
    }

    private void processFormulaForLoop(Sheet sheet, int rowNum, int cellNum, String formula, List<String> references, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, Map<String, String> formulaParams) {
        int offDownNum = 0;
        int offRightNum = 0;
        int count = Integer.parseInt(formulaParams.get("count"));
        int overRow = Integer.parseInt(formulaParams.get("overRow"));
        int overCol = Integer.parseInt(formulaParams.get("overCol"));
        int cycleNum = Integer.parseInt(formulaParams.get("cycleNum"));
        if (HussarUtils.isNotEmpty(offsetDown)) {
            offDownNum = this.getSumOfValuesLessThanNum(offsetDown, rowNum);
        }
        if (HussarUtils.isNotEmpty(offsetRight)) {
            offRightNum = this.getSumOfValuesLessThanNum(offsetRight, cellNum);
        }
        int startRow = rowNum + offDownNum;
        int startCol = cellNum + offRightNum;
        Cell templateCell = sheet.getRow(startRow).getCell(startCol);
        this.shiftDownAndFillFormulaForLoop(sheet, startRow, startCol, templateCell, offsetDown, offsetRight, count, references, formula, overRow, overCol, cycleNum);
    }

    private void shiftDownAndFillFormula(Sheet sheet, int startRow, int startCol, Cell templateCell, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, int num, List<String> references, String formula) {
        Row templateRow = templateCell.getRow();
        short templateRowHeight = templateCell.getCellStyle().getWrapText() || templateRow.getHeight() == sheet.getDefaultRowHeight() ? (short)-1 : (short)templateRow.getHeight();
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        for (String reference : references) {
            String letter = ExcelExporterServiceImpl.extractLetters(reference);
            int rowNum = ExcelExporterServiceImpl.extractNumbers(reference) - 1;
            int cellNum = ExcelExporterServiceImpl.excelColumnToNumber(letter);
            int offDownNum = 0;
            int offRightNum = 0;
            if (HussarUtils.isNotEmpty(offsetDown)) {
                offDownNum = this.getSumOfValuesLessThanNum(offsetDown, rowNum);
            }
            if (HussarUtils.isNotEmpty(offsetRight)) {
                offRightNum = this.getSumOfValuesLessThanNum(offsetRight, cellNum);
            }
            int newRow = rowNum + offDownNum + 1;
            int newCol = cellNum + offRightNum;
            String newReference = ExcelExporterServiceImpl.numberToExcelColumn(newCol) + newRow;
            replaceMap.put(reference, newReference);
        }
        boolean isColumnWidthSet = false;
        for (int i = 0; i < num; ++i) {
            Cell targetCell;
            int currentRowNum = startRow + i;
            Row targetRow = sheet.getRow(currentRowNum);
            if (targetRow == null) {
                targetRow = sheet.createRow(currentRowNum);
            }
            if (i != 0 && templateRow != null) {
                targetRow.setHeight(templateRowHeight);
            }
            if ((targetCell = targetRow.getCell(startCol)) == null) {
                targetCell = targetRow.createCell(startCol);
            }
            if (templateCell != null && i != 0) {
                this.copyCell(templateCell, targetCell);
                if (!isColumnWidthSet) {
                    int templateColWidth = sheet.getColumnWidth(templateCell.getColumnIndex());
                    sheet.setColumnWidth(startCol, templateColWidth);
                    isColumnWidthSet = true;
                }
            }
            String newFormula = formula;
            for (Map.Entry entry : replaceMap.entrySet()) {
                String newReference = (String)entry.getValue();
                int rowNum = ExcelExporterServiceImpl.extractNumbers(newReference) + i;
                String letter = ExcelExporterServiceImpl.extractLetters(newReference);
                String replaceReference = letter + rowNum;
                newFormula = newFormula.replace((CharSequence)entry.getKey(), replaceReference);
            }
            targetCell.setCellFormula(newFormula);
        }
    }

    private void shiftDownAndFillFormulaForLoop(Sheet sheet, int startRow, int startCol, Cell templateCell, Map<Integer, Integer> offsetDown, Map<Integer, Integer> offsetRight, int num, List<String> references, String formula, int overRow, int overCol, int cycleNum) {
        Row templateRow = templateCell.getRow();
        short templateRowHeight = templateCell.getCellStyle().getWrapText() || templateRow.getHeight() == sheet.getDefaultRowHeight() ? (short)-1 : (short)templateRow.getHeight();
        int templateColWidth = sheet.getColumnWidth(templateCell.getColumnIndex());
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        for (String reference : references) {
            String letter = ExcelExporterServiceImpl.extractLetters(reference);
            int rowNum = ExcelExporterServiceImpl.extractNumbers(reference) - 1;
            int cellNum = ExcelExporterServiceImpl.excelColumnToNumber(letter);
            int offDownNum = 0;
            int offRightNum = 0;
            if (HussarUtils.isNotEmpty(offsetDown)) {
                offDownNum = this.getSumOfValuesLessThanNum(offsetDown, rowNum);
            }
            if (HussarUtils.isNotEmpty(offsetRight)) {
                offRightNum = this.getSumOfValuesLessThanNum(offsetRight, cellNum);
            }
            int newRow = rowNum + offDownNum + 1;
            int newCol = cellNum + offRightNum;
            String newReference = ExcelExporterServiceImpl.numberToExcelColumn(newCol) + newRow;
            replaceMap.put(reference, newReference);
        }
        for (int i = 0; i < num; ++i) {
            int index;
            int targetRowNum = startRow + overRow * i;
            Row targetRow = sheet.getRow(targetRowNum);
            if (targetRow == null) {
                targetRow = sheet.createRow(targetRowNum);
            }
            if (i == 0 && templateRow != null) {
                targetRow.setHeight(templateRowHeight);
            }
            for (int j = 0; j < cycleNum && (index = i * cycleNum + j) < num; ++j) {
                int targetColNum = startCol + overCol * j;
                Cell targetCell = targetRow.getCell(targetColNum);
                if (targetCell == null) {
                    targetCell = targetRow.createCell(targetColNum);
                }
                if (templateCell != null && (i != 0 || j != 0)) {
                    int currentColWidth;
                    this.copyCell(templateCell, targetCell);
                    if (j != 0 && ((currentColWidth = sheet.getColumnWidth(targetColNum)) <= 0 || currentColWidth != templateColWidth)) {
                        sheet.setColumnWidth(targetColNum, templateColWidth);
                    }
                }
                String newFormula = formula;
                for (Map.Entry entry : replaceMap.entrySet()) {
                    String newReference = (String)entry.getValue();
                    int rowNum = ExcelExporterServiceImpl.extractNumbers(newReference) + overRow * i;
                    int letterNum = ExcelExporterServiceImpl.excelColumnToNumber(ExcelExporterServiceImpl.extractLetters(newReference));
                    String letter = ExcelExporterServiceImpl.numberToExcelColumn(letterNum += overCol * j);
                    String replaceReference = letter + rowNum;
                    newFormula = newFormula.replace((CharSequence)entry.getKey(), replaceReference);
                }
                targetCell.setCellFormula(newFormula);
            }
        }
    }

    private static /* synthetic */ Object lambda$processAndFillLoopAreaData$15(String fieldName, Map map) {
        return map.get(fieldName);
    }

    private static /* synthetic */ boolean lambda$processAndFillLoopAreaData$14(String fieldName, Map map) {
        return map.containsKey(fieldName);
    }
}

